/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonValue;
import kafka.zk.CellIdsZNode$;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.KafkaException;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CellIdZNode$ {
    public static CellIdZNode$ MODULE$;

    static {
        new CellIdZNode$();
    }

    public String path(int cellId) {
        return new StringBuilder(1).append(CellIdsZNode$.MODULE$.path()).append("/").append(cellId).toString();
    }

    public byte[] encode(Cell cell) {
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokers"), (Object)cell.brokersList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)BoxesRunTime.boxToByte((byte)cell.state().code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_size"), (Object)BoxesRunTime.boxToShort((short)cell.minSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_size"), (Object)BoxesRunTime.boxToShort((short)cell.maxSize()))}))).asJava());
    }

    public Cell decode(int cellId, byte[] bytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(bytes);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new KafkaException(new StringBuilder(30).append("Failed to parse the cell id ").append(cellId).append(": ").append(new String(bytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
            }
            throw new MatchError(either);
        }
        JsonValue js = (JsonValue)((Right)either).value();
        Seq brokers = (Seq)js.asJsonObject().apply("brokers").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        int state = BoxesRunTime.unboxToInt((Object)js.asJsonObject().apply("state").to(DecodeJson$DecodeInt$.MODULE$));
        int minSize = BoxesRunTime.unboxToInt((Object)js.asJsonObject().apply("min_size").to(DecodeJson$DecodeInt$.MODULE$));
        int maxSize = BoxesRunTime.unboxToInt((Object)js.asJsonObject().apply("max_size").to(DecodeJson$DecodeInt$.MODULE$));
        Cell cell = new Cell(cellId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)brokers.toSet().map((Function1 & Serializable & scala.Serializable)x -> CellIdZNode$.$anonfun$decode$72(BoxesRunTime.unboxToInt((Object)x)), Set$.MODULE$.canBuildFrom())).asJava(), CellState.toEnum((byte)((byte)state)), (short)minSize, (short)maxSize);
        return cell;
    }

    public static final /* synthetic */ Integer $anonfun$decode$72(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private CellIdZNode$() {
        MODULE$ = this;
    }
}

