/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.ZkAdminManager$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u000b\u0016\u0001qA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\t\u0007I\u0011A)\t\rU\u0003\u0001\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0003X\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u0015\t\b\u0001\"\u0003s\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t9\b\u0001C!\u0003sBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002(\u0002!\t%!+\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0002\u00185.\u001cuN\u001c4jO6KwM]1uS>t7\t\\5f]RT!AF\f\u0002\u00135LwM]1uS>t'B\u0001\r\u001a\u0003\tQ8NC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u000f&cA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'_5\tqE\u0003\u0002\u0017Q)\u0011\u0011FK\u0001\t[\u0016$\u0018\rZ1uC*\u0011!d\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021O\t)2i\u001c8gS\u001el\u0015n\u001a:bi&|gn\u00117jK:$\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001a\u0003\u0015)H/\u001b7t\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0002\u0011i\\7\t\\5f]R\u0004\"!\u000f\u001e\u000e\u0003]I!aO\f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003=\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014\bC\u0001\u001a?\u0013\ty4GA\bQCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s\u0003iQ8n\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u000b:\u001cw\u000eZ3s!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mS:\\'B\u0001$\u001a\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001j\u0011\u0002\u0019\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003L\u001b:{\u0005C\u0001'\u0001\u001b\u0005)\u0002\"B\u001c\u0005\u0001\u0004A\u0004\"\u0002\u001f\u0005\u0001\u0004i\u0004\"\u0002!\u0005\u0001\u0004\t\u0015!D1e[&t'l[\"mS\u0016tG/F\u0001S!\tI4+\u0003\u0002U/\ti\u0011\tZ7j]j[7\t\\5f]R\fa\"\u00193nS:T6n\u00117jK:$\b%\u0001\tge>l'l[#oi&$\u0018PT1nKR\u0019\u0001,Z4\u0011\u0005e\u0013gB\u0001.a!\tYf,D\u0001]\u0015\ti6$\u0001\u0004=e>|GO\u0010\u0006\u0002?\u0006)1oY1mC&\u0011\u0011MX\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b=\")am\u0002a\u00011\u0006QQM\u001c;jift\u0015-\\3\t\u000b!<\u0001\u0019A5\u0002\u0015\r|gNZ5h)f\u0004X\rE\u0002kWbk\u0011AX\u0005\u0003Yz\u0013aa\u00149uS>t\u0017A\u0004;p5.,e\u000e^5us:\u000bW.\u001a\u000b\u00041>\u0004\b\"\u00024\t\u0001\u0004A\u0006\"\u00025\t\u0001\u0004I\u0017!\u0005;p5.,e\u000e^5us\u000e{gNZ5hgR\u00191/\u001f@\u0011\u0005Q<X\"A;\u000b\u0005Y\f\u0013\u0001B;uS2L!\u0001_;\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003{\u0013\u0001\u000710A\u0005d_:4\u0017nZ'baB!A\u000f -Y\u0013\tiXOA\u0002NCBDQ\u0001[\u0005A\u0002%\fqBY;jY\u0012,e\u000e^5us\u0012\u000bG/\u0019\u000b\u0007\u0003\u0007\tY#a\f\u0011\t\u0005\u0015\u0011Q\u0005\b\u0005\u0003\u000f\tyB\u0004\u0003\u0002\n\u0005ma\u0002BA\u0006\u0003/qA!!\u0004\u0002\u00169!\u0011qBA\n\u001d\rY\u0016\u0011C\u0005\u0002]%\u0011A&L\u0005\u00035-J1!!\u0007+\u0003\u0019\u0019w.\\7p]&\u0019\u0011&!\b\u000b\u0007\u0005e!&\u0003\u0003\u0002\"\u0005\r\u0012!E\"mS\u0016tG/U;pi\u0006\u0014VmY8sI*\u0019\u0011&!\b\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u000b\u000b:$\u0018\u000e^=ECR\f'\u0002BA\u0011\u0003GAa!!\f\u000b\u0001\u0004A\u0016AC3oi&$\u0018\u0010V=qK\")aM\u0003a\u00011\u0006\u0019\u0012\u000e^3sCR,7\t\\5f]R\fVo\u001c;bgR!\u0011QGA\u001e!\rQ\u0017qG\u0005\u0004\u0003sq&\u0001B+oSRDq!!\u0010\f\u0001\u0004\ty$A\u0004wSNLGo\u001c:\u0011\t\u0005\u0005\u0013q\n\b\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005%c\u0002BA\u0006\u0003\u000fJ!!\u000b\u0016\n\u0005YA\u0013bAA'O\u0005)2i\u001c8gS\u001el\u0015n\u001a:bi&|gn\u00117jK:$\u0018\u0002BA)\u0003'\u0012!c\u00117jK:$\u0018+^8uCZK7/\u001b;pe*\u0019\u0011QJ\u0014\u0002)%$XM]1uK\n\u0013xn[3s\u0007>tg-[4t)\u0011\t)$!\u0017\t\u000f\u0005mC\u00021\u0001\u0002^\u0005i1m\u001c8gS\u001e4\u0016n]5u_J\u0004B!!\u0011\u0002`%!\u0011\u0011MA*\u0005M\u0011%o\\6fe\u000e{gNZ5h-&\u001c\u0018\u000e^8s\u0003MIG/\u001a:bi\u0016$v\u000e]5d\u0007>tg-[4t)\u0011\t)$a\u001a\t\u000f\u0005%T\u00021\u0001\u0002l\u0005q1m\u001c8gS\u001e\u001cuN\\:v[\u0016\u0014\bCBA7\u0003gB60\u0004\u0002\u0002p)\u0019\u0011\u0011O;\u0002\u0011\u0019,hn\u0019;j_:LA!!\u001e\u0002p\tQ!)[\"p]N,X.\u001a:\u0002!I,\u0017\r\u001a+pa&\u001c7i\u001c8gS\u001e\u001cHCBA\u001b\u0003w\ny\b\u0003\u0004\u0002~9\u0001\r\u0001W\u0001\ni>\u0004\u0018n\u0019(b[\u0016Dq!!\u001b\u000f\u0001\u0004\t\t\tE\u0003\u0002n\u0005\r50\u0003\u0003\u0002\u0006\u0006=$\u0001C\"p]N,X.\u001a:\u0002\u0019]\u0014\u0018\u000e^3D_:4\u0017nZ:\u0015\u0011\u0005-\u0015\u0011SAQ\u0003G\u00032AJAG\u0013\r\tyi\n\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\b\u0003'{\u0001\u0019AAK\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi\"\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003?\u000bIJ\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000bi|\u0001\u0019A>\t\u000f\u0005\u0015v\u00021\u0001\u0002\f\u0006)1\u000f^1uK\u0006iA-\u001a7fi\u0016\u001cuN\u001c4jON$b!a#\u0002,\u00065\u0006bBAJ!\u0001\u0007\u0011Q\u0013\u0005\b\u0003K\u0003\u0002\u0019AAF\u0003E9(/\u001b;f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u000b\u0003\u0017\u000b\u0019,a.\u0002D\u0006\u001d\u0007BBA[#\u0001\u000710\u0001\u0004f]RLG/\u001f\u0005\b\u0003s\u000b\u0002\u0019AA^\u0003\u0019\tXo\u001c;bgB)A\u000f -\u0002>B\u0019a$a0\n\u0007\u0005\u0005wD\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0003\u000b\f\u0002\u0019A>\u0002\u000bM\u001c'/Y7\t\u000f\u0005\u0015\u0016\u00031\u0001\u0002\f\u0006!BO]=Xe&$X-\u00128uSRL8i\u001c8gS\u001e$B\"!4\u0002P\u0006E\u0017Q[Am\u0003G\u0004BA[6\u0002\f\"1\u0011Q\u0006\nA\u0002aCa!a5\u0013\u0001\u0004A\u0016\u0001\u00029bi\"Da!a6\u0013\u0001\u0004\u0019\u0018!\u00029s_B\u001c\bbBAn%\u0001\u0007\u0011Q\\\u0001\u0007GJ,\u0017\r^3\u0011\u0007)\fy.C\u0002\u0002bz\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002&J\u0001\r!a#\u0002+I,\u0017\rZ\"mkN$XM\u001d'j].\u001cuN\u001c4jOR1\u0011QGAu\u0003kDq!a;\u0014\u0001\u0004\ti/\u0001\u0004mS:\\\u0017\n\u001a\t\u0005\u0003_\f\t0\u0004\u0002\u0002\u001e%!\u00111_A\u000f\u0005\u0011)V/\u001b3\t\u000f\u0005%4\u00031\u0001\u0002\u0002\u0002")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final ClusterLinkConfigEncoder zkClusterLinkConfigEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkEntityName(String entityName, Option<String> configType) {
        if (entityName.equals(ConfigEntityName$.MODULE$.Default())) {
            return "";
        }
        if (configType.contains((Object)ConfigType$.MODULE$.ClusterLink())) {
            return CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString(entityName).toString();
        }
        return entityName;
    }

    private String toZkEntityName(String entityName, Option<String> configType) {
        if (entityName.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        if (configType.contains((Object)ConfigType$.MODULE$.ClusterLink())) {
            return CoreUtils$.MODULE$.toJavaUUIDStringFromKafkaUuidString(entityName);
        }
        return entityName;
    }

    /*
     * WARNING - void declaration
     */
    private Properties toZkEntityConfigs(java.util.Map<String, String> configMap, Option<String> configType) {
        void var3_3;
        Properties props = new Properties();
        configMap.forEach((x0$1, x1$1) -> {
            String key = x0$1;
            String value = x1$1;
            props.put(key, value);
        });
        if (configType.contains((Object)ConfigType$.MODULE$.ClusterLink())) {
            this.zkClusterLinkConfigEncoder.encode(props);
        } else {
            configMap.forEach((x0$2, x1$2) -> {
                String key = x0$2;
                String value = x1$2;
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    props.put(key, $this.passwordEncoder.encode(new Password(value)));
                    return;
                }
                props.put(key, value);
            });
        }
        return var3_3;
    }

    private ClientQuotaRecord.EntityData buildEntityData(String entityType, String entityName) {
        return new ClientQuotaRecord.EntityData().setEntityType(entityType).setEntityName(this.fromZkEntityName(entityName, (Option<String>)new Some((Object)entityType)));
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1(ConfigType$.MODULE$.User(), "user", visitor);
        this.migrateEntityType$1(ConfigType$.MODULE$.Client(), "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs(ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1(ConfigType$.MODULE$.Ip(), "ip", visitor);
    }

    public void iterateBrokerConfigs(ConfigMigrationClient.BrokerConfigVisitor configVisitor) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Broker());
        this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.Broker(), (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateBrokerConfigs$1(this, configVisitor, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.readTopicConfigs((String)topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkEntityName(topicName, (Option<String>)new Some((Object)ConfigType$.MODULE$.Topic()));
        Properties props = this.zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topicResource);
        java.util.Map decodedProps = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Tuple2 tuple2 = DynamicBrokerConfig$.MODULE$.isPasswordConfig(key) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        String string = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            configConsumer.accept(decodedProps);
            return;
        }
        catch (Throwable logAndRethrow_e) {
            void logAndRethrow_msg;
            this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        Object object = new Object();
        try {
            ZkMigrationLeadershipState zkMigrationLeadershipState;
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
                if (bl) {
                    throw throwable;
                }
                boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
                if (bl2) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
            return zkMigrationLeadershipState;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readClusterLinkConfig(Uuid linkId, Consumer<java.util.Map<String, String>> configConsumer) {
        String linkResource = this.toZkEntityName(linkId.toString(), (Option<String>)new Some((Object)ConfigType$.MODULE$.ClusterLink()));
        Properties props = this.zkClient.getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkResource);
        HashMap decodedPropsMap = new HashMap();
        this.zkClusterLinkConfigEncoder.decode(props).entrySet().forEach(entry -> decodedPropsMap.put(entry.getKey().toString(), entry.getValue().toString()));
        String string = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(linkResource).append(".").toString();
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            configConsumer.accept(decodedPropsMap);
            return;
        }
        catch (Throwable logAndRethrow_e) {
            void logAndRethrow_msg;
            this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)$this.buildEntityData(entityType$1, name), (List)Nil$.MODULE$)).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1))))).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String string = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    if (ZkMigrationClient$.MODULE$ == null) {
                        throw null;
                    }
                    try {
                        visitor$1.visitScramCredential(name, mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        void logAndRethrow_msg;
                        $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$2._1();
                double value = x0$2._2$mcD$sp();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            if (!quotaMap.isEmpty()) {
                String string = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                if (ZkMigrationClient$.MODULE$ == null) {
                    throw null;
                }
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                    return;
                }
                catch (Throwable logAndRethrow_e) {
                    void logAndRethrow_msg;
                    $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
            }
        } else {
            throw new MatchError(null);
        }
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block6: {
            String[] components;
            Properties props;
            block8: {
                String name;
                block7: {
                    if (x0$1 == null) break block6;
                    name = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = name.split("/");
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).size() != 3) break block7;
                    String string = components[1];
                    String string2 = "clients";
                    if (string != null && string.equals(string2)) break block8;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(name).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildEntityData("user", components[0]), (List)new .colon.colon((Object)$this.buildEntityData("client-id", components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Double d;
                String key;
                if (x0$2 != null) {
                    key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                } else {
                    throw new MatchError(null);
                }
                Double doubleValue = d;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).asJava();
            String string = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                visitor$1.visitClientQuota((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, ConfigMigrationClient.BrokerConfigVisitor configVisitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkEntityName(broker, (Option<String>)new Some((Object)ConfigType$.MODULE$.Broker()));
            HashMap plainProps = new HashMap();
            HashMap encryptedProps = new HashMap();
            ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                void var7_7;
                boolean bl;
                String string;
                String key;
                if (x0$2 != null) {
                    key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        string = $this.passwordEncoder.decode(value).value();
                        bl = true;
                    } else {
                        string = value;
                        bl = false;
                    }
                } else {
                    throw new MatchError(null);
                }
                boolean bl2 = bl;
                String newValue = string;
                String string2 = bl2 ? (String)encryptedProps.put(key, var7_7) : (String)plainProps.put(key, var7_7);
                return string2;
            });
            String string = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                configVisitor$1.visitBrokerConfig(brokerResource, (java.util.Map)plainProps, (java.util.Map)encryptedProps);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopicConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$1, String topic) {
        $this.readTopicConfigs(topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1) {
        ConfigResource.Type type = configResource$1.type();
        Object object = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)ConfigType$.MODULE$.ClusterLink()) : None$.MODULE$));
        String configName = $this.toZkEntityName(configResource$1.name(), (Option<String>)object);
        if (object.isDefined()) {
            ZkMigrationLeadershipState zkMigrationLeadershipState;
            Properties props = $this.toZkEntityConfigs(configMap$1, (Option<String>)object);
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)object.get(), configName, props, false, state$1);
            if (option instanceof Some) {
                zkMigrationLeadershipState = (ZkMigrationLeadershipState)((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                void var14_14;
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)object.get());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                boolean x$2 = false;
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, x$2);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)object.get(), configName, props, true, state$1);
                if (!(option2 instanceof Some)) {
                    if (None$.MODULE$.equals(option2)) {
                        throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(object.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                    }
                    throw new MatchError(option2);
                }
                ZkMigrationLeadershipState newStateSecondTry = (ZkMigrationLeadershipState)((Some)option2).value();
                zkMigrationLeadershipState = var14_14;
            } else {
                throw new MatchError(option);
            }
            return zkMigrationLeadershipState;
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Object object = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)ConfigType$.MODULE$.ClusterLink()) : None$.MODULE$));
        String configName = $this.toZkEntityName(configResource$2.name(), (Option<String>)object);
        if (object.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)object.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(object).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    public static final /* synthetic */ void $anonfun$writeClientQuotas$6(java.util.Map configKeys$1, Properties props$3, String x0$1, Double x1$1) {
        String key = x0$1;
        Double value = x1$1;
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys$1.get(key);
        if (configKey == null) {
            throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append(key).toString());
        }
        ConfigDef.Type type = configKey.type;
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            props$3.setProperty(key, value.toString());
            return;
        }
        boolean bl = ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type);
        if (bl) {
            long intValue;
            double epsilon = 1.0E-6;
            ConfigDef.Type type2 = configKey.type;
            ConfigDef.Type type3 = ConfigDef.Type.LONG;
            long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(value) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(value) + epsilon)));
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(value))) > epsilon) {
                throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append(key).append(" must be a ").append(configKey.type).append(" value").toString());
            }
            props$3.setProperty(key, Long.toString(intValue));
            return;
        }
        throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        ZkMigrationLeadershipState zkMigrationLeadershipState;
        void var14_15;
        void var13_14;
        void var12_13;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Option option;
        Some some;
        scala.collection.mutable.Map entityMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity$3).asScala();
        Option user = entityMap.get((Object)"user").map((Function1 & Serializable & scala.Serializable)x$4 -> $this.toZkEntityName((String)x$4, (Option<String>)None$.MODULE$));
        Option client = entityMap.get((Object)"client-id").map((Function1 & Serializable & scala.Serializable)x$5 -> $this.toZkEntityName((String)x$5, (Option<String>)None$.MODULE$));
        Option ip = entityMap.get((Object)"ip").map((Function1 & Serializable & scala.Serializable)x$6 -> $this.toZkEntityName((String)x$6, (Option<String>)None$.MODULE$));
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            option = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            option = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.Client());
            option = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.Ip());
            option = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else {
            some = None$.MODULE$;
            option = None$.MODULE$;
            map = CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Option option2 = option;
        Option configType = (Option)some;
        Option path = option2;
        java.util.Map<String, ConfigDef.ConfigKey> configKeys = map2;
        void configType2 = var12_13;
        void path2 = var13_14;
        void configKeys2 = var14_15;
        if (path2.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((arg_0, arg_1) -> ZkConfigMigrationClient.$anonfun$writeClientQuotas$6((java.util.Map)configKeys2, props, arg_0, arg_1));
        scram$1.forEach((x0$2, x1$2) -> {
            String key = x0$2;
            String value = x1$2;
            props.put(key, value);
        });
        Option<ZkMigrationLeadershipState> option3 = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, false, state$3);
        if (option3 instanceof Some) {
            zkMigrationLeadershipState = (ZkMigrationLeadershipState)((Some)option3).value();
        } else if (None$.MODULE$.equals(option3)) {
            void var23_25;
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get());
            boolean x$2 = false;
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, x$2);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option4 = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, true, state$3);
            if (!(option4 instanceof Some)) {
                if (None$.MODULE$.equals(option4)) {
                    throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
                }
                throw new MatchError(option4);
            }
            ZkMigrationLeadershipState newStateSecondTry = (ZkMigrationLeadershipState)((Some)option4).value();
            zkMigrationLeadershipState = var23_25;
        } else {
            throw new MatchError(option3);
        }
        return zkMigrationLeadershipState;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$4, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4) {
        void var10_10;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$4);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), SetDataRequest$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var9_9;
            $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            return new Some((Object)state$4.withMigrationZkVersion((int)var9_9));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var10_10.head()).resultCode(), (String)path$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder, ClusterLinkConfigEncoder zkClusterLinkConfigEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        this.zkClusterLinkConfigEncoder = zkClusterLinkConfigEncoder;
        Logging.$init$(this);
        this.adminZkClient = new AdminZkClient(zkClient);
    }
}

