/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.telemetry.api.events.EventEmitter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kafka.catalog.CatalogMetrics;
import kafka.catalog.InMemoryLocalStore;
import kafka.catalog.LocalStore;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.ZKMetadataCollectorConfig;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;

public final class ZKMetadataCollectorContext
implements AutoCloseable {
    private final ZKMetadataCollectorConfig config;
    private final LocalStore localStore;
    private final MetadataCollectorEventQueue eventQueue;
    private final Throttler throttler;
    private final KafkaZkClient zkClient;
    private final Metrics metrics;
    private final CatalogMetrics catalogMetrics;
    private final KafkaConfig originalConfig;
    private final int epoch;
    private final long startNs;
    private final Map<String, TopicInfo> initialTopicsWithInfo;
    private final Map<String, ClusterLinkInfo> initialClusterLinksWithInfo;
    private volatile long lastSnapshotNs;

    public ZKMetadataCollectorContext(ZKMetadataCollectorConfig config, Map<String, TopicInfo> initialTopicsWithInfo, Map<String, ClusterLinkInfo> initialClusterLinksWithInfo, MetadataCollectorEventQueue eventQueue, Metrics metrics, KafkaZkClient zkClient, KafkaConfig originalConfig, int epoch, Time time) {
        this.initialTopicsWithInfo = new HashMap<String, TopicInfo>(initialTopicsWithInfo);
        this.initialClusterLinksWithInfo = new HashMap<String, ClusterLinkInfo>(initialClusterLinksWithInfo);
        this.config = config;
        this.eventQueue = eventQueue;
        this.localStore = new InMemoryLocalStore();
        this.metrics = metrics;
        this.zkClient = zkClient;
        this.catalogMetrics = new CatalogMetrics(metrics, this.localStore::size);
        this.originalConfig = originalConfig;
        this.epoch = epoch;
        this.throttler = new Throttler((double)config.maxZkRequestPerSec, 100L, "catalog-collect", "entries", time);
        this.lastSnapshotNs = this.startNs = time.nanoseconds();
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public MetadataCollectorEventQueue eventQueue() {
        return this.eventQueue;
    }

    public LocalStore localStore() {
        return this.localStore;
    }

    public EventEmitter eventEmitter() {
        return this.metrics.eventEmitter();
    }

    public CatalogMetrics catalogMetrics() {
        return this.catalogMetrics;
    }

    public KafkaConfig originalConfig() {
        return this.originalConfig;
    }

    public int epoch() {
        return this.epoch;
    }

    public long startNs() {
        return this.startNs;
    }

    public TopicInfo removeTopicFromInitialSnapshot(String topicName) {
        return this.initialTopicsWithInfo.remove(topicName);
    }

    public ClusterLinkInfo removeClusterLinkFromInitialSnapshot(String clusterLink) {
        return this.initialClusterLinksWithInfo.remove(clusterLink);
    }

    public TopicInfo topicInfo(String topicName) {
        return this.initialTopicsWithInfo.get(topicName);
    }

    public ClusterLinkInfo clusterLinkInfo(String clusterLink) {
        return this.initialClusterLinksWithInfo.get(clusterLink);
    }

    public Set<String> initialTopics() {
        return new HashSet<String>(this.initialTopicsWithInfo.keySet());
    }

    public Set<ClusterLinkInfo> initialClusterLinks() {
        return new HashSet<ClusterLinkInfo>(this.initialClusterLinksWithInfo.values());
    }

    public boolean cacheInitialized() {
        return this.initialTopicsWithInfo.isEmpty() && this.initialClusterLinksWithInfo.isEmpty();
    }

    public ZKMetadataCollectorConfig config() {
        return this.config;
    }

    public void setLastSnapshotNs(long snapshotNs) {
        this.lastSnapshotNs = snapshotNs;
    }

    public long lastSnapshotNs() {
        return this.lastSnapshotNs;
    }

    @Override
    public void close() {
        if (this.catalogMetrics != null) {
            this.catalogMetrics.removeCatalogMetrics();
        }
    }
}

