/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import java.util.Optional;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import org.apache.kafka.common.utils.Time;

public class CollectorStopEvent
extends MetadataCollectorEvent {
    public CollectorStopEvent(ZKMetadataCollector collector, Time time) {
        super(collector, time);
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        context.eventQueue().cancel("SNAPSHOT_EVENT");
        context.eventQueue().cancel("CACHE_BUILD_EVENT");
        context.close();
        this.collector.setCollectorContext(Optional.empty());
        LOG.info("Finished closing {}." + this.collector.getClass().getSimpleName());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof CollectorContextNotInitializedException) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Stopping an inactive MetadataCollector", e);
            }
        } else {
            LOG.error("Error stopping MetadataCollector", e);
        }
    }
}

