/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.util.FutureUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u001dx!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003ad!B\u0019)\u0001!r\u0004\u0002C\u0016\u0005\u0005\u000b\u0007I\u0011\u0002*\t\u0011U#!\u0011!Q\u0001\nMC\u0001B\u0016\u0003\u0003\u0006\u0004%Ia\u0016\u0005\tA\u0012\u0011\t\u0011)A\u00051\")\u0011\b\u0002C\u0001C\")A\r\u0002C!K\")\u0011\u000e\u0002C!U\"9\u0011Q\u0002\u0003\u0005B\u0005=\u0001bBA\u0012\t\u0011\u0005\u0013Q\u0005\u0005\b\u0003\u0007\"A\u0011IA#\u0011\u001d\tY\u0006\u0002C!\u0003;Bq!!\u001d\u0005\t\u0003\n\u0019\bC\u0004\u0002\b\u0012!\t%!#\t\u000f\u0005uE\u0001\"\u0011\u0002 \"9\u0011q\u001b\u0003\u0005B\u0005e\u0007bBAy\t\u0011\u0005\u00131\u001f\u0005\b\u00057!A\u0011\tB\u000f\u0011\u001d\u0011)\u0003\u0002C\u0005\u0005OAqAa\u0015\u0005\t\u0003\u0012)\u0006C\u0004\u0003l\u0011!\tE!\u001c\t\u000f\t\rE\u0001\"\u0003\u0003\u0006\"9!q\u0017\u0003\u0005B\te\u0006b\u0002Bh\t\u0011\u0005#\u0011\u001b\u0005\b\u0007\u0013!A\u0011IB\u0006\u0011\u001d\u0019y\u0001\u0002C!\u0007#Aqa!\t\u0005\t\u0003\u001a\u0019\u0003C\u0004\u00044\u0011!\te!\u000e\t\u000f\r}B\u0001\"\u0011\u0004B!91Q\n\u0003\u0005B\r=\u0003bBB6\t\u0011\u00053Q\u000e\u0005\b\u0007k\"A\u0011IB<\u0011\u001d\u0019I\t\u0002C!\u0007\u0017Cqa!$\u0005\t\u0003\u001ay\tC\u0004\u0004&\u0012!\tea*\u0002/\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018\tZ1qi\u0016\u0014(BA\u0015+\u0003\u00159'o\\;q\u0015\tYC&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001'A\u0007\u0002Q\t9rI]8va\u000e{wN\u001d3j]\u0006$xN]!eCB$XM]\n\u0003\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010\u0003\u0015\t\u0007\u000f\u001d7z)%i4QXBg\u0007/\u001cI\u000e\u0005\u00021\tM\u0019AaP$\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n1qJ\u00196fGR\u0004\"\u0001\u0013)\u000e\u0003%S!!\u000b&\u000b\u0005-Z%BA\u0017M\u0015\tie*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005EK%\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s+\u0005\u0019\u0006C\u0001\u0019U\u0013\t\t\u0006&\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0003uS6,W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016!B;uS2\u001c(BA/L\u0003\u0019\u0019w.\\7p]&\u0011qL\u0017\u0002\u0005)&lW-A\u0003uS6,\u0007\u0005F\u0002>E\u000eDQaK\u0005A\u0002MCQAV\u0005A\u0002a\u000bQ#[:OK^<%o\\;q\u0007>|'\u000fZ5oCR|'\u000fF\u0001g!\t!t-\u0003\u0002ik\t9!i\\8mK\u0006t\u0017AF2p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;\u0015\t-L\u00181\u0001\t\u0004YF\u001cX\"A7\u000b\u00059|\u0017AC2p]\u000e,(O]3oi*\u0011\u0001oQ\u0001\u0005kRLG.\u0003\u0002s[\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0005Q<X\"A;\u000b\u0005Yd\u0016aB7fgN\fw-Z\u0005\u0003qV\u0014!eQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fgB|gn]3ECR\f\u0007\"\u0002>\f\u0001\u0004Y\u0018aB2p]R,\u0007\u0010\u001e\t\u0003y~l\u0011! \u0006\u0003}r\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0004\u0003\u0003i(A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u000bY\u0001\u0019AA\u0004\u0003\u001d\u0011X-];fgR\u00042\u0001^A\u0005\u0013\r\tY!\u001e\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u0014g\"\f'/Z$s_V\u0004\b*Z1si\n,\u0017\r\u001e\u000b\u0007\u0003#\tI\"a\u0007\u0011\t1\f\u00181\u0003\t\u0004i\u0006U\u0011bAA\fk\ny2\u000b[1sK\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bid\u0001\u0019A>\t\u000f\u0005\u0015A\u00021\u0001\u0002\u001eA\u0019A/a\b\n\u0007\u0005\u0005RO\u0001\u0010TQ\u0006\u0014Xm\u0012:pkBDU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000fR1uC\u0006I!n\\5o\u000fJ|W\u000f\u001d\u000b\t\u0003O\ty#!\r\u0002:A!A.]A\u0015!\r!\u00181F\u0005\u0004\u0003[)(!\u0006&pS:<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006u6\u0001\ra\u001f\u0005\b\u0003\u000bi\u0001\u0019AA\u001a!\r!\u0018QG\u0005\u0004\u0003o)(\u0001\u0006&pS:<%o\\;q%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002<5\u0001\r!!\u0010\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB\u0019\u0011,a\u0010\n\u0007\u0005\u0005#L\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u0002\u0013MLhnY$s_V\u0004H\u0003CA$\u0003\u001f\n\t&!\u0017\u0011\t1\f\u0018\u0011\n\t\u0004i\u0006-\u0013bAA'k\n)2+\u001f8d\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007\"\u0002>\u000f\u0001\u0004Y\bbBA\u0003\u001d\u0001\u0007\u00111\u000b\t\u0004i\u0006U\u0013bAA,k\n!2+\u001f8d\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e#bi\u0006Dq!a\u000f\u000f\u0001\u0004\ti$A\u0005iK\u0006\u0014HOY3biR1\u0011qLA4\u0003S\u0002B\u0001\\9\u0002bA\u0019A/a\u0019\n\u0007\u0005\u0015TOA\u000bIK\u0006\u0014HOY3biJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bi|\u0001\u0019A>\t\u000f\u0005\u0015q\u00021\u0001\u0002lA\u0019A/!\u001c\n\u0007\u0005=TO\u0001\u000bIK\u0006\u0014HOY3biJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u000bY\u0016\fg/Z$s_V\u0004HCBA;\u0003{\ny\b\u0005\u0003mc\u0006]\u0004c\u0001;\u0002z%\u0019\u00111P;\u0003-1+\u0017M^3He>,\bOU3ta>t7/\u001a#bi\u0006DQA\u001f\tA\u0002mDq!!\u0002\u0011\u0001\u0004\t\t\tE\u0002u\u0003\u0007K1!!\"v\u0005UaU-\u0019<f\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e#bi\u0006\f!\u0002\\5ti\u001e\u0013x.\u001e9t)\u0019\tY)a%\u0002\u0016B!A.]AG!\r!\u0018qR\u0005\u0004\u0003#+(A\u0006'jgR<%o\\;qgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bi\f\u0002\u0019A>\t\u000f\u0005\u0015\u0011\u00031\u0001\u0002\u0018B\u0019A/!'\n\u0007\u0005mUOA\u000bMSN$xI]8vaN\u0014V-];fgR$\u0015\r^1\u0002\u001d\u0011,7o\u0019:jE\u0016<%o\\;qgR1\u0011\u0011UA]\u0003w\u0003B\u0001\\9\u0002$B1\u0011QUAT\u0003Wk\u0011a\\\u0005\u0004\u0003S{'\u0001\u0002'jgR\u0004B!!,\u00024:\u0019A/a,\n\u0007\u0005EV/\u0001\u000eEKN\u001c'/\u001b2f\u000fJ|W\u000f]:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u00026\u0006]&A\u0004#fg\u000e\u0014\u0018NY3e\u000fJ|W\u000f\u001d\u0006\u0004\u0003c+\b\"\u0002>\u0013\u0001\u0004Y\bbBA_%\u0001\u0007\u0011qX\u0001\tOJ|W\u000f]%egB1\u0011QUAT\u0003\u0003\u0004B!a1\u0002R:!\u0011QYAg!\r\t9-N\u0007\u0003\u0003\u0013T1!a3/\u0003\u0019a$o\\8u}%\u0019\u0011qZ\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019.!6\u0003\rM#(/\u001b8h\u0015\r\ty-N\u0001\rI\u0016dW\r^3He>,\bo\u001d\u000b\t\u00037\fY/!<\u0002pB!A.]Ao!\u0011\ty.!:\u000f\u0007Q\f\t/C\u0002\u0002dV\f\u0001\u0004R3mKR,wI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\t9/!;\u0003=\u0011+G.\u001a;bE2,wI]8vaJ+7/\u001e7u\u0007>dG.Z2uS>t'bAArk\")!p\u0005a\u0001w\"9\u0011QX\nA\u0002\u0005}\u0006bBA\u001e'\u0001\u0007\u0011QH\u0001\u0010M\u0016$8\r[!mY>3gm]3ugRA\u0011Q\u001fB\u0003\u0005\u000f\u00119\u0002\u0005\u0003mc\u0006]\b\u0003BA}\u0003\u007ft1\u0001^A~\u0013\r\ti0^\u0001\u0018\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAA!\u0001\u0003\u0004\tArJ\u001a4tKR4U\r^2i%\u0016\u001c\bo\u001c8tK\u001e\u0013x.\u001e9\u000b\u0007\u0005uX\u000fC\u0003{)\u0001\u00071\u0010C\u0004\u0002\u0006Q\u0001\rA!\u0003\u0011\t\t-!\u0011\u0003\b\u0004i\n5\u0011b\u0001B\bk\u00061rJ\u001a4tKR4U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0003\u0014\tU!aF(gMN,GOR3uG\"\u0014V-];fgR<%o\\;q\u0015\r\u0011y!\u001e\u0005\u0007\u00053!\u0002\u0019\u00014\u0002\u001bI,\u0017/^5sKN#\u0018M\u00197f\u000311W\r^2i\u001f\u001a47/\u001a;t)!\t)Pa\b\u0003\"\t\r\u0002\"\u0002>\u0016\u0001\u0004Y\bbBA\u0003+\u0001\u0007!\u0011\u0002\u0005\u0007\u00053)\u0002\u0019\u00014\u0002#!\fg\u000e\u001a7f\r\u0016$8\r[(gMN,G\u000f\u0006\u0005\u0002v\n%\"Q\u0006B\u0018\u0011\u001d\u0011YC\u0006a\u0001\u0003\u0003\fqa\u001a:pkBLE\r\u0003\u0004\u0003\u001aY\u0001\rA\u001a\u0005\b\u0005c1\u0002\u0019\u0001B\u001a\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006i\tU\"\u0011H\u0005\u0004\u0005o)$AB(qi&|g\u000e\u0005\u0004\u0003<\t\u0015#1\n\b\u0005\u0005{\u0011\tE\u0004\u0003\u0002H\n}\u0012\"\u0001\u001c\n\u0007\t\rS'A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d#\u0011\n\u0002\u0004'\u0016\f(b\u0001B\"kA!!Q\nB(\u001b\u0005a\u0016b\u0001B)9\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!D2p[6LGo\u00144gg\u0016$8\u000f\u0006\u0005\u0003X\t}#\u0011\rB5!\u0011a\u0017O!\u0017\u0011\u0007Q\u0014Y&C\u0002\u0003^U\u0014\u0001d\u00144gg\u0016$8i\\7nSR\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015Qx\u00031\u0001|\u0011\u001d\t)a\u0006a\u0001\u0005G\u00022\u0001\u001eB3\u0013\r\u00119'\u001e\u0002\u0018\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e#bi\u0006Dq!a\u000f\u0018\u0001\u0004\ti$\u0001\u000ed_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8\u000f\u0006\u0005\u0003p\t]$\u0011\u0010BA!\u0011a\u0017O!\u001d\u0011\u0007Q\u0014\u0019(C\u0002\u0003vU\u00141\u0004\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fgB|gn]3ECR\f\u0007\"\u0002>\u0019\u0001\u0004Y\bbBA\u00031\u0001\u0007!1\u0010\t\u0004i\nu\u0014b\u0001B@k\nQB\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cH\u000fR1uC\"9\u00111\b\rA\u0002\u0005u\u0012aF2sK\u0006$Xm\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b)9\u00119I!%\u0003\u001c\n}%\u0011\u0016BW\u0005c\u0003BA!#\u0003\u000e6\u0011!1\u0012\u0006\u0003;2JAAa$\u0003\f\n\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\tM\u0015\u00041\u0001\u0003\u0016\u0006i1-\u001e:sK:$H+[7f\u001bN\u00042\u0001\u000eBL\u0013\r\u0011I*\u000e\u0002\u0005\u0019>tw\rC\u0004\u0003\u001ef\u0001\rA!&\u0002\r=4gm]3u\u0011\u001d\u0011\t+\u0007a\u0001\u0005G\u000b1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019AG!*\n\u0007\t\u001dVGA\u0002J]RDqAa+\u001a\u0001\u0004\t\t-\u0001\u0005nKR\fG-\u0019;b\u0011\u001d\u0011y+\u0007a\u0001\u0005+\u000bqbY8n[&$H+[7fgR\fW\u000e\u001d\u0005\b\u0005gK\u0002\u0019\u0001B[\u0003=)\u0007\u0010]5sKRKW.Z:uC6\u0004\b#\u0002\u001b\u00036\tU\u0015!\u00043fY\u0016$Xm\u00144gg\u0016$8\u000f\u0006\u0005\u0003<\n\r'Q\u0019Bg!\u0011a\u0017O!0\u0011\u0007Q\u0014y,C\u0002\u0003BV\u0014\u0001d\u00144gg\u0016$H)\u001a7fi\u0016\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015Q(\u00041\u0001|\u0011\u001d\t)A\u0007a\u0001\u0005\u000f\u00042\u0001\u001eBe\u0013\r\u0011Y-\u001e\u0002\u0018\u001f\u001a47/\u001a;EK2,G/\u001a*fcV,7\u000f\u001e#bi\u0006Dq!a\u000f\u001b\u0001\u0004\ti$A\nd_6\u0004H.\u001a;f)J\fgn]1di&|g\u000e\u0006\b\u0003T\nm'q\u001cBr\u0005[\u0014\tPa?\u0011\t1\f(Q\u001b\t\u0004\u0001\n]\u0017b\u0001Bm\u0003\n!ak\\5e\u0011\u001d\u0011in\u0007a\u0001\u0005\u0017\n!\u0001\u001e9\t\u000f\t\u00058\u00041\u0001\u0003\u0016\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\t\u00158\u00041\u0001\u0003h\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u00042\u0001\u000eBu\u0013\r\u0011Y/\u000e\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005_\\\u0002\u0019\u0001BR\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0004\u0003tn\u0001\rA!>\u0002\rI,7/\u001e7u!\ra(q_\u0005\u0004\u0005sl(!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\"9!Q`\u000eA\u0002\t}\u0018a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0007\u0003\u0019)!\u0004\u0002\u0004\u0004)\u0011akQ\u0005\u0005\u0007\u000f\u0019\u0019A\u0001\u0005EkJ\fG/[8o\u00031\u0001\u0018M\u001d;ji&|gNR8s)\u0011\u0011\u0019k!\u0004\t\u000f\t-B\u00041\u0001\u0002B\u00061rN\u001c+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\r\u0006\u0005\u0003T\u000eM1QCB\u000f\u0011\u001d\u0011\t/\ba\u0001\u0005+CqA!\r\u001e\u0001\u0004\u00199\u0002E\u0003A\u00073\u0011Y%C\u0002\u0004\u001c\u0005\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0007?i\u0002\u0019\u0001B{\u0003E!(/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e^\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d#fY\u0016$X\r\u001a\u000b\u0007\u0007K\u0019Yc!\r\u0011\u0007Q\u001a9#C\u0002\u0004*U\u0012A!\u00168ji\"91Q\u0006\u0010A\u0002\r=\u0012a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\u0005\u0015\u0016q\u0015B&\u0011\u001d\tYD\ba\u0001\u0003{\t!b\u001c8FY\u0016\u001cG/[8o)\u0019\u0019)ca\u000e\u0004<!91\u0011H\u0010A\u0002\t\r\u0016aG4s_V\u0004X*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8J]\u0012,\u0007\u0010C\u0004\u0004>}\u0001\rAa)\u0002C\u001d\u0014x.\u001e9NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\u0019)ca\u0011\u0004F!91\u0011\b\u0011A\u0002\t\r\u0006bBB\u001fA\u0001\u00071q\t\t\u0005\u0003K\u001bI%C\u0002\u0004L=\u00141b\u00149uS>t\u0017\r\\%oi\u0006\u0011rN\u001c(fo6+G/\u00193bi\u0006LU.Y4f)\u0019\u0019)c!\u0015\u0004b!911K\u0011A\u0002\rU\u0013\u0001\u00038fo&k\u0017mZ3\u0011\t\r]3QL\u0007\u0003\u00073R1aa\u0017L\u0003\u0015IW.Y4f\u0013\u0011\u0019yf!\u0017\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u001d\u0019\u0019'\ta\u0001\u0007K\nQ\u0001Z3mi\u0006\u0004Baa\u0016\u0004h%!1\u0011NB-\u00055iU\r^1eCR\fG)\u001a7uC\u0006IrM]8va6+G/\u00193bi\u0006$v\u000e]5d\u0007>tg-[4t)\t\u0019y\u0007\u0005\u0003\u0002&\u000eE\u0014bAB:_\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u000fM$\u0018M\u001d;vaR!1QEB=\u0011\u001d\u0019Yh\ta\u0001\u0007{\n\u0001e\u001a:pkBlU\r^1eCR\fGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiB!1qPBC\u001b\t\u0019\tIC\u0002\u0004\u0004>\f\u0001BZ;oGRLwN\\\u0005\u0005\u0007\u000f\u001b\tIA\u0006J]R\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001C:ikR$wn\u001e8\u0015\u0005\r\u0015\u0012!F2p]N,X.\u001a:He>,\b\u000fR3tGJL'-\u001a\u000b\u0007\u0007#\u001b\tka)\u0011\t1\f81\u0013\t\u0007\u0003K\u000b9k!&\u0011\t\r]5Q\u0014\b\u0004i\u000ee\u0015bABNk\u0006\t3i\u001c8tk6,'o\u0012:pkB$Um]2sS\n,'+Z:q_:\u001cX\rR1uC&!\u0011QWBP\u0015\r\u0019Y*\u001e\u0005\u0006u\u0016\u0002\ra\u001f\u0005\b\u0003{+\u0003\u0019AA`\u0003I\u0019\b.\u0019:f\u000fJ|W\u000f\u001d#fg\u000e\u0014\u0018NY3\u0015\r\r%6\u0011XB^!\u0011a\u0017oa+\u0011\r\u0005\u0015\u0016qUBW!\u0011\u0019yk!.\u000f\u0007Q\u001c\t,C\u0002\u00044V\fad\u00155be\u0016<%o\\;q\t\u0016\u001c8M]5cKJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005U6q\u0017\u0006\u0004\u0007g+\b\"\u0002>'\u0001\u0004Y\bbBA_M\u0001\u0007\u0011q\u0018\u0005\b\u0007\u007f\u001b\u0001\u0019ABa\u0003\u0019\u0019wN\u001c4jOB!11YBe\u001b\t\u0019)MC\u0002\u0004H2\naa]3sm\u0016\u0014\u0018\u0002BBf\u0007\u000b\u00141bS1gW\u0006\u001cuN\u001c4jO\"91qZ\u0002A\u0002\rE\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0007\u0007\u001c\u0019.\u0003\u0003\u0004V\u000e\u0015'A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006-\u000e\u0001\r\u0001\u0017\u0005\b\u00077\u001c\u0001\u0019ABo\u0003\u001diW\r\u001e:jGN\u0004Baa8\u0004d6\u00111\u0011\u001d\u0006\u0004\u00077d\u0016\u0002BBs\u0007C\u0014q!T3ue&\u001c7\u000f")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(kafkaConfig, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public boolean isNewGroupCoordinator() {
        return false;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<ShareGroupHeartbeatResponseData> shareGroupHeartbeat(RequestContext context, ShareGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.SHARE_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(request.protocols().valuesList()).asScala()).map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()), Buffer$.MODULE$.canBuildFrom())).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.members()).asScala()).toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())), (Set<String>)((Set)Option$.MODULE$.apply((Object)request.typesFilter()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        void error2 = var4_4;
        void groups2 = var5_5;
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(error2.code());
        groups2.foreach((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$5(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(groupIds).asScala()).map((Function1 & Serializable & scala.Serializable)groupId -> this.describeGroup$1((String)groupId), Buffer$.MODULE$.canBuildFrom())).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code())));
        Map<String, Errors> map = Implicits$.MODULE$.MapExtensionMethods(this.coordinator().handleDeleteGroups((Set<String>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(groupIds).asScala()).toSet(), new RequestLocal(bufferSupplier)));
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        request.topics().forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> handleFetchOffset(String groupId, boolean requireStable, Option<Seq<TopicPartition>> partitions) {
        void var6_6;
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        void error2 = var5_5;
        void results2 = var6_6;
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> future = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        void v0 = error2;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(error2.exception());
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset));
            Map map = Implicits$.MODULE$.MapExtensionMethods(results2);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            future.complete(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(topicsList));
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationIdOrMemberEpoch(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap(Predef$.MODULE$.$conforms()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), -1L, (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.transactionalId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap(Predef$.MODULE$.$conforms()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier), context.apiVersion());
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, long commitTimestamp, Option<Object> expireTimestamp) {
        Optional<Integer> optional;
        switch (leaderEpoch) {
            case -1: {
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            }
        }
        return new OffsetAndMetadata(offset, optional, metadata == null ? OffsetAndMetadata$.MODULE$.NoMetadata() : metadata, -1L == commitTimestamp ? currentTimeMs : commitTimestamp, expireTimestamp);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var8_8;
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void groupError2 = var7_7;
        void topicPartitionResults2 = var8_8;
        void v0 = groupError2;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(groupError2.exception());
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error));
            Map map = Implicits$.MODULE$.MapExtensionMethods(topicPartitionResults2);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        return FutureUtils.failedFuture((Throwable)new IllegalStateException("The old group coordinator does not support `completeTransaction` API."));
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public CompletableFuture<Void> onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        try {
            return this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(partitions).asScala()), transactionResult);
        }
        catch (Throwable throwable) {
            return FutureUtils.failedFuture((Throwable)throwable);
        }
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPartitions).asScala()), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    public CompletableFuture<java.util.List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_DESCRIBE.name).append(" API.").toString()));
    }

    public CompletableFuture<java.util.List<ShareGroupDescribeResponseData.DescribedGroup>> shareGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.SHARE_GROUP_DESCRIBE.name).append(" API.").toString()));
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)joinResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)syncGroupResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable & scala.Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull(Predef$.MODULE$.$conforms())), List$.MODULE$.canBuildFrom())).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$5(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()).setGroupType(group.groupType()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId) {
        void var4_4;
        void var3_3;
        Tuple2<Errors, GroupSummary> tuple2 = this.coordinator().handleDescribeGroup(groupId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        GroupSummary summary = (GroupSummary)tuple2._2();
        void error2 = var3_3;
        void summary2 = var4_4;
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(error2.code()).setGroupId(groupId).setGroupState(summary2.state()).setProtocolType(summary2.protocolType()).setProtocolData(summary2.protocol()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)summary2.members().map((Function1 & Serializable & scala.Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull(Predef$.MODULE$.$conforms())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()), List$.MODULE$.canBuildFrom())).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error));
        Map map = Implicits$.MODULE$.MapExtensionMethods(commitStatus);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), partition.commitTimestamp(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error));
        Map map = Implicits$.MODULE$.MapExtensionMethods(results);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

