/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t5v!\u0002\u00180\u0011\u00031d!\u0002\u001d0\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%Ia\u0011\u0005\u0007\u0019\u0006\u0001\u000b\u0011\u0002#\t\u000f5\u000b!\u0019!C\u0005\u0007\"1a*\u0001Q\u0001\n\u0011C\u0001bT\u0001C\u0002\u0013\u0005q\u0006\u0015\u0005\u00073\u0006\u0001\u000b\u0011B)\t\u000bi\u000bA\u0011A.\u0007\taz\u0003!\u0018\u0005\tc*\u0011\t\u0011)A\u0005e\"AqO\u0003B\u0001B\u0003%\u0001\u0010\u0003\u0005|\u0015\t\u0005\t\u0015!\u0003}\u0011)\t)A\u0003B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001bQ!\u0011!Q\u0001\n\u0005=\u0001B\u0002!\u000b\t\u0003\ti\u0002C\u0005\u0002*)\u0011\r\u0011\"\u0003\u0002,!A\u0011\u0011\b\u0006!\u0002\u0013\ti\u0003C\u0005\u0002<)\u0011\r\u0011\"\u0003\u0002>!A\u00111\n\u0006!\u0002\u0013\ty\u0004C\u0005\u0002N)\u0011\r\u0011\"\u0003\u0002P!A\u0011\u0011\u000e\u0006!\u0002\u0013\t\t\u0006C\u0005\u0002l)\u0011\r\u0011\"\u0003\u0002n!A\u0011q\u000e\u0006!\u0002\u0013\t\u0019\u0007C\u0005\u0002r)\u0011\r\u0011\"\u0003\u0002t!A\u0011q\u0011\u0006!\u0002\u0013\t)\bC\u0005\u0002\n*\u0011\r\u0011\"\u0003\u0002\f\"A\u0011q\u0015\u0006!\u0002\u0013\ti\tC\u0004\u0002**!\t%a+\t\u000f\u0005M&\u0002\"\u0003\u0002,\"A\u0011Q\u0017\u0006\u0005\u0002=\n9\f\u0003\u0005\u0002D*!\taLA7\u0011!\t)M\u0003C\u0001_\u0005\u001d\u0007bBAr\u0015\u0011%\u00111\u0016\u0005\b\u0003KTA\u0011IAt\u0011\u001d\t9P\u0003C\u0005\u0003sDq!a@\u000b\t\u0003\u0011\t\u0001C\u0004\u0003,)!\tA!\f\t\u000f\t=\"\u0002\"\u0003\u00032!9!1\b\u0006\u0005\u0002\tu\u0002b\u0002B\"\u0015\u0011%!Q\t\u0005\b\u0005\u0017RA\u0011\u0001B'\u0011\u001d\u0011)H\u0003C\u0001\u0005oBqA! \u000b\t\u0003\u0011y\b\u0003\u0007\u0003\u0004*\u0001\n\u0011!A\u0001\n\u0003\u0011))A\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!\u0001M\u0019\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003eM\n1bY8pe\u0012Lg.\u0019;pe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005]\nQ\"A\u0018\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0002KUs7N\\8x]\u0012+7\u000f^5oCRLwN\\)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00027b]\u001eT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n11\u000b\u001e:j]\u001e\fa%\u00168l]><h\u000eR3ti&t\u0017\r^5p]F+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005bunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003\tbunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\u0005\t\u0006c\u0001*X\t6\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-r\n!bY8mY\u0016\u001cG/[8o\u0013\tA6KA\u0002TKR\fA\"T3ue&\u001cg*Y7fg\u0002\nQ!\u00199qYf$R\u0002\u0018BH\u0005#\u0013iJa(\u0003\"\n\r\u0006CA\u001c\u000b'\rQal\u001b\t\u0003?&l\u0011\u0001\u0019\u0006\u0003C\n\fA!\u001e;jY*\u00111\rZ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Q*'B\u00014h\u0003\u0019\t\u0007/Y2iK*\t\u0001.A\u0002pe\u001eL!A\u001b1\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011An\\\u0007\u0002[*\u0011anM\u0001\u0006kRLGn]\u0005\u0003a6\u0014q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003gVl\u0011\u0001\u001e\u0006\u0003GNJ!A\u001e;\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005ML\u0018B\u0001>u\u00055iU\r^1eCR\f7)Y2iK\u0006ia.\u001a;x_J\\7\t\\5f]R\u00042!`A\u0001\u001b\u0005q(BA@e\u0003\u001d\u0019G.[3oiNL1!a\u0001\u007f\u00055qU\r^<pe.\u001cE.[3oi\u0006yA\u000f\u001f8Ti\u0006$X-T1oC\u001e,'\u000fE\u00028\u0003\u0013I1!a\u00030\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/\u0001\u0003uS6,\u0007\u0003BA\t\u00033i!!a\u0005\u000b\u00079\f)BC\u0002\u0002\u0018\u0011\faaY8n[>t\u0017\u0002BA\u000e\u0003'\u0011A\u0001V5nKRYA,a\b\u0002\"\u0005\r\u0012QEA\u0014\u0011\u0015\t\b\u00031\u0001s\u0011\u00159\b\u00031\u0001y\u0011\u0015Y\b\u00031\u0001}\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000fAq!!\u0004\u0011\u0001\u0004\ty!\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024\t\fq!\\3ue&\u001c7/\u0003\u0003\u00028\u0005E\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\nq#\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\t\u0005\u0015\u0013QC\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI%a\u0011\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u00021%tG/\u001a:Ce>\\WM\u001d'jgR,g.\u001a:OC6,\u0007%A\u000bnCJ\\WM]:Rk\u0016,X\rU3s\u0005J|7.\u001a:\u0016\u0005\u0005E\u0003\u0003CA*\u00033\ni&a\u0019\u000e\u0005\u0005U#bAA,+\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0013Q\u000b\u0002\u0004\u001b\u0006\u0004\bcA\u001e\u0002`%\u0019\u0011\u0011\r\u001f\u0003\u0007%sG\u000fE\u00028\u0003KJ1!a\u001a0\u00059!\u0006P\\'be.,'/U;fk\u0016\fa#\\1sW\u0016\u00148/U;fk\u0016\u0004VM\u001d\"s_.,'\u000fI\u0001\u001d[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3s+\t\t\u0019'A\u000fnCJ\\WM]:Rk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:!\u0003Y!\bP\u001c'pO\u0006\u0003\b/\u001a8e%\u0016$(/_)vKV,WCAA;!\u0019\t9(! \u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003/\nYH\u0003\u0002b\u0011&!\u0011qPA=\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\r9\u00141Q\u0005\u0004\u0003\u000b{#A\u0005)f]\u0012LgnZ\"p[BdW\r^3Uq:\fq\u0003\u001e=o\u0019><\u0017\t\u001d9f]\u0012\u0014V\r\u001e:z#V,W/\u001a\u0011\u0002=Q\u0014\u0018M\\:bGRLwN\\:XSRD\u0007+\u001a8eS:<W*\u0019:lKJ\u001cXCAAG!!\t9(a$\u0002\u0014\u0006\u0005\u0015\u0002BAI\u0003s\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\t)*a)\u000f\t\u0005]\u0015q\u0014\t\u0004\u00033cTBAAN\u0015\r\ti*N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005F(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0017\u0006\u0015&bAAQy\u0005yBO]1og\u0006\u001cG/[8og^KG\u000f\u001b)f]\u0012LgnZ'be.,'o\u001d\u0011\u0002\u0011MDW\u000f\u001e3po:$\"!!,\u0011\u0007m\ny+C\u0002\u00022r\u0012A!\u00168ji\u0006i!/Z7pm\u0016lU\r\u001e:jGN\fa\"];fk\u00164uN\u001d\"s_.,'\u000f\u0006\u0003\u0002:\u0006}\u0006#B\u001e\u0002<\u0006\r\u0014bAA_y\t1q\n\u001d;j_:Dq!!1 \u0001\u0004\ti&\u0001\u0005ce>\\WM]%e\u0003U\tX/Z;f\r>\u0014XK\\6o_^t'I]8lKJ\f1#\u00193e\u001b\u0006\u00148.\u001a:t\r>\u0014(I]8lKJ$\u0002\"!,\u0002J\u0006U\u0017\u0011\u001c\u0005\b\u0003\u0017\f\u0003\u0019AAg\u0003\u0019\u0011'o\\6feB!\u0011qZAi\u001b\t\t)\"\u0003\u0003\u0002T\u0006U!\u0001\u0002(pI\u0016Dq!a6\"\u0001\u0004\ti&A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a7\"\u0001\u0004\ti.A\u000eqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM\u001d\t\u0004o\u0005}\u0017bAAq_\t\u0001\u0003+\u001a8eS:<7i\\7qY\u0016$X\r\u0016=o\u0003:$W*\u0019:lKJ,e\u000e\u001e:z\u0003=\u0011X\r\u001e:z\u0019><\u0017\t\u001d9f]\u0012\u001c\u0018\u0001E4f]\u0016\u0014\u0018\r^3SKF,Xm\u001d;t)\t\tI\u000f\u0005\u0004\u0002l\u00065\u0018\u0011_\u0007\u0003\u0003wJA!a<\u0002|\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007}\u000b\u00190C\u0002\u0002v\u0002\u00141DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018AE<sSR,G\u000b\u001f8D_6\u0004H.\u001a;j_:$B!!,\u0002|\"9\u0011Q \u0013A\u0002\u0005\u0005\u0015A\u00059f]\u0012LgnZ\"p[BdW\r^3Uq:\f1#\u00193e)btW*\u0019:lKJ\u001cHk\\*f]\u0012$\"\"!,\u0003\u0004\t\u001d!q\u0003B\u0011\u0011\u001d\u0011)!\na\u0001\u0003;\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\t%Q\u00051\u0001\u0003\f\u0005IA\u000f\u001f8SKN,H\u000e\u001e\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)!!\u0011CA\u000b\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B\u000b\u0005\u001f\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0011\u001d\u0011I\"\na\u0001\u00057\t1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCB\u0019qG!\b\n\u0007\t}qFA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0003$\u0015\u0002\rA!\n\u0002\u00179,w/T3uC\u0012\fG/\u0019\t\u0004o\t\u001d\u0012b\u0001B\u0015_\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003eqW/\u001c+y]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:\u0016\u0005\u0005u\u0013\u0001\u00075bgB+g\u000eZ5oO6\u000b'o[3sgR{wK]5uKR!!1\u0007B\u001d!\rY$QG\u0005\u0004\u0005oa$a\u0002\"p_2,\u0017M\u001c\u0005\b\u000539\u0003\u0019\u0001B\u000e\u0003]i\u0017-\u001f2f/JLG/\u001a+y]\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0003\u0002.\n}\u0002b\u0002B!Q\u0001\u0007\u00111S\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006qAO]=BaB,g\u000e\u001a+p\u0019><G\u0003BAW\u0005\u000fBqA!\u0013*\u0001\u0004\t\t)\u0001\u0007uq:dunZ!qa\u0016tG-\u0001\u000ebI\u0012$\u0006P\\'be.,'o\u001d+p\u0005J|7.\u001a:Rk\u0016,X\r\u0006\u0007\u0002.\n=#\u0011\fB2\u0005O\u0012I\u0007C\u0004\u0003R)\u0002\rAa\u0015\u0002\u0015A\u0014x\u000eZ;dKJLE\rE\u0002<\u0005+J1Aa\u0016=\u0005\u0011auN\\4\t\u000f\tm#\u00061\u0001\u0003^\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042a\u000fB0\u0013\r\u0011\t\u0007\u0010\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005KR\u0003\u0019\u0001B\u0006\u0003\u0019\u0011Xm];mi\"9\u0011Q \u0016A\u0002\u0005\u0005\u0005b\u0002B6U\u0001\u0007!QN\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB!!k\u0016B8!\u0011\tyM!\u001d\n\t\tM\u0014Q\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0005\u0012X-\\8wK6\u000b'o[3sg\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\tiK!\u001f\t\u000f\tm4\u00061\u0001\u0002^\u0005\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\u0006\u0019\"/Z7pm\u0016l\u0015M]6feN4uN\u001d+y]R!\u0011Q\u0016BA\u0011\u001d\ti\u0010\fa\u0001\u0003\u0003\u000bQ\u0004\u001d:pi\u0016\u001cG/\u001a3%Q\u0006\u001c\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u000b\u0005\u0005\u000f\u0013i\t\u0006\u0003\u00034\t%\u0005\"\u0003BF[\u0005\u0005\t\u0019AAg\u0003\rAH%\r\u0005\t\u0005\u0017k\u0013\u0011!a\u00019\")\u0011/\u0003a\u0001e\"9\u00111G\u0005A\u0002\tM\u0005\u0003\u0002BK\u00053k!Aa&\u000b\t\u0005M\u0012QC\u0005\u0005\u00057\u00139JA\u0004NKR\u0014\u0018nY:\t\u000b]L\u0001\u0019\u0001=\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b!9\u0011QB\u0005A\u0002\u0005=\u0001b\u0002BS\u0013\u0001\u0007!qU\u0001\u000bY><7i\u001c8uKb$\b\u0003BA\t\u0005SKAAa+\u0002\u0014\tQAj\\4D_:$X\r\u001f;")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig kafkaConfig, Metrics metrics, MetadataCache metadataCache, TransactionStateManager transactionStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, transactionStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public /* synthetic */ boolean protected$hasInFlightRequests(TransactionMarkerChannelManager x$1, Node x$12) {
        return x$1.hasInFlightRequests(x$12);
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Object object;
        void atomicGetOrUpdate_key;
        void atomicGetOrUpdate_map;
        int brokerId = broker.id();
        Integer n = BoxesRunTime.boxToInteger((int)brokerId);
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> map = this.markersQueuePerBroker();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = TransactionMarkerChannelManager.$anonfun$addMarkersForBroker$1(this, brokerId, broker);
            object = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
        } else {
            throw new MatchError((Object)option);
        }
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Added marker ").append(pendingCompleteTxnAndMarker.txnMarkerEntry()).append(" for transactional id").append(" ").append(pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId()).append(" to destination broker ").append(brokerId).toString());
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pendingCompleteTxnAndMarkerEntries).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.markersQueuePerBroker().values().filter((Function1 & Serializable & scala.Serializable)brokerRequestQueue -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$4(this, brokerRequestQueue)))).map((Function1 & Serializable & scala.Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$7(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = (List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((List)entries).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.txnMarkerEntry(), Buffer$.MODULE$.canBuildFrom())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder($this.metadataCache.metadataVersion().writeTxnMarkersRequestVersion(), markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder)request, (RequestCompletionHandler)requestCompletionHandler);
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Replaced an existing pending complete txn ").append(prev).append(" with ").append(pendingCompleteTxn).append(" while adding markers to send.").toString());
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable & scala.Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal$.MODULE$.NoCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable & scala.Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName()));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topicPartitions.toList()).asJava());
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to remove pending marker entry ").append(current).append(" trying to remove ").append(pendingCompleteTxn).toString());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$1(TransactionMarkerChannelManager $this) {
        return $this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public static final /* synthetic */ int $anonfun$new$2(TransactionMarkerChannelManager $this) {
        return $this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(TransactionMarkerChannelManager $this, int brokerId$1, Node broker$1) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Creating new marker queue map to destination broker ").append(brokerId$1).toString());
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala()).toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$4(TransactionMarkerChannelManager $this, TxnMarkerQueue brokerRequestQueue) {
        return !$this.protected$hasInFlightRequests($this, brokerRequestQueue.destination());
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$7(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker -1").toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker ").append(brokerId$2).toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable & scala.Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time);
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$2(this)));
    }
}

