/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import kafka.durability.audit.AuditJobSummary$;
import kafka.durability.audit.DurabilityAuditConstants$;
import org.apache.kafka.common.utils.Time;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u001a5\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001A\u0002\u0013\u0005q\tC\u0004L\u0001\u0001\u0007I\u0011\u0001'\t\rI\u0003\u0001\u0015)\u0003I\u0011\u001d\u0019\u0006\u00011A\u0005\u0002QCq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011\r\u0003\u0004d\u0001\u0001\u0006K!\u0016\u0005\bI\u0002\u0001\r\u0011\"\u0001U\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019Da\u0001\u001b\u0001!B\u0013)\u0006bB5\u0001\u0001\u0004%\ta\u0012\u0005\bU\u0002\u0001\r\u0011\"\u0001l\u0011\u0019i\u0007\u0001)Q\u0005\u0011\"9a\u000e\u0001a\u0001\n\u0003y\u0007b\u0002<\u0001\u0001\u0004%\ta\u001e\u0005\u0007s\u0002\u0001\u000b\u0015\u00029\t\u000fi\u0004\u0001\u0019!C\u0001\u000f\"91\u0010\u0001a\u0001\n\u0003a\bB\u0002@\u0001A\u0003&\u0001\nC\u0004\u0000\u0001\u0001\u0007I\u0011A$\t\u0013\u0005\u0005\u0001\u00011A\u0005\u0002\u0005\r\u0001bBA\u0004\u0001\u0001\u0006K\u0001\u0013\u0005\t\u0003\u0013\u0001\u0001\u0019!C\u0001\u000f\"I\u00111\u0002\u0001A\u0002\u0013\u0005\u0011Q\u0002\u0005\b\u0003#\u0001\u0001\u0015)\u0003I\u0011!\t\u0019\u0002\u0001a\u0001\n\u00039\u0005\"CA\u000b\u0001\u0001\u0007I\u0011AA\f\u0011\u001d\tY\u0002\u0001Q!\n!C\u0011\"!\b\u0001\u0001\u0004%\t!a\b\t\u0013\u0005\u001d\u0002\u00011A\u0005\u0002\u0005%\u0002\u0002CA\u0017\u0001\u0001\u0006K!!\t\t\u0013\u0005=\u0002\u00011A\u0005\u0002\u0005}\u0001\"CA\u0019\u0001\u0001\u0007I\u0011AA\u001a\u0011!\t9\u0004\u0001Q!\n\u0005\u0005\u0002\"CA\u001d\u0001\u0001\u0007I\u0011AA\u0010\u0011%\tY\u0004\u0001a\u0001\n\u0003\ti\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0015BA\u0011\u0011!\t\u0019\u0005\u0001a\u0001\n\u0003y\u0007\"CA#\u0001\u0001\u0007I\u0011AA$\u0011\u001d\tY\u0005\u0001Q!\nADq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002R\u0001!\t!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0001\u0002P!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u001f\u0003A\u0011AAI\u000f\u001d\t\t\u000b\u000eE\u0001\u0003G3aa\r\u001b\t\u0002\u0005\u0015\u0006B\u0002\"1\t\u0003\t9\u000b\u0003\u0004\u0002*B\"\ta\u0011\u0002\u0010\u0003V$\u0017\u000e\u001e&pEN+X.\\1ss*\u0011QGN\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003oa\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005I\u0014!B6bM.\f7\u0001A\n\u0003\u0001q\u0002\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001E!\t)\u0005!D\u00015\u0003\u0015QwNY%e+\u0005A\u0005CA\u001fJ\u0013\tQeHA\u0002J]R\f\u0011B[8c\u0013\u0012|F%Z9\u0015\u00055\u0003\u0006CA\u001fO\u0013\tyeH\u0001\u0003V]&$\bbB)\u0004\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014A\u00026pE&#\u0007%A\u0005ti\u0006\u0014H\u000fV5nKV\tQ\u000bE\u0002>-bK!a\u0016 \u0003\r=\u0003H/[8o!\tIf,D\u0001[\u0015\tYF,\u0001\u0003uS6,'\"A/\u0002\t)\fg/Y\u0005\u0003?j\u0013q!\u00138ti\u0006tG/A\u0007ti\u0006\u0014H\u000fV5nK~#S-\u001d\u000b\u0003\u001b\nDq!\u0015\u0004\u0002\u0002\u0003\u0007Q+\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002\nabY8na2,G/[8o)&lW-\u0001\nd_6\u0004H.\u001a;j_:$\u0016.\\3`I\u0015\fHCA'h\u0011\u001d\t\u0016\"!AA\u0002U\u000bqbY8na2,G/[8o)&lW\rI\u0001\u0019i>\u0004\u0018n\u0019)beRLG/[8ogJ+\u0017/^3ti\u0016$\u0017\u0001\b;pa&\u001c\u0007+\u0019:uSRLwN\\:SKF,Xm\u001d;fI~#S-\u001d\u000b\u0003\u001b2Dq!\u0015\u0007\u0002\u0002\u0003\u0007\u0001*A\ru_BL7\rU1si&$\u0018n\u001c8t%\u0016\fX/Z:uK\u0012\u0004\u0013AB:uCR,8/F\u0001q!\t\tH/D\u0001s\u0015\t\u0019H,\u0001\u0003mC:<\u0017BA;s\u0005\u0019\u0019FO]5oO\u0006Q1\u000f^1ukN|F%Z9\u0015\u00055C\bbB)\u0010\u0003\u0003\u0005\r\u0001]\u0001\bgR\fG/^:!\u0003q!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c6-\u00198oK\u0012\u001cVoY2fgN\f\u0001\u0005^8qS\u000e\u0004\u0016M\u001d;ji&|gnU2b]:,GmU;dG\u0016\u001c8o\u0018\u0013fcR\u0011Q* \u0005\b#J\t\t\u00111\u0001I\u0003u!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c6-\u00198oK\u0012\u001cVoY2fgN\u0004\u0013!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\*lSB\u0004X\rZ\u0001\u001ai>\u0004\u0018n\u0019)beRLG/[8o'.L\u0007\u000f]3e?\u0012*\u0017\u000fF\u0002N\u0003\u000bAq!U\u000b\u0002\u0002\u0003\u0007\u0001*\u0001\fu_BL7\rU1si&$\u0018n\u001c8TW&\u0004\b/\u001a3!\u0003U!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c6-\u00198oK\u0012\f\u0011\u0004^8qS\u000e\u0004\u0016M\u001d;ji&|gnU2b]:,Gm\u0018\u0013fcR\u0019Q*a\u0004\t\u000fEC\u0012\u0011!a\u0001\u0011\u00061Bo\u001c9jGB\u000b'\u000f^5uS>t7kY1o]\u0016$\u0007%A\u0013u_R\fG\u000eV5fe\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:SKF,Xm\u001d;fI\u0006ICo\u001c;bYRKWM]\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001c(+Z9vKN$X\rZ0%KF$2!TA\r\u0011\u001d\t6$!AA\u0002!\u000ba\u0005^8uC2$\u0016.\u001a:D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH/\u001a3!\u0003\u0001\"x\u000e^1m\u001f\u001a47/\u001a;D_VtG/Q2s_N\u001c\b+\u0019:uSRLwN\\:\u0016\u0005\u0005\u0005\u0002cA\u001f\u0002$%\u0019\u0011Q\u0005 \u0003\t1{gnZ\u0001%i>$\u0018\r\\(gMN,GoQ8v]R\f5M]8tgB\u000b'\u000f^5uS>t7o\u0018\u0013fcR\u0019Q*a\u000b\t\u0011Es\u0012\u0011!a\u0001\u0003C\t\u0011\u0005^8uC2|eMZ:fi\u000e{WO\u001c;BGJ|7o\u001d)beRLG/[8og\u0002\nQ\u0004^8uC2<\u0015\r]\"pk:$\u0018i\u0019:pgN\u0004\u0016M\u001d;ji&|gn]\u0001\"i>$\u0018\r\\$ba\u000e{WO\u001c;BGJ|7o\u001d)beRLG/[8og~#S-\u001d\u000b\u0004\u001b\u0006U\u0002\u0002C)\"\u0003\u0003\u0005\r!!\t\u0002=Q|G/\u00197HCB\u001cu.\u001e8u\u0003\u000e\u0014xn]:QCJ$\u0018\u000e^5p]N\u0004\u0013!\u0006;pi\u0006dG+[7f)\u0006\\W-\u00138NS2d\u0017n]\u0001\u001ai>$\u0018\r\u001c+j[\u0016$\u0016m[3J]6KG\u000e\\5t?\u0012*\u0017\u000fF\u0002N\u0003\u007fA\u0001\"\u0015\u0013\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u0017i>$\u0018\r\u001c+j[\u0016$\u0016m[3J]6KG\u000e\\5tA\u00059!n\u001c2UsB,\u0017a\u00036pERK\b/Z0%KF$2!TA%\u0011\u001d\tv%!AA\u0002A\f\u0001B[8c)f\u0004X\rI\u0001\u001fS:\u001c'/Z7f]R\fU\u000fZ5uK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]R$\u0012!T\u0001\u001fS:\u001c'/Z7f]R\u0004\u0016M\u001d;ji&|gnU6jaB,GmQ8v]R\f\u0001%\u001b8de\u0016lWM\u001c;Tk\u000e\u001cW-\u001a3fIB\u000b'\u000f^5uS>t7i\\;oi\u0006i\"/\u001a9peR$\u0016.\u001a:D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000fF\u0002N\u00033Ba!a\u0017-\u0001\u0004A\u0015a\u0006;jKJ\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t\u0003-\u0019w.\u001c9mKR,'j\u001c2\u0015\u00135\u000b\t'!\u001a\u0002j\u0005\u0015\u0005bBA2[\u0001\u0007\u0011\u0011E\u0001\u0011i>$\u0018\r\\(gMN,GoQ8v]RDq!a\u001a.\u0001\u0004\t\t#A\u0007u_R\fGnR1q\u0007>,h\u000e\u001e\u0005\u000776\u0002\r!a\u001b\u0011\t\u00055\u0014\u0011Q\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005)Q\u000f^5mg*!\u0011QOA<\u0003\u0019\u0019w.\\7p]*\u0019\u0011(!\u001f\u000b\t\u0005m\u0014QP\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0014aA8sO&!\u00111QA8\u0005\u0011!\u0016.\\3\t\u000f\u0005\u001dU\u00061\u0001\u0002\n\u0006Aa-\u001b8jg\",G\rE\u0002>\u0003\u0017K1!!$?\u0005\u001d\u0011un\u001c7fC:\f\u0001B]3tKRTuN\u0019\u000b\n\u001b\u0006M\u0015qSAM\u0003;Ca!!&/\u0001\u0004A\u0015\u0001\u00038fo*{'-\u00133\t\u000bms\u0003\u0019A+\t\r\u0005me\u00061\u0001I\u0003Q!x\u000e^1m)>\u0004\u0018n\u0019)beRLG/[8og\"9\u0011q\u0014\u0018A\u0002\u0005%\u0015aD5t\u001f:$U-\\1oI\u0006+H-\u001b;\u0002\u001f\u0005+H-\u001b;K_\n\u001cV/\\7bef\u0004\"!\u0012\u0019\u0014\u0005AbDCAAR\u0003\u0015\t\u0007\u000f\u001d7z\u0001")
public class AuditJobSummary {
    private int jobId = -1;
    private Option<Instant> startTime = None$.MODULE$;
    private Option<Instant> completionTime = None$.MODULE$;
    private int topicPartitionsRequested = 0;
    private String status = "";
    private int topicPartitionScannedSuccess = 0;
    private int topicPartitionSkipped = 0;
    private int topicPartitionScanned = 0;
    private int totalTierCompactedPartitionsRequested = 0;
    private long totalOffsetCountAcrossPartitions = 0L;
    private long totalGapCountAcrossPartitions = 0L;
    private long totalTimeTakeInMillis = 0L;
    private String jobType = "";

    public static AuditJobSummary apply() {
        return AuditJobSummary$.MODULE$.apply();
    }

    public int jobId() {
        return this.jobId;
    }

    public void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    public Option<Instant> startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Option<Instant> x$1) {
        this.startTime = x$1;
    }

    public Option<Instant> completionTime() {
        return this.completionTime;
    }

    public void completionTime_$eq(Option<Instant> x$1) {
        this.completionTime = x$1;
    }

    public int topicPartitionsRequested() {
        return this.topicPartitionsRequested;
    }

    public void topicPartitionsRequested_$eq(int x$1) {
        this.topicPartitionsRequested = x$1;
    }

    public String status() {
        return this.status;
    }

    public void status_$eq(String x$1) {
        this.status = x$1;
    }

    public int topicPartitionScannedSuccess() {
        return this.topicPartitionScannedSuccess;
    }

    public void topicPartitionScannedSuccess_$eq(int x$1) {
        this.topicPartitionScannedSuccess = x$1;
    }

    public int topicPartitionSkipped() {
        return this.topicPartitionSkipped;
    }

    public void topicPartitionSkipped_$eq(int x$1) {
        this.topicPartitionSkipped = x$1;
    }

    public int topicPartitionScanned() {
        return this.topicPartitionScanned;
    }

    public void topicPartitionScanned_$eq(int x$1) {
        this.topicPartitionScanned = x$1;
    }

    public int totalTierCompactedPartitionsRequested() {
        return this.totalTierCompactedPartitionsRequested;
    }

    public void totalTierCompactedPartitionsRequested_$eq(int x$1) {
        this.totalTierCompactedPartitionsRequested = x$1;
    }

    public long totalOffsetCountAcrossPartitions() {
        return this.totalOffsetCountAcrossPartitions;
    }

    public void totalOffsetCountAcrossPartitions_$eq(long x$1) {
        this.totalOffsetCountAcrossPartitions = x$1;
    }

    public long totalGapCountAcrossPartitions() {
        return this.totalGapCountAcrossPartitions;
    }

    public void totalGapCountAcrossPartitions_$eq(long x$1) {
        this.totalGapCountAcrossPartitions = x$1;
    }

    public long totalTimeTakeInMillis() {
        return this.totalTimeTakeInMillis;
    }

    public void totalTimeTakeInMillis_$eq(long x$1) {
        this.totalTimeTakeInMillis = x$1;
    }

    public String jobType() {
        return this.jobType;
    }

    public void jobType_$eq(String x$1) {
        this.jobType = x$1;
    }

    public void incrementAuditedPartitionCount() {
        this.topicPartitionScanned_$eq(this.topicPartitionScanned() + 1);
    }

    public void incrementPartitionSkippedCount() {
        this.topicPartitionSkipped_$eq(this.topicPartitionSkipped() + 1);
    }

    public void incrementSucceededPartitionCount() {
        this.topicPartitionScannedSuccess_$eq(this.topicPartitionScannedSuccess() + 1);
    }

    public void reportTierCompactedPartitions(int tierCompactedPartitions) {
        this.totalTierCompactedPartitionsRequested_$eq(tierCompactedPartitions);
    }

    public void completeJob(long totalOffsetCount, long totalGapCount, Time time, boolean finished) {
        this.completionTime_$eq((Option<Instant>)new Some((Object)Instant.ofEpochMilli(time.milliseconds())));
        this.totalOffsetCountAcrossPartitions_$eq(totalOffsetCount);
        this.totalGapCountAcrossPartitions_$eq(totalGapCount);
        this.totalTimeTakeInMillis_$eq(this.startTime().get() != null ? Duration.between((Temporal)this.startTime().get(), (Temporal)this.completionTime().get()).toMillis() : 0L);
        this.status_$eq(finished ? DurabilityAuditConstants$.MODULE$.AUDIT_JOB_STATUS_COMPLETED() : DurabilityAuditConstants$.MODULE$.AUDIT_JOB_STATUS_ABORTED());
    }

    public void resetJob(int newJobId, Option<Instant> time, int totalTopicPartitions, boolean isOnDemandAudit) {
        this.jobId_$eq(newJobId);
        this.startTime_$eq(time);
        this.topicPartitionsRequested_$eq(totalTopicPartitions);
        this.topicPartitionScanned_$eq(0);
        this.topicPartitionScannedSuccess_$eq(0);
        this.topicPartitionSkipped_$eq(0);
        this.totalGapCountAcrossPartitions_$eq(0L);
        this.totalOffsetCountAcrossPartitions_$eq(0L);
        this.totalTimeTakeInMillis_$eq(0L);
        this.totalTierCompactedPartitionsRequested_$eq(0);
        this.status_$eq(DurabilityAuditConstants$.MODULE$.AUDIT_JOB_STATUS_IN_PROGRESS());
        this.jobType_$eq(isOnDemandAudit ? DurabilityAuditConstants$.MODULE$.AUDIT_JOB_TYPE_ON_DEMAND() : DurabilityAuditConstants$.MODULE$.AUDIT_JOB_TYPE_PERIODIC());
    }
}

