/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.durability.db.serdes.Database;
import io.confluent.kafka.durability.db.serdes.Header;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.TopicState;
import kafka.durability.db.TopicState$;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftQuorumState;
import kafka.durability.db.kraft.KRaftQuorumState$;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.exceptions.DurabilityObjectNotFoundException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-da\u0002\u00180!\u0003\r\tA\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011!9\u0005A1A\u0005\u0002=\u001a\u0005b\u0002%\u0001\u0005\u0004%\ta\u0011\u0005\t\u0013\u0002\u0001\r\u0011\"\u00010\u0015\"Aq\u000b\u0001a\u0001\n\u0003y\u0003\f\u0003\u0005\\\u0001\t\u0007I\u0011A\u0018]\u0011!\u0019\b\u00011A\u0005\u0002E\"\b\u0002C>\u0001\u0001\u0004%\t!\r?\t\u0011y\u0004\u0001\u0019!C\u0001_}D!\"a\u0002\u0001\u0001\u0004%\taLA\u0005\u0011!\ti\u0001\u0001D\u0001_\u0005=\u0001\"CA \u0001\t\u0007i\u0011AA!\u0011)\t\u0019\u0006\u0001a\u0001\u000e#y\u0013Q\u000b\u0005\u000b\u0003;\u0002\u0001\u0019!D\t_\u0005}\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\u0007\u0003O\u0002a\u0011\u0001 \t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"1\u0011q\u0019\u0001\u0007\u0002yBq!!6\u0001\t\u0013\t9\u000eC\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'CqA!'\u0001\t\u0013\u0011Y\nC\u0004\u00032\u0002!\tAa-\t\u000f\t}\u0006\u0001\"\u0001\u0003B\"9!Q\u001a\u0001\u0005\u0002\t=\u0007b\u0002Bn\u0001\u0011\u0005!Q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005WDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003t\u0002!\tA!>\t\u000f\tm\b\u0001\"\u0001\u0003r\"1!Q \u0001\u0005\u0002yB\u0001Ba@\u0001\t#y3\u0011\u0001\u0005\t\u0007\u001f\u0001A\u0011C\u0018\u0004\u0012!91q\u0003\u0001\u0005\u0002\re\u0001bBB\u0011\u0001\u0011\u000511\u0005\u0005\b\u0007\u001b\u0002A\u0011AB(\u0011!\u0019\u0019\u0006\u0001D\u0001_\rU\u0003bBB-\u0001\u0019\u000511\f\u0005\u0007\u0007;\u0002A\u0011\u0001 \u0003\u000f\u0011\u0013GK]1ji*\u0011\u0001'M\u0001\u0003I\nT!AM\u001a\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tq\b\u0005\u00029\u0001&\u0011\u0011)\u000f\u0002\u0005+:LG/A\u000bE\u0005~\u0013UK\u0012$F%~Ke*\u0013+`\u0019\u0016su\t\u0016%\u0016\u0003\u0011\u0003\"\u0001O#\n\u0005\u0019K$aA%oi\u00069C)\u0016*B\u0005&c\u0015\nV-`\u000bZ+e\nV*`)>\u0003\u0016jQ0Q\u0003J#\u0016\nV%P\u001d~\u001bu*\u0016(U\u0003%\"UKU!C\u00132KE+W0M\u001fN\u001bv,\u0012,F\u001dR{\u0006+\u0012*`)>\u0003\u0016jQ0Q\u0003J#\u0016\nV%P\u001d\u000611\u000f^1ukN,\u0012a\u0013\t\u0003\u0019Bs!!\u0014(\u000e\u0003=J!aT\u0018\u0002\u0011\u0011\u00137\u000b^1ukNL!!\u0015*\u0003\u0011\u0011\u00137\u000b^1ukNT!aT\u0018)\u0005\u0015!\u0006C\u0001\u001dV\u0013\t1\u0016H\u0001\u0005w_2\fG/\u001b7f\u0003)\u0019H/\u0019;vg~#S-\u001d\u000b\u0003\u007feCqA\u0017\u0004\u0002\u0002\u0003\u00071*A\u0002yIE\n1\u0002^8qS\u000e\u001cF/\u0019;fgV\tQ\f\u0005\u0003_G\u0016\u0004X\"A0\u000b\u0005\u0001\f\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Ef\n!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0004ICNDW*\u00199\u0011\u0005\u0019lgBA4l!\tA\u0017(D\u0001j\u0015\tQW'\u0001\u0004=e>|GOP\u0005\u0003Yf\na\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011A.\u000f\t\u0003\u001bFL!A]\u0018\u0003\u0015Q{\u0007/[2Ti\u0006$X-\u0001\tle\u00064G/U;peVl7\u000b^1uKV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002y_\u0005)1N]1gi&\u0011!p\u001e\u0002\u0011\u0017J\u000bg\r^)v_J,Xn\u0015;bi\u0016\fAc\u001b:bMR\fVo\u001c:v[N#\u0018\r^3`I\u0015\fHCA ~\u0011\u001dQ\u0016\"!AA\u0002U\fa\u0001\u001a2TSj,WCAA\u0001!\rA\u00141A\u0005\u0004\u0003\u000bI$\u0001\u0002'p]\u001e\f!\u0002\u001a2TSj,w\fJ3r)\ry\u00141\u0002\u0005\t5.\t\t\u00111\u0001\u0002\u0002\u0005Qr-\u001a;U_BL7\rU1si&$\u0018n\u001c8t\r>\u0014\u0018)\u001e3jiV\u0011\u0011\u0011\u0003\t\u0007\u0003'\ti\"a\t\u000f\t\u0005U\u0011\u0011\u0004\b\u0004Q\u0006]\u0011\"\u0001\u001e\n\u0007\u0005m\u0011(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\u0004'\u0016\f(bAA\u000esA9\u0001(!\n\u0002*\u0005\u0005\u0011bAA\u0014s\t1A+\u001e9mKJ\u0002B!a\u000b\u0002<5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004d_6lwN\u001c\u0006\u0004i\u0005M\"\u0002BA\u001b\u0003o\ta!\u00199bG\",'BAA\u001d\u0003\ry'oZ\u0005\u0005\u0003{\tiC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007\u0011L'/\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AA5p\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012AAR5mK\u00061\u0001.Z1eKJ,\"!a\u0016\u0011\u00075\u000bI&C\u0002\u0002\\=\u0012\u0001\u0002\u00122IK\u0006$WM]\u0001\u000bQ\u0016\fG-\u001a:`I\u0015\fHcA \u0002b!A!lDA\u0001\u0002\u0004\t9&A\u0005hKR$%mU5{KR\u0011\u0011\u0011A\u0001\u000bG\",7m\u001b9pS:$\b&B\t\u0002l\u0005]\u0004#\u0002\u001d\u0002n\u0005E\u0014bAA8s\t1A\u000f\u001b:poN\u0004B!!\u0012\u0002t%!\u0011QOA$\u0005-Iu*\u0012=dKB$\u0018n\u001c82\ry)\u0017\u0011PASc%\u0019\u00131PAB\u00037\u000b))\u0006\u0003\u0002~\u0005}T#A3\u0005\u000f\u0005\u0005UG1\u0001\u0002\f\n\tA+\u0003\u0003\u0002\u0006\u0006\u001d\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\nf\na\u0001\u001e5s_^\u001c\u0018\u0003BAG\u0003'\u00032\u0001OAH\u0013\r\t\t*\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\t)*a&\u000f\u0007a\nI\"\u0003\u0003\u0002\u001a\u0006\u0005\"!\u0003+ie><\u0018M\u00197fc%\u0019\u0013QTAP\u0003C\u000bIID\u00029\u0003?K1!!#:c\u0015\u0011\u0003(OAR\u0005\u0015\u00198-\u00197bc\r1\u0013\u0011O\u0001\u000ee\u0016\u001cwN^3s\u0011\u0016\fG-\u001a:\u0015\t\u0005]\u00131\u0016\u0005\b\u0003[\u0013\u0002\u0019AAX\u0003\rAGM\u001d\t\u0005\u0003c\u000b\u0019-\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0019\u0019XM\u001d3fg*\u0019\u0001'!/\u000b\u0007I\nYLC\u00025\u0003{SA!a0\u0002B\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003\u0013JA!!2\u00024\n1\u0001*Z1eKJ\fqA]3d_Z,'\u000fK\u0003\u0014\u0003W\nY-\r\u0004\u001fK\u00065\u00171[\u0019\nG\u0005m\u00141QAh\u0003\u000b\u000b\u0014bIAO\u0003?\u000b\t.!#2\u000b\tB\u0014(a)2\u0007\u0019\n\t(\u0001\nxSRD'+Z1eS:,7o]\"iK\u000e\\W\u0003BAm\u0003?$B!a7\u0002jB!\u0011Q\\Ap\u0019\u0001!q!!!\u0015\u0005\u0004\t\t/\u0005\u0003\u0002\u000e\u0006\r\bc\u0001\u001d\u0002f&\u0019\u0011q]\u001d\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002lR!\t\u0019AAw\u0003\r1WO\u001c\t\u0006q\u0005=\u00181\\\u0005\u0004\u0003cL$\u0001\u0003\u001fcs:\fW.\u001a )\u000bQ\t)Pa\u0001\u0011\u000ba\ni'a>\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@2\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0005\u0003\tYPA\u000fEkJ\f'-\u001b7jif$%IT8u%\u0016\fG-_#yG\u0016\u0004H/[8oc\u0019qRM!\u0002\u0003\fEJ1%a\u001f\u0002\u0004\n\u001d\u0011QQ\u0019\nG\u0005u\u0015q\u0014B\u0005\u0003\u0013\u000bTA\t\u001d:\u0003G\u000b4AJA|\u0003M1W\r^2i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\u0011\tB!\b\u0011\u000ba\u0012\u0019Ba\u0006\n\u0007\tU\u0011H\u0001\u0004PaRLwN\u001c\t\u0004\u001b\ne\u0011b\u0001B\u000e_\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007b\u0002B\u0010+\u0001\u0007\u0011\u0011F\u0001\u0003S\u0012DS!FA{\u0005G\tdAH3\u0003&\t-\u0012'C\u0012\u0002|\u0005\r%qEACc%\u0019\u0013QTAP\u0005S\tI)M\u0003#qe\n\u0019+M\u0002'\u0003o\fACZ3uG\"tU\r\u001f;Bk\u0012LGo\u00144gg\u0016$H\u0003\u0002B\u0019\u0005g\u0001R\u0001\u000fB\n\u0003\u0003AqAa\b\u0017\u0001\u0004\tI\u0003K\u0003\u0017\u0003k\u00149$\r\u0004\u001fK\ne\"qH\u0019\nG\u0005m\u00141\u0011B\u001e\u0003\u000b\u000b\u0014bIAO\u0003?\u0013i$!#2\u000b\tB\u0014(a)2\u0007\u0019\n90A\beK2,G/\u001a)beRLG/[8o)\ry$Q\t\u0005\b\u0005?9\u0002\u0019AA\u0015\u00031\tG\r\u001a)beRLG/[8o)\u0019\u0011\tBa\u0013\u0003N!9!q\u0004\rA\u0002\u0005%\u0002b\u0002B(1\u0001\u0007!qC\u0001\u0006gR\fG/\u001a\u0015\u00061\tM#1\f\t\u0006q\u00055$Q\u000b\t\u0005\u0003s\u00149&\u0003\u0003\u0003Z\u0005m(!\t#ve\u0006\u0014\u0017\u000e\\5us>\u0013'.Z2u\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0017G\u0002\u0010f\u0005;\u0012\u0019'M\u0005$\u0003w\n\u0019Ia\u0018\u0002\u0006FJ1%!(\u0002 \n\u0005\u0014\u0011R\u0019\u0006EaJ\u00141U\u0019\u0004M\tU\u0003&\u0002\r\u0002v\n\u001d\u0014G\u0002\u0010f\u0005S\u0012y'M\u0005$\u0003w\n\u0019Ia\u001b\u0002\u0006FJ1%!(\u0002 \n5\u0014\u0011R\u0019\u0006EaJ\u00141U\u0019\u0004M\u0005]\u0018\u0001D1eI\u0006+H-\u001b;J]\u001a|GC\u0002B\t\u0005k\u00129\bC\u0004\u0003 e\u0001\r!!\u000b\t\u000f\t=\u0013\u00041\u0001\u0003\u0018!*\u0011Da\u0015\u0003|E2a$\u001aB?\u0005\u0007\u000b\u0014bIA>\u0003\u0007\u0013y(!\"2\u0013\r\ni*a(\u0003\u0002\u0006%\u0015'\u0002\u00129s\u0005\r\u0016g\u0001\u0014\u0003V!*\u0011$!>\u0003\bF2a$\u001aBE\u0005\u001f\u000b\u0014bIA>\u0003\u0007\u0013Y)!\"2\u0013\r\ni*a(\u0003\u000e\u0006%\u0015'\u0002\u00129s\u0005\r\u0016g\u0001\u0014\u0002x\u0006y\u0011\r\u001a3ECR\fGj\\:t\u0013:4w\u000e\u0006\u0004\u0003\u0012\tU%q\u0013\u0005\b\u0005?Q\u0002\u0019AA\u0015\u0011\u001d\u0011yE\u0007a\u0001\u0005/\t\u0001\"\u00193e)>\u0004\u0018n\u0019\u000b\u0007\u0005;\u0013yJa)\u0011\ta\u0012\u0019\u0002\u001d\u0005\u0007\u0005C[\u0002\u0019A3\u0002\u000bQ|\u0007/[2\t\r\t=3\u00041\u0001qQ\u0015Y\u0012Q\u001fBTc\u0019qRM!+\u00030FJ1%a\u001f\u0002\u0004\n-\u0016QQ\u0019\nG\u0005u\u0015q\u0014BW\u0003\u0013\u000bTA\t\u001d:\u0003G\u000b4AJA|\u0003Y\tG\rZ&SC\u001a$\b+\u0019:uSRLwN\\*uCR,G\u0003\u0002B[\u0005{\u0003R\u0001\u000fB\n\u0005o\u00032A\u001eB]\u0013\r\u0011Yl\u001e\u0002\u0014\u0017J\u000bg\r\u001e)beRLG/[8o'R\fG/\u001a\u0005\b\u0005\u001fb\u0002\u0019\u0001B\\\u0003a1W\r^2i\u0017J\u000bg\r\u001e)beRLG/[8o'R\fG/\u001a\u000b\u0005\u0005k\u0013\u0019\rC\u0004\u0003Fv\u0001\rAa2\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA\u0016\u0005\u0013LAAa3\u0002.\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0014C\u0012$7JU1gi\u0016\u0003xn\u00195MK\u0006$WM\u001d\u000b\u0007\u0005#\u0014\u0019Na6\u0011\ta\u0012\u0019\u0002\u0012\u0005\u0007\u0005+t\u0002\u0019\u0001#\u0002\u000b\u0015\u0004xn\u00195\t\r\teg\u00041\u0001E\u0003!aW-\u00193fe&#\u0017!\u0007;sk:\u001c\u0017\r^3L%\u00064G/\u00129pG\"dU-\u00193feN$2a\u0010Bp\u0011\u0019\u0011\to\ba\u0001\t\u0006AQ.\u001b8Fa>\u001c\u0007.A\u000bgKR\u001c\u0007n\u0013*bMR,\u0005o\\2i\u0019\u0016\fG-\u001a:\u0015\t\tE'q\u001d\u0005\u0007\u0005+\u0004\u0003\u0019\u0001#\u0002%M,Go\u0013*bMRdunY1m\u000bB|7\r\u001b\u000b\u0005\u0005#\u0014i\u000f\u0003\u0004\u0003V\u0006\u0002\r\u0001R\u0001\u0013O\u0016$8JU1gi2{7-\u00197Fa>\u001c\u0007\u000e\u0006\u0002\u0003R\u0006\u00192/\u001a;L%\u00064G\u000fT8dC2tu\u000eZ3JIR!!\u0011\u001bB|\u0011\u0019\u0011Ip\ta\u0001\t\u00061an\u001c3f\u0013\u0012\f1cZ3u\u0017J\u000bg\r\u001e'pG\u0006dgj\u001c3f\u0013\u0012\fQc\u00197fCJ\\%+\u00194u#V|'/^7Ti\u0006$X-A\u0005tKJL\u0017\r\\5{KR\u001111\u0001\t\u0005\u0007\u000b\u0019Y!\u0004\u0002\u0004\b)!1\u0011BA&\u0003\rq\u0017n\\\u0005\u0005\u0007\u001b\u00199A\u0001\u0006CsR,')\u001e4gKJ\f1\u0002Z3tKJL\u0017\r\\5{KR\u0019qha\u0005\t\u000f\rUq\u00051\u0001\u0004\u0004\u00051!-\u001e4gKJ\f\u0001\"[:P]2Lg.Z\u000b\u0003\u00077\u00012\u0001OB\u000f\u0013\r\u0019y\"\u000f\u0002\b\u0005>|G.Z1o\u0003\u0011*\b\u000fZ1uK\u0012+(/\u00192jY&$\u0018\u0010V8qS\u000e\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$H#B \u0004&\r%\u0002BBB\u0014S\u0001\u0007A)A\u0005qCJ$\u0018\u000e^5p]\"911F\u0015A\u0002\u0005\u0005\u0011AB8gMN,G\u000fK\u0003*\u0007_\u00199\u0004E\u00039\u0003[\u001a\t\u0004\u0005\u0003\u0002\u0014\rM\u0012\u0002BB\u001b\u0003C\u0011\u0011$\u00138eKb|U\u000f^(g\u0005>,h\u000eZ:Fq\u000e,\u0007\u000f^5p]F2a$ZB\u001d\u0007\u007f\t\u0014bIA>\u0003\u0007\u001bY$!\"2\u0013\r\ni*a(\u0004>\u0005%\u0015'\u0002\u00129s\u0005\r\u0016g\u0001\u0014\u00042!*\u0011&!>\u0004DE2a$ZB#\u0007\u0017\n\u0014bIA>\u0003\u0007\u001b9%!\"2\u0013\r\ni*a(\u0004J\u0005%\u0015'\u0002\u00129s\u0005\r\u0016g\u0001\u0014\u0002x\u0006\u0011s-\u001a;EkJ\f'-\u001b7jif$v\u000e]5d!\u0006\u0014H/\u001b;j_:|eMZ:fiN,\"a!\u0015\u0011\r\u0005M\u0011QDA\u0001\u0003A9W\r^!mYB\u000b'\u000f^5uS>t7/\u0006\u0002\u0004XA1\u00111CA\u000f\u0003S\t\u0001CZ3uG\"$v\u000e]5d'R\fG/Z:\u0015\u0003u\u000bQa\u00197pg\u0016DS!LA6\u0007C\ndAH3\u0004d\r%\u0014'C\u0012\u0002|\u0005\r5QMACc%\u0019\u0013QTAP\u0007O\nI)M\u0003#qe\n\u0019+M\u0002'\u0003c\u0002")
public interface DbTrait {
    public void kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$topicStates_$eq(HashMap<String, TopicState> var1);

    public int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH();

    public int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT();

    public int DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION();

    public Enumeration.Value status();

    public void status_$eq(Enumeration.Value var1);

    public HashMap<String, TopicState> topicStates();

    public KRaftQuorumState kraftQuorumState();

    public void kraftQuorumState_$eq(KRaftQuorumState var1);

    public long dbSize();

    public void dbSize_$eq(long var1);

    public Seq<Tuple2<TopicPartition, Object>> getTopicPartitionsForAudit();

    public File dir();

    public DbHeader header();

    public void header_$eq(DbHeader var1);

    public static /* synthetic */ long getDbSize$(DbTrait $this) {
        return $this.getDbSize();
    }

    default public long getDbSize() {
        return this.dbSize();
    }

    public void checkpoint() throws IOException;

    private DbHeader recoverHeader(Header hdr) {
        long[] committedOffsets = (long[])Array$.MODULE$.fill(this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), hdr.durabilityPartitionsOffsetsLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ii -> {
            committedOffsets$1[ii] = hdr.durabilityPartitionsOffsets(ii);
        });
        return new DbHeader(hdr.version(), hdr.durabilityRunId(), committedOffsets);
    }

    public void recover() throws IOException;

    private <T> T withReadinessCheck(Function0<T> fun) throws DurabilityDBNotReadyException {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        if (!(value2 != null ? !value2.equals(value) : value != null)) {
            return (T)fun.apply();
        }
        throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
    }

    public static /* synthetic */ Option fetchPartitionState$(DbTrait $this, TopicPartition id) {
        return $this.fetchPartitionState(id);
    }

    default public Option<PartitionState> fetchPartitionState(TopicPartition id) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchPartitionState$1(this, id);
            return option;
        }
    }

    public static /* synthetic */ Option fetchNextAuditOffset$(DbTrait $this, TopicPartition id) {
        return $this.fetchNextAuditOffset(id);
    }

    default public Option<Object> fetchNextAuditOffset(TopicPartition id) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchNextAuditOffset$1(this, id);
            return option;
        }
    }

    public static /* synthetic */ void deletePartition$(DbTrait $this, TopicPartition id) {
        $this.deletePartition(id);
    }

    default public void deletePartition(TopicPartition id) {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            DbTrait.$anonfun$deletePartition$1(this, id);
            return;
        }
    }

    public static /* synthetic */ Option addPartition$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addPartition(id, state);
    }

    default public Option<PartitionState> addPartition(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addPartition$1(this, id, state);
            return option;
        }
    }

    public static /* synthetic */ Option addAuditInfo$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addAuditInfo(id, state);
    }

    default public Option<PartitionState> addAuditInfo(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addAuditInfo$1(this, id, state);
            return option;
        }
    }

    public static /* synthetic */ Option addDataLossInfo$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addDataLossInfo(id, state);
    }

    default public Option<PartitionState> addDataLossInfo(TopicPartition id, PartitionState state) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addDataLossInfo$1(this, id, state);
            return option;
        }
    }

    private Option<TopicState> addTopic(String topic, TopicState state) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addTopic$1(this, topic, state);
            return option;
        }
    }

    public static /* synthetic */ Option addKRaftPartitionState$(DbTrait $this, KRaftPartitionState state) {
        return $this.addKRaftPartitionState(state);
    }

    default public Option<KRaftPartitionState> addKRaftPartitionState(KRaftPartitionState state) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addKRaftPartitionState$1(this, state);
            return option;
        }
    }

    public static /* synthetic */ Option fetchKRaftPartitionState$(DbTrait $this, TopicIdPartition topicIdPartition) {
        return $this.fetchKRaftPartitionState(topicIdPartition);
    }

    default public Option<KRaftPartitionState> fetchKRaftPartitionState(TopicIdPartition topicIdPartition) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchKRaftPartitionState$1(this, topicIdPartition);
            return option;
        }
    }

    public static /* synthetic */ Option addKRaftEpochLeader$(DbTrait $this, int epoch, int leaderId) {
        return $this.addKRaftEpochLeader(epoch, leaderId);
    }

    default public Option<Object> addKRaftEpochLeader(int epoch, int leaderId) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addKRaftEpochLeader$1(this, epoch, leaderId);
            return option;
        }
    }

    public static /* synthetic */ void truncateKRaftEpochLeaders$(DbTrait $this, int minEpoch) {
        $this.truncateKRaftEpochLeaders(minEpoch);
    }

    default public void truncateKRaftEpochLeaders(int minEpoch) {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            DbTrait.$anonfun$truncateKRaftEpochLeaders$1(this, minEpoch);
            return;
        }
    }

    public static /* synthetic */ Option fetchKRaftEpochLeader$(DbTrait $this, int epoch) {
        return $this.fetchKRaftEpochLeader(epoch);
    }

    default public Option<Object> fetchKRaftEpochLeader(int epoch) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchKRaftEpochLeader$1(this, epoch);
            return option;
        }
    }

    public static /* synthetic */ Option setKRaftLocalEpoch$(DbTrait $this, int epoch) {
        return $this.setKRaftLocalEpoch(epoch);
    }

    default public Option<Object> setKRaftLocalEpoch(int epoch) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$setKRaftLocalEpoch$1(this, epoch);
            return option;
        }
    }

    public static /* synthetic */ Option getKRaftLocalEpoch$(DbTrait $this) {
        return $this.getKRaftLocalEpoch();
    }

    default public Option<Object> getKRaftLocalEpoch() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$getKRaftLocalEpoch$1(this);
            return option;
        }
    }

    public static /* synthetic */ Option setKRaftLocalNodeId$(DbTrait $this, int nodeId) {
        return $this.setKRaftLocalNodeId(nodeId);
    }

    default public Option<Object> setKRaftLocalNodeId(int nodeId) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$setKRaftLocalNodeId$1(this, nodeId);
            return option;
        }
    }

    public static /* synthetic */ Option getKRaftLocalNodeId$(DbTrait $this) {
        return $this.getKRaftLocalNodeId();
    }

    default public Option<Object> getKRaftLocalNodeId() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$getKRaftLocalNodeId$1(this);
            return option;
        }
    }

    public static /* synthetic */ void clearKRaftQuorumState$(DbTrait $this) {
        $this.clearKRaftQuorumState();
    }

    default public void clearKRaftQuorumState() {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.apply());
            return;
        }
    }

    public static /* synthetic */ ByteBuffer serialize$(DbTrait $this) {
        return $this.serialize();
    }

    default public ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH()).forceDefaults(true);
        Iterable topicIdx = (Iterable)this.topicStates().values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serialize(builder)), Iterable$.MODULE$.canBuildFrom());
        int topicOffsets = Database.createTopicsVector((FlatBufferBuilder)builder, (int[])((int[])topicIdx.toArray(ClassTag$.MODULE$.Int())));
        int kraftQuorumStateOffset = this.kraftQuorumState().serialize(builder);
        int hdrOffset = this.header().serialize(builder);
        int end = Database.createDatabase((FlatBufferBuilder)builder, (int)hdrOffset, (int)topicOffsets, (int)kraftQuorumStateOffset);
        builder.finish(end);
        return Database.getRootAsDatabase((ByteBuffer)builder.dataBuffer()).getByteBuffer().duplicate();
    }

    public static /* synthetic */ void deserialize$(DbTrait $this, ByteBuffer buffer) {
        $this.deserialize(buffer);
    }

    default public void deserialize(ByteBuffer buffer) {
        Database database = Database.getRootAsDatabase((ByteBuffer)buffer);
        Header hdr = database.header();
        this.header_$eq(this.recoverHeader(hdr));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), database.topicsLength()).foreach((Function1 & Serializable & scala.Serializable)i -> DbTrait.$anonfun$deserialize$1(this, database, BoxesRunTime.unboxToInt((Object)i)));
        if (database.kraftQuorumState() != null) {
            this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.apply(database.kraftQuorumState()));
            return;
        }
    }

    public static /* synthetic */ boolean isOnline$(DbTrait $this) {
        return $this.isOnline();
    }

    default public boolean isOnline() {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static /* synthetic */ void updateDurabilityTopicPartitionOffset$(DbTrait $this, int partition, long offset) {
        $this.updateDurabilityTopicPartitionOffset(partition, offset);
    }

    default public void updateDurabilityTopicPartitionOffset(int partition, long offset) throws DurabilityDBNotReadyException, IndexOutOfBoundsException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            this.header().offsets()[partition] = offset;
            return;
        }
    }

    public static /* synthetic */ Seq getDurabilityTopicPartitionOffsets$(DbTrait $this) {
        return $this.getDurabilityTopicPartitionOffsets();
    }

    default public Seq<Object> getDurabilityTopicPartitionOffsets() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Seq seq = DbTrait.$anonfun$getDurabilityTopicPartitionOffsets$1(this);
            return seq;
        }
    }

    public Seq<TopicPartition> getAllPartitions();

    public HashMap<String, TopicState> fetchTopicStates();

    public static /* synthetic */ void close$(DbTrait $this) {
        $this.close();
    }

    default public void close() throws IOException {
        this.checkpoint();
    }

    public static /* synthetic */ Option $anonfun$fetchPartitionState$1(DbTrait $this, TopicPartition id$1) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$1.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            return s.partitions().get((Object)BoxesRunTime.boxToInteger((int)id$1.partition()));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ Option $anonfun$fetchNextAuditOffset$1(DbTrait $this, TopicPartition id$2) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$2.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            Option option2 = s.partitions().get((Object)BoxesRunTime.boxToInteger((int)id$2.partition()));
            if (option2 instanceof Some) {
                PartitionState value = (PartitionState)((Some)option2).value();
                if (value.auditInfo().readTierPartitionOffset() != -1L) {
                    return new Some((Object)BoxesRunTime.boxToLong((long)(value.auditInfo().readTierPartitionOffset() + 1L)));
                }
                return new Some((Object)BoxesRunTime.boxToLong((long)value.auditInfo().readTierPartitionOffset()));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ Object $anonfun$deletePartition$1(DbTrait $this, TopicPartition id$3) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$3.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            s.partitions().remove((Object)BoxesRunTime.boxToInteger((int)id$3.partition()));
            if (s.partitions().isEmpty()) {
                return $this.topicStates().remove((Object)id$3.topic());
            }
            return BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ Option $anonfun$addPartition$1(DbTrait $this, TopicPartition id$4, PartitionState state$1) {
        if (!$this.topicStates().contains((Object)id$4.topic())) {
            $this.addTopic(id$4.topic(), TopicState$.MODULE$.apply(id$4.topic(), (HashMap<Object, PartitionState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$))));
            return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
        }
        Option option = ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().get((Object)BoxesRunTime.boxToInteger((int)id$4.partition()));
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            state$1.auditInfo_$eq(value.auditInfo());
            return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
    }

    public static /* synthetic */ Option $anonfun$addAuditInfo$1(DbTrait $this, TopicPartition id$5, PartitionState state$2) {
        if (!$this.topicStates().contains((Object)id$5.topic())) {
            $this.addTopic(id$5.topic(), TopicState$.MODULE$.apply(id$5.topic(), (HashMap<Object, PartitionState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$))));
            return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)state$2);
        }
        Option option = ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().get((Object)BoxesRunTime.boxToInteger((int)id$5.partition()));
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            value.auditInfo_$eq(state$2.auditInfo());
            return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)value);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)state$2);
    }

    public static /* synthetic */ Option $anonfun$addDataLossInfo$1(DbTrait $this, TopicPartition id$6, PartitionState state$3) {
        if (!$this.topicStates().contains((Object)id$6.topic())) {
            $this.addTopic(id$6.topic(), TopicState$.MODULE$.apply(id$6.topic(), (HashMap<Object, PartitionState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$))));
            return ((TopicState)$this.topicStates().apply((Object)id$6.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$6.partition()), (Object)state$3);
        }
        Option option = ((TopicState)$this.topicStates().apply((Object)id$6.topic())).partitions().get((Object)BoxesRunTime.boxToInteger((int)id$6.partition()));
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            value.dataLoss_$eq(state$3.dataLoss());
            return ((TopicState)$this.topicStates().apply((Object)id$6.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$6.partition()), (Object)value);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$6.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$6.partition()), (Object)state$3);
    }

    public static /* synthetic */ Option $anonfun$addTopic$1(DbTrait $this, String topic$1, TopicState state$4) {
        return $this.topicStates().put((Object)topic$1, (Object)state$4);
    }

    public static /* synthetic */ Option $anonfun$addKRaftPartitionState$1(DbTrait $this, KRaftPartitionState state$5) {
        return $this.kraftQuorumState().kRaftPartitionStates().put((Object)state$5.topicIdPartition(), (Object)state$5);
    }

    public static /* synthetic */ Option $anonfun$fetchKRaftPartitionState$1(DbTrait $this, TopicIdPartition topicIdPartition$1) {
        return $this.kraftQuorumState().kRaftPartitionStates().get((Object)topicIdPartition$1);
    }

    public static /* synthetic */ Option $anonfun$addKRaftEpochLeader$1(DbTrait $this, int epoch$1, int leaderId$1) {
        return $this.kraftQuorumState().epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)epoch$1), (Object)BoxesRunTime.boxToInteger((int)leaderId$1));
    }

    public static /* synthetic */ boolean $anonfun$truncateKRaftEpochLeaders$2(int minEpoch$1, Tuple2 epochAndLeader) {
        return epochAndLeader._1$mcI$sp() >= minEpoch$1;
    }

    public static /* synthetic */ void $anonfun$truncateKRaftEpochLeaders$1(DbTrait $this, int minEpoch$1) {
        $this.kraftQuorumState().epochLeaderIds_$eq((HashMap<Object, Object>)((HashMap)$this.kraftQuorumState().epochLeaderIds().filter((Function1 & Serializable & scala.Serializable)epochAndLeader -> BoxesRunTime.boxToBoolean((boolean)DbTrait.$anonfun$truncateKRaftEpochLeaders$2(minEpoch$1, epochAndLeader)))));
    }

    public static /* synthetic */ Option $anonfun$fetchKRaftEpochLeader$1(DbTrait $this, int epoch$2) {
        return $this.kraftQuorumState().epochLeaderIds().get((Object)BoxesRunTime.boxToInteger((int)epoch$2));
    }

    public static /* synthetic */ Option $anonfun$setKRaftLocalEpoch$1(DbTrait $this, int epoch$3) {
        int n = $this.kraftQuorumState().epoch();
        switch (n) {
            case -1: {
                $this.kraftQuorumState().epoch_$eq(epoch$3);
                return None$.MODULE$;
            }
        }
        $this.kraftQuorumState().epoch_$eq(epoch$3);
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$getKRaftLocalEpoch$1(DbTrait $this) {
        int n = $this.kraftQuorumState().epoch();
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$setKRaftLocalNodeId$1(DbTrait $this, int nodeId$1) {
        int n = $this.kraftQuorumState().localNodeId();
        switch (n) {
            case -1: {
                $this.kraftQuorumState().localNodeId_$eq(nodeId$1);
                return None$.MODULE$;
            }
        }
        $this.kraftQuorumState().localNodeId_$eq(nodeId$1);
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$getKRaftLocalNodeId$1(DbTrait $this) {
        int n = $this.kraftQuorumState().localNodeId();
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$deserialize$1(DbTrait $this, Database database$1, int i) {
        TopicState topicState = TopicState$.MODULE$.apply(database$1.topics(i));
        return $this.topicStates().put((Object)topicState.topic(), (Object)topicState);
    }

    public static /* synthetic */ Seq $anonfun$getDurabilityTopicPartitionOffsets$1(DbTrait $this) {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps($this.header().offsets())).toSeq();
    }

    public static void $init$(DbTrait $this) {
        $this.kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(0x100000);
        $this.kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(50);
        $this.kafka$durability$db$DbTrait$_setter_$DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION_$eq(10);
        $this.status_$eq(DbStatus$.MODULE$.Init());
        $this.kafka$durability$db$DbTrait$_setter_$topicStates_$eq((HashMap<String, TopicState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)));
        $this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.apply());
        $this.dbSize_$eq(0L);
    }
}

