/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Objects;
import kafka.tier.common.RestServerRequest;
import org.apache.http.client.utils.URIBuilder;

public class GetAuditJobStatusRequest
implements RestServerRequest {
    private final String brokerUrl;
    private final String brokerId;
    private final boolean detail;

    public GetAuditJobStatusRequest(String brokerUrl, boolean detail, String brokerId) {
        this.brokerUrl = brokerUrl;
        this.detail = detail;
        this.brokerId = brokerId;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    @Override
    public RestServerRequest.RestRequestType requestType() {
        return RestServerRequest.RestRequestType.POST;
    }

    @Override
    public String requestBodyAsJson() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("detail", String.valueOf(this.detail));
        StringBuilder body = new StringBuilder();
        body.append("{");
        attributes.forEach((k, v) -> body.append("\"").append((String)k).append("\": \"").append((String)v).append("\","));
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        return body.toString();
    }

    @Override
    public String brokerUrl() {
        return this.brokerUrl;
    }

    @Override
    public String requestName() {
        return GetAuditJobStatusRequest.class.getName();
    }

    @Override
    public URI uri() throws URISyntaxException {
        return new URIBuilder(this.brokerUrl + "/v1/audit/get-audit-job-status").build();
    }

    public int hashCode() {
        return Objects.hash(this.brokerUrl, this.detail, this.brokerId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAuditJobStatusRequest that = (GetAuditJobStatusRequest)o;
        return this.detail == that.detail && Objects.equals(this.brokerUrl, that.brokerUrl) && Objects.equals(this.brokerId, that.brokerId);
    }
}

