/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleanerMetrics$;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B+W\u0001mC\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\t{\u0002\u0011)\u0019!C\u0001}\"I\u00111\u0004\u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005}\u0001BCA\u001e\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011Q\b\u0001\u0003\u0006\u0004%\t!a\u0010\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\t\t\u0005\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017Bq!!\u0016\u0001\t\u0003\t9\u0006\u0003\u0006\u0002f\u0001\u0011\r\u0011\"\u0001W\u0003OB\u0001\"a\u001e\u0001A\u0003%\u0011\u0011\u000e\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003wB\u0011\"! \u0001\u0001\u0004%I!a \t\u000f\u0005-\u0005\u0001)Q\u0005_\"I\u0011Q\u0013\u0001C\u0002\u0013\u0005\u0011q\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u001a\"I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111\u0015\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0001\"a.\u0001A\u0003&\u0011Q\u0015\u0005\n\u0003s\u0003!\u0019!C\u0005\u0003wC\u0001\"a1\u0001A\u0003%\u0011Q\u0018\u0005\u000b\u0003\u000b\u0004!\u0019!C\u0001-\u0006\u001d\u0007\u0002CAj\u0001\u0001\u0006I!!3\t\u0015\u0005U\u0007A1A\u0005\u0002Y\u000b9\u000e\u0003\u0005\u0003(\u0002\u0001\u000b\u0011BAm\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WC\u0001B!0\u0001\t\u00031&q\u0018\u0005\b\u0005\u0003\u0004A\u0011\u0001B/\u0011!\u0011\u0019\r\u0001Q\u0005\n\tu\u0003b\u0002Bc\u0001\u0011\u0005!Q\f\u0005\b\u0005\u000f\u0004A\u0011\u0001B/\u0011\u001d\u0011I\r\u0001C!\u0005\u0017DqAa5\u0001\t\u0003\u0012)\u000eC\u0004\u0003b\u0002!\tEa9\t\u000f\t-\b\u0001\"\u0001\u0003n\"9!\u0011\u001f\u0001\u0005\u0002\tM\b\"\u0003B\u0000\u0001E\u0005I\u0011AB\u0001\u0011\u001d\u00199\u0002\u0001C\u0001\u00073Aqa!\n\u0001\t\u0003\u00199\u0003C\u0004\u0004.\u0001!\taa\f\t\u000f\re\u0002\u0001\"\u0001\u0004<!91q\b\u0001\u0005\u0002\r\u0005\u0003bBB'\u0001\u0011\u00051q\n\u0005\n\u00073\u0002\u0011\u0013!C\u0001\u00077Bqaa\u0018\u0001\t\u0003\u0019\t\u0007\u0003\u0005\u0004l\u0001!\t\u0001WA>\u0011!\u0019i\u0007\u0001C\u0001-\n}faBAu\u0001\u00011\u00161\u001e\u0005\u000b\u0003s\u0004$\u0011!Q\u0001\n\u0005m\bbBA+a\u0011\u0005!\u0011\u0001\u0005\b\u0005\u000b\u0001D\u0011\u000bB\u0004\u0011%\u0011y\u0002\rb\u0001\n\u0003\u0011\t\u0003\u0003\u0005\u0003*A\u0002\u000b\u0011\u0002B\u0012\u0011%\u0011Y\u0003\ra\u0001\n\u0003\u0011i\u0003C\u0005\u00036A\u0002\r\u0011\"\u0001\u00038!A!1\b\u0019!B\u0013\u0011y\u0003C\u0005\u0003@A\u0002\r\u0011\"\u0001\u0003B!I!\u0011\n\u0019A\u0002\u0013\u0005!1\n\u0005\t\u0005\u001f\u0002\u0004\u0015)\u0003\u0003D!9!1\u000b\u0019\u0005\n\tU\u0003b\u0002B.a\u0011\u0005#Q\f\u0005\b\u0005?\u0002D\u0011\u0002B1\u0011\u001d\u0011I\u0007\rC\u0005\u0005CBqAa\u001f1\t\u0013\u0011i\bC\u0004\u0003\nB\"IAa#\b\u000f\r=d\u000b#\u0001\u0004r\u00191QK\u0016E\u0001\u0007gBq!!\u0016D\t\u0003\u0019)\bC\u0005\u0004x\r\u0013\r\u0011\"\u0001\u0003L\"A1\u0011P\"!\u0002\u0013\u0011i\rC\u0004\u0004|\r#\ta! \t\u0013\r\u00055I1A\u0005\n\r\r\u0005\u0002CBH\u0007\u0002\u0006Ia!\"\t\u0013\rE5I1A\u0005\n\r\r\u0005\u0002CBJ\u0007\u0002\u0006Ia!\"\t\u0013\rU5I1A\u0005\n\r\r\u0005\u0002CBL\u0007\u0002\u0006Ia!\"\t\u0013\re5I1A\u0005\n\r\r\u0005\u0002CBN\u0007\u0002\u0006Ia!\"\t\u0013\ru5I1A\u0005\n\r\r\u0005\u0002CBP\u0007\u0002\u0006Ia!\"\t\u0015\r\u00056I1A\u0005\u0002Y\u001b\u0019\u000b\u0003\u0005\u0004(\u000e\u0003\u000b\u0011BBS\u0011%\u0019IkQI\u0001\n\u0003\u0019YK\u0001\u0006M_\u001e\u001cE.Z1oKJT!a\u0016-\u0002\u00071|wMC\u0001Z\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001/cQB\u0011Q\fY\u0007\u0002=*\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\n1\u0011I\\=SK\u001a\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a-\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d$'a\u0002'pO\u001eLgn\u001a\t\u0003S2l\u0011A\u001b\u0006\u0003Wb\u000baa]3sm\u0016\u0014\u0018BA7k\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u0006i\u0011N\\5uS\u0006d7i\u001c8gS\u001e\u0004\"\u0001]>\u000e\u0003ET!a\u0016:\u000b\u0005M$\u0018!C5oi\u0016\u0014h.\u00197t\u0015\t)h/A\u0004ti>\u0014\u0018mZ3\u000b\u0005e;(B\u0001=z\u0003\u0019\t\u0007/Y2iK*\t!0A\u0002pe\u001eL!\u0001`9\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0003\u001dawn\u001a#jeN,\u0012a \t\u0007\u0003\u0003\t9!a\u0003\u000e\u0005\u0005\r!bAA\u0003=\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00111\u0001\u0002\u0004'\u0016\f\b\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0003S>T!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\tyA\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0003\u0003C\u0001raYA\u0012\u0003O\t\u0019$C\u0002\u0002&\u0011\u0014A\u0001U8pYB!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.Y\faaY8n[>t\u0017\u0002BA\u0019\u0003W\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00026\u0005]R\"\u0001,\n\u0007\u0005ebKA\u0006BEN$(/Y2u\u0019><\u0017!\u00027pON\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u0002BA\u0019\u0001/a\u0011\n\u0007\u0005\u0015\u0013O\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0011\t\u00055\u0013\u0011K\u0007\u0003\u0003\u001fR1!ZA\u0016\u0013\u0011\t\u0019&a\u0014\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005e\u00131LA/\u0003?\n\t'a\u0019\u0011\u0007\u0005U\u0002\u0001C\u0003o\u0013\u0001\u0007q\u000eC\u0003~\u0013\u0001\u0007q\u0010C\u0004\u0002\u001e%\u0001\r!!\t\t\u000f\u0005u\u0012\u00021\u0001\u0002B!I\u0011\u0011J\u0005\u0011\u0002\u0003\u0007\u00111J\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003S\u0002B!a\u001b\u0002t5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0004nKR\u0014\u0018nY:\u000b\u0005-4\u0018\u0002BA;\u0003[\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u000511m\u001c8gS\u001e,\u0012a\\\u0001\u000bG>tg-[4`I\u0015\fH\u0003BAA\u0003\u000f\u00032!XAB\u0013\r\t)I\u0018\u0002\u0005+:LG\u000f\u0003\u0005\u0002\n6\t\t\u00111\u0001p\u0003\rAH%M\u0001\bG>tg-[4!Q\rq\u0011q\u0012\t\u0004;\u0006E\u0015bAAJ=\nAao\u001c7bi&dW-\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005e\u0005\u0003BA\u001b\u00037K1!!(W\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM]\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA\u0005\u00112m\\7qC\u000e$\u0018n\u001c8DaVlU\r^3s+\t\t)\u000bE\u0003^\u0003O\u000bY+C\u0002\u0002*z\u0013aa\u00149uS>t\u0007cA2\u0002.&\u0019\u0011q\u00163\u0003\u001fQC'/Z1eg\u000e\u0003X/T3uKJ\facY8na\u0006\u001cG/[8o\u0007B,X*\u001a;fe~#S-\u001d\u000b\u0005\u0003\u0003\u000b)\fC\u0005\u0002\nJ\t\t\u00111\u0001\u0002&\u0006\u00192m\\7qC\u000e$\u0018n\u001c8DaVlU\r^3sA\u0005q1\r\\3b]\u0016\u0014X*\u001a;sS\u000e\u001cXCAA_!\u0011\t)$a0\n\u0007\u0005\u0005gKA\tM_\u001e\u001cE.Z1oKJlU\r\u001e:jGN\fqb\u00197fC:,'/T3ue&\u001c7\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!!3\u0011\t\u0005-\u0017qZ\u0007\u0003\u0003\u001bT!!\u001a:\n\t\u0005E\u0017Q\u001a\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAAm!\u0019\tY.!9\u0002f6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\u0019!A\u0004nkR\f'\r\\3\n\t\u0005\r\u0018Q\u001c\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0002hBj\u0011\u0001\u0001\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\tA\niO\u0019\t\u0005\u0003_\f)0\u0004\u0002\u0002r*!\u00111_A9\u0003\u0011)H/\u001b7\n\t\u0005]\u0018\u0011\u001f\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0005uQJ,\u0017\rZ%e!\ri\u0016Q`\u0005\u0004\u0003\u007ft&aA%oiR!\u0011Q\u001dB\u0002\u0011\u001d\tIP\ra\u0001\u0003w\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\u0011I\u0001\u0005\u0003\u0003\f\tea\u0002\u0002B\u0007\u0005+\u00012Aa\u0004_\u001b\t\u0011\tBC\u0002\u0003\u0014i\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\f=\u00061\u0001K]3eK\u001aLAAa\u0007\u0003\u001e\t11\u000b\u001e:j]\u001eT1Aa\u0006_\u0003\u001d\u0019G.Z1oKJ,\"Aa\t\u0011\t\u0005U\"QE\u0005\u0004\u0005O1&aB\"mK\u0006tWM]\u0001\tG2,\u0017M\\3sA\u0005IA.Y:u'R\fGo]\u000b\u0003\u0005_\u0001B!!\u000e\u00032%\u0019!1\u0007,\u0003\u0019\rcW-\u00198feN#\u0018\r^:\u0002\u001b1\f7\u000f^*uCR\u001cx\fJ3r)\u0011\t\tI!\u000f\t\u0013\u0005%u'!AA\u0002\t=\u0012A\u00037bgR\u001cF/\u0019;tA!\u001a\u0001(a$\u0002#1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8/\u0006\u0002\u0003DA!\u0011Q\u0007B#\u0013\r\u00119E\u0016\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002+1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8o\u0018\u0013fcR!\u0011\u0011\u0011B'\u0011%\tIIOA\u0001\u0002\u0004\u0011\u0019%\u0001\nmCN$\bK]3DY\u0016\fgn\u0015;biN\u0004\u0003fA\u001e\u0002\u0010\u0006I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003\u0003\u00139\u0006C\u0004\u0003Zq\u0002\r!a\n\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u00061Am\\,pe.$\"!!!\u0002)Q\u0014\u0018p\u00117fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8h)\t\u0011\u0019\u0007E\u0002^\u0005KJ1Aa\u001a_\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u00197fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8hQ\u0015y$Q\u000eB=!\u0015i&q\u000eB:\u0013\r\u0011\tH\u0018\u0002\u0007i\"\u0014xn^:\u0011\t\u0005U\"QO\u0005\u0004\u0005o2&\u0001\u0006'pO\u000ecW-\u00198j]\u001e,\u0005pY3qi&|gn\t\u0002\u0003t\u0005A1\r\\3b]2{w\r\u0006\u0003\u0002\u0002\n}\u0004b\u0002BA\u0001\u0002\u0007!1Q\u0001\nG2,\u0017M\\1cY\u0016\u0004B!!\u000e\u0003\u0006&\u0019!q\u0011,\u0003\u00151{w\rV8DY\u0016\fg.A\u0006sK\u000e|'\u000fZ*uCR\u001cH\u0003DAA\u0005\u001b\u0013\tJ!&\u0003 \n\r\u0006b\u0002BH\u0003\u0002\u0007\u00111`\u0001\u0003S\u0012DqAa%B\u0001\u0004\u0011I!\u0001\u0003oC6,\u0007b\u0002BL\u0003\u0002\u0007!\u0011T\u0001\u0005MJ|W\u000eE\u0002^\u00057K1A!(_\u0005\u0011auN\\4\t\u000f\t\u0005\u0016\t1\u0001\u0003\u001a\u0006\u0011Ao\u001c\u0005\b\u0005K\u000b\u0005\u0019\u0001B\u0018\u0003\u0015\u0019H/\u0019;t\u0003%\u0019G.Z1oKJ\u001c\b%A\u000bnCb|e/\u001a:DY\u0016\fg.\u001a:UQJ,\u0017\rZ:\u0015\t\u0005m(Q\u0016\u0005\b\u0005_S\u0002\u0019\u0001BY\u0003\u00051\u0007cB/\u00034\u0006\u0015(qW\u0005\u0004\u0005ks&!\u0003$v]\u000e$\u0018n\u001c82!\ri&\u0011X\u0005\u0004\u0005ws&A\u0002#pk\ndW-A\beK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u+\t\tY0A\u0004ti\u0006\u0014H/\u001e9\u0002!MDW\u000f\u001e3po:\u001cE.Z1oKJ\u001c\u0018\u0001C:ikR$wn\u001e8\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"A!4\u0011\r\u0005\u0005!q\u001aB\u0005\u0013\u0011\u0011\t.a\u0001\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011\u0011\u0011Bl\u0011\u001d\u0011I.\ta\u0001\u00057\f\u0011B\\3x\u0007>tg-[4\u0011\u0007%\u0014i.C\u0002\u0003`*\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t\tI!:\u0003j\"9!q\u001d\u0012A\u0002\tm\u0017!C8mI\u000e{gNZ5h\u0011\u001d\u0011IN\ta\u0001\u00057\fQ\"\u00192peR\u001cE.Z1oS:<G\u0003BAA\u0005_DqA!\u0017$\u0001\u0004\t9#A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!!!\u0003v\ne\bb\u0002B|I\u0001\u0007\u00111B\u0001\bI\u0006$\u0018\rR5s\u0011%\u0011Y\u0010\nI\u0001\u0002\u0004\u0011i0A\tqCJ$\u0018\u000e^5p]R{'+Z7pm\u0016\u0004R!XAT\u0003O\t1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TCAB\u0002U\u0011\u0011ip!\u0002,\u0005\r\u001d\u0001\u0003BB\u0005\u0007'i!aa\u0003\u000b\t\r51qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0005_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007+\u0019YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u0011\u0011QB\u000e\u0007;\u0019\t\u0003C\u0004\u0003Z\u0019\u0002\r!a\n\t\u000f\r}a\u00051\u0001\u0002\f\u0005a1o\\;sG\u0016dun\u001a#je\"911\u0005\u0014A\u0002\u0005-\u0011A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011\u0011QB\u0015\u0011\u001d\u0019Yc\na\u0001\u0005\u0013\t1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002\u0002\u000eE21GB\u001b\u0011\u001d\u00119\u0010\u000ba\u0001\u0003\u0017AqA!\u0017)\u0001\u0004\t9\u0003C\u0004\u00048!\u0002\rA!'\u0002\r=4gm]3u\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!!!\u0004>!9!\u0011L\u0015A\u0002\u0005\u001d\u0012A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0003\u001b\u0019\u0005C\u0004\u0004F)\u0002\raa\u0012\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004b!!\u0001\u0004J\u0005\u001d\u0012\u0002BB&\u0003\u0007\u0011\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\rC^\f\u0017\u000e^\"mK\u0006tW\r\u001a\u000b\t\u0005G\u001a\tfa\u0015\u0004V!9!\u0011L\u0016A\u0002\u0005\u001d\u0002bBB\u001cW\u0001\u0007!\u0011\u0014\u0005\n\u0007/Z\u0003\u0013!a\u0001\u00053\u000b\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"a!\u0018+\t\te5QA\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHCAB2!\u0019\t\ta!\u0013\u0004fA9Qla\u001a\u0002(\u0005M\u0012bAB5=\n1A+\u001e9mKJ\nQbY;se\u0016tGoQ8oM&<\u0017\u0001D2mK\u0006tWM]\"pk:$\u0018A\u0003'pO\u000ecW-\u00198feB\u0019\u0011QG\"\u0014\u0005\rcFCAB9\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u000eG2,\u0017M\\3s\u0007>tg-[4\u0015\u0007=\u001cy\bC\u0004\u0002z\u001d\u0003\rAa7\u0002K5\u000b\u0007PQ;gM\u0016\u0014X\u000b^5mSj\fG/[8o!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,WCABC!\u0011\u00199i!$\u000e\u0005\r%%\u0002BBF\u0003'\tA\u0001\\1oO&!!1DBE\u0003\u0019j\u0015\r\u001f\"vM\u001a,'/\u0016;jY&T\u0018\r^5p]B+'oY3oi6+GO]5d\u001d\u0006lW\rI\u0001\u001f\u00072,\u0017M\\3s%\u0016\u001cw\u000e]=QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\fqd\u00117fC:,'OU3d_BL\b+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003Yi\u0015\r_\"mK\u0006tG+[7f\u001b\u0016$(/[2OC6,\u0017aF'bq\u000ecW-\u00198US6,W*\u001a;sS\u000et\u0015-\\3!\u0003ui\u0015\r_\"p[B\f7\r^5p]\u0012+G.Y=NKR\u0014\u0018nY:OC6,\u0017AH'bq\u000e{W\u000e]1di&|g\u000eR3mCflU\r\u001e:jGNt\u0015-\\3!\u0003e!U-\u00193UQJ,\u0017\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3\u00025\u0011+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u00175+GO]5d\u001d\u0006lWm]\u000b\u0003\u0007K\u0003b!!\u0001\u0003P\u000e\u0015\u0015\u0001D'fiJL7MT1nKN\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004.*\"\u00111JB\u0003\u0001")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private Option<ThreadsCpuMeter> compactionCpuMeter;
    private final LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    private Option<ThreadsCpuMeter> compactionCpuMeter() {
        return this.compactionCpuMeter;
    }

    private void compactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.compactionCpuMeter = x$1;
    }

    public LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics() {
        return this.kafka$log$LogCleaner$$cleanerMetrics;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
        this.compactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)((SeqLike)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getId()), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq())));
    }

    private void shutdownCleaners() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    public void shutdown() {
        try {
            this.shutdownCleaners();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdownCleaners();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (long)((int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }))) / 1000L;
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$3() {
        return this.cleanerManager().cleanBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$4() {
        return this.cleanerManager().cleanableBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$5() {
        return this.cleanerManager().uncleanableBytesLast().get();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$6() {
        return (int)((double)100 * this.cleanerManager().dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$2) {
        return x$2.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$2));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ double kafka$log$LogCleaner$$$anonfun$new$9() {
        return BoxesRunTime.unboxToDouble((Object)this.compactionCpuMeter().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) * (double)100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$12() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$17(CleanerThread x$7) {
        return x$7.lastStats().bufferUtilization();
    }

    public static final /* synthetic */ int $anonfun$new$16(LogCleaner $this) {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$17(x$7));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public static final /* synthetic */ int $anonfun$new$18(LogCleaner $this) {
        ArrayBuffer stats = (ArrayBuffer)$this.cleaners().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$23(CleanerThread x$11) {
        return x$11.lastStats().elapsedSecs();
    }

    public static final /* synthetic */ int $anonfun$new$22(LogCleaner $this) {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$23(x$11));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public static final /* synthetic */ double $anonfun$new$25(CleanerThread x$12) {
        return x$12.lastPreCleanStats().maxCompactionDelayMs();
    }

    public static final /* synthetic */ int $anonfun$new$24(LogCleaner $this) {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$25(x$12));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) / 1000;
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$16 -> x$16 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.compactionCpuMeter = None$.MODULE$;
        this.kafka$log$LogCleaner$$cleanerMetrics = new LogCleanerMetrics(LogCleanerMetrics$.MODULE$.$lessinit$greater$default$1());
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxCompactionDelayGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsUncleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxDirtyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxBufferUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final double value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanerRecopyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$16(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$18(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$22(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$24(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$17 -> (TopicPartition)x$17._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tOffset Map is Full: %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stats.offsetMapFull())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            }, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastStats = new CleanerStats(LogCleaner.this.kafka$log$LogCleaner$$time, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

