/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011ua!B/_\u0001y\u0013\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011A9\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013\u0011\bBCA\u0002\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u00055\u0002A!b\u0001\n\u0003\ty\u0003\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003cAq!!\u0012\u0001\t\u0003\t9\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\r\u0001!\u0002\u0013\t)\u0006C\u0004\u0002h\u0001!\t&!\u001b\t\u0015\u0005\u0005\u0005A1A\u0005\u0002y\u000b\u0019\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAC\u0011%\t\t\n\u0001a\u0001\n\u0013\t\u0019\nC\u0005\u0002.\u0002\u0001\r\u0011\"\u0003\u00020\"A\u00111\u0018\u0001!B\u0013\t)\nC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u00111\u001c\u0001!\u0002\u0013\tI\rC\u0005\u0002^\u0002\u0011\r\u0011\"\u0003\u0002`\"A\u0011\u0011\u001e\u0001!\u0002\u0013\t\t\u000fC\u0005\u0002l\u0002\u0011\r\u0011\"\u0003\u0002n\"A!1\u0001\u0001!\u0002\u0013\ty\u000fC\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b!A!q\u0002\u0001!\u0002\u0013\u0011I\u0001C\u0005\u0003\u0012\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!\u0011\u0005\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003$\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!Q\u0005\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003(\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!\u0011\u0006\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003,\u0001\u0001\r\u0011\"\u0001\u0003.!I!Q\u0007\u0001A\u0002\u0013\u0005!q\u0007\u0005\t\u0005w\u0001\u0001\u0015)\u0003\u00030!Q!q\b\u0001C\u0002\u0013\u0005aL!\u0011\t\u0011\tM\u0003\u0001)A\u0005\u0005\u0007B\u0011B!\u0016\u0001\u0001\u0004%IAa\u0016\t\u0013\t}\u0003\u00011A\u0005\n\t\u0005\u0004\u0002\u0003B3\u0001\u0001\u0006KA!\u0017\t\u0013\t%\u0004A1A\u0005\n\t-\u0004\u0002\u0003BB\u0001\u0001\u0006IA!\u001c\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"A!Q\u0012\u0001\u0005\u0002y\u0013y\t\u0003\u0005\u0003\u001c\u0002!\tA\u0018BO\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OC\u0011B!3\u0001#\u0003%\tAa3\t\u000f\t\u0005\b\u0001\"\u0001\u0003d\"9!\u0011\u001f\u0001\u0005\u0002\t\r\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\b\u0005w\u0004A\u0011\u0001B\u007f\u0011\u001d\u0019\t\u0001\u0001C\u0001\u0007\u0007Aqaa\u0003\u0001\t\u0013\u0019i\u0001C\u0004\u0004\u001c\u0001!Ia!\b\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91q\u0005\u0001\u0005\u0002\r%\u0002\"CB\u001f\u0001E\u0005I\u0011AB \u0011%\u0019\u0019\u0005AI\u0001\n\u0003\u0019)\u0005C\u0004\u0004J\u0001!\taa\u0013\t\u000f\r]\u0003\u0001\"\u0001\u0004Z!91q\f\u0001\u0005\u0002\r\u0005\u0004bBB6\u0001\u0011\u00051Q\u000e\u0005\b\u0007o\u0002A\u0011AB=\u0011!\ti\u000e\u0001C\u0001=\u000eu\u0004bBBD\u0001\u0011\u00051\u0011\u0012\u0005\b\u0007#\u0003A\u0011ABJ\u0011\u001d\u0019I\n\u0001C\u0001\u00077Cqa!(\u0001\t\u0003\u0019YjB\u0004\u0004 zC\ta!)\u0007\rus\u0006\u0012ABR\u0011\u001d\t)e\u0011C\u0001\u0007KC\u0011ba*D\u0005\u0004%I!a!\t\u0011\r%6\t)A\u0005\u0003\u000bC\u0011ba+D\u0005\u0004%I!a!\t\u0011\r56\t)A\u0005\u0003\u000bC\u0011ba,D\u0005\u0004%I!a!\t\u0011\rE6\t)A\u0005\u0003\u000bC\u0011ba-D\u0005\u0004%I!a!\t\u0011\rU6\t)A\u0005\u0003\u000bC\u0011ba.D\u0005\u0004%I!a!\t\u0011\re6\t)A\u0005\u0003\u000bC\u0011ba/D\u0005\u0004%I!a!\t\u0011\ru6\t)A\u0005\u0003\u000bC\u0011ba0D\u0005\u0004%I!a!\t\u0011\r\u00057\t)A\u0005\u0003\u000bC!ba1D\u0005\u0004%\tAXBc\u0011!\u0019Ym\u0011Q\u0001\n\r\u001d\u0007BCBg\u0007\n\u0007I\u0011\u00010\u0004F\"A1qZ\"!\u0002\u0013\u00199\rC\u0004\u0004R\u000e#Iaa5\t\u000f\r]7\t\"\u0001\u0004Z\"91\u0011]\"\u0005\u0002\r\r\bbBB{\u0007\u0012\u00051q\u001f\u0005\b\t\u0013\u0019E\u0011\u0001C\u0006\u0011\u001d!9b\u0011C\u0001\t3\u0011\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0015\ty\u0006-A\u0002m_\u001eT\u0011!Y\u0001\u0006W\u000647.Y\n\u0004\u0001\rL\u0007C\u00013h\u001b\u0005)'\"\u00014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!,'AB!osJ+g\r\u0005\u0002k[6\t1N\u0003\u0002mA\u0006)Q\u000f^5mg&\u0011an\u001b\u0002\b\u0019><w-\u001b8h\u0003\u001dawn\u001a#jeN\u001c\u0001!F\u0001s!\r\u0019h\u000f_\u0007\u0002i*\u0011Q/Z\u0001\u000bG>dG.Z2uS>t\u0017BA<u\u0005\r\u0019V-\u001d\t\u0003szl\u0011A\u001f\u0006\u0003wr\f!![8\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0005\u0005\u001d\u0001c\u00026\u0002\n\u00055\u00111E\u0005\u0004\u0003\u0017Y'\u0001\u0002)p_2\u0004B!a\u0004\u0002 5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004d_6lwN\u001c\u0006\u0004C\u0006]!\u0002BA\r\u00037\ta!\u00199bG\",'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t\tB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0015\u0012qE\u0007\u0002=&\u0019\u0011\u0011\u00060\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003\u007fi!!!\u000e\u000b\u0007}\u000b9D\u0003\u0003\u0002:\u0005m\u0012!C5oi\u0016\u0014h.\u00197t\u0015\u0011\ti$!\u0006\u0002\u000fM$xN]1hK&!\u0011\u0011IA\u001b\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005\u0002J\u0005-\u0013QJA(!\r\t)\u0003\u0001\u0005\u0006_\u001e\u0001\rA\u001d\u0005\b\u0003\u00079\u0001\u0019AA\u0004\u0011\u001d\tic\u0002a\u0001\u0003c\tA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u00059Q.\u001a;sS\u000e\u001c(\u0002BA0\u0003+\taa]3sm\u0016\u0014\u0018\u0002BA2\u00033\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005-\u0004\u0003BA7\u0003wrA!a\u001c\u0002xA\u0019\u0011\u0011O3\u000e\u0005\u0005M$bAA;a\u00061AH]8pizJ1!!\u001ff\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011P3\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f+\t\t)\t\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tY\t`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002~\u0005%\u0015!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u0002\u0016B9\u0011qSAOq\u0006\u0005VBAAM\u0015\r\tY\n^\u0001\nS6lW\u000f^1cY\u0016LA!a(\u0002\u001a\n\u0019Q*\u00199\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!!%\u0002(*\u0019\u0011q\f1\n\t\u0005-\u0016Q\u0015\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002\u001f\rDWmY6q_&tGo]0%KF$B!!-\u00028B\u0019A-a-\n\u0007\u0005UVM\u0001\u0003V]&$\b\"CA]\u001d\u0005\u0005\t\u0019AAK\u0003\rAH%M\u0001\rG\",7m\u001b9pS:$8\u000f\t\u0015\u0004\u001f\u0005}\u0006c\u00013\u0002B&\u0019\u00111Y3\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8Qe><'/Z:t+\t\tI\r\u0005\u0005\u0002L\u0006E\u0017QBAk\u001b\t\tiMC\u0002\u0002PR\fq!\\;uC\ndW-\u0003\u0003\u0002T\u00065'a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003K\t9.C\u0002\u0002Zz\u0013\u0001\u0003T8h\u00072,\u0017M\\5oON#\u0018\r^3\u0002\u0017%t\u0007K]8he\u0016\u001c8\u000fI\u0001\u0016k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t+\t\t\t\u000f\u0005\u0005\u0002L\u0006E\u00171NAr!\u0019\tY-!:\u0002\u000e%!\u0011q]Ag\u0005\r\u0019V\r^\u0001\u0017k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tA\u0005!An\\2l+\t\ty\u000f\u0005\u0003\u0002r\u0006}XBAAz\u0015\u0011\t)0a>\u0002\u000b1|7m[:\u000b\t\u0005e\u00181`\u0001\u000bG>t7-\u001e:sK:$(bAA\u007fy\u0006!Q\u000f^5m\u0013\u0011\u0011\t!a=\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003I\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3\u0016\u0005\t%\u0001\u0003BAy\u0005\u0017IAA!\u0004\u0002t\nI1i\u001c8eSRLwN\\\u0001\u0014a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG\rI\u0001\u000fG2,\u0017M\u001c\"zi\u0016\u001cH*Y:u+\t\u0011)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\u0011\u0011Y\"a>\u0002\r\u0005$x.\\5d\u0013\u0011\u0011yB!\u0007\u0003\u0015\u0005#x.\\5d\u0019>tw-A\bdY\u0016\fgNQ=uKNd\u0015m\u001d;!\u0003I\u0019G.Z1oC\ndWMQ=uKNd\u0015m\u001d;\u0002'\rdW-\u00198bE2,')\u001f;fg2\u000b7\u000f\u001e\u0011\u0002)Ut7\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cH*Y:u\u0003U)hn\u00197fC:\f'\r\\3CsR,7\u000fT1ti\u0002\n\u0011\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_V\u0011!q\u0006\t\u0004I\nE\u0012b\u0001B\u001aK\n1Ai\\;cY\u0016\fQ\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_~#S-\u001d\u000b\u0005\u0003c\u0013I\u0004C\u0005\u0002:~\t\t\u00111\u0001\u00030\u0005QB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5pA!\u001a\u0001%a0\u0002-\u001d\fWoZ3NKR\u0014\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5UC\u001e,\"Aa\u0011\u0011\u0011\t\u0015#qIA6\u0005\u0013j!!a?\n\t\u0005M\u00171 \t\u0007\u0005\u000b\u0012YEa\u0014\n\t\t5\u00131 \u0002\u0005\u0019&\u001cH\u000f\u0005\u0005\u0003F\tE\u00131NA6\u0013\u0011\ty*a?\u0002/\u001d\fWoZ3NKR\u0014\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5UC\u001e\u0004\u0013!\u0004;j[\u0016|e\rT1tiJ+h.\u0006\u0002\u0003ZA\u0019AMa\u0017\n\u0007\tuSM\u0001\u0003M_:<\u0017!\u0005;j[\u0016|e\rT1tiJ+hn\u0018\u0013fcR!\u0011\u0011\u0017B2\u0011%\tI\fJA\u0001\u0002\u0004\u0011I&\u0001\buS6,wJ\u001a'bgR\u0014VO\u001c\u0011)\u0007\u0015\ny,A\u000bbG\"LWM^3e\u00072,\u0017M\\5oOJ\u000bG/[8\u0016\u0005\t5\u0004\u0003\u0002B8\u0005\u007fj!A!\u001d\u000b\t\tM$QO\u0001\u0005G>\u0014XM\u0003\u0003\u0002\\\t]$\u0002\u0002B=\u0005w\na!_1n[\u0016\u0014(B\u0001B?\u0003\r\u0019w.\\\u0005\u0005\u0005\u0003\u0013\tHA\u0005ISN$xn\u001a:b[\u00061\u0012m\u00195jKZ,Gm\u00117fC:Lgn\u001a*bi&|\u0007%A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\t%\u0005\u0003CA7\u0005\u0017\u000biA!\u0017\n\t\u0005}\u0015qP\u0001\u000eG2,\u0017M\\5oON#\u0018\r^3\u0015\t\tE%q\u0013\t\u0006I\nM\u0015Q[\u0005\u0004\u0005++'AB(qi&|g\u000eC\u0004\u0003\u001a&\u0002\r!!\u0004\u0002\u0005Q\u0004\u0018\u0001E:fi\u000ecW-\u00198j]\u001e\u001cF/\u0019;f)\u0019\t\tLa(\u0003\"\"9!\u0011\u0014\u0016A\u0002\u00055\u0001b\u0002BRU\u0001\u0007\u0011Q[\u0001\u0006gR\fG/Z\u0001\u001aOJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\u0006\u0004\u0003*\nE&q\u0018\t\u0006I\nM%1\u0016\t\u0005\u0003K\u0011i+C\u0002\u00030z\u0013!\u0002T8h)>\u001cE.Z1o\u0011\u001d\u0011\u0019l\u000ba\u0001\u0005k\u000bA\u0001^5nKB!!q\u0017B^\u001b\t\u0011ILC\u0002m\u0003#IAA!0\u0003:\n!A+[7f\u0011%\u0011\tm\u000bI\u0001\u0002\u0004\u0011\u0019-A\u0007qe\u0016\u001cE.Z1o'R\fGo\u001d\t\u0005\u0003K\u0011)-C\u0002\u0003Hz\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018aI4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bTCAa1\u0003P.\u0012!\u0011\u001b\t\u0005\u0005'\u0014i.\u0004\u0002\u0003V*!!q\u001bBm\u0003%)hn\u00195fG.,GMC\u0002\u0003\\\u0016\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yN!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"A!:\u0011\u000bM\u00149Oa;\n\u0007\t%HO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001d!'Q^A\u0007\u0003GI1Aa<f\u0005\u0019!V\u000f\u001d7fe\u0005iA-\u001a7fi\u0006\u0014G.\u001a'pON\fQ\"\u00192peR\u001cE.Z1oS:<G\u0003BAY\u0005oDqA!?0\u0001\u0004\ti!\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011\u0011\u0017B\u0000\u0011\u001d\u0011I\u0010\ra\u0001\u0003\u001b\taB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u00022\u000e\u0015\u0001bBB\u0004c\u0001\u00071\u0011B\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB)1Oa:\u0002\u000e\u0005\t\u0012n]\"mK\u0006t\u0017N\\4J]N#\u0018\r^3\u0015\r\r=1QCB\f!\r!7\u0011C\u0005\u0004\u0007')'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005s\u0014\u0004\u0019AA\u0007\u0011\u001d\u0019IB\ra\u0001\u0003+\fQ\"\u001a=qK\u000e$X\rZ*uCR,\u0017aF5t\u00072,\u0017M\\5oO&s7\u000b^1uKB\u000bWo]3e)\u0011\u0019yaa\b\t\u000f\te8\u00071\u0001\u0002\u000e\u0005!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$B!!-\u0004&!9!\u0011 \u001bA\u0002\u00055\u0011!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugRA\u0011\u0011WB\u0016\u0007_\u00199\u0004\u0003\u0004\u0004.U\u0002\r\u0001_\u0001\bI\u0006$\u0018\rR5s\u0011%\u0019\t$\u000eI\u0001\u0002\u0004\u0019\u0019$\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u0015!'1SB\u001b!\u001d!'Q^A\u0007\u00053B\u0011b!\u000f6!\u0003\u0005\raa\u000f\u0002#A\f'\u000f^5uS>tGk\u001c*f[>4X\rE\u0003e\u0005'\u000bi!A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HEM\u000b\u0003\u0007\u0003RCaa\r\u0003P\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uIM*\"aa\u0012+\t\rm\"qZ\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u00022\u000e53qJB*\u0011\u001d\u0011I\u0010\u000fa\u0001\u0003\u001bAaa!\u00159\u0001\u0004A\u0018\u0001D:pkJ\u001cW\rT8h\t&\u0014\bBBB+q\u0001\u0007\u00010\u0001\u0006eKN$Hj\\4ESJ\f1\u0003[1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016$B!!-\u0004\\!91QL\u001dA\u0002\u0005-\u0014a\u00013je\u00069R.Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\t\u0003c\u001b\u0019g!\u001a\u0004h!11Q\u0006\u001eA\u0002aDqA!?;\u0001\u0004\ti\u0001C\u0004\u0004ji\u0002\rA!\u0017\u0002\r=4gm]3u\u00031!wN\\3DY\u0016\fg.\u001b8h)!\t\tla\u001c\u0004r\rM\u0004b\u0002B}w\u0001\u0007\u0011Q\u0002\u0005\u0007\u0007[Y\u0004\u0019\u0001=\t\u000f\rU4\b1\u0001\u0003Z\u0005IQM\u001c3PM\u001a\u001cX\r^\u0001\rI>tW\rR3mKRLgn\u001a\u000b\u0005\u0003c\u001bY\bC\u0004\u0004\bq\u0002\ra!\u0003\u0015\t\r}41\u0011\t\u0007\u0003[\u001a\t)!\u0004\n\t\u0005\u001d\u0018q\u0010\u0005\b\u0007\u000bk\u0004\u0019AA6\u0003\u0019awn\u001a#je\u0006AR.\u0019:l!\u0006\u0014H/\u001b;j_:,fn\u00197fC:\f'\r\\3\u0015\r\u0005E61RBG\u0011\u001d\u0019)I\u0010a\u0001\u0003WBqaa$?\u0001\u0004\ti!A\u0005qCJ$\u0018\u000e^5p]\u00061\u0012n]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0004\u0010\rU5q\u0013\u0005\u0007?~\u0002\r!a\t\t\u000f\tex\b1\u0001\u0002\u000e\u0005iR.Y5oi\u0006Lg.\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u00022\u0006i!/Z7pm\u0016lU\r\u001e:jGN\f\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s!\r\t)cQ\n\u0004\u0007\u000eLGCABQ\u0003\u0011*fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0017!J+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003i)fn\u00197fC:\f'\r\\3CsR,7/T3ue&\u001cg*Y7f\u0003m)fn\u00197fC:\f'\r\\3CsR,7/T3ue&\u001cg*Y7fA\u0005aB+[7f'&t7-\u001a'bgR\u0014VO\\'t\u001b\u0016$(/[2OC6,\u0017!\b+j[\u0016\u001c\u0016N\\2f\u0019\u0006\u001cHOU;o\u001bNlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002+\u0005\u001b\u0007.[3wK\u0012\u001cE.Z1oS:<'+\u0019;j_\u00061\u0012i\u00195jKZ,Gm\u00117fC:Lgn\u001a*bi&|\u0007%A\fD_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t')\u001f;fg\u0006A2i\\7qC\u000e$X\r\u001a)beRLG/[8o\u0005f$Xm\u001d\u0011\u00029\r{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c'pG\u0006d')\u001f;fg\u0006i2i\\7qC\u000e$X\r\u001a)beRLG/[8o\u0019>\u001c\u0017\r\u001c\"zi\u0016\u001c\b%A\u000fD_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>tG+[3sK\u0012\u0014\u0015\u0010^3t\u0003y\u0019u.\u001c9bGR,G\rU1si&$\u0018n\u001c8US\u0016\u0014X\r\u001a\"zi\u0016\u001c\b%\u0001\u000bHCV<W-T3ue&\u001cg*Y7f\u001d>$\u0016mZ\u000b\u0003\u0007\u000f\u0004b!a&\u0004J\u0006\u0015\u0015\u0002BAt\u00033\u000bQcR1vO\u0016lU\r\u001e:jG:\u000bW.\u001a(p)\u0006<\u0007%\u0001\u000bISN$xn\u001a:b[6+GO]5d\u001d\u0006lWm]\u0001\u0016\u0011&\u001cHo\\4sC6lU\r\u001e:jG:\u000bW.Z:!\u0003II7oQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3\u0015\t\r=1Q\u001b\u0005\u0007?^\u0003\r!a\t\u0002A1|7-\u00197FCJd\u0017.Z:u\t&\u0014H/\u001f\"bi\u000eDG+[7fgR\fW\u000e\u001d\u000b\u0007\u00053\u001aYn!8\t\r}C\u0006\u0019AA\u0012\u0011\u001d\u0019y\u000e\u0017a\u0001\u00053\n\u0001CZ5sgR$\u0015N\u001d;z\u001f\u001a47/\u001a;\u0002%5\f\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-\u001f\u000b\t\u00053\u001a)oa:\u0004r\"1q,\u0017a\u0001\u0003GAqa!;Z\u0001\u0004\u0019Y/\u0001\ffCJd\u0017.Z:u\t&\u0014H/\u001f+j[\u0016\u001cH/Y7q!\u0015!7Q\u001eB-\u0013\r\u0019y/\u001a\u0002\n\rVt7\r^5p]BBqaa=Z\u0001\u0004\u0011I&A\u0002o_^\f\u0001c\u00197fC:\f'\r\\3PM\u001a\u001cX\r^:\u0015\u0011\re8q C\u0001\t\u000f\u0001B!!\n\u0004|&\u00191Q 0\u0003\u001d=3gm]3ugR{7\t\\3b]\"1qL\u0017a\u0001\u0003GAq\u0001b\u0001[\u0001\u0004!)!A\bmCN$8\t\\3b]>3gm]3u!\u0015!'1\u0013B-\u0011\u001d\u0019\u0019P\u0017a\u0001\u00053\nqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\u00115Aq\u0002C\t\t'\u0001r\u0001\u001aBw\u00053\u0012I\u0006\u0003\u0004`7\u0002\u0007\u00111\u0005\u0005\b\u0007?\\\u0006\u0019\u0001B-\u0011\u001d!)b\u0017a\u0001\u00053\n\u0011#\u001e8dY\u0016\fg.\u00192mK>3gm]3u\u0003m!W/\u00197D_6\u0004\u0018m\u0019;j_:\u001cE.Z1oS:<'i\\;oIR!AQ\u0001C\u000e\u0011\u0019yF\f1\u0001\u0002$\u0001")
public class LogCleanerManager
implements Logging {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final KafkaMetricsGroup metricsGroup;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress;
    private final scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private final AtomicLong cleanBytesLast;
    private final AtomicLong cleanableBytesLast;
    private final AtomicLong uncleanableBytesLast;
    private volatile double dirtiestLogCleanableRatio;
    private final HashMap<String, java.util.List<java.util.Map<String, String>>> gaugeMetricNameWithTag;
    private volatile long timeOfLastRun;
    private final Histogram achievedCleaningRatio;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Object> dualCompactionCleaningBound(AbstractLog abstractLog) {
        return LogCleanerManager$.MODULE$.dualCompactionCleaningBound(abstractLog);
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(AbstractLog abstractLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(abstractLog, l, l2);
    }

    public static OffsetsToClean cleanableOffsets(AbstractLog abstractLog, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(abstractLog, option, l);
    }

    public static long maxCompactionDelay(AbstractLog abstractLog, Function0<Object> function0, long l) {
        if (LogCleanerManager$.MODULE$ == null) {
            throw null;
        }
        long maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(abstractLog.config().maxCompactionLagMs(), 0L);
        long maxCompactionDelay_cleanUntilTime = l - maxCompactionDelay_maxCompactionLagMs;
        if (maxCompactionDelay_cleanUntilTime < 0L) {
            return 0L;
        }
        long maxCompactionDelay_earliestDirtySegmentTimestamp = function0.apply$mcJ$sp();
        if (maxCompactionDelay_earliestDirtySegmentTimestamp < maxCompactionDelay_cleanUntilTime) {
            return maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public static long localEarliestDirtyBatchTimestamp(AbstractLog abstractLog, long l) {
        return LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(abstractLog, l);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public AtomicLong cleanBytesLast() {
        return this.cleanBytesLast;
    }

    public AtomicLong cleanableBytesLast() {
        return this.cleanableBytesLast;
    }

    public AtomicLong uncleanableBytesLast() {
        return this.uncleanableBytesLast;
    }

    public double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    public void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    public HashMap<String, java.util.List<java.util.Map<String, String>>> gaugeMetricNameWithTag() {
        return this.gaugeMetricNameWithTag;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    private Histogram achievedCleaningRatio() {
        return this.achievedCleaningRatio;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            long now = time.milliseconds();
            this.timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable allCleanableLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$3._1();
                    AbstractLog log = (AbstractLog)x0$3._2();
                    try {
                        long maxCompactionDelay_earliestDirtySegmentTimestamp;
                        Option lastCleanOffset = lastClean.get((Object)topicPartition);
                        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                        if (offsetsToClean.forceUpdateCheckpoint()) {
                            this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), this.updateCheckpoints$default$3());
                        }
                        if (LogCleanerManager$.MODULE$ == null) {
                            throw null;
                        }
                        long maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L);
                        long maxCompactionDelay_cleanUntilTime = now - maxCompactionDelay_maxCompactionLagMs;
                        long compactionDelayMs = maxCompactionDelay_cleanUntilTime < 0L ? 0L : ((maxCompactionDelay_earliestDirtySegmentTimestamp = LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, offsetsToClean.firstDirtyOffset())) < maxCompactionDelay_cleanUntilTime ? maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp : 0L);
                        preCleanStats.updateMaxCompactionDelay(compactionDelayMs);
                        return new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                    }
                    catch (Throwable e) {
                        throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                    }
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            this.cleanBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.cleanBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            this.cleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.cleanableBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            this.uncleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((TraversableOnce)allCleanableLogs.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.uncleanableBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            Iterable dirtyLogs = (Iterable)allCleanableLogs.filterNot((Function1 & Serializable & scala.Serializable)logToClean -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$10(this, logToClean)));
            this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$11(ltc)));
            if (cleanableLogs.isEmpty()) {
                return None$.MODULE$;
            }
            preCleanStats.recordCleanablePartitions(cleanableLogs.size());
            LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
            this.achievedCleaningRatio().update((int)(filthiest.cleanableRatio() * (double)100));
            double expectedShrinkageRatio = filthiest.log().lastShrinkageRatio() * filthiest.cleanableRatio();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Filthiest log %s has last.shrinkage.ratio=%.3f, dirty.ratio=%.3f, expected.shrinkage.ratio=%.3f %n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filthiest.log().name(), BoxesRunTime.boxToDouble((double)filthiest.log().lastShrinkageRatio()), BoxesRunTime.boxToDouble((double)filthiest.cleanableRatio()), BoxesRunTime.boxToDouble((double)expectedShrinkageRatio)})));
            return new Some((Object)filthiest);
        });
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Iterable deletableLogs = (Iterable)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$2)));
            deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$3._1();
                    return this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                }
                throw new MatchError(null);
            });
            return deletableLogs;
        });
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$1)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition tp = (TopicPartition)x0$2._1();
                    return this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                }
                throw new MatchError(null);
            });
            return toClean;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$));
        });
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Option option = this.inProgress().get(topicPartition);
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
            }
            if (option instanceof Some) {
                int count;
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && (count = logCleaningPaused.pausedCount()) > 1) {
                    return this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
                }
                throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
            }
            throw new MatchError((Object)option);
        }));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            return !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        }
        throw new MatchError((Object)option);
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
            if (Option$.MODULE$.apply((Object)this.logs().get(topicPartition)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isFrozenLogStartOffsetState()))) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
            if (checkpoint != null) {
                try {
                    scala.collection.immutable.Map map;
                    scala.collection.immutable.Map map2;
                    scala.collection.immutable.Map currentCheckpoint = ((TraversableOnce)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2(this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
                    if (partitionToRemove instanceof Some) {
                        TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove).value();
                        map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                    } else if (None$.MODULE$.equals(partitionToRemove)) {
                        map2 = currentCheckpoint;
                    } else {
                        throw new MatchError((Object)partitionToRemove);
                    }
                    scala.collection.immutable.Map updatedCheckpoint = map2;
                    if (partitionToUpdateOrAdd instanceof Some) {
                        Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd).value();
                        map = updatedCheckpoint.$plus(updatedOffset);
                    } else if (None$.MODULE$.equals(partitionToUpdateOrAdd)) {
                        map = updatedCheckpoint;
                    } else {
                        throw new MatchError((Object)partitionToUpdateOrAdd);
                    }
                    updatedCheckpoint = map;
                    checkpoint.write((Map<TopicPartition, Object>)updatedCheckpoint);
                    return;
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    return;
                }
            }
        });
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.read().get((Object)topicPartition));
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition).append("' ").append("from ").append(sourceLogDir.getAbsoluteFile()).append(" directory.").toString());
                    Option x$2 = Option$.MODULE$.apply((Object)topicPartition);
                    Option<Tuple2<TopicPartition, Object>> x$3 = this.updateCheckpoints$default$2();
                    this.updateCheckpoints(sourceLogDir, x$3, (Option<TopicPartition>)x$2);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition).append("' ").append("to ").append(destLogDir.getAbsoluteFile()).append(" directory.").toString());
                    this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))), this.updateCheckpoints$default$3());
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
            Set logUncleanablePartitions = (Set)this.uncleanablePartitions().getOrElse((Object)sourceLogDir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
            if (logUncleanablePartitions.contains((Object)topicPartition)) {
                logUncleanablePartitions.remove((Object)topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
                return;
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x0$1))))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (Option$.MODULE$.apply((Object)this.logs().get(topicPartition)).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maybeTruncateCheckpoint$2(x$9)))) {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint != null) {
                    Map<TopicPartition, Object> existing = checkpoint.read();
                    if (BoxesRunTime.unboxToLong((Object)existing.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset) {
                        checkpoint.write((Map<TopicPartition, Object>)((Map)((scala.collection.mutable.MapLike)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(existing)).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset)))));
                        return;
                    }
                    return;
                }
                return;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))), this.updateCheckpoints$default$3());
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            }
            throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            }
            throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((GenTraversableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option = this.uncleanablePartitions().get((Object)logDir);
            if (option instanceof Some) {
                return BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition));
            }
            if (None$.MODULE$.equals(option)) {
                return this.uncleanablePartitions().put((Object)logDir, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            }
            throw new MatchError((Object)option);
        });
    }

    public boolean isUncleanablePartition(AbstractLog log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.uncleanablePartitions().get((Object)log.parentDir()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition)))));
    }

    public void maintainUncleanablePartitions() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.uncleanablePartitions().values().foreach((Function1 & Serializable & scala.Serializable)partitions -> {
                LogCleanerManager.$anonfun$maintainUncleanablePartitions$2(this, partitions);
                return BoxedUnit.UNIT;
            });
            ((MapLike)this.uncleanablePartitions().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$5(x0$1)))).keys().toList().foreach((Function1 & Serializable & scala.Serializable)key -> this.uncleanablePartitions().remove(key));
        });
    }

    public void removeMetrics() {
        LogCleanerManager$.MODULE$.GaugeMetricNameNoTag().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleanerManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        LogCleanerManager$.MODULE$.HistogramMetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleanerManager.$anonfun$removeMetrics$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.gaugeMetricNameWithTag()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricNameAndTags -> {
            LogCleanerManager.$anonfun$removeMetrics$3(this, metricNameAndTags);
            return BoxedUnit.UNIT;
        });
        this.gaugeMetricNameWithTag().clear();
    }

    public static final /* synthetic */ int $anonfun$new$2(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock($this.lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
    }

    public static final /* synthetic */ boolean $anonfun$new$1(LogCleanerManager $this, File dir) {
        java.util.Map metricTag = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleanerManager.$anonfun$new$2($this, dir)), metricTag);
        return ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), x$2 -> new ArrayList())).add(metricTag);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$11(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, AbstractLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$10(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$11(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock($this.lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
            if (option instanceof Some) {
                Set partitions = (Set)((Some)option).value();
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
                long now = Time.SYSTEM.milliseconds();
                return BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            if (None$.MODULE$.equals(option)) {
                return 0L;
            }
            throw new MatchError((Object)option);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$new$7(LogCleanerManager $this, File dir) {
        java.util.Map metricTag = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$8($this, dir)), metricTag);
        return ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), x$3 -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ boolean $anonfun$new$16(File dir$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            AbstractLog log = (AbstractLog)x0$1._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$17(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((AbstractLog)x0$2._2()).sizeAsyncUpdated();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$15(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$16(dir$3, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$17(x0$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$20(File dir$3, Tuple2 x0$3) {
        if (x0$3 != null) {
            AbstractLog log = (AbstractLog)x0$3._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$21(Tuple2 x0$4) {
        if (x0$4 != null) {
            return ((AbstractLog)x0$4._2()).sizeDetailsAsyncUpdated().localSize();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$19(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$20(dir$3, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$21(x0$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$24(File dir$3, Tuple2 x0$5) {
        if (x0$5 != null) {
            AbstractLog log = (AbstractLog)x0$5._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$25(Tuple2 x0$6) {
        if (x0$6 != null) {
            return ((AbstractLog)x0$6._2()).sizeDetailsAsyncUpdated().tieredSize();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$23(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$24(dir$3, x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$25(x0$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$14(LogCleanerManager $this, File dir) {
        java.util.Map metricTag = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionBytes(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$15($this, dir)), metricTag);
        ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionBytes(), k -> new ArrayList())).add(metricTag);
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$19($this, dir)), metricTag);
        ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes(), k -> new ArrayList())).add(metricTag);
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$23($this, dir)), metricTag);
        return ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes(), k -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ long $anonfun$new$27(LogCleanerManager $this) {
        return Time.SYSTEM.milliseconds() - $this.timeOfLastRun();
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((AbstractLog)x0$1._2()).isLocallyCompactable();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            AbstractLog log = (AbstractLog)x0$2._2();
            return $this.isUncleanablePartition(log, topicPartition) || log.isFrozenLogStartOffsetState();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$10(LogCleanerManager $this, LogToClean logToClean) {
        return $this.inProgress().contains((Object)logToClean.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$11(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > ltc.log().config().minCleanableRatio;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((AbstractLog)x0$1._2()).isLocallyCompactable();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            return $this.inProgress().contains((Object)topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            return !$this.inProgress().contains((Object)topicPartition) && log.isLocallyCompactable() && !$this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.logs().keys().contains((Object)tp);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((File)x0$1._1()).getAbsolutePath();
            return string == null ? dir$4 != null : !string.equals(dir$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateCheckpoint$2(AbstractLog x$9) {
        return x$9.config().compact();
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$2(LogCleanerManager $this, Set partitions) {
        ((TraversableOnce)partitions.filterNot((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, id)))).toList().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitions.remove((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Set)x0$1._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleanerManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$2(LogCleanerManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$4(LogCleanerManager $this, Tuple2 metricNameAndTags$1, java.util.Map tag) {
        $this.metricsGroup().removeMetric((String)metricNameAndTags$1._1(), tag);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$3(LogCleanerManager $this, Tuple2 metricNameAndTags) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)metricNameAndTags._2()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tag -> {
            LogCleanerManager.$anonfun$removeMetrics$4($this, metricNameAndTags, tag);
            return BoxedUnit.UNIT;
        });
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.cleanBytesLast = new AtomicLong(0L);
        this.cleanableBytesLast = new AtomicLong(0L);
        this.uncleanableBytesLast = new AtomicLong(0L);
        this.dirtiestLogCleanableRatio = 0.0;
        this.gaugeMetricNameWithTag = new HashMap();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$1(this, dir)));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$7(this, dir)));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$14(this, dir)));
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$27(this)));
        this.achievedCleaningRatio = this.metricsGroup().newHistogram(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$AchievedCleaningRatio());
    }
}

