/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.log.LocalLog$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Some;

public final class StrayLogMetadataFile$
implements Logging {
    public static StrayLogMetadataFile$ MODULE$;
    private final String StrayLogMetadataFilename;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new StrayLogMetadataFile$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String StrayLogMetadataFilename() {
        return this.StrayLogMetadataFilename;
    }

    private File newFile(File dir) {
        return new File(dir, this.StrayLogMetadataFilename());
    }

    public Option<TopicPartition> read(File dir, LogDirFailureChannel logDirFailureChannel) {
        File metadataFile = this.newFile(dir);
        Path filePath = metadataFile.toPath().toAbsolutePath();
        if (!metadataFile.exists() || metadataFile.length() == 0L) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(StrayLogMetadataFile$.$anonfun$read$1(metadataFile)));
            }
            return Option$.MODULE$.empty();
        }
        try {
            Some some;
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                some = new Some((Object)LocalLog$.MODULE$.parseTopicPartitionName(reader.readLine()));
            }
            return some;
        }
        catch (IOException ioe) {
            String msg = new StringBuilder(58).append("Error while reading stray log metadata file ").append(metadataFile.getAbsolutePath()).append(" due to error ").append(ioe.getMessage()).toString();
            logDirFailureChannel.maybeAddOfflineLogDir(metadataFile.getParentFile().getParent(), msg, ioe);
            throw new KafkaStorageException(msg, (Throwable)ioe);
        }
        catch (Exception e) {
            String msg = new StringBuilder(58).append("Error while reading stray log metadata file ").append(metadataFile.getAbsolutePath()).append(" due to error ").append(e.getMessage()).toString();
            throw new KafkaException(msg, (Throwable)e);
        }
    }

    public void createFileWithData(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        File metadataFile = this.newFile(dir);
        Path path = metadataFile.toPath().toAbsolutePath();
        Path tempPath = Paths.get(new StringBuilder(4).append(((Object)path).toString()).append(".tmp").toString(), new String[0]);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tempPath.toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(LocalLog$.MODULE$.logDirName(topicPartition));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)tempPath, (Path)path);
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to stray log metadata file ").append(metadataFile.getAbsolutePath()).toString();
            logDirFailureChannel.maybeAddOfflineLogDir(metadataFile.getParentFile().getParent(), msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public long lastModifiedTime(File dir) {
        File metadataFile = this.newFile(dir);
        if (!metadataFile.exists() || metadataFile.length() == 0L) {
            throw new KafkaException(new StringBuilder(42).append("Missing or empty stray log metadata file: ").append(metadataFile.getAbsolutePath()).toString());
        }
        return metadataFile.lastModified();
    }

    public static final /* synthetic */ String $anonfun$read$1(File metadataFile$1) {
        return new StringBuilder(42).append("Missing or empty stray log metadata file: ").append(metadataFile$1.getAbsolutePath()).toString();
    }

    private StrayLogMetadataFile$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.StrayLogMetadataFilename = "partition.stray";
    }
}

