/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0004\b\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0011!\u0001\u0004A!A!\u0002\u0013A\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\u001c\u0001\t\u0013A\u0004\"B\"\u0001\t\u0013!\u0005\"\u0002%\u0001\t\u0013I\u0005\"B*\u0001\t\u0013!\u0006\"B/\u0001\t\u0013q\u0006\"\u00022\u0001\t\u0013\u0019\u0007\"\u00023\u0001\t\u0013\u0019\u0007\"B3\u0001\t\u00031'!\u0007'j]VDh)\u001b7f\u001b\u0016$(/[2t\u0007>dG.Z2u_JT!a\u0004\t\u0002\u000f5,GO]5dg*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0005qe>\u001c'k\\8u!\ta2E\u0004\u0002\u001eCA\u0011aDF\u0007\u0002?)\u0011\u0001EE\u0001\u0007yI|w\u000e\u001e \n\u0005\t2\u0012A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!A\t\f\u0002\r1|wmZ3s+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0013aA8sO&\u0011qF\u000b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u00051A(\u001b8jiz\"2aM\u001b7!\t!\u0004!D\u0001\u000f\u0011\u0015QB\u00011\u0001\u001c\u0011\u00151C\u00011\u0001)\u0003\u00191G\rU1uQR\t\u0011\b\u0005\u0002;\u00036\t1H\u0003\u0002={\u0005!a-\u001b7f\u0015\tqt(A\u0002oS>T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002Cw\t!\u0001+\u0019;i\u0003\u0019)8/\u00192mKR\tQ\t\u0005\u0002\u0016\r&\u0011qI\u0006\u0002\b\u0005>|G.Z1o\u0003!1\u0017\u000e\\3MSN$H#\u0001&\u0011\u0007UYU*\u0003\u0002M-\t)\u0011I\u001d:bsB\u0011a*U\u0007\u0002\u001f*\u0011\u0001kP\u0001\u0003S>L!AU(\u0003\t\u0019KG.Z\u0001\u0018G>,h\u000e\u001e$jY\u0016\u001cx+\u001b;i\u0007>tG-\u001b;j_:$\"!\u0016-\u0011\u0005U1\u0016BA,\u0017\u0005\rIe\u000e\u001e\u0005\u00063\"\u0001\rAW\u0001\nG>tG-\u001b;j_:\u0004B!F.N\u000b&\u0011AL\u0006\u0002\n\rVt7\r^5p]F\nAc]=nE>d\u0017n\u0019'j].\u001cuN\u001c;bS:\u001cHcA#`A\")A(\u0003a\u0001\u001b\")\u0011-\u0003a\u00017\u000511/\u001e2tiJ\f\u0011b]8dW\u000e{WO\u001c;\u0015\u0003U\u000bqA\u001a3D_VtG/\u0001\u000bnCf\u0014WMU3hSN$XM]'fiJL7m\u001d\u000b\u0003O*\u0004\"!\u00065\n\u0005%4\"\u0001B+oSRDQa\u001b\u0007A\u00021\f\u0001B]3hSN$(/\u001f\t\u0003[Vl\u0011A\u001c\u0006\u0003_B\fAaY8sK*\u0011q\"\u001d\u0006\u0003eN\fa!_1n[\u0016\u0014(\"\u0001;\u0002\u0007\r|W.\u0003\u0002w]\nyQ*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010")
public class LinuxFileMetricsCollector {
    private final String procRoot;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    private Path fdPath() {
        return Paths.get(this.procRoot, "self", "fd");
    }

    private boolean usable() {
        try {
            return this.fdPath().toFile().canRead();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private File[] fileList() {
        try {
            return this.fdPath().toFile().listFiles();
        }
        catch (Exception exception) {
            return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
        }
    }

    private int countFilesWithCondition(Function1<File, Object> condition) {
        try {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileList())).count(condition);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean symbolicLinkContains(File file, String substr) {
        try {
            return ((Object)Files.readSymbolicLink(file.toPath())).toString().contains(substr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int sockCount() {
        Function1 & java.io.Serializable & Serializable socketPipeCondition = (Function1 & java.io.Serializable & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LinuxFileMetricsCollector.$anonfun$sockCount$1(this, file));
        try {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileList())).count((Function1)socketPipeCondition);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int fdCount() {
        int n;
        int n2;
        Function1 & java.io.Serializable & Serializable socketPipeCondition = (Function1 & java.io.Serializable & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LinuxFileMetricsCollector.$anonfun$fdCount$1(this, file));
        Function1 & java.io.Serializable & Serializable jarCondition = (Function1 & java.io.Serializable & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.symbolicLinkContains(file, ".jar"));
        try {
            n2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileList())).count((Function1)socketPipeCondition);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        int socketPipeFiles = n2;
        try {
            n = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileList())).count((Function1)jarCondition);
        }
        catch (Exception exception) {
            n = 0;
        }
        int jarFiles = n;
        return this.fileList().length - socketPipeFiles - jarFiles;
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxFileMetricsCollector.registerGauge$1("linux-file-descriptors-total", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxFileMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxFileMetricsCollector$$$anonfun$maybeRegisterMetrics$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxFileMetricsCollector.registerGauge$1("linux-connections-total", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxFileMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxFileMetricsCollector$$$anonfun$maybeRegisterMetrics$3();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sockCount$1(LinuxFileMetricsCollector $this, File file) {
        return $this.symbolicLinkContains(file, "socket:") || $this.symbolicLinkContains(file, "pipe:");
    }

    public static final /* synthetic */ boolean $anonfun$fdCount$1(LinuxFileMetricsCollector $this, File file) {
        return $this.symbolicLinkContains(file, "socket:") || $this.symbolicLinkContains(file, "pipe:");
    }

    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)"KafkaServer", (String)name);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxFileMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.fdCount();
    }

    public final /* synthetic */ double kafka$metrics$LinuxFileMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.sockCount();
    }

    public LinuxFileMetricsCollector(String procRoot, Logger logger) {
        this.procRoot = procRoot;
        this.logger = logger;
    }
}

