/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.Set;
import java.util.UUID;
import kafka.restore.MessageEmitter;
import kafka.restore.messages.RestoreObjectsInStoreResponse;
import kafka.restore.messages.UploadFtpsToStoreRequest;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class FtpsRepairedToFtpsReconciledTransition
extends AbstractTransition {
    public FtpsRepairedToFtpsReconciledTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_REPAIRED;
    }

    @Override
    public State getTargetState() {
        return State.FTPS_RECONCILED;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        String ftpsFile;
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof RestoreObjectsInStoreResponse)) {
            return false;
        }
        RestoreObjectsInStoreResponse response = (RestoreObjectsInStoreResponse)event.getData("message_response");
        Set<UUID> failedSegmentIds = response.getFailedSegmentIds();
        UploadFtpsToStoreRequest request = null;
        if (failedSegmentIds.size() == 0) {
            ftpsFile = (String)fsm.getMetadata("ftps_file_path");
            LOGGER.debug(String.format("[%s-%d]: ftpsFile from META_FTPS_FILE_PATH = %s", response.getTopic(), response.getPartition(), ftpsFile));
            if (this.shouldRestoreFromFtpsSnapshot(fsm)) {
                FtpsStateForRestore ftpsForRestore = (FtpsStateForRestore)fsm.getMetadata("ftps_for_restore");
                ftpsFile = ftpsForRestore.updatedFtpsState.flushedPath();
                LOGGER.debug(String.format("[%s-%d]: ftpsFile from ftpsForRestore.updatedFtpsState = %s", response.getTopic(), response.getPartition(), ftpsFile));
            }
        } else {
            return false;
        }
        request = new UploadFtpsToStoreRequest(0, response.getTopic(), response.getPartition(), ftpsFile);
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

