/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.Scheduler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g!B\u001a5\u0003\u0003I\u0004\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u0011Q\u0003!\u0011!Q\u0001\n%C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!y\u0007A!A!\u0002\u0013\u0001\b\"\u0002<\u0001\t\u00039\b\"CA\u000b\u0001\t\u0007I\u0011BA\f\u0011!\t)\u0003\u0001Q\u0001\n\u0005e\u0001BCA\u0014\u0001\t\u0007I\u0011\u0001\u001b\u0002*!A\u0011Q\b\u0001!\u0002\u0013\tY\u0003C\u0005\u0002@\u0001\u0011\r\u0011\"\u0005\u0002B!A\u00111\u000b\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0005\u0002X!A\u0011q\f\u0001!\u0002\u0013\tI\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0005\u0002d!9\u0011Q\r\u0001!\u0002\u0013Y\u0006\"CA4\u0001\t\u0007I\u0011AA5\u0011!\t\t\b\u0001Q\u0001\n\u0005-\u0004\"CA:\u0001\t\u0007I\u0011AA;\u0011!\ti\b\u0001Q\u0001\n\u0005]\u0004\"CA@\u0001\t\u0007I\u0011BAA\u0011!\tI\t\u0001Q\u0001\n\u0005\r\u0005\u0002CAF\u0001\u0011\u0005A'!$\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"A\u0011Q\u0015\u0001\u0005\u0002Q\n9\u000b\u0003\u0005\u0002*\u0002!\t\u0001NAV\u0011\u001d\ty\u000b\u0001C\u0001\u0003cC\u0011\"a1\u0001#\u0003%\t!!2\t\u0011\u0005m\u0007\u0001\"\u00015\u0003;D\u0001\"!=\u0001\t\u0003!\u00141\u001f\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011i\u0001\u0001D\u0001\u0005\u001fAqAa\n\u0001\t\u0003\u0011I\u0003C\u0005\u0003D\u0001\t\n\u0011\"\u0001\u0003F!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B(\u0001\u0011E!\u0011\u000b\u0005\b\u00057\u0002A\u0011\u0001B/\u0011%\u0011\t\u0007AI\u0001\n\u0003\u0011)\u0005C\u0004\u0003d\u0001!\tB!\u001a\t\u000f\t]\u0004\u0001\"\u0001\u0003z!9!1\u0013\u0001\u0005\u0002\tU\u0005b\u0002BQ\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0005G\u0003A\u0011AAG\u000f%\u0011)\u000bNA\u0001\u0012\u0003\u00119K\u0002\u00054i\u0005\u0005\t\u0012\u0001BU\u0011\u00191x\u0006\"\u0001\u0003,\"I!QV\u0018\u0012\u0002\u0013\u0005!q\u0016\u0005\n\u0005o{\u0013\u0013!C\u0001\u0005s\u0013a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u0003kY\naa]3sm\u0016\u0014(\"A\u001c\u0002\u000b-\fgm[1\u0004\u0001U\u0011!h_\n\u0004\u0001m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g\r\u0005\u0002C\u000b6\t1I\u0003\u0002Em\u0005)Q\u000f^5mg&\u0011ai\u0011\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0016\u0003%\u0003\"AS)\u000f\u0005-{\u0005C\u0001'>\u001b\u0005i%B\u0001(9\u0003\u0019a$o\\8u}%\u0011\u0001+P\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q{\u0005)a.Y7fA\u0005A1\r\\5f]RLE-A\u0006ok64U\r^2iKJ\u001c\bC\u0001\u001fY\u0013\tIVHA\u0002J]R\f\u0011BZ3uG\"lu\u000eZ3\u0011\u0005qkV\"\u0001\u001b\n\u0005y#$\u0001\u0006$fi\u000eD7i\u001c8oK\u000e$\u0018n\u001c8t\u001b>$W-A\u0005tG\",G-\u001e7feB\u0019A(Y2\n\u0005\tl$AB(qi&|g\u000e\u0005\u0002e[6\tQM\u0003\u0002gO\u0006!Q\u000f^5m\u0015\t)\u0004N\u0003\u00028S*\u0011!n[\u0001\u0007CB\f7\r[3\u000b\u00031\f1a\u001c:h\u0013\tqWMA\u0005TG\",G-\u001e7fe\u0006yQ\r\u001f;sC6+GO]5d)\u0006<7\u000f\u0005\u0003ri&KU\"\u0001:\u000b\u0005Ml\u0014AC2pY2,7\r^5p]&\u0011QO\u001d\u0002\u0004\u001b\u0006\u0004\u0018A\u0002\u001fj]&$h\bF\u0007y\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111\u0003\t\u00049\u0002I\bC\u0001>|\u0019\u0001!Q\u0001 \u0001C\u0002u\u0014\u0011\u0001V\t\u0004}\u0006\r\u0001C\u0001\u001f\u0000\u0013\r\t\t!\u0010\u0002\b\u001d>$\b.\u001b8h!\ra\u0016QA\u0005\u0004\u0003\u000f!$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006\u000f\"\u0001\r!\u0013\u0005\u0006+\"\u0001\r!\u0013\u0005\u0006-\"\u0001\ra\u0016\u0005\u00065\"\u0001\ra\u0017\u0005\b?\"\u0001\n\u00111\u0001a\u0011\u001dy\u0007\u0002%AA\u0002A\fA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bh\u0003\u001diW\r\u001e:jGNLA!a\t\u0002\u001e\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003A1W\r^2iKJ$\u0006N]3bI6\u000b\u0007/\u0006\u0002\u0002,A9\u0011QFA\u001a\u0003oIXBAA\u0018\u0015\r\t\tD]\u0001\b[V$\u0018M\u00197f\u0013\u0011\t)$a\f\u0003\u000f!\u000b7\u000f['baB\u0019A,!\u000f\n\u0007\u0005mBG\u0001\u0006GKR\u001c\u0007.\u001a:UC\u001e\f\u0011CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199!\u0003\u0011awnY6\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0012\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0003QqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6feV\u0011\u0011\u0011\f\t\u0005y\u0005ms+C\u0002\u0002^u\u0012Q!\u0011:sCf\fQC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014\b%A\u000esKBd\u0017nY1GKR\u001c\u0007nQ8o]\u0016\u001cG/[8og6{G-Z\u000b\u00027\u0006a\"/\u001a9mS\u000e\fg)\u001a;dQ\u000e{gN\\3di&|gn]'pI\u0016\u0004\u0013\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t+\t\tY\u0007E\u0002]\u0003[J1!a\u001c5\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\n\u0001\u0003]1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005]\u0004c\u0001/\u0002z%\u0019\u00111\u0010\u001b\u0003!A\u000bWo]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00059bkN,G\rU1si&$\u0018n\u001c8tA\u0005!A/Y4t+\t\t\u0019\tE\u0003ri\u0006\u0015\u0015\n\u0005\u0003\u0002F\u0005\u001d\u0015b\u0001*\u0002H\u0005)A/Y4tA\u0005a2M]3bi\u0016\u001cV\r]1sCR,g)\u001a;dQ\u0016\u0014X*\u001a;sS\u000e\u001cHCAAH!\ra\u0014\u0011S\u0005\u0004\u0003'k$\u0001B+oSR\fA\"\\5o\r\u0016$8\r\u001b*bi\u0016$B!!'\u0002 B\u0019A(a'\n\u0007\u0005uUH\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003CS\u0002\u0019AAR\u0003)1W\r^2iKJl\u0015\r\u001d\t\u0006cR\f9$_\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\tq+A\neK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u)\u0006<7\u000fF\u0002q\u0003[Ca!a \u001d\u0001\u0004\u0001\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0019\ty)a-\u00028\"1\u0011QW\u000fA\u0002]\u000bqA\\3x'&TX\rC\u0005\u0002:v\u0001\n\u00111\u0001\u0002<\u0006Ya-\u001a;dQ\u0016\u0014\bk\\8m!\u0011a\u0014-!0\u0011\u0007q\u000by,C\u0002\u0002BR\u00121BR3uG\",'\u000fU8pY\u0006Q\"/Z:ju\u0016$\u0006N]3bIB{w\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0019\u0016\u0005\u0003w\u000bIm\u000b\u0002\u0002LB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017!C;oG\",7m[3e\u0015\r\t).P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAm\u0003\u001f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)9W\r\u001e$fi\u000eDWM\u001d\u000b\u0005\u0003?\f\t\u000fE\u0002=CfDq!a9 \u0001\u0004\t)/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;i\u0003\u0019\u0019w.\\7p]&!\u0011q^Au\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fAbZ3u\r\u0016$8\r[3s\u0013\u0012$RaVA{\u0003oDq!a9!\u0001\u0004\t)\u000fC\u0004\u0002:\u0002\u0002\r!!0\u000275\f'o\u001b)beRLG/[8og\u001a{'\u000f\u0016:v]\u000e\fG/[8o)!\ty)!@\u0003\u0002\t\r\u0001BBA\u0000C\u0001\u0007q+\u0001\u0005ce>\\WM]%e\u0011\u001d\t\u0019/\ta\u0001\u0003KDqA!\u0002\"\u0001\u0004\u00119!\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019AH!\u0003\n\u0007\t-QH\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$GcB=\u0003\u0012\tU!Q\u0005\u0005\u0007\u0005'\u0011\u0003\u0019A,\u0002\u0013\u0019,Go\u00195fe&#\u0007b\u0002B\fE\u0001\u0007!\u0011D\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)\u0019!q\u0004\u001c\u0002\u000f\rdWo\u001d;fe&!!1\u0005B\u000f\u00059\u0011%o\\6fe\u0016sG\rU8j]RDq!!/#\u0001\u0004\ti,A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogRA\u0011q\u0012B\u0016\u0005o\u0011I\u0004C\u0004\u0003.\r\u0002\rAa\f\u0002'A\f'\u000f^5uS>t\u0017I\u001c3PM\u001a\u001cX\r^:\u0011\rE$\u0018Q\u001dB\u0019!\ra&1G\u0005\u0004\u0005k!$!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"9\u0011\u0011X\u0012A\u0002\u0005u\u0006\"\u0003B\u001eGA\u0005\t\u0019\u0001B\u001f\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003\u0003\u001f\u0003@\u0005\u0015\u00180a$\n\u0007\t\u0005SHA\u0005Gk:\u001cG/[8oe\u0005\t\u0013\r\u001a3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\t\u0016\u0005\u0005{\tI-\u0001\nbI\u00124\u0015-\u001b7fIB\u000b'\u000f^5uS>tG\u0003BAH\u0005\u001bBq!a9&\u0001\u0004\t)/\u0001\u000fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\r\u0005=%1\u000bB,\u0011\u0019\u0011)F\na\u0001s\u0006ia-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DqA!\u0017'\u0001\u0004\u0011y#\u0001\fj]&$\u0018.\u00197PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195t\u0003qi\u0017-\u001f2f\u001b&<'/\u0019;f\u0013:\u001c\u0016P\\2QCJ$\u0018\u000e^5p]N$B!a$\u0003`!I!1H\u0014\u0011\u0002\u0003\u0007!QH\u0001'[\u0006L(-Z'jOJ\fG/Z%o'ft7\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\n\u0014a\u0005;p\u0013:LG/[1m\r\u0016$8\r[*uCR,GC\u0002B\u0018\u0005O\u0012Y\u0007C\u0004\u0003j%\u0002\r!a\u0001\u0002\u000f\u0019,Go\u00195fe\"9!QN\u0015A\u0002\t=\u0014a\u00049beRLG/[8o'R\fG/Z:\u0011\rE$\u0018Q\u001dB9!\ra&1O\u0005\u0004\u0005k\"$a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017aE7bs\n,W\u000b\u001d3bi\u0016$v\u000e]5d\u0013\u0012\u001cHCBAH\u0005w\u0012\t\tC\u0004\u0003~)\u0002\rAa \u0002%A\f'\u000f^5uS>t7\u000fV8Va\u0012\fG/\u001a\t\u0006cR\f)o\u0016\u0005\b\u0005\u0007S\u0003\u0019\u0001BC\u0003!!x\u000e]5d\u0013\u0012\u001c\bC\u0002\u001f\u0003\b&\u0013Y)C\u0002\u0003\nv\u0012\u0011BR;oGRLwN\\\u0019\u0011\tq\n'Q\u0012\t\u0005\u0003O\u0014y)\u0003\u0003\u0003\u0012\u0006%(\u0001B+vS\u0012\f!D]3n_Z,g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$BAa\u001c\u0003\u0018\"9!\u0011T\u0016A\u0002\tm\u0015A\u00039beRLG/[8ogB)\u0011O!(\u0002f&\u0019!q\u0014:\u0003\u0007M+G/\u0001\u000etQV$Hm\\<o\u0013\u0012dWMR3uG\",'\u000f\u00165sK\u0006$7/\u0001\tdY>\u001cX-\u00117m\r\u0016$8\r[3sg\u00061\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000f\u0005\u0002]_M\u0011qf\u000f\u000b\u0003\u0005O\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003\u0002BY\u0005k+\"Aa-+\u0007\u0001\fI\rB\u0003}c\t\u0007Q0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0005\u0005w\u0013y,\u0006\u0002\u0003>*\u001a\u0001/!3\u0005\u000bq\u0014$\u0019A?")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final int numFetchers;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private final int[] numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final PausedPartitions pausedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    public int[] numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public PausedPartitions pausedPartitions() {
        return this.pausedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)fetcherPool -> this.metricsGroup().newGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble((double)this.minFetchRate((Map)this.fetcherThreadMap().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))))), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags().$plus$plus((GenTraversableOnce)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())})))).asJava()));
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble((Object)fetcherMap.values().headOption().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)fetcherMap.values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isThreadFailed()));
            return n;
        }
    }

    public Map<String, String> deadThreadCountTags(Map<String, String> tags) {
        return tags;
    }

    public void resizeThreadPool(int newSize, Option<FetcherPool> fetcherPool) {
        Object object = this.lock();
        synchronized (object) {
            if (fetcherPool.isEmpty()) {
                FetcherPool$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)pool -> {
                    this.maybeMigratePartitions$1(pool, newSize);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.maybeMigratePartitions$1((FetcherPool)fetcherPool.get(), newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<FetcherPool> resizeThreadPool$default$2() {
        return None$.MODULE$;
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition, FetcherPool fetcherPool) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker()[fetcherPool.index()];
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            FetcherPool$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, topicPartition, brokerId, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition, fetcherPool));
                }
                throw new MatchError(null);
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach(arg_0 -> AbstractFetcherManager.$anonfun$addFetcherForPartitions$3$adapted(this, fetcherPool, callback, arg_0));
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$6, x$7);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Added fetcher ").append(fetcherThread.getName()).append(" to broker ").append(fetcherThread.leader().brokerEndPoint().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeMigrateInSyncPartitions(Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                if (x$11 != null) {
                    FetcherTag $anonfun$maybeMigrateInSyncPartitions$2_tag = (FetcherTag)x$11._1();
                    AbstractFetcherThread $anonfun$maybeMigrateInSyncPartitions$2_fetcher = (AbstractFetcherThread)x$11._2();
                    FetcherPool fetcherPool = $anonfun$maybeMigrateInSyncPartitions$2_tag.fetcherPool();
                    FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
                    if (!(fetcherPool != null ? !fetcherPool.equals(fetcherPool$Default$) : fetcherPool$Default$ != null)) {
                        scala.collection.immutable.Set $anonfun$maybeMigrateInSyncPartitions$2_inSyncPartitions = ((TraversableOnce)((TraversableLike)$anonfun$maybeMigrateInSyncPartitions$2_fetcher.fetcherLagStats().stats().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            if (x0$2 != null) {
                                return (TopicPartition)x0$2._1();
                            }
                            throw new MatchError(null);
                        }, Iterable$.MODULE$.canBuildFrom())).toSet();
                        Map<TopicPartition, PartitionFetchState> $anonfun$maybeMigrateInSyncPartitions$2_partitionStates = $anonfun$maybeMigrateInSyncPartitions$2_fetcher.removePartitions((Set<TopicPartition>)$anonfun$maybeMigrateInSyncPartitions$2_inSyncPartitions);
                        Map<TopicPartition, InitialFetchState> $anonfun$maybeMigrateInSyncPartitions$2_fetchStates = this.toInitialFetchState($anonfun$maybeMigrateInSyncPartitions$2_fetcher, $anonfun$maybeMigrateInSyncPartitions$2_partitionStates);
                        this.addFetcherForPartitions($anonfun$maybeMigrateInSyncPartitions$2_fetchStates, FetcherPool$InSync$.MODULE$, callback);
                        if ($anonfun$maybeMigrateInSyncPartitions$2_partitionStates.nonEmpty()) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.keys()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                        }
                    }
                } else {
                    throw new MatchError(null);
                }
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> maybeMigrateInSyncPartitions$default$1() {
        return (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
            AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$default$1$1(x$9, x$10);
            return BoxedUnit.UNIT;
        };
    }

    public Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new InitialFetchState(fetchState.topicId(), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset(), fetchState.replicationSessionId()));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    int leaderId = x0$1._2$mcI$sp();
                    return (Seq)FetcherPool$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition, (FetcherPool)poolType), (FetcherPool)poolType), Seq$.MODULE$.canBuildFrom());
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Seq brokerAndFetcherId = (Seq)x0$2._1();
                    Map partitionsToUpdate = (Map)x0$2._2();
                    return new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                }
                throw new MatchError(null);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                if (x$13 == null) {
                    throw new MatchError(null);
                }
                Seq $anonfun$maybeUpdateTopicIds$5_fetcherTags = (Seq)x$13._1();
                Set $anonfun$maybeUpdateTopicIds$5_partitions = (Set)x$13._2();
                $anonfun$maybeUpdateTopicIds$5_fetcherTags.foreach((Function1 & Serializable & scala.Serializable)fetcherTag -> {
                    this.fetcherThreadMap().get(fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                        x$12.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
            this.pausedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                if (x$14 != null) {
                    FetcherTag key = (FetcherTag)x$14._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$14._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq((Object)key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$15)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$6))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$16);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public static final /* synthetic */ long $anonfun$new$1(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong((Object)$this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.fetcherLagStats().stats().values().iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lag())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$new$4(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong((Object)$this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$5(x$1))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ double $anonfun$new$8(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$9(x$3))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$new$10(AbstractFetcherManager $this) {
        return $this.failedPartitions().size();
    }

    public static final /* synthetic */ int $anonfun$new$11(AbstractFetcherManager $this) {
        return $this.pausedPartitions().size();
    }

    public static final /* synthetic */ void $anonfun$new$13(AbstractFetcherManager $this, Scheduler s) {
        s.schedule("migrate-in-sync-partitions-thread", () -> $this.maybeMigrateInSyncPartitions($this.maybeMigrateInSyncPartitions$default$1()), 0L, 1000L);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$1) : fetcherPool$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    private final void maybeMigratePartitions$1(FetcherPool fetcherPool, int newSize$1) {
        int currentSize = this.numFetchersPerBroker()[fetcherPool.index()];
        if (newSize$1 != currentSize) {
            this.numFetchersPerBroker()[fetcherPool.index()] = newSize$1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Resizing fetcher thread in ").append(fetcherPool.name()).append(" size from ").append(currentSize).append(" to ").append(newSize$1).toString());
            this.migratePartitions$1(newSize$1, fetcherPool);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$resizeThreadPool$2(FetcherPool fetcherPool$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$3) : fetcherPool$3 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$4(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset(), currentFetchState.replicationSessionId());
        ((scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate((Object)id$1.fetcherPool(), (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).update((Object)topicPartition, (Object)initialFetchState);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$resizeThreadPool$3(int newSize$2, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$2) {
            thread.shutdown();
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$4(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize, FetcherPool fetcherPool2) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        void forKeyValue$extension_f2;
        void forKeyValue$extension_$this2;
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap filteredFetcherThreads = (HashMap)this.fetcherThreadMap().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$resizeThreadPool$2(fetcherPool2, x0$1)));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$3(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(filteredFetcherThreads);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
        Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        };
        Map map2 = Implicits$.MODULE$.MapExtensionMethods(allRemovedPartitionsMapByFetcherPool);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, TopicPartition topicPartition$2, int brokerId$1, long truncationOffset$1, FetcherPool fetcherPool) {
        int fetcherId = $this.getFetcherId(topicPartition$2, fetcherPool);
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId, fetcherPool);
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable & scala.Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put((Object)fetcherTag, fetcherThread);
        ((AbstractFetcherThread)fetcherThread).start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$4(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$4, Function2 callback$1, Tuple2 x$8) {
        block6: {
            if (x$8 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
            initialFetchOffsets = (Map)x$8._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$4);
            var8_7 = false;
            var9_8 = null;
            var10_9 = $this.fetcherThreadMap().get((Object)fetcherTag);
            if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Some)var10_9;
            currentFetcherThread = (AbstractFetcherThread)var9_8.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var12_11 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
                v1 = currentFetcherThread;
            } else if (var8_7) {
                ((AbstractFetcherThread)var9_8.value()).shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var10_9)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError((Object)var10_9);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)fetcherThread));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$6, AbstractFetcherThread x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        if (x0$1 != null && (lagMetrics = (FetcherLagMetrics)x0$1._2()) != null) {
            return lagMetrics.lag() == 0L;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Function2 callback$2, Tuple2 x$11) {
        block6: {
            block9: {
                AbstractFetcherThread fetcher;
                FetcherTag tag;
                block8: {
                    FetcherPool$Default$ fetcherPool$Default$;
                    FetcherPool fetcherPool;
                    block7: {
                        if (x$11 == null) break block6;
                        tag = (FetcherTag)x$11._1();
                        fetcher = (AbstractFetcherThread)x$11._2();
                        fetcherPool = tag.fetcherPool();
                        fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
                        if (fetcherPool != null) break block7;
                        if (fetcherPool$Default$ != null) {
                            return;
                        }
                        break block8;
                    }
                    if (!fetcherPool.equals(fetcherPool$Default$)) break block9;
                }
                scala.collection.immutable.Set inSyncPartitions = ((TraversableOnce)((TraversableLike)fetcher.fetcherLagStats().stats().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        return (TopicPartition)x0$2._1();
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions((Set<TopicPartition>)inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, callback$2);
                if (partitionStates.nonEmpty()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.keys()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$default$1$1(TopicPartition x$9, AbstractFetcherThread x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$4(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$7(Set partitions$1, Function1 topicIds$1, AbstractFetcherThread x$12) {
        x$12.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$13) {
        if (x$13 != null) {
            Seq fetcherTags = (Seq)x$13._1();
            Set partitions = (Set)x$13._2();
            fetcherTags.foreach((Function1 & Serializable & scala.Serializable)fetcherTag -> {
                this.fetcherThreadMap().get(fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                    x$12.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$5) {
        return check$ifrefutable$5 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$15) {
        if (x$15 != null) {
            return ((AbstractFetcherThread)x$15._2()).initiateShutdown();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$6) {
        return check$ifrefutable$6 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$16) {
        if (x$16 != null) {
            ((AbstractFetcherThread)x$16._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.numFetchers = numFetchers;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = (int[])Array$.MODULE$.fill(FetcherPool$.MODULE$.values().size(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.numFetchers, ClassTag$.MODULE$.Int());
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.pausedPartitions = new PausedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = ((MapLike)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.metricsGroup().newGauge("MaxLag", () -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$1(this)), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalLag", () -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$4(this)), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble((double)this.minFetchRate((Map)this.fetcherThreadMap())), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalFetchRate", () -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$8(this)), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("FailedPartitionsCount", () -> BoxesRunTime.boxToInteger((int)AbstractFetcherManager.$anonfun$new$10(this)), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("PausedPartitionsCount", () -> BoxesRunTime.boxToInteger((int)AbstractFetcherManager.$anonfun$new$11(this)), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("DeadThreadCount", () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.deadThreadCountTags(this.tags())).asJava());
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (!(fetchConnectionsMode != null ? !fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$) : fetchConnectionsMode$Isolated$ != null)) {
            scheduler.foreach((Function1 & Serializable & scala.Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$13(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$3$adapted(AbstractFetcherManager $this, FetcherPool fetcherPool$4, Function2 callback$1, Tuple2 x$8) {
        if (x$8 == null) ** GOTO lbl25
        $anonfun$addFetcherForPartitions$3_brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
        $anonfun$addFetcherForPartitions$3_initialFetchOffsets = (Map)x$8._2();
        $anonfun$addFetcherForPartitions$3_fetcherTag = new FetcherTag($anonfun$addFetcherForPartitions$3_brokerAndFetcherId.broker().id(), $anonfun$addFetcherForPartitions$3_brokerAndFetcherId.fetcherId(), fetcherPool$4);
        var8_7 = false;
        var9_8 = null;
        var10_9 = $this.fetcherThreadMap().get((Object)$anonfun$addFetcherForPartitions$3_fetcherTag);
        if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
        var8_7 = true;
        var9_8 = (Some)var10_9;
        $anonfun$addFetcherForPartitions$3_currentFetcherThread = (AbstractFetcherThread)var9_8.value();
        v0 = $anonfun$addFetcherForPartitions$3_currentFetcherThread.leader().brokerEndPoint();
        var12_11 = $anonfun$addFetcherForPartitions$3_brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
            v1 = $anonfun$addFetcherForPartitions$3_currentFetcherThread;
        } else if (var8_7) {
            ((AbstractFetcherThread)var9_8.value()).shutdown();
            v1 = $this.addAndStartFetcherThread$1($anonfun$addFetcherForPartitions$3_brokerAndFetcherId, $anonfun$addFetcherForPartitions$3_fetcherTag);
        } else if (None$.MODULE$.equals(var10_9)) {
            v1 = $this.addAndStartFetcherThread$1($anonfun$addFetcherForPartitions$3_brokerAndFetcherId, $anonfun$addFetcherForPartitions$3_fetcherTag);
        } else {
            throw new MatchError((Object)var10_9);
lbl25:
            // 1 sources

            throw new MatchError(null);
        }
        $anonfun$addFetcherForPartitions$3_fetcherThread = v1;
        $this.addPartitionsToFetcherThread($anonfun$addFetcherForPartitions$3_fetcherThread, (Map<TopicPartition, InitialFetchState>)$anonfun$addFetcherForPartitions$3_initialFetchOffsets);
        $anonfun$addFetcherForPartitions$3_initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)$anonfun$addFetcherForPartitions$3_fetcherThread));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

