/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.KafkaConfig;
import kafka.server.PerNodeQueue;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}c!B\u0015+\u0003\u0003y\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011\u0015y\u0007\u0001\"\u0001q\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0007\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%\t!a\u000f\t\u0017\u00055\u0003\u00011AA\u0002\u0013\u0005\u0011q\n\u0005\f\u00037\u0002\u0001\u0019!A!B\u0013\ti\u0004C\u0005\u0002f\u0001\u0001\r\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001A\u0002\u0013\u0005\u0011\u0011\u000f\u0005\t\u0003k\u0002\u0001\u0015)\u0003\u0002j!I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111\u0010\u0005\b\u0003{\u0002\u0001\u0015!\u0003c\u0011%\ty\b\u0001b\u0001\n\u0003\tY\bC\u0004\u0002\u0002\u0002\u0001\u000b\u0011\u00022\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAI\u0001\u0001\u0006I!a\"\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAK\u0001\u0001\u0006I!a\"\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAM\u0001\u0001\u0006I!a\"\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!7\u0001\t\u0003\t\t\u000fC\u0004\u0002p\u0002!I!!=\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!1\u0003\u0001\u0007\u0002\tU\u0001b\u0002B \u0001\u0019\u0005!\u0011\t\u0005\n\u0005\u000f\u0002\u0011\u0013!C\u0001\u0005\u0013\u0012Q#\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e+ie\u0016\fGM\u0003\u0002,Y\u000511/\u001a:wKJT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001+\t\u0001DoE\u0002\u0001cu\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003WYR!!L\u001c\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0005\u0003yM\u0012Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\r\u0005\u0002?\u00036\tqH\u0003\u0002AY\u0005)Q\u000f^5mg&\u0011!i\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011QIR\u0007\u0002U%\u0011qI\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004nKR\u0014\u0018nY:\u0011\u0005)sU\"A&\u000b\u0005!c%BA'7\u0003\u0019\u0019w.\\7p]&\u0011qj\u0013\u0002\b\u001b\u0016$(/[2t\u00039yf.\u001a;x_J\\7\t\\5f]R\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u001c\u0002\u000f\rd\u0017.\u001a8ug&\u0011ak\u0015\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002\u001d-\fgm[1TG\",G-\u001e7feB\u0011!'W\u0005\u00035N\u0012abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0003uS6,\u0007CA/`\u001b\u0005q&B\u0001!M\u0013\t\u0001gL\u0001\u0003US6,\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016\u0004\"a\u00197\u000f\u0005\u0011T\u0007CA3i\u001b\u00051'BA4/\u0003\u0019a$o\\8u})\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\u00061\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0007.\u0001\u0004=S:LGO\u0010\u000b\fcz|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001E\u0002F\u0001I\u0004\"a\u001d;\r\u0001\u0011)Q\u000f\u0001b\u0001m\n\tA+\u0005\u0002xwB\u0011\u00010_\u0007\u0002Q&\u0011!\u0010\u001b\u0002\b\u001d>$\b.\u001b8h!\tAH0\u0003\u0002~Q\n\u0019\u0011I\\=\t\u000b\r;\u0001\u0019\u0001#\t\u000b!;\u0001\u0019A%\t\u000bA;\u0001\u0019A)\t\u000b];\u0001\u0019\u0001-\t\u000bm;\u0001\u0019\u0001/\t\u000b\u0005<\u0001\u0019\u00012\u0002\u0019E,X-^3QKJtu\u000eZ3\u0016\u0005\u00055\u0001\u0003CA\b\u00033\ti\"!\n\u000e\u0005\u0005E!\u0002BA\n\u0003+\t!bY8oGV\u0014(/\u001a8u\u0015\r\t9\u0002[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000e\u0003#\u00111!T1q!\u0011\ty\"!\t\u000e\u00031K1!a\tM\u0005\u0011qu\u000eZ3\u0011\t\u0015\u000b9C]\u0005\u0004\u0003SQ#\u0001\u0004)fe:{G-Z)vKV,\u0017!D9vKV,\u0007+\u001a:O_\u0012,\u0007%\u0001\tsKF,Xm\u001d;US6,w.\u001e;NgV\u0011\u0011\u0011\u0007\t\u0004q\u0006M\u0012bAA\u001bQ\n\u0019\u0011J\u001c;\u0002#I,\u0017/^3tiRKW.Z8vi6\u001b\b%\u0001\trk>$\u0018mQ8pe\u0012Lg.\u0019;peV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u0015\tXo\u001c;b\u0015\r\t9\u0005L\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0002L\u0005\u0005#\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0003Q\tXo\u001c;b\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR!\u0011\u0011KA,!\rA\u00181K\u0005\u0004\u0003+B'\u0001B+oSRD\u0011\"!\u0017\u000e\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0013'A\trk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u0002B3ADA0!\rA\u0018\u0011M\u0005\u0004\u0003GB'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000fM$\u0018M\u001d;fIV\u0011\u0011\u0011\u000e\t\u0004q\u0006-\u0014bAA7Q\n9!i\\8mK\u0006t\u0017aC:uCJ$X\rZ0%KF$B!!\u0015\u0002t!I\u0011\u0011\f\t\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\tgR\f'\u000f^3eA!\u001a\u0011#a\u0018\u0002%I,\u0017/^3ti:\u000bW.\u001a(p'B\f7-Z\u000b\u0002E\u0006\u0019\"/Z9vKN$h*Y7f\u001d>\u001c\u0006/Y2fA\u0005aQ.\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0011C\\8eK2{wn[;q\r\u0006LG.\u001e:f+\t\t9\tE\u0002K\u0003\u0013K1!a#L\u0005\u0019\u0019VM\\:pe\u0006\u0011bn\u001c3f\u0019>|7.\u001e9GC&dWO]3!\u0003)\u0011\bo\u0019$bS2,(/Z\u0001\feB\u001cg)Y5mkJ,\u0007%\u0001\u000bsa\u000e$\u0015n]2p]:,7\r\u001e$bS2,(/Z\u0001\u0016eB\u001cG)[:d_:tWm\u0019;GC&dWO]3!\u0003!\u0011\bo\u0019*fiJL\u0018!\u0003:qGJ+GO]=!\u0003\u0015\u0019H/\u0019:u)\u0011\t\t&a(\t\u000f\u0005\u001dc\u00041\u0001\u0002>\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002R\u0005A1o\u00195fIVdW\r\u0006\u0005\u0002R\u0005%\u0016QVA\\\u0011\u0019\tY\u000b\ta\u0001E\u0006!a.Y7f\u0011\u001d\ty\u000b\ta\u0001\u0003c\u000b1AZ;o!\u0015A\u00181WA)\u0013\r\t)\f\u001b\u0002\n\rVt7\r^5p]BBq!!/!\u0001\u0004\tY,\u0001\u0005qKJLw\u000eZ't!\rA\u0018QX\u0005\u0004\u0003\u007fC'\u0001\u0002'p]\u001e\f\u0001cZ3oKJ\fG/\u001a*fcV,7\u000f^:\u0015\u0005\u0005\u0015\u0007CBAd\u0003\u001f\f\u0019.\u0004\u0002\u0002J*\u0019A'a3\u000b\u0005\u00055\u0017\u0001\u00026bm\u0006LA!!5\u0002J\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007I\n).C\u0002\u0002XN\u00121DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018aD1eI\u0016sGO]=G_Jtu\u000eZ3\u0015\t\u0005E\u0013Q\u001c\u0005\u0007\u0003?\u0014\u0003\u0019\u0001:\u0002\u000b\u0015tGO]=\u0015\r\u0005E\u00131]As\u0011\u0019\tyn\ta\u0001e\"9\u0011q]\u0012A\u0002\u0005%\u0018\u0001\u00028pI\u0016\u0004R\u0001_Av\u0003;I1!!<i\u0005\u0019y\u0005\u000f^5p]\u0006q\u0001.\u00198eY\u0016\u0014Vm\u001d9p]N,GCBAz\u0003\u007f\u0014\t\u0001\u0006\u0003\u0002R\u0005U\bbBA|I\u0001\u0007\u0011\u0011`\u0001\te\u0016\u001c\bo\u001c8tKB\u0019!+a?\n\u0007\u0005u8K\u0001\bDY&,g\u000e\u001e*fgB|gn]3\t\u000f\u0005\u001dC\u00051\u0001\u0002\u001e!9!1\u0001\u0013A\u0002\t\u0015\u0011aB3oiJLWm\u001d\t\u0006\u0003\u000f\u00149A]\u0005\u0005\u0005\u0013\tIMA\u0005BeJ\f\u0017\u0010T5ti\u0006i!/\u001a;ss\u001a{'/\u00128uef$b!!\u0015\u0003\u0010\tE\u0001b\u0002B\u0002K\u0001\u0007!Q\u0001\u0005\b\u0003O,\u0003\u0019AAu\u00035\u0019'/Z1uKJ+\u0017/^3tiR1!q\u0003B\u001e\u0005{\u0001DA!\u0007\u00030A1!1\u0004B\u0014\u0005[qAA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005Ca\u0015\u0001\u0003:fcV,7\u000f^:\n\t\t\u0015\"qD\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!!\u0011\u0006B\u0016\u0005\u001d\u0011U/\u001b7eKJTAA!\n\u0003 A\u00191Oa\f\u0005\u0017\tEb%!A\u0001\u0002\u000b\u0005!1\u0007\u0002\u0004?\u0012\n\u0014cA<\u00036A!!Q\u0004B\u001c\u0013\u0011\u0011IDa\b\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!a:'\u0001\u0004\ti\u0002C\u0004\u0003\u0004\u0019\u0002\rA!\u0002\u0002\u000f\u001d,GOT8eKR1\u0011\u0011\u001eB\"\u0005\u000bBa!a8(\u0001\u0004\u0011\b\"CAtOA\u0005\t\u0019AAu\u0003E9W\r\u001e(pI\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0017RC!!;\u0003N-\u0012!q\n\t\u0005\u0005#\u0012Y&\u0004\u0002\u0003T)!!Q\u000bB,\u0003%)hn\u00195fG.,GMC\u0002\u0003Z!\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iFa\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class AbstractRequestThread<T>
extends InterBrokerSendThread
implements Logging {
    private final Metrics metrics;
    private final KafkaScheduler kafkaScheduler;
    private final Time time;
    private final String requestName;
    private final Map<Node, PerNodeQueue<T>> queuePerNode;
    private final int requestTimeoutMs;
    private volatile QuotaCoordinator quotaCoordinator;
    private volatile boolean started;
    private final String requestNameNoSpace;
    private final String metricsGroup;
    private final Sensor nodeLookupFailure;
    private final Sensor rpcFailure;
    private final Sensor rpcDisconnectFailure;
    private final Sensor rpcRetry;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<Node, PerNodeQueue<T>> queuePerNode() {
        return this.queuePerNode;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public boolean started() {
        return this.started;
    }

    public void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public String requestNameNoSpace() {
        return this.requestNameNoSpace;
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public Sensor nodeLookupFailure() {
        return this.nodeLookupFailure;
    }

    public Sensor rpcFailure() {
        return this.rpcFailure;
    }

    public Sensor rpcDisconnectFailure() {
        return this.rpcDisconnectFailure;
    }

    public Sensor rpcRetry() {
        return this.rpcRetry;
    }

    public void start(QuotaCoordinator coordinator) {
        super.start();
        this.quotaCoordinator_$eq(coordinator);
        this.started_$eq(true);
    }

    public void shutdown() {
        super.shutdown();
        this.queuePerNode().clear();
        this.metrics.removeSensor(this.nodeLookupFailure().name());
        this.metrics.removeSensor(this.rpcFailure().name());
        this.metrics.removeSensor(this.rpcRetry().name());
        this.quotaCoordinator_$eq(null);
        this.started_$eq(false);
    }

    public void schedule(String name, Function0<BoxedUnit> fun, long periodMs) {
        this.kafkaScheduler.schedule(name, () -> fun.apply$mcV$sp(), 0L, periodMs);
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)((TraversableLike)this.queuePerNode().values().map((Function1 & Serializable & scala.Serializable)queue -> {
            ArrayList entryData = new ArrayList();
            queue.queue().drainTo(entryData);
            return new Tuple2((Object)queue.destination(), entryData);
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractRequestThread.$anonfun$generateRequests$2(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                Node node = (Node)x0$2._1();
                ArrayList entries = (ArrayList)x0$2._2();
                return new RequestAndCompletionHandler(currentTimeMs, node, this.createRequest(node, entries), request -> this.handleResponse(node, entries, request));
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
    }

    public void addEntryForNode(T entry) {
        this.addEntryForNode(entry, (Option<Node>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void addEntryForNode(T entry, Option<Node> node) {
        if (this.started()) {
            Option<Node> option = this.getNode(entry, node);
            if (option instanceof Some) {
                Object object;
                void atomicGetOrUpdate_map;
                Node node2 = (Node)((Some)option).value();
                Map<Node, PerNodeQueue<T>> map = this.queuePerNode();
                if (CoreUtils$.MODULE$ == null) {
                    throw null;
                }
                Option option2 = atomicGetOrUpdate_map.get((Object)node2);
                if (option2 instanceof Some) {
                    object = ((Some)option2).value();
                } else if (None$.MODULE$.equals(option2)) {
                    PerNodeQueue atomicGetOrUpdate_value = AbstractRequestThread.$anonfun$addEntryForNode$1(node2);
                    object = atomicGetOrUpdate_map.putIfAbsent((Object)node2, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option2);
                }
                ((PerNodeQueue)object).addEntry(entry);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append($this.requestName).append(" Request's destination node is unavailable, skipping ").append($this.requestName).append(" for entry ").append(entry).append(".").toString());
                this.nodeLookupFailure().record();
                return;
            }
            throw new MatchError(option);
        }
    }

    private void handleResponse(Node coordinator, ArrayList<T> entries, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append($this.requestName).append(" Request ").append(entries).append(" failed due to authentication error with coordinator").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.authenticationException());
            this.rpcFailure().record();
            return;
        }
        if (response.versionMismatch() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append($this.requestName).append(" Request ").append(entries).append(" failed due to unsupported version error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.versionMismatch());
            this.rpcFailure().record();
            return;
        }
        if (response.wasDisconnected()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append($this.requestName).append(" Request failed due to a disconnection before fully reading a response").toString());
            this.rpcDisconnectFailure().record();
            this.rpcFailure().record();
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_COORDINATOR)) {
            this.networkClient.disconnect(coordinator.idString());
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        if (!((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(response.responseBody().errorCounts().keySet()).asScala()).forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AbstractRequestThread.$anonfun$handleResponse$6(e)))) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append($this.requestName).append(" Request failed with Response ").append(response).toString());
            this.rpcFailure().record();
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received response for ").append($this.requestName).append(" Request").toString());
    }

    private void retryForEntry(ArrayList<T> entries, Option<Node> node) {
        entries.forEach(entry -> this.addEntryForNode(entry, node));
        this.rpcRetry().record();
    }

    public abstract AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node var1, ArrayList<T> var2);

    public abstract Option<Node> getNode(T var1, Option<Node> var2);

    public Option<Node> getNode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            Node node = (Node)x0$1._1();
            return !((ArrayList)x0$1._2()).isEmpty() && !node.isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ PerNodeQueue $anonfun$addEntryForNode$1(Node node$2) {
        return new PerNodeQueue(node$2);
    }

    public static final /* synthetic */ boolean $anonfun$handleResponse$6(Errors e) {
        Errors errors = e;
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public AbstractRequestThread(KafkaConfig config, Metrics metrics, NetworkClient _networkClient, KafkaScheduler kafkaScheduler, Time time, String requestName) {
        this.metrics = metrics;
        this.kafkaScheduler = kafkaScheduler;
        this.time = time;
        this.requestName = requestName;
        super(new StringBuilder(25).append("DynamicQuotaSenderThread-").append(config.brokerId()).toString(), (KafkaClient)_networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[Dynamic Quota Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.queuePerNode = (Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.requestTimeoutMs = 30000;
        this.started = false;
        this.requestNameNoSpace = requestName.replace(" ", "-");
        this.metricsGroup = new StringBuilder(8).append(this.requestNameNoSpace().toLowerCase()).append("-metrics").toString();
        this.nodeLookupFailure = metrics.sensor(new StringBuilder(17).append(this.requestNameNoSpace()).append("NodeLookupFailure").toString());
        this.nodeLookupFailure().add(metrics.metricName("node-lookup-failure", this.metricsGroup(), "The rate of node lookup failure"), (MeasurableStat)new Rate());
        this.rpcFailure = metrics.sensor(new StringBuilder(10).append(this.requestNameNoSpace()).append("RPCFailure").toString());
        this.rpcFailure().add(metrics.metricName("rpc-failure", this.metricsGroup(), new StringBuilder(24).append("The rate of ").append(requestName).append(" RPC failure").toString()), (MeasurableStat)new Rate());
        this.rpcDisconnectFailure = metrics.sensor(new StringBuilder(20).append(this.requestNameNoSpace()).append("RPCDisconnectFailure").toString());
        this.rpcDisconnectFailure().add(metrics.metricName("rpc-disconnect-failure", this.metricsGroup(), new StringBuilder(35).append("The rate of ").append(requestName).append(" RPC disconnect failure").toString()), (MeasurableStat)new Rate());
        this.rpcRetry = metrics.sensor(new StringBuilder(8).append(this.requestNameNoSpace()).append("RPCRetry").toString());
        this.rpcRetry().add(metrics.metricName("rpc-retry", this.metricsGroup(), new StringBuilder(22).append("The rate of ").append(requestName).append(" RPC retry").toString()), (MeasurableStat)new Rate());
    }
}

