/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u000b\u0017\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bU\u0003A\u0011\u0001,\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0004A\u0011\u0001@\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!\u0011\r\u0001\u0005\n\t\r\u0004b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\b\u0005'\u0003A\u0011\u0002BK\u00051\u0019uN\u001c4jO\"+G\u000e]3s\u0015\t9\u0002$\u0001\u0004tKJ4XM\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\r\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005)ZS\"\u0001\f\n\u000512\"!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\u0004d_:4\u0017n\u001a\t\u0003U=J!\u0001\r\f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011G>tg-[4SKB|7/\u001b;pef\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\f\u0002\u00115,G/\u00193bi\u0006L!a\u000e\u001b\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\u0018!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsB\u0019QD\u000f\u001f\n\u0005mr\"AB(qi&|g\u000e\u0005\u0002>\r6\taH\u0003\u0002@\u0001\u00061\u0001o\u001c7jGfT!aF!\u000b\u0005e\u0011%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!a\u0012 \u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#\u0001&\u0011\u0005-\u000bfB\u0001'P\u001b\u0005i%B\u0001(\u0017\u0003\u0011a\u0017N\\6\n\u0005Ak\u0015AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefL!AU*\u0003\u00171Kgn['b]\u0006<WM\u001d\u0006\u0003!6\u000b1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\na\u0001P5oSRtDCB,Y3j[F\f\u0005\u0002+\u0001!)\u0001f\u0002a\u0001S!)Qf\u0002a\u0001]!)\u0011g\u0002a\u0001e!)\u0001h\u0002a\u0001s!)\u0001j\u0002a\u0001\u0015\u0006Q\u0011\r\u001c7D_:4\u0017nZ:\u0015\u0005}+\b\u0003\u00021fOJl\u0011!\u0019\u0006\u0003E\u000e\fq!\\;uC\ndWM\u0003\u0002e=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\f'aA'baB\u0011\u0001n\u001c\b\u0003S6\u0004\"A\u001b\u0010\u000e\u0003-T!\u0001\u001c\u000e\u0002\rq\u0012xn\u001c;?\u0013\tqg$\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018\u001f!\ti2/\u0003\u0002u=\t\u0019\u0011I\\=\t\u000b5B\u0001\u0019\u0001<\u0011\u0005]\\X\"\u0001=\u000b\u00055J(B\u0001>B\u0003\u0019\u0019w.\\7p]&\u0011A\u0010\u001f\u0002\u000f\u0003\n\u001cHO]1di\u000e{gNZ5h\u0003qA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014V-];fgR$Ra`A\u0006\u0003G\u0001B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bI\u0018aB7fgN\fw-Z\u0005\u0005\u0003\u0013\t\u0019AA\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0003\u001bI\u0001\u0019AA\b\u0003\u001d\u0011X-];fgR\u0004B!!\u0005\u0002\u001e9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018a\tqA\\3uo>\u00148.\u0003\u0003\u0002\u001c\u0005U\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003?\t\tCA\u0004SKF,Xm\u001d;\u000b\t\u0005m\u0011Q\u0003\u0005\b\u0003KI\u0001\u0019AA\u0014\u0003)\tW\u000f\u001e5IK2\u0004XM\u001d\t\u0004U\u0005%\u0012bAA\u0016-\tQ\u0011)\u001e;i\u0011\u0016d\u0007/\u001a:\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$\"\"!\r\u0002R\u0005e\u00141QAL!\u0019\t\u0019$!\u0010\u0002D9!\u0011QGA\u001d\u001d\rQ\u0017qG\u0005\u0002?%\u0019\u00111\b\u0010\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005mb\u0004\u0005\u0003\u0002F\u0005-c\u0002BA\u0001\u0003\u000fJA!!\u0013\u0002\u0004\u0005YB)Z:de&\u0014WmQ8oM&<7OU3ta>t7/\u001a#bi\u0006LA!!\u0014\u0002P\t)B)Z:de&\u0014WmQ8oM&<7OU3tk2$(\u0002BA%\u0003\u0007Aq!a\u0015\u000b\u0001\u0004\t)&A\u000bsKN|WO]2f)>\u001cuN\u001c4jO:\u000bW.Z:\u0011\r\u0005M\u0012QHA,!\u0011\tI&a\u001d\u000f\t\u0005m\u0013q\u000e\b\u0005\u0003;\niG\u0004\u0003\u0002`\u0005-d\u0002BA1\u0003SrA!a\u0019\u0002h9\u0019!.!\u001a\n\u0003\u0015K!a\u0011#\n\u0005e\u0011\u0015B\u0001>B\u0013\r\t)!_\u0005\u0005\u0003c\n\u0019!\u0001\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002v\u0005]$a\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN|WO]2f\u0015\u0011\t\t(a\u0001\t\u000f\u0005m$\u00021\u0001\u0002~\u0005y\u0011N\\2mk\u0012,7+\u001f8p]fl7\u000fE\u0002\u001e\u0003\u007fJ1!!!\u001f\u0005\u001d\u0011un\u001c7fC:Dq!!\"\u000b\u0001\u0004\t9)A\u0005qe&t7-\u001b9bYB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015\u0001B1vi\"T1!!%z\u0003!\u0019XmY;sSRL\u0018\u0002BAK\u0003\u0017\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG\u000eC\u0004\u0002\u001a*\u0001\r!! \u0002)%t7\r\\;eK\u0012{7-^7f]R\fG/[8o\u0003Y\u0019'/Z1uKR{\u0007/[2D_:4\u0017nZ#oiJLHCCAP\u0003_\u000b9-a7\u0002^R1\u0011\u0011UAT\u0003W\u0003B!!\u0012\u0002$&!\u0011QUA(\u0005u!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:pkJ\u001cWMU3tk2$\bBBAU\u0017\u0001\u0007q-\u0001\u0003oC6,\u0007BBAW\u0017\u0001\u0007!/A\u0003wC2,X\rC\u0004\u00022.\u0001\r!a-\u0002\u00131|wmQ8oM&<\u0007\u0003BA[\u0003\u0007l!!a.\u000b\t\u0005e\u00161X\u0001\u0004Y><'\u0002BA_\u0003\u007f\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005\u0005\u0017)A\u0004ti>\u0014\u0018mZ3\n\t\u0005\u0015\u0017q\u0017\u0002\n\u0019><7i\u001c8gS\u001eDq!!3\f\u0001\u0004\tY-\u0001\u0006u_BL7\r\u0015:paN\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.\u0001\u0003vi&d'BAAk\u0003\u0011Q\u0017M^1\n\t\u0005e\u0017q\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA>\u0017\u0001\u0007\u0011Q\u0010\u0005\b\u00033[\u0001\u0019AA?\u0003I1\u0017\u000e\u001c;feR{\u0007/[2D_:4\u0017nZ:\u0015\r\u0005\r\u0018q^A}!\u0015\u0001\u0017Q]Au\u0013\r\t9/\u0019\u0002\u0007\u0005V4g-\u001a:\u0011\u000bu\tYo\u001a:\n\u0007\u00055hD\u0001\u0004UkBdWM\r\u0005\b\u0003cd\u0001\u0019AAz\u0003\u001d\u0019wN\u001c4jON\u0004b!!>\u0002x\u001e\u0014X\"A2\n\u0005\u0019\u001c\u0007bBA~\u0019\u0001\u0007\u0011Q`\u0001\fG>tg-[4OC6,7\u000f\u0005\u0003\u001eu\u0005}\b#BA{\u0005\u00039\u0017b\u0001B\u0002G\n\u00191+\u001a;\u0002)Y\fG.\u001b3bi\u0016\u001cuN\u001c4jOB{G.[2z)!\u0011IAa\u0004\u0003\u001a\t}\u0001cA\u000f\u0003\f%\u0019!Q\u0002\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005#i\u0001\u0019\u0001B\n\u0003!\u0011Xm]8ve\u000e,\u0007cA<\u0003\u0016%\u0019!q\u0003=\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\"9!1D\u0007A\u0002\tu\u0011\u0001E2p]\u001aLw-\u00128ue&,7/T1q!\u0019\t)0a>hO\"9\u0011QQ\u0007A\u0002\u0005\u001d\u0015aF2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e,e\u000e\u001e:z)!\u0011)Ca\u000b\u00030\tEBCBAQ\u0005O\u0011I\u0003\u0003\u0004\u0002*:\u0001\ra\u001a\u0005\u0007\u0003[s\u0001\u0019\u0001:\t\u000f\t5b\u00021\u0001\u0002~\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rC\u0004\u0002|9\u0001\r!! \t\u000f\u0005ee\u00021\u0001\u0002~\u0005a2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6D_:4\u0017nZ#oiJLHC\u0002B\u001c\u0005{\u0011\t\u0005\u0006\u0004\u0002\"\ne\"1\b\u0005\u0007\u0003S{\u0001\u0019A4\t\r\u00055v\u00021\u0001s\u0011\u001d\u0011yd\u0004a\u0001\u0003\u007f\fq#\u001a=qY&\u001c\u0017\u000e\u001e7z'\u0016$8i\u001c8gS\u001e\\U-_:\t\u000b5z\u0001\u0019\u0001<\u0002\u001d\r|gNZ5h'ftwN\\=ngRA!q\tB(\u0005#\u00129\u0006\u0005\u0004\u00024\u0005u\"\u0011\n\t\u0005\u0003\u000b\u0012Y%\u0003\u0003\u0003N\u0005=#A\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:Ts:|g._7\t\r\u0005%\u0006\u00031\u0001h\u0011\u001d\u0011\u0019\u0006\u0005a\u0001\u0005+\n\u0001b]=o_:LXn\u001d\t\u0006\u0003g\tid\u001a\u0005\b\u00053\u0002\u0002\u0019AA?\u0003-I7oU3og&$\u0018N^3\u0002\u001d\t\u0014xn[3s'ftwN\\=ngR!!Q\u000bB0\u0011\u0019\tI+\u0005a\u0001O\u0006\u0019\"M]8lKJ$unY;nK:$\u0018\r^5p]R\u0019qM!\u001a\t\r\u0005%&\u00031\u0001h\u0003I\u0019wN\u001c4jOJ+7\u000f]8og\u0016$\u0016\u0010]3\u0015\t\t-$q\u0010\t\u0005\u0005[\u0012IH\u0004\u0003\u0003p\tUTB\u0001B9\u0015\r\u0011\u0019(_\u0001\te\u0016\fX/Z:ug&!!q\u000fB9\u0003]!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX-\u0003\u0003\u0003|\tu$AC\"p]\u001aLw\rV=qK*!!q\u000fB9\u0011\u001d\u0011\ti\u0005a\u0001\u0005\u0007\u000b!bY8oM&<G+\u001f9f!\u0011i\"H!\"\u0011\t\t\u001d%Q\u0012\b\u0004o\n%\u0015b\u0001BFq\u0006I1i\u001c8gS\u001e$UMZ\u0005\u0005\u0005\u001f\u0013\tJ\u0001\u0003UsB,'b\u0001BFq\u00061\"/Z:pkJ\u001cWMT1nKR{'I]8lKJLE\r\u0006\u0003\u0003\u0018\nu\u0005cA\u000f\u0003\u001a&\u0019!1\u0014\u0010\u0003\u0007%sG\u000f\u0003\u0004\u0003 R\u0001\raZ\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((GenTraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.nonInternalValues()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    public DescribeConfigsResponseData handleDescribeConfigsRequest(RequestChannel.Request request, AuthHelper authHelper) {
        void var6_6;
        void var5_5;
        DescribeConfigsRequest describeConfigsRequest = (DescribeConfigsRequest)request.body(ClassTag$.MODULE$.apply(DescribeConfigsRequest.class));
        Tuple2 tuple2 = ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describeConfigsRequest.data().resources()).asScala()).partition((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$handleDescribeConfigsRequest$1(authHelper, request, resource)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer authorizedResources = (Buffer)tuple2._1();
        Buffer unauthorizedResources = (Buffer)tuple2._2();
        void authorizedResources2 = var5_5;
        void unauthorizedResources2 = var6_6;
        List<DescribeConfigsResponseData.DescribeConfigsResult> authorizedConfigs = this.describeConfigs((List<DescribeConfigsRequestData.DescribeConfigsResource>)authorizedResources2.toList(), describeConfigsRequest.data().includeSynonyms(), request.session().principal, describeConfigsRequest.data().includeDocumentation());
        Buffer unauthorizedConfigs = (Buffer)unauthorizedResources2.map((Function1 & Serializable & scala.Serializable)resource -> {
            Errors errors;
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type)))) {
                errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
            } else if (ConfigResource.Type.TOPIC.equals(type)) {
                errors = Errors.TOPIC_AUTHORIZATION_FAILED;
            } else {
                throw new InvalidRequestException(new StringBuilder(39).append("Unexpected resource type ").append(type).append(" for resource ").append(resource.resourceName()).toString());
            }
            Errors error = errors;
            return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setConfigs(Collections.emptyList()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponseData().setResults((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)authorizedConfigs.$plus$plus((GenTraversableOnce)unauthorizedConfigs, List$.MODULE$.canBuildFrom())).asJava());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return (List)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)resource -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    org.apache.kafka.common.TopicType orgApacheKafkaCommonTopicType;
                    String topic = resource.resourceName();
                    Topic.validate((String)topic);
                    Option<org.apache.kafka.common.TopicType> option = $this.metadataCache.getTopicType(topic);
                    if (option instanceof Some && (orgApacheKafkaCommonTopicType = (org.apache.kafka.common.TopicType)((Some)option).value()) != null) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        TopicType orgApacheKafkaMetadataTopicType = TopicType.forId((byte)orgApacheKafkaCommonTopicType.id());
                        LogConfig logConfig = LogConfig.fromProps($this.config.extractLogConfigMap(orgApacheKafkaCommonTopicType), (Properties)topicProps, (TopicType)orgApacheKafkaMetadataTopicType);
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    } else {
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    }
                    return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                } else if (ConfigResource.Type.BROKER.equals(type)) {
                    if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                        Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    } else {
                        void createResponseConfig$1_createConfigEntry;
                        if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(resource.resourceName()).toString());
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)$this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    }
                    return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                    void createResponseConfig$1_createConfigEntry;
                    if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                        throw new InvalidRequestException("Broker id must not be empty");
                    }
                    if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) {
                        throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(resource.resourceName()).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
                    this.validateConfigPolicy(configResource, (Map<String, String>)Map$.MODULE$.empty(), principal);
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                    scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                    Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                } else if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                    Properties properties;
                    if (this.clusterLinkManager() == null) {
                        throw new UnsupportedVersionException("Cannot describe CLUSTER_LINK resources in this version of the software.");
                    }
                    String linkName = resource.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    Uuid linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    ConfigRepository configRepository = $this.configRepository;
                    if (configRepository instanceof ZkConfigRepository) {
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, CoreUtils$.MODULE$.toJavaUUID(linkId).toString()));
                    } else {
                        if (!(configRepository instanceof KRaftMetadataCache)) throw new IllegalStateException("Unsupported config repository type");
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    }
                    Properties persistentProps = properties;
                    String errorMessage = new StringBuilder(225).append("Cluster link configs could not be decoded for link '").append(linkName).append("', '").append("password.encoder.secret").append("' ").append("may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.").toString();
                    try {
                        void createResponseConfig$1_createConfigEntry;
                        Set explicitlySetConfigKeys = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(persistentProps.keySet()).asScala();
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Explicitly set config keys ").append(explicitlySetConfigKeys).append(".").toString());
                        ClusterLinkConfig config = (ClusterLinkConfig)((Object)((Object)this.clusterLinkManager().linkConfigFromPersistentProps(linkName, persistentProps, false).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            throw new InvalidConfigurationException(errorMessage);
                        })));
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createClusterLinkConfigEntry((Set<String>)explicitlySetConfigKeys, config, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    }
                    catch (ConfigException configException) {
                        throw new InvalidConfigurationException(errorMessage);
                    }
                } else {
                    if (!ConfigResource.Type.CLIENT_METRICS.equals(type)) throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    String subscriptionName = resource.resourceName();
                    if (subscriptionName == null || subscriptionName.isEmpty()) {
                        throw new InvalidRequestException("Client metrics subscription name must not be empty");
                    }
                    Properties entityProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, subscriptionName));
                    ListBuffer configEntries = new ListBuffer();
                    entityProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> configEntries.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name.toString()).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.CLIENT_METRICS_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()))));
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)configEntries).asJava());
                }
                return describeConfigsResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource.resourceName()).setResourceType(resource.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option configEntryType = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LogConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : (value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms()))));
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$7)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(Set<String> explicitlySetConfigKeys, AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType = config.typeOf(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)Option$.MODULE$.apply((Object)configEntryType));
        String valueAsString = isSensitive || value == null ? null : (value instanceof String ? value.toString() : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType));
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(explicitlySetConfigKeys.contains((Object)name) ? DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        synonyms.foreach((Function1 & Serializable & scala.Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.currentDynamicBrokerConfigValue(synonym), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.currentDynamicDefaultConfigValue(synonym), DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.staticBrokerConfigs().get((Object)synonym), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.staticDefaultConfigs().get((Object)synonym), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        if (ConfigDef.Type.BOOLEAN.equals(type)) {
            return DescribeConfigsResponse.ConfigType.BOOLEAN;
        }
        if (ConfigDef.Type.STRING.equals(type)) {
            return DescribeConfigsResponse.ConfigType.STRING;
        }
        if (ConfigDef.Type.INT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.INT;
        }
        if (ConfigDef.Type.SHORT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.SHORT;
        }
        if (ConfigDef.Type.LONG.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LONG;
        }
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            return DescribeConfigsResponse.ConfigType.DOUBLE;
        }
        if (ConfigDef.Type.LIST.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LIST;
        }
        if (ConfigDef.Type.CLASS.equals(type)) {
            return DescribeConfigsResponse.ConfigType.CLASS;
        }
        if (ConfigDef.Type.PASSWORD.equals(type)) {
            return DescribeConfigsResponse.ConfigType.PASSWORD;
        }
        return DescribeConfigsResponse.ConfigType.UNKNOWN;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsRequest$1(AuthHelper authHelper$1, RequestChannel.Request request$1, DescribeConfigsRequestData.DescribeConfigsResource resource) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
        if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type)))) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        throw new InvalidRequestException(new StringBuilder(39).append("Unexpected resource type ").append(type).append(" for resource ").append(resource.resourceName()).toString());
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource resource$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)resource$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).toSet())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                Object value = x0$1._2();
                return (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            }
            throw new MatchError(null);
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean sslTruststorePasswordCheck;
            String configName = (String)x0$1._1();
            boolean recordInterceptorCheck = !configName.equals("confluent.append.record.interceptor.classes");
            boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
            boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
            boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
            boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
            boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
            boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
            boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
            boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
            boolean bearerAuthIssuerEndpoint = !configName.equals("confluent.bearer.auth.issuer.endpoint.url");
            boolean bearerAuthClientId = !configName.equals("confluent.bearer.auth.client.id");
            boolean bearerAuthClientSecret = !configName.equals("confluent.bearer.auth.client.secret");
            boolean bearerAuthClientScope = !configName.equals("confluent.bearer.auth.scope");
            boolean bearerAuthClientScopeClaim = !configName.equals("confluent.bearer.auth.scope.claim.name");
            boolean bearerAuthClientSubClaim = !configName.equals("confluent.bearer.auth.sub.claim.name");
            boolean bearerAuthLogicalCluster = !configName.equals("confluent.bearer.auth.logical.cluster");
            boolean bearerAuthIdentityPool = !configName.equals("confluent.bearer.auth.identity.pool.id");
            boolean bearerAuthBufferExpirySecond = !configName.equals("confluent.bearer.auth.cache.expiry.buffer.seconds");
            boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
            boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
            boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
            boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
            boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
            boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
            boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
            boolean bl = sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
            return basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && bearerAuthIssuerEndpoint && bearerAuthClientId && bearerAuthClientSecret && bearerAuthClientScope && bearerAuthClientScopeClaim && bearerAuthClientSubClaim && bearerAuthLogicalCluster && bearerAuthIdentityPool && bearerAuthBufferExpirySecond && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((Object)configName)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$7) {
        return perBrokerConfig$1 || x$7.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(String synonymName, Option synonymValue, DescribeConfigsResponse.ConfigSource source, boolean isSensitive$2, Buffer allSynonyms$1) {
        synonymValue.map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(synonymName).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$1, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$1 != null : !string.equals(name$1);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
        Logging.$init$(this);
    }
}

