/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.MergedLog$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.DelayedRemoteFetchMetrics$;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchPartitionStats;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\b\u0010\u0001QA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tU\u0001\u0011\t\u0011)A\u0005W!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")Q\u000f\u0001C\u0001m\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003#\u0001A\u0011IA\b\u0005I!U\r\\1zK\u0012\u0014V-\\8uK\u001a+Go\u00195\u000b\u0005A\t\u0012AB:feZ,'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\b\n\u0005ay!\u0001\u0005#fY\u0006LX\rZ(qKJ\fG/[8o\u0003=\u0011X-\\8uK\u001a+Go\u00195UCN\\\u0007cA\u000e#I5\tAD\u0003\u0002\u001e=\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0001\u0013\u0001B;uS2T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$9\t1a)\u001e;ve\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0011\u0002\t1\fgnZ\u0005\u0003S\u0019\u0012AAV8jI\u0006\t\"/Z7pi\u00164U\r^2i%\u0016\u001cX\u000f\u001c;\u0011\u0007mac&\u0003\u0002.9\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0005=ZT\"\u0001\u0019\u000b\u0005E\u0012\u0014a\u00017pO*\u00111\u0007N\u0001\nS:$XM\u001d8bYNT!!\u000e\u001c\u0002\u000fM$xN]1hK*\u0011!c\u000e\u0006\u0003qe\na!\u00199bG\",'\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=a\t\u0019\"+Z7pi\u0016dun\u001a*fC\u0012\u0014Vm];mi\u0006y!/Z7pi\u00164U\r^2i\u0013:4w\u000e\u0005\u00020\u007f%\u0011\u0001\t\r\u0002\u0017%\u0016lw\u000e^3Ti>\u0014\u0018mZ3GKR\u001c\u0007.\u00138g_\u0006!\"/Z7pi\u00164U\r^2i\u001b\u0006Dx+Y5u\u001bN\u0004\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013A\u0001T8oO\u0006!b-\u001a;dQB\u000b'\u000f^5uS>t7\u000b^1ukN\u00042AS'P\u001b\u0005Y%B\u0001'E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d.\u00131aU3r!\u0011\u0019\u0005K\u0015-\n\u0005E#%A\u0002+va2,'\u0007\u0005\u0002T-6\tAK\u0003\u0002Vm\u000511m\\7n_:L!a\u0016+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007C\u0001\fZ\u0013\tQvB\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\fM\u0016$8\r\u001b)be\u0006l7\u000f\u0005\u00020;&\u0011a\f\r\u0002\f\r\u0016$8\r\u001b)be\u0006l7/\u0001\tm_\u000e\fGNU3bIJ+7/\u001e7ugB\u0019!*T1\u0011\t\r\u0003&K\u0019\t\u0003-\rL!\u0001Z\b\u0003\u001b1{wMU3bIJ+7/\u001e7u\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AF4\n\u0005!|!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004BaQ6ne&\u0011A\u000e\u0012\u0002\n\rVt7\r^5p]F\u00022AS'o!\u0011\u0019\u0005KU8\u0011\u0005=\u0002\u0018BA91\u0005I1U\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\u0005\r\u001b\u0018B\u0001;E\u0005\u0011)f.\u001b;\u0002\rqJg.\u001b;?)-9\b0\u001f>|yvtx0!\u0001\u0011\u0005Y\u0001\u0001\"B\r\u000b\u0001\u0004Q\u0002\"\u0002\u0016\u000b\u0001\u0004Y\u0003\"B\u001f\u000b\u0001\u0004q\u0004\"B!\u000b\u0001\u0004\u0011\u0005\"\u0002%\u000b\u0001\u0004I\u0005\"B.\u000b\u0001\u0004a\u0006\"B0\u000b\u0001\u0004\u0001\u0007\"B3\u000b\u0001\u00041\u0007\"B5\u000b\u0001\u0004Q\u0017a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\"!a\u0002\u0011\u0007\r\u000bI!C\u0002\u0002\f\u0011\u0013qAQ8pY\u0016\fg.\u0001\u0007p]\u0016C\b/\u001b:bi&|g\u000eF\u0001s\u0003)ygnQ8na2,G/\u001a")
public class DelayedRemoteFetch
extends DelayedOperation {
    private final Future<Void> remoteFetchTask;
    private final CompletableFuture<RemoteLogReadResult> remoteFetchResult;
    private final RemoteStorageFetchInfo remoteFetchInfo;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final FetchParams fetchParams;
    private final Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults;
    private final ReplicaManager replicaManager;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            this.fetchPartitionStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Partition partition;
                    TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
                    LogOffsetMetadata logOffsetMetadata = ((FetchPartitionStatus)x0$1._2()).startOffsetMetadata();
                    try {
                        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                        if (!(logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2))) {
                            return BoxedUnit.UNIT;
                        }
                        partition = $this.replicaManager.getPartitionOrException(topicPartition.topicPartition());
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicPartition).append(" is in an offline log directory, satisfy ").append($this.fetchParams).append(" immediately").toString());
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicPartition).append(", satisfy ").append($this.fetchParams).append(" immediately").toString());
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker is no longer the leader or follower of %s, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchParams})));
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    return partition;
                }
                throw new MatchError(null);
            });
            if (!this.remoteFetchResult.isDone()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (!this.remoteFetchTask.cancel(true)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Remote fetch task for RemoteStorageFetchInfo: ").append($this.remoteFetchInfo).append(" could not be cancelled and its isDone value is ").append($this.remoteFetchTask.isDone()).toString());
        }
        DelayedRemoteFetchMetrics$.MODULE$.expiredRequestMeter().mark();
    }

    @Override
    public void onComplete() {
        Seq fetchPartitionData = (Seq)this.localReadResults.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                LogReadResult result = (LogReadResult)x0$1._2();
                if (tp.topicPartition().equals((Object)$this.remoteFetchInfo.topicPartition) && $this.remoteFetchResult.isDone()) {
                    Errors errors = result.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && result.info().delayedRemoteStorageFetch.isPresent()) {
                        if ($this.remoteFetchResult.get().error.isPresent()) {
                            FetchDataInfo x$1 = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
                            None$ x$2 = None$.MODULE$;
                            long x$3 = MergedLog$.MODULE$.UnknownOffset();
                            long x$4 = MergedLog$.MODULE$.UnknownOffset();
                            long x$5 = MergedLog$.MODULE$.UnknownOffset();
                            long x$6 = MergedLog$.MODULE$.UnknownOffset();
                            long x$7 = -1L;
                            None$ x$8 = None$.MODULE$;
                            boolean x$9 = false;
                            boolean x$10 = false;
                            Some x$11 = new Some($this.remoteFetchResult.get().error.get());
                            Option<Object> x$12 = LogReadResult$.MODULE$.apply$default$11();
                            long x$13 = LogReadResult$.MODULE$.apply$default$13();
                            LogReadResult qual$1 = new LogReadResult(x$1, (Option<FetchResponseData.EpochEndOffset>)x$2, x$3, x$4, x$5, x$6, x$7, (Option<Object>)x$8, x$9, x$10, x$12, (Option<Throwable>)x$11, x$13);
                            boolean x$14 = false;
                            long x$15 = qual$1.toFetchPartitionData$default$2();
                            long x$16 = qual$1.toFetchPartitionData$default$3();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)qual$1.toFetchPartitionData(x$14, x$15, x$16));
                        }
                        FetchDataInfo info = (FetchDataInfo)$this.remoteFetchResult.get().fetchDataInfo.get();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), info.records, Optional.empty(), result.lastStableOffset().isDefined() ? OptionalLong.of(BoxesRunTime.unboxToLong((Object)result.lastStableOffset().get())) : OptionalLong.empty(), info.abortedTransactions, result.preferredReadReplica().isDefined() ? OptionalInt.of(BoxesRunTime.unboxToInt((Object)result.preferredReadReplica().get())) : OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L)));
                    }
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(false, result.toFetchPartitionData$default$2(), result.toFetchPartitionData$default$3()));
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public DelayedRemoteFetch(Future<Void> remoteFetchTask, CompletableFuture<RemoteLogReadResult> remoteFetchResult, RemoteStorageFetchInfo remoteFetchInfo, long remoteFetchMaxWaitMs, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, FetchParams fetchParams, Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults, ReplicaManager replicaManager, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.remoteFetchTask = remoteFetchTask;
        this.remoteFetchResult = remoteFetchResult;
        this.remoteFetchInfo = remoteFetchInfo;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.fetchParams = fetchParams;
        this.localReadResults = localReadResults;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(remoteFetchMaxWaitMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
        if (fetchParams.isFromFollower()) {
            throw new IllegalStateException(new StringBuilder(63).append("The follower should not invoke remote fetch. Fetch params are: ").append(fetchParams).toString());
        }
    }
}

