/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.NetworkHealthManager$;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.log.LogCleaner$;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.network.SocketServer$;
import kafka.server.DynamicBackpressure$;
import kafka.server.DynamicBalancerConfig$;
import kafka.server.DynamicBrokerLoad$;
import kafka.server.DynamicClusterLinkConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicDurabilityAuditConfig$;
import kafka.server.DynamicE2EChecksumConfig$;
import kafka.server.DynamicKafkaApiConfig$;
import kafka.server.DynamicLeaderEpochCheckpointFileConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicObservabilityConfig$;
import kafka.server.DynamicQuotaConfig$;
import kafka.server.DynamicRemoteLogConfig$;
import kafka.server.DynamicReplicaManagerConfig$;
import kafka.server.DynamicReplicationModeConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.DynamicTransactionCoordinator$;
import kafka.server.DynamicZkControllerConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe$;
import kafka.server.resource.DiskIOManager;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator$;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static DynamicBrokerConfig$ MODULE$;
    private final scala.collection.mutable.Set<String> DynamicSecurityConfigs;
    private final Set<String> DynamicProducerStateManagerConfig;
    private final scala.collection.mutable.Set<String> AllDynamicConfigs;
    private final Set<String> ClusterLevelListenerConfigs;
    private final scala.collection.mutable.Set<String> PerBrokerConfigs;
    private final Set<String> DefaultOnlyBrokerConfigs;
    private final Set<String> ListenerMechanismConfigs;
    private final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    private final Regex ListenerConfigRegex;
    private final scala.collection.mutable.Set<String> DynamicPasswordConfigs;
    private final ConfigDef SecurityConfigDef;

    static {
        new DynamicBrokerConfig$();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return this.DynamicSecurityConfigs;
    }

    public Set<String> DynamicProducerStateManagerConfig() {
        return this.DynamicProducerStateManagerConfig;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return this.AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return this.ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return this.PerBrokerConfigs;
    }

    private Set<String> DefaultOnlyBrokerConfigs() {
        return this.DefaultOnlyBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return this.ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    private Regex ListenerConfigRegex() {
        return this.ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return this.DynamicPasswordConfigs;
    }

    public ConfigDef SecurityConfigDef() {
        return this.SecurityConfigDef;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(x$1)));
    }

    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        String string = ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG;
        if (!(string != null ? !string.equals(name) : name != null) ? true : "log.roll.hours".equals(name)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$));
        }
        String string2 = ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG;
        if (!(string2 != null ? !string2.equals(name) : name != null) ? true : "log.roll.jitter.hours".equals(name)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.jitter.hours", (List)Nil$.MODULE$));
        }
        String string3 = ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG;
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, (List)new .colon.colon((Object)"log.flush.scheduler.interval.ms", (List)Nil$.MODULE$));
        }
        String string4 = ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG;
        if (!(string4 != null ? !string4.equals(name) : name != null) ? true : ("log.retention.minutes".equals(name) ? true : "log.retention.hours".equals(name))) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.retention.minutes", (List)new .colon.colon((Object)"log.retention.hours", (List)Nil$.MODULE$)));
        }
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)name);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            if (matchListenerOverride) {
                Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)baseName.endsWith(x$1)));
                return new .colon.colon((Object)name, (List)new .colon.colon((Object)((String)mechanismConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> baseName)), (List)Nil$.MODULE$));
            }
        }
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
            return;
        }
        DynamicBrokerConfig$.checkInvalidProps$1(this.defaultOnlyBrokerConfigs(props), "Cannot update these configs at the broker level; only the default cluster level is supported");
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(this.PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.perBrokerListenerConfig$1(name))));
    }

    private Set<String> defaultOnlyBrokerConfigs(Properties props) {
        return (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(this.DefaultOnlyBrokerConfigs());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String string = (String)x0$1._1();
                String v = (String)x0$1._2();
                Option option = MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return baseProps.put(k, v);
            }
            throw new MatchError(null);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.AllDynamicConfigs().map((Function1 & Serializable & scala.Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains(name) ? "per-broker" : "cluster-wide";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)mode);
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public Properties resolveVariableConfigs(Properties propsOriginal) {
        Properties props = new Properties();
        new AbstractConfig(new ConfigDef(), (java.util.Map)propsOriginal, Utils.castToStringObjectMap((java.util.Map)propsOriginal), false).originals().forEach((key, value) -> {
            if (!key.startsWith("config.providers")) {
                props.put(key, value);
                return;
            }
        });
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)name);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            return !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        }
        return false;
    }

    private DynamicBrokerConfig$() {
        MODULE$ = this;
        this.DynamicSecurityConfigs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
        this.DynamicProducerStateManagerConfig = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producer.id.expiration.ms", "transaction.partition.verification.enable"}));
        this.AllDynamicConfigs = this.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metric.reporters"}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs()).$plus$plus(this.DynamicProducerStateManagerConfig()).$plus$plus(DynamicBackpressure$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierFetcher.reconfigurableConfigs).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuditLogRouterConfigProp()}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuthenticationAuditLogEnableProp()}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuditLogEnableProp()}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.ClusterRegistryConfigProp()}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.authentication.event.rate.limit"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.authorization.event.rate.limit"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.kafka.request.rate.limit"}))).$plus$plus(DynamicBalancerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.traffic.network.id"}))).$plus$plus(DynamicClusterLinkConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicDurabilityAuditConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicE2EChecksumConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLeaderEpochCheckpointFileConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(StorageProbe$.MODULE$.ReconfigurableConfigs()).$plus$plus(SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)ReplicationQuotaManagerConfig.RECONFIGURABLE_CONFIGS).asScala()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto.create.topics.enable", "num.partitions", "fetch.max.bytes"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.reporters.telemetry.auto.enable"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.telemetry.enabled"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.catalog.collector.enable"}))).$plus$plus(TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTopicSnapshotCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(BrokerHealthManager$.MODULE$.ReconfigurableConfigs()).$plus$plus(NetworkHealthManager$.MODULE$.ReconfigurableConfigs()).$plus$plus(BackupObjectLifecycleManagerCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.topic.policy.max.partitions.per.tenant", "confluent.plugins.topic.policy.max.partitions.per.cluster", "confluent.plugins.topic.policy.max.topics.per.cluster", "confluent.plugins.topic.policy.max.replicas.per.broker", "confluent.plugins.topic.policy.lkc.metadata.partition.count.enforcement.enable"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.cells.enable", "confluent.cells.implicit.creation.enable", "confluent.cells.load.refresher.enable", "confluent.topic.partition.default.placement"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.quota.tenant.default.controller.mutation.rate", "confluent.quota.tenant.internal.throttling.enable", "confluent.quota.tenant.internal.broker.max.producer.rate", "confluent.quota.tenant.internal.broker.max.consumer.rate", "confluent.quota.tenant.default.producer.id.rate", "confluent.quota.tenant.produce.multiplier", "confluent.quota.tenant.fetch.multiplier", "confluent.quota.tenant.user.quotas.enable"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.cluster.link.policy.max.destination.links.per.tenant"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.cluster.link.policy.max.source.links.per.tenant"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.dataflow.policy.watch.monitor.ms"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.min.acks"}))).$plus$plus(DynamicBrokerLoad$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicReplicaManagerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicReplicationModeConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicZkControllerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicTransactionCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTasks$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTopicDataLossValidator.RECONFIGURABLE_CONFIGS).$plus$plus(TierTopicConsumer.RECONFIGURABLE_CONFIGS).$plus$plus(QuotaCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicQuotaConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.request.pipelining.enable"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multitenant.authorizer.support.resource.ids"}))).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.track.api.key.per.ip", "confluent.track.tenant.id.per.ip", "confluent.track.per.ip.max.size"}))).$plus$plus(DiskIOManager.reconfigurableConfigs).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.heap.tenured.notify.bytes"}))).$plus$plus(DynamicRemoteLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicKafkaApiConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicObservabilityConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.traffic.network.type"})));
        this.ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections", "max.connection.creation.rate", KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp(), KafkaConfig$.MODULE$.MaxConnectionCreationThrottleMsProp(), KafkaConfig$.MODULE$.MinConnectionCreationThrottleMsProp(), "num.network.threads", KafkaConfig$.MODULE$.SslCipherSuitesProp(), KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), "connections.max.idle.ms", KafkaConfig$.MODULE$.ListenerConnectionRatePerIpMaxProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpFloorProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpStepProp(), "confluent.max.connection.rate.per.tenant", "confluent.floor.connection.rate.per.tenant", "confluent.step.connection.rate.per.tenant", "max.connections.reap.amount"}));
        this.PerBrokerConfigs = (scala.collection.mutable.Set)this.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).diff(this.ClusterLevelListenerConfigs());
        this.DefaultOnlyBrokerConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.eligible.controllers"}));
        this.ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.jaas.config", "sasl.login.callback.handler.class", "sasl.login.class", "sasl.server.callback.handler.class", "connections.max.reauth.ms"}));
        this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
        this.ListenerConfigRegex = new StringOps(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)")).r();
        Set passwordConfigs = ((MapLike)KafkaConfig$.MODULE$.configKeys().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        this.DynamicPasswordConfigs = (scala.collection.mutable.Set)this.AllDynamicConfigs().intersect((GenSet)passwordConfigs);
        this.SecurityConfigDef = new ConfigDef().withClientSslSupport().withClientSaslSupport();
    }
}

