/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001\u0002\u0012$\u0001!B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"I\u0011\n\u0001BC\u0002\u0013\u00051E\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0017\"Iq\u000b\u0001BC\u0002\u0013\u00051\u0005\u0017\u0005\t9\u0002\u0011\t\u0011)A\u00053\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00115\u0004!\u0011!Q\u0001\n9DQ\u0001\u001f\u0001\u0005\u0002eD\u0011\"!\u0003\u0001\u0001\u0004%\t\"a\u0003\t\u0013\u0005u\u0001\u00011A\u0005\u0012\u0005}\u0001\u0002CA\u0016\u0001\u0001\u0006K!!\u0004\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001e\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!a\"\u0001\t#\tI\tC\u0004\u0002\"\u0002!\t\"a)\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003;\u0004A\u0011IAp\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003$\u0001!\tB!\n\t\u000f\tU\u0002\u0001\"\u0005\u00038!9!Q\b\u0001\u0005\u0012\t}\u0002b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005[\u0002A\u0011\tB8\u0005Q\u0011V-\\8uK2+\u0017\rZ3s\u000b:$\u0007k\\5oi*\u0011A%J\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001S=\u001a\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021c5\t1%\u0003\u00023G\tqA*Z1eKJ,e\u000e\u001a)pS:$\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c&\u0003\u0015)H/\u001b7t\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\u00131|w\r\u0015:fM&D\bCA\u001eC\u001d\ta\u0004\t\u0005\u0002>W5\taH\u0003\u0002@O\u00051AH]8pizJ!!Q\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003.\naB\u00197pG.LgnZ*f]\u0012,'\u000f\u0005\u00021\u000f&\u0011\u0001j\t\u0002\r\u00052|7m[5oON+g\u000eZ\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0002\u0017B\u0011A\nV\u0007\u0002\u001b*\u0011ajT\u0001\bG2LWM\u001c;t\u0015\t1\u0003K\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<\u0017BA+N\u0005M1U\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0003Q1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3sA\u0005q!/Z9vKN$()^5mI\u0016\u0014X#A-\u0011\u0005AR\u0016BA.$\u00059\u0011V-];fgR\u0014U/\u001b7eKJ\fqB]3rk\u0016\u001cHOQ;jY\u0012,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"\u0001M0\n\u0005\u0001\u001c#!\u0005$pY2|w/\u001a:UQJ|G\u000f\u001e7fe\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0001gY\u0005\u0003I\u000e\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001\u0019h\u0013\tA7E\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005AZ\u0017B\u00017$\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003]iW\r^1eCR\fg+\u001a:tS>t7+\u001e9qY&,'\u000fE\u0002+_FL!\u0001]\u0016\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001:w\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0019w.\\7p]*\u0011AeT\u0005\u0003oN\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001di\\H0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011\u0001\u0007\u0001\u0005\u0006s1\u0001\rA\u000f\u0005\u0006\u000b2\u0001\rA\u0012\u0005\u0006\u00132\u0001\ra\u0013\u0005\u0006/2\u0001\r!\u0017\u0005\u0006;2\u0001\rA\u0018\u0005\u0006C2\u0001\rA\u0019\u0005\u0006K2\u0001\rA\u001a\u0005\u0006S2\u0001\rA\u001b\u0005\u0006[2\u0001\rA\\\u0001\nM\u0016$8\r[*ju\u0016,\"!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!A.\u00198h\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u0011q!\u00138uK\u001e,'/A\u0007gKR\u001c\u0007nU5{K~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u0002+\u0003GI1!!\n,\u0005\u0011)f.\u001b;\t\u0013\u0005%b\"!AA\u0002\u00055\u0011a\u0001=%c\u0005Qa-\u001a;dQNK'0\u001a\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIV\u0011\u0011\u0011\u0007\t\u0004U\u0005M\u0012bAA\u001bW\t9!i\\8mK\u0006t\u0017!D5oSRL\u0017\r^3DY>\u001cX\r\u0006\u0002\u0002\"\u0005)1\r\\8tK\u0006q!M]8lKJ,e\u000e\u001a)pS:$HCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$K\u000591\r\\;ti\u0016\u0014\u0018\u0002BA&\u0003\u000b\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0002R\u0005=\u0004\u0003CA*\u00033\ni&a\u001a\u000e\u0005\u0005U#bAA,W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0013Q\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BA0\u0003Gj!!!\u0019\u000b\u0005Q|\u0015\u0002BA3\u0003C\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002j\u0005-T\"\u0001\u0001\n\u0007\u00055\u0014GA\u0005GKR\u001c\u0007\u000eR1uC\"9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003BA;\u0003\u0003sA!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\n\t'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty(!\u001f\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005\r\u0015Q\u0011\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\ty(!\u001f\u0002+A\u0014xnY3tg\u001a+Go\u00195Fq\u000e,\u0007\u000f^5p]R!\u0011\u0011EAF\u0011\u001d\ti)\u0006a\u0001\u0003\u001f\u000b\u0011\u0001\u001e\t\u0005\u0003#\u000bYJ\u0004\u0003\u0002\u0014\u0006]ebA\u001f\u0002\u0016&\tA&C\u0002\u0002\u001a.\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%!\u0003+ie><\u0018M\u00197f\u0015\r\tIjK\u0001\u0015aJ|7-Z:t\r\u0016$8\r\u001b*fgB|gn]3\u0015\t\u0005E\u0013Q\u0015\u0005\b\u0003O3\u0002\u0019AAU\u00039\u0019G.[3oiJ+7\u000f]8og\u0016\u00042\u0001TAV\u0013\r\ti+\u0014\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0003M1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u)\u0019\t\u0019,!/\u0002>B\u0019!/!.\n\u0007\u0005]6O\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u0005mv\u00031\u0001\u0002^\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA`/\u0001\u0007\u0011\u0011Y\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0002+\u0003\u0007L1!!2,\u0005\rIe\u000e^\u0001\u0012M\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$HCBAZ\u0003\u0017\fi\rC\u0004\u0002<b\u0001\r!!\u0018\t\u000f\u0005}\u0006\u00041\u0001\u0002B\u0006qb-\u001a;dQRKWM]'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UCJ<W\r\u001e\u000b\u0007\u0003'\fI.a7\u0011\u0007A\n).C\u0002\u0002X\u000e\u0012a\u0002V5fe>3gm]3u\u0013:4w\u000eC\u0004\u0002<f\u0001\r!!\u0018\t\u000f\u0005}\u0016\u00041\u0001\u0002B\u0006Ab-\u001a;dQ\u0016\u000b'\u000f\\5fgRdunY1m\u001f\u001a47/\u001a;\u0015\r\u0005M\u0016\u0011]Ar\u0011\u001d\tYL\u0007a\u0001\u0003;Bq!a0\u001b\u0001\u0004\t\t-A\u0006gKR\u001c\u0007n\u00144gg\u0016$H\u0003CAu\u0003_\f\t0a=\u0011\u000f)\nY/!1\u0002T&\u0019\u0011Q^\u0016\u0003\rQ+\b\u000f\\33\u0011\u001d\tYl\u0007a\u0001\u0003;Bq!a0\u001c\u0001\u0004\t\t\rC\u0004\u0002vn\u0001\r!a>\u0002\u0013QLW.Z:uC6\u0004\bc\u0001\u0016\u0002z&\u0019\u00111`\u0016\u0003\t1{gnZ\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\t\u0005!q\u0003\t\t\u0003'\nI&!\u0018\u0003\u0004A!!Q\u0001B\t\u001d\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003C\nq!\\3tg\u0006<W-\u0003\u0003\u0003\u0010\t%\u0011\u0001I(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAAa\u0005\u0003\u0016\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002\u0002B\b\u0005\u0013AqA!\u0007\u001d\u0001\u0004\u0011Y\"\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002\"a\u0015\u0002Z\u0005u#Q\u0004\t\u0005\u0003S\u0012y\"C\u0002\u0003\"E\u0012\u0011\"\u00129pG\"$\u0015\r^1\u00029\r\u0014X-\u0019;f\u000bB|7\r[#oI>3gm]3ugJ+\u0017/^3tiR!!q\u0005B\u001a!\u0011\u0011ICa\f\u000f\t\u0005]$1F\u0005\u0005\u0005[\tI(\u0001\u000fPM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\n\t\u0005\r%\u0011\u0007\u0006\u0005\u0005[\tI\bC\u0004\u0003\u001au\u0001\rAa\u0007\u0002=A\u0014xnY3tg\u0016\u0003xn\u00195F]\u0012|eMZ:fiN\u0014Vm\u001d9p]N,G\u0003\u0002B\u0001\u0005sAqAa\u000f\u001f\u0001\u0004\tI+\u0001\u0005sKN\u0004xN\\:f\u0003u\u0001(o\\2fgN,\u0005o\\2i\u000b:$wJ\u001a4tKR\u001ch)Y5mkJ,GC\u0002B\u0001\u0005\u0003\u0012\u0019\u0005C\u0004\u0003\u001a}\u0001\rAa\u0007\t\u000f\u00055u\u00041\u0001\u0002\u0010\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\t%#1\r\t\u0007\u0005\u0017\u0012\tFa\u0016\u000f\u0007A\u0012i%C\u0002\u0003P\r\nQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003T\tU#\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003P\r\u0002RA\u000bB-\u0005;J1Aa\u0017,\u0005\u0019y\u0005\u000f^5p]B!!1\nB0\u0013\u0011\u0011\tG!\u0016\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\te\u0001\u00051\u0001\u0003fAA\u00111KA-\u0003;\u00129\u0007E\u00021\u0005SJ1Aa\u001b$\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003=I7OU3bIf4uN\u001d$fi\u000eDG\u0003BA\u0019\u0005cBqAa\u001d\"\u0001\u0004\ti&\u0001\u0002ua\u0002")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(Integer x$1) {
        this.fetchSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.processFetchException(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        return this.processFetchResponse(clientResponse2);
    }

    public void processFetchException(Throwable t) {
        this.fetchSessionHandler().handleError(t);
    }

    public Map<TopicPartition, FetchResponseData.PartitionData> processFetchResponse(ClientResponse clientResponse) {
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return scala.collection.Map$.MODULE$.empty();
        }
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse.requestHeader().apiVersion())).asScala();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            void var4_4;
            Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TierOffsetInfo tierOffsetInfo = (TierOffsetInfo)tuple2._2();
            return var4_4;
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Remote Leader Endpoint.");
    }

    private Tuple2<Object, TierOffsetInfo> fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)listOffsetRequest).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV2)) {
                if (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID)) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()));
                }
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(responsePartition.offset()));
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0))));
        }
        throw errors.exception();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return scala.collection.Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.createEpochEndOffsetsRequest(partitions);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            return this.processEpochEndOffsetsResponse(response);
        }
        catch (Throwable t) {
            return this.processEpochEndOffsetsFailure(partitions, t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OffsetsForLeaderEpochRequest.Builder createEpochEndOffsetsRequest(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$createEpochEndOffsetsRequest$1(topics, topicPartition, epochData));
        Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsResponse(ClientResponse response) {
        OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responseBody.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)offsetForLeaderTopicResult -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopicResult.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)offsetForLeaderPartitionResult -> {
            TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
        }, Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsFailure(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions, Throwable t) {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        Errors error = AbstractFetcherThread$.MODULE$.exceptionToError(t);
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || $this.throttler.shouldThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager, $this.quota);
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$5 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$5))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.replicationSessionId().map((Function1 & Serializable & scala.Serializable)x$6 -> RemoteLeaderEndPoint.$anonfun$buildFetch$4(BoxesRunTime.unboxToLong((Object)x$6))))), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)Errors.KAFKA_STORAGE_ERROR));
                }
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Some fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Some>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createEpochEndOffsetsRequest$1(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Long $anonfun$buildFetch$4(long x$6) {
        return BoxesRunTime.boxToLong((long)x$6);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

