/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u0016-\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"I\u0011\n\u0001B\u0001B\u0003%!*\u0014\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005q\"Aa\u0010\u0001B\u0001B\u0003%q\u0010C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u0013\u0005=\u0002A1A\u0005\n\u0005E\u0002bBA\u001a\u0001\u0001\u0006I!\u0012\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003oAq!!\u000f\u0001A\u0003%A\u000f\u0003\u0006\u0002<\u0001\u0011\r\u0011\"\u0001-\u0003{A\u0001\"a\u0015\u0001A\u0003%\u0011q\b\u0005\n\u0003+\u0002!\u0019!C)\u0003/B\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003C\u0002!\u0019!C)\u0003/B\u0001\"a\u0019\u0001A\u0003%\u0011\u0011\f\u0005\b\u0003K\u0002A\u0011KA4\u0011\u001d\ty\u0007\u0001C)\u0003cBq!a\u001f\u0001\t#\ni\bC\u0004\u0002\u0002\u0002!\t&a!\t\u000f\u0005M\u0005\u0001\"\u0015\u0002\u0016\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003_\u0003A\u0011IAW\u0011\u001d\t\t\f\u0001C!\u0003gC\u0001\"!8\u0001\t\u0003a\u0013Q\u0016\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\t)\u0010\u0001C!\u0003oDqAa\u0002\u0001\t#\u0012I\u0001C\u0007\u0003\u0012\u0001\u0001\n1!A\u0001\n\u0013\u0011\u0019\"T\u0004\n\u0005+a\u0013\u0011!E\u0001\u0005/1\u0001b\u000b\u0017\u0002\u0002#\u0005!\u0011\u0004\u0005\b\u0003#9C\u0011\u0001B\u0011\u0011%\u0011\u0019cJI\u0001\n\u0003\u0011)\u0003C\u0005\u0003<\u001d\n\n\u0011\"\u0001\u0003>\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!!\f\u0018\u0002\rM,'O^3s\u0015\u0005y\u0013!B6bM.\f7\u0001A\n\u0003\u0001I\u0002\"a\r\u001b\u000e\u00031J!!\u000e\u0017\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\tA\u0014I\u0004\u0002:\u007fA\u0011!(P\u0007\u0002w)\u0011A\bM\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001v\n\u0011BZ3uG\",'/\u00133\u0011\u0005\u0019;U\"A\u001f\n\u0005!k$aA%oi\u00061A.Z1eKJ\u0004\"aM&\n\u00051c#A\u0004'fC\u0012,'/\u00128e!>Lg\u000e^\u0005\u0003\u0013R\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"a\r)\n\u0005Ec#aC&bM.\f7i\u001c8gS\u001e\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005M\"\u0016BA+-\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\tqCV\u001cX\r\u001a)beRLG/[8ogB\u00111\u0007W\u0005\u000332\u0012\u0001\u0003U1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u00039\u001al\u0011!\u0018\u0006\u0003=~\u000bQ!\u001e;jYNT!\u0001Y1\u0002\r\r|W.\\8o\u0015\ty#M\u0003\u0002dI\u00061\u0011\r]1dQ\u0016T\u0011!Z\u0001\u0004_J<\u0017BA4^\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u00024U&\u00111\u000e\f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\t\u0019d.\u0003\u0002pY\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006iAn\\4D_:$X\r\u001f;PaR\u00042A\u0012:u\u0013\t\u0019XH\u0001\u0004PaRLwN\u001c\t\u00039VL!A^/\u0003\u00151{wmQ8oi\u0016DH/A\bfqR\u0014\u0018-T3ue&\u001cG+Y4t!\u0011IHpN\u001c\u000e\u0003iT!a_\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~u\n\u0019Q*\u00199\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b#\u0002$\u0002\u0002\u0005\u0015\u0011bAA\u0002{\tIa)\u001e8di&|g\u000e\r\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u0001-a\u0003\u000b\u00055\n\u0017\u0002BA\b\u0003\u0013\u0011q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005U\u0011qCA\r\u00037\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u0011\u0005M\u0002\u0001\"\u0002\u001c\u000e\u0001\u00049\u0004\"\u0002#\u000e\u0001\u0004)\u0005\"B%\u000e\u0001\u0004Q\u0005\"\u0002(\u000e\u0001\u0004y\u0005\"\u0002*\u000e\u0001\u0004\u0019\u0006\"\u0002,\u000e\u0001\u00049\u0006\"\u0002.\u000e\u0001\u0004Y\u0006\"\u00025\u000e\u0001\u0004I\u0007\"\u00027\u000e\u0001\u0004i\u0007b\u00029\u000e!\u0003\u0005\r!\u001d\u0005\bo6\u0001\n\u00111\u0001y\u0011\u0015qX\u00021\u0001\u0000\u0003%\u0011X\r\u001d7jG\u0006LE-F\u0001F\u0003)\u0011X\r\u001d7jG\u0006LE\rI\u0001\u000bY><7i\u001c8uKb$X#\u0001;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\u001fa\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<\b*[4i/\u0006$XM]7be.,\"!a\u0010\u0011\r\u0005\u0005\u0013qIA&\u001b\t\t\u0019EC\u0002\u0002Fi\fq!\\;uC\ndW-\u0003\u0003\u0002J\u0005\r#A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002N\u0005=S\"A0\n\u0007\u0005EsL\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002?A\f'\u000f^5uS>t7oV5uQ:+w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007%A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\"!!\u0017\u0011\u0007\u0019\u000bY&C\u0002\u0002^u\u0012qAQ8pY\u0016\fg.\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013!\u0007;sC:\u001c\u0018\u000e^5p]R{\u0007+^:i'V\u0004\bo\u001c:uK\u0012\f!\u0004\u001e:b]NLG/[8o)>\u0004Vo\u001d5TkB\u0004xN\u001d;fI\u0002\n1\u0002\\1uKN$X\t]8dQR!\u0011\u0011NA6!\r1%/\u0012\u0005\b\u0003[B\u0002\u0019AA&\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002t\u0005e\u0004c\u0001$\u0002v%\u0019\u0011qO\u001f\u0003\t1{gn\u001a\u0005\b\u0003[J\u0002\u0019AA&\u00031awnZ#oI>3gm]3u)\u0011\t\u0019(a \t\u000f\u00055$\u00041\u0001\u0002L\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005\u0015\u0015QRAH!\u00111%/a\"\u0011\t\u0005\u001d\u0011\u0011R\u0005\u0005\u0003\u0017\u000bIA\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u000554\u00041\u0001\u0002L!1\u0011\u0011S\u000eA\u0002\u0015\u000bQ!\u001a9pG\"\f\u0011d\u00195fG.\u0004x.\u001b8u%\u0016\u001cwN^3ss>3gm]3ugR!\u0011qSAO!\r1\u0015\u0011T\u0005\u0004\u00037k$\u0001B+oSRDq!a(\u001d\u0001\u0004\t\t+A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\t\t%a)\u0002L%!\u0011QUA\"\u0005-\t%O]1z\u0005V4g-\u001a:\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA-\u00035\tw/Y5u'\",H\u000fZ8x]R\u0011\u0011qS\u0001\u0007I><vN]6\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\t),a3\u0002N\u0006E\u0007\u0003\u0002$s\u0003o\u0003B!!/\u0002H6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0002m_\u001eTA!!1\u0002D\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u000b\f\u0017aB:u_J\fw-Z\u0005\u0005\u0003\u0013\fYLA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003[\u0002\u0003\u0019AA&\u0011\u001d\ty\r\ta\u0001\u0003g\n1BZ3uG\"|eMZ:fi\"9\u00111\u001b\u0011A\u0002\u0005U\u0017!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002X\u0006eW\"\u0001\u0001\n\u0007\u0005mGGA\u0005GKR\u001c\u0007\u000eR1uC\u0006a2m\\7qY\u0016$X\rR3mCf,GMR3uG\"\u0014V-];fgR\u001c\u0018aG7bs\n,w+\u0019:o\u0013\u001a|e/\u001a:tSj,GMU3d_J$7\u000f\u0006\u0004\u0002\u0018\u0006\r\u00181\u001f\u0005\b\u0003K\u0014\u0003\u0019AAt\u0003\u001d\u0011XmY8sIN\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0004\u0003[|\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0002r\u0006-(!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002n\t\u0002\r!a\u0013\u0002\u0011Q\u0014XO\\2bi\u0016$b!!\u0017\u0002z\u0006u\bbBA~G\u0001\u0007\u00111J\u0001\u0003iBDq!a@$\u0001\u0004\u0011\t!A\u000bpM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007M\u0012\u0019!C\u0002\u0003\u00061\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011q\u0013B\u0006\u0005\u001bAq!!\u001c%\u0001\u0004\tY\u0005C\u0004\u0003\u0010\u0011\u0002\r!a\u001d\u0002\r=4gm]3u\u00031\u0019X\u000f]3sI1,\u0017\rZ3s+\u0005Q\u0015\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u00024OM\u0019qEa\u0007\u0011\u0007\u0019\u0013i\"C\u0002\u0003 u\u0012a!\u00118z%\u00164GC\u0001B\f\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa\n+\u0007E\u0014Ic\u000b\u0002\u0003,A!!Q\u0006B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012!C;oG\",7m[3e\u0015\r\u0011)$P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001d\u0005_\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE*\"Aa\u0010+\u0007a\u0014I\u0003")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final int replicaId;
    private final LogContext logContext;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean transitionToPushSupported;

    public static Map<String, String> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<LogContext> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
        if (topicPartitions.isEmpty()) {
            return;
        }
        ArrayBuffer affectedLogs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1(this, affectedLogs, tp);
            return BoxedUnit.UNIT;
        });
        ((ResizableArray)((SeqLike)affectedLogs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.parentDirFile(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$4(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        Option<LogAppendInfo> logAppendInfo = this.replicaMgr.appendRecordsToFollowerReplica(topicPartition, fetchOffset, AppendOrigin.REPLICATION, -1L, Optional.empty(), records, partitionData.highWatermark(), Optional.of(BoxesRunTime.boxToLong((long)partitionData.logStartOffset())), this.quota);
        if (logAppendInfo.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$processPartitionData$1(x$2)))) {
            this.partitionsWithNewHighWatermark().$plus$eq((Object)topicPartition);
        }
        if (records.sizeInBytes() > 0) {
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
            return;
        }
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (offsetTruncationState.offset() < log.highWatermark()) {
            if (!partition.isUncleanLeader()) {
                if (partition.isActiveLinkDestinationLeader()) {
                    this.replicaMgr.clusterLinkTruncationBelowHWM().mark();
                } else {
                    this.replicaMgr.truncationBelowHWM().mark();
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        partition.truncateTo(offsetTruncationState.offset(), false, false);
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$1(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        Option<AbstractLog> log = $this.replicaMgr.getLog(tp);
        if (log != null) {
            log.foreach((Function1 & Serializable & scala.Serializable)l -> affectedLogs$1.$plus$eq(l));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$4(ReplicaFetcherThread $this, File dir) {
        $this.replicaMgr.logManager().checkpointRecoveryOffsetsInDir(dir);
    }

    public static final /* synthetic */ boolean $anonfun$processPartitionData$1(LogAppendInfo x$2) {
        LeaderHwChange leaderHwChange = x$2.leaderHwChange();
        LeaderHwChange leaderHwChange2 = LeaderHwChange.INCREASED;
        return !(leaderHwChange != null ? !leaderHwChange.equals(leaderHwChange2) : leaderHwChange2 != null);
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags, Function0<MetadataVersion> metadataVersionSupplier) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, new ConfluentReplicaFetcherTierStateMachine(leader, replicaMgr, exponentialBackoff), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(this.super$leader().brokerEndPoint().id()).append(", fetcherId=").append($this.fetcherId).append("] ").toString()));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
        this.transitionToPushSupported = true;
    }
}

