/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.OptionalInt;
import kafka.cluster.Partition;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class RequestHandlerHelper$ {
    public static RequestHandlerHelper$ MODULE$;

    static {
        new RequestHandlerHelper$();
    }

    public void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClusterLinkFactory.LinkManager clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Iterable<Partition> updatedLeaders, Iterable<Partition> updatedFollowers) {
        updatedLeaders.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            RequestHandlerHelper$.$anonfun$onLeadershipChange$1(groupCoordinator, txnCoordinator, tierDeletedPartitionsCoordinatorOpt, backupObjectLifecycleManagerCoordinatorOpt, tierTopicSnapshotCoordinatorOpt, clusterLinkManager, quotaCoordinatorOpt, partition);
            return BoxedUnit.UNIT;
        });
        updatedFollowers.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            RequestHandlerHelper$.$anonfun$onLeadershipChange$6(groupCoordinator, txnCoordinator, tierDeletedPartitionsCoordinatorOpt, backupObjectLifecycleManagerCoordinatorOpt, tierTopicSnapshotCoordinatorOpt, clusterLinkManager, quotaCoordinatorOpt, partition);
            return BoxedUnit.UNIT;
        });
    }

    public String routingPathPrefixOrNull(RequestContext context) {
        PathAwareSniHostName sniHostName = context.sniHostName;
        if (sniHostName != null && sniHostName.routingPathPrefix() != null) {
            return new StringBuilder(1).append(sniHostName.routingPathPrefix()).append("-").toString();
        }
        return null;
    }

    public void validateAlterBrokerReplicaExclusionRequest(AlterBrokerReplicaExclusionsRequest request) {
        List brokerIds = (List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.data().brokersToExclude()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), List$.MODULE$.canBuildFrom());
        if (brokerIds.isEmpty()) {
            throw new InvalidBrokerReplicaExclusionException("At least one broker must be provided for exclusion");
        }
        if (brokerIds.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 < 0)) {
            throw new UnrepresentableBrokerIdException(new StringBuilder(30).append("Invalid broker ids specified: ").append(brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 < 0)).toString());
        }
        if (brokerIds.size() != brokerIds.toSet().size()) {
            throw new InvalidBrokerReplicaExclusionException("Cannot have duplicate broker ids in the same exclusion request.");
        }
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(request.data().brokersToExclude()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exclusion -> {
            RequestHandlerHelper$.$anonfun$validateAlterBrokerReplicaExclusionRequest$4(exclusion);
            return BoxedUnit.UNIT;
        });
    }

    public void validateRemoveBrokersRequest(RemoveBrokersRequest request) {
        List brokersToRemove = (List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.data().brokersToRemove()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), List$.MODULE$.canBuildFrom());
        if (brokersToRemove.isEmpty()) {
            throw new InvalidBrokerRemovalException("At least one broker id need to be specified.");
        }
        if (brokersToRemove.size() != brokersToRemove.toSet().size()) {
            throw new InvalidBrokerRemovalException("Cannot have duplicate broker ids in the same broker removal request.");
        }
        List invalidBrokers = (List)brokersToRemove.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 < 0);
        if (invalidBrokers.nonEmpty()) {
            throw new UnrepresentableBrokerIdException(new StringBuilder(30).append("Invalid broker ids specified: ").append(invalidBrokers).toString());
        }
    }

    public ComputeEvenClusterLoadPlanResponseData convertEvenClusterLoadPlanInternalToResponseData(EvenClusterLoadPlanInternal plan) {
        return new ComputeEvenClusterLoadPlanResponseData().setInterBrokerMoves(plan.movementStats().interBrokerMoves()).setInterBrokerMovesMB(plan.movementStats().interBrokerMovesMB()).setLeadershipMoves(plan.movementStats().leadershipMoves()).setRecentWindows(plan.clusterRelatedStats().recentWindows()).setPartitionCoveragePercent(plan.clusterRelatedStats().partitionCoveragePercent()).setNewBrokers(plan.brokerRelatedStats().newBrokers()).setDeadOrRemovedBrokers(plan.brokerRelatedStats().deadOrRemovedBrokers()).setViolatedGoalsBeforeOptimization(plan.goalRelatedStats().violatedGoalsBeforeOptimization()).setViolatedGoalsAfterOptimization(plan.goalRelatedStats().violatedGoalsAfterOptimization()).setMovementGeneratingGoals(plan.goalRelatedStats().movementGeneratingGoals()).setExcludedTopics(plan.clusterRelatedStats().excludedTopics()).setBrokersExcludedForLeadership(plan.brokerRelatedStats().brokersExcludedForLeadership()).setBrokersExcludedForReplicaMove(plan.brokerRelatedStats().brokersExcludedForReplicaMove()).setTotalBrokers(plan.clusterRelatedStats().totalBrokers()).setTotalReplicas(plan.clusterRelatedStats().totalReplicas()).setTotalTopics(plan.clusterRelatedStats().totalTopics()).setBalancednessScorePreRebalance(plan.clusterBalancedness().balancednessScorePreRebalance()).setBalancednessScorePostRebalance(plan.clusterBalancedness().balancednessScorePostRebalance()).setGoalStats((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.convertPlanGoalStatsToResponseData(plan)).asJava()).setClusterLoadPreRebalance((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(plan.clusterBalancedness().clusterLoadPreRebalance()).asScala()).map((Function1 & Serializable & scala.Serializable)bs -> new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(bs.brokerId()).setHost(bs.host()).setDiskMB(bs.diskMB()).setDiskPercent(bs.diskPercent()).setCpuPercent(bs.cpuPercent()).setLeaderNetworkInKBps(bs.leaderNetworkInKBps()).setFollowerNetworkInKBps(bs.followerNetworkInKBps()).setNetworkOutKBps(bs.networkOutKBps()).setPotentialNetworkOutKBps(bs.potentialNetworkOutKBps()).setLeaders(bs.leaders()).setReplicas(bs.replicas()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setClusterLoadPostRebalance((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(plan.clusterBalancedness().clusterLoadPostRebalance()).asScala()).map((Function1 & Serializable & scala.Serializable)bs -> new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(bs.brokerId()).setHost(bs.host()).setDiskMB(bs.diskMB()).setDiskPercent(bs.diskPercent()).setCpuPercent(bs.cpuPercent()).setLeaderNetworkInKBps(bs.leaderNetworkInKBps()).setFollowerNetworkInKBps(bs.followerNetworkInKBps()).setNetworkOutKBps(bs.networkOutKBps()).setPotentialNetworkOutKBps(bs.potentialNetworkOutKBps()).setLeaders(bs.leaders()).setReplicas(bs.replicas()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
    }

    private List<ComputeEvenClusterLoadPlanResponseData.GoalStat> convertPlanGoalStatsToResponseData(EvenClusterLoadPlanInternal plan) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(plan.goalRelatedStats().goalStats()).asScala()).map((Function1 & Serializable & scala.Serializable)gs -> new ComputeEvenClusterLoadPlanResponseData.GoalStat().setGoalName(gs.goalName()).setAvgResources(new ComputeEvenClusterLoadPlanResponseData.AvgResources().setCpuPercent(gs.avgResources().cpuPercent()).setNetworkInboundKBps(gs.avgResources().networkInboundKBps()).setProducerInboundKBps(gs.avgResources().producerInboundKBps()).setConsumerOutboundKBps(gs.avgResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.avgResources().networkOutboundKBps()).setDiskMB(gs.avgResources().diskMB()).setPotentialNwOutKBps(gs.avgResources().potentialNwOutKBps()).setReplicas(gs.avgResources().replicas()).setLeaderReplicas(gs.avgResources().leaderReplicas()).setTopicReplicas(gs.avgResources().topicReplicas())).setMaxResources(new ComputeEvenClusterLoadPlanResponseData.MaxResources().setCpuPercent(gs.maxResources().cpuPercent()).setNetworkInboundKBps(gs.maxResources().networkInboundKBps()).setProducerInboundKBps(gs.maxResources().producerInboundKBps()).setConsumerOutboundKBps(gs.maxResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.maxResources().networkOutboundKBps()).setDiskMB(gs.maxResources().diskMB()).setPotentialNwOutKBps(gs.maxResources().potentialNwOutKBps()).setReplicas(gs.maxResources().replicas()).setLeaderReplicas(gs.maxResources().leaderReplicas()).setTopicReplicas(gs.maxResources().topicReplicas())).setMinResources(new ComputeEvenClusterLoadPlanResponseData.MinResources().setCpuPercent(gs.minResources().cpuPercent()).setNetworkInboundKBps(gs.minResources().networkInboundKBps()).setProducerInboundKBps(gs.minResources().producerInboundKBps()).setConsumerOutboundKBps(gs.minResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.minResources().networkOutboundKBps()).setDiskMB(gs.minResources().diskMB()).setPotentialNwOutKBps(gs.minResources().potentialNwOutKBps()).setReplicas(gs.minResources().replicas()).setLeaderReplicas(gs.minResources().leaderReplicas()).setTopicReplicas(gs.minResources().topicReplicas())).setStdResources(new ComputeEvenClusterLoadPlanResponseData.StdResources().setCpuPercent(gs.stdResources().cpuPercent()).setNetworkInboundKBps(gs.stdResources().networkInboundKBps()).setProducerInboundKBps(gs.stdResources().producerInboundKBps()).setConsumerOutboundKBps(gs.stdResources().consumeOutboundKBps()).setNetworkOutboundKBps(gs.stdResources().networkOutboundKBps()).setDiskMB(gs.stdResources().diskMB()).setPotentialNwOutKBps(gs.stdResources().potentialNwOutKBps()).setReplicas(gs.stdResources().replicas()).setLeaderReplicas(gs.stdResources().leaderReplicas()).setTopicReplicas(gs.stdResources().topicReplicas())).setGoalOverview(new ComputeEvenClusterLoadPlanResponseData.GoalOverview().setGoalStatus(gs.goalOverview().goalStatus()).setRejectingGoals((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(gs.goalOverview().rejectingGoals()).asScala()).map((Function1 & Serializable & scala.Serializable)rg -> new ComputeEvenClusterLoadPlanResponseData.RejectingGoal().setGoalName(rg.goalName()).setProposalsRejected(rg.proposalsRejected()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setProposalsGenerated(gs.goalOverview().proposalsGenerated()).setProposalsRejected(gs.goalOverview().proposalsRejected()).setProposalsRejectedPercent(gs.goalOverview().proposalsRejectedPercent()).setProposalsAccepted(gs.goalOverview().proposalsAccepted()).setProposalsAcceptedPercent(gs.goalOverview().proposalsAcceptedPercent()).setMoves(gs.goalOverview().moves()).setSwaps(gs.goalOverview().swaps())), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public static final /* synthetic */ void $anonfun$onLeadershipChange$1(GroupCoordinator groupCoordinator$1, TransactionCoordinator txnCoordinator$1, Option tierDeletedPartitionsCoordinatorOpt$1, Option backupObjectLifecycleManagerCoordinatorOpt$1, Option tierTopicSnapshotCoordinatorOpt$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Option quotaCoordinatorOpt$1, Partition partition) {
        if (!partition.linkedUpdatesOnly()) {
            String string = partition.topic();
            String string2 = "__consumer_offsets";
            if (string != null && string.equals(string2)) {
                groupCoordinator$1.onElection(partition.partitionId(), partition.getLeaderEpoch());
                return;
            }
        }
        if (!partition.linkedUpdatesOnly()) {
            String string = partition.topic();
            String string3 = "__transaction_state";
            if (string != null && string.equals(string3)) {
                txnCoordinator$1.onElection(partition.partitionId(), partition.getLeaderEpoch());
                return;
            }
        }
        if (partition.topic().startsWith("_confluent-tier-state")) {
            tierDeletedPartitionsCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.handleImmigration(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            backupObjectLifecycleManagerCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.onElection(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            tierTopicSnapshotCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.onElection(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            return;
        }
        String string = partition.topic();
        String string4 = "_confluent-link-metadata";
        if (string != null && string.equals(string4)) {
            clusterLinkManager$1.onMetadataPartitionLeaderElection(partition.partitionId(), partition.getLeaderEpoch());
            return;
        }
        if (partition.topic().startsWith("_confluent-quotas")) {
            quotaCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onElection(partition.partitionId(), partition.getLeaderEpoch());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onLeadershipChange$6(GroupCoordinator groupCoordinator$1, TransactionCoordinator txnCoordinator$1, Option tierDeletedPartitionsCoordinatorOpt$1, Option backupObjectLifecycleManagerCoordinatorOpt$1, Option tierTopicSnapshotCoordinatorOpt$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Option quotaCoordinatorOpt$1, Partition partition) {
        if (!partition.linkedUpdatesOnly()) {
            String string = partition.topic();
            String string2 = "__consumer_offsets";
            if (string != null && string.equals(string2)) {
                groupCoordinator$1.onResignation(partition.partitionId(), OptionalInt.of(partition.getLeaderEpoch()));
                return;
            }
        }
        if (!partition.linkedUpdatesOnly()) {
            String string = partition.topic();
            String string3 = "__transaction_state";
            if (string != null && string.equals(string3)) {
                txnCoordinator$1.onResignation(partition.partitionId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch())));
                return;
            }
        }
        if (partition.topic().startsWith("_confluent-tier-state")) {
            tierDeletedPartitionsCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.handleEmigration(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            backupObjectLifecycleManagerCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.onResignation(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            tierTopicSnapshotCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.onResignation(partition.partitionId());
                return BoxedUnit.UNIT;
            });
            return;
        }
        String string = partition.topic();
        String string4 = "_confluent-link-metadata";
        if (string != null && string.equals(string4)) {
            clusterLinkManager$1.onMetadataPartitionLeaderResignation(partition.partitionId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch())));
            return;
        }
        if (partition.topic().startsWith("_confluent-quotas")) {
            quotaCoordinatorOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.onResignation(partition.partitionId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch())));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateAlterBrokerReplicaExclusionRequest$4(AlterBrokerReplicaExclusionsRequestData.BrokerExclusion exclusion) {
        byte opCode = exclusion.exclusionOperationCode();
        ExclusionOp.OpType opType = ExclusionOp.OpType.forId((byte)opCode);
        ExclusionOp.OpType opType2 = ExclusionOp.OpType.UNKNOWN;
        if (!(opType != null ? !opType.equals(opType2) : opType2 != null)) {
            throw new InvalidBrokerReplicaExclusionException(new StringBuilder(45).append("Could not recognize exclusion operation code ").append(opCode).toString());
        }
        try {
            ExclusionRequestUtils.validateReason((String)exclusion.reason());
            return;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBrokerReplicaExclusionException("Invalid reason supplied for replica exclusions", (Throwable)e);
        }
    }

    private RequestHandlerHelper$() {
        MODULE$ = this;
    }
}

