/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ClusterlinkV1alphaApi;
import io.confluent.flink.apiserver.client.CoreV1Api;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1alphaLogicalKafkaCluster;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1alphaLogicalKafkaClusterList;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1alphaLogicalKafkaClusterSpec;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1alphaSite;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kafka.server.DataFlowPolicy;
import kafka.server.KafkaConfig;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalLkcMetadataLookupKey;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmRegionalMetadataClient$;
import kafka.server.RmRegionalMetadataWatcher;
import kafka.server.Subscription;
import kafka.server.Watch;
import kafka.server.ssl.MtlsWithServerCertConfigs;
import kafka.utils.Logging;
import okhttp3.OkHttpClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-v!\u0002\"D\u0011\u0003Ae!\u0002&D\u0011\u0003Y\u0005\"\u0002-\u0002\t\u0003I\u0006b\u0002.\u0002\u0005\u0004%Ia\u0017\u0005\u0007?\u0006\u0001\u000b\u0011\u0002/\t\u0011\u0001\f!\u0019!C\u0001\u0007\u0006Da\u0001^\u0001!\u0002\u0013\u0011\u0007\u0002C;\u0002\u0005\u0004%\ta\u0011<\t\u000f\u0005=\u0011\u0001)A\u0005o\"9\u0011\u0011C\u0001\u0005\n\u0005M\u0001bBA\u001b\u0003\u0011\u0005\u0011q\u0007\u0005\b\u0003/\nA\u0011AA-\r\u0015Q5IAA/\u0011)\tY\u0007\u0004B\u0001B\u0003%\u0011Q\u000e\u0005\u000712!\t!a\u001d\t\u0015\u0005eD\u00021A\u0005\u0002\r\u000bY\b\u0003\u0006\u0002~1\u0001\r\u0011\"\u0001D\u0003\u007fB\u0001\"!\"\rA\u0003&\u0011Q\u000e\u0005\r\u0003\u000fc\u0001\u0019!a\u0001\n\u0003\u0019\u0015\u0011\u0012\u0005\r\u0003Wc\u0001\u0019!a\u0001\n\u0003\u0019\u0015Q\u0016\u0005\f\u0003cc\u0001\u0019!A!B\u0013\tY\tC\u0005\u000242\u0011\r\u0011\"\u0003\u00026\"A\u0011Q\u0018\u0007!\u0002\u0013\t9\f\u0003\u0006\u0002@2\u0011\r\u0011\"\u0001D\u0003\u0003D\u0001\"!3\rA\u0003%\u00111\u0019\u0005\u000b\u0003\u0017d!\u0019!C\u0001\u0007\u00065\u0007\u0002CAk\u0019\u0001\u0006I!a4\t\u0017\u0005]G\u00021AA\u0002\u0013%\u0011\u0011\u001c\u0005\f\u0003Wd\u0001\u0019!a\u0001\n\u0013\ti\u000fC\u0006\u0002r2\u0001\r\u0011!Q!\n\u0005m\u0007BCAz\u0019\u0001\u0007I\u0011A\"\u0002v\"Q!\u0011\u0001\u0007A\u0002\u0013\u00051Ia\u0001\t\u0011\t\u001dA\u0002)Q\u0005\u0003oDAB!\u0003\r\u0001\u0004\u0005\r\u0011\"\u0001D\u0005\u0017AABa\u0005\r\u0001\u0004\u0005\r\u0011\"\u0001D\u0005+A1B!\u0007\r\u0001\u0004\u0005\t\u0015)\u0003\u0003\u000e!I!1\u0004\u0007C\u0002\u0013%!Q\u0004\u0005\t\u0005_a\u0001\u0015!\u0003\u0003 !Q!\u0011\u0007\u0007C\u0002\u0013\u00051Ia\r\t\u0011\t\u0015C\u0002)A\u0005\u0005kA\u0011Ba\u0012\r\u0001\u0004%\taQ.\t\u0015\t%C\u00021A\u0005\u0002\r\u0013Y\u0005C\u0004\u0003P1\u0001\u000b\u0015\u0002/\t\u0013\tEC\u00021A\u0005\u0002\r[\u0006B\u0003B*\u0019\u0001\u0007I\u0011A\"\u0003V!9!\u0011\f\u0007!B\u0013a\u0006\u0002\u0003B.\u0019\u0011\u00051I!\u0018\t\u000f\t\u001dD\u0002\"\u0011\u0003j!A!Q\u0010\u0007\u0005\u0002\r\u0013y\bC\u0004\u0003\u00122!\tEa%\t\u0011\t%F\u0002\"\u0001D\u0005WCqAa.\r\t\u0003\u0012I\fC\u0004\u0003N2!\tEa4\t\u000f\tEG\u0002\"\u0011\u0003T\"9!q\u001f\u0007\u0005\n\t=\u0007b\u0002B}\u0019\u0011\u0005#1 \u0005\b\u0005{dA\u0011\u0002B\u0000\u0011\u001d\u0019\t\u0001\u0004C!\u0007\u0007Aqa!\u0003\r\t\u0003\u001aY\u0001C\u0004\u0004\u00141!\te!\u0006\t\u000f\ruA\u0002\"\u0003\u0003P\"A1q\u0004\u0007\u0005\u0002\r\u001b\t\u0003C\u0004\u000401!Ia!\r\t\u0011\r=B\u0002\"\u0001D\u0007#Bqaa\f\r\t\u0013\u0019i\u0007C\u0004\u0004\n2!\tea#\u00021Ik'+Z4j_:\fG.T3uC\u0012\fG/Y\"mS\u0016tGO\u0003\u0002E\u000b\u000611/\u001a:wKJT\u0011AR\u0001\u0006W\u000647.Y\u0002\u0001!\tI\u0015!D\u0001D\u0005a\u0011VNU3hS>t\u0017\r\\'fi\u0006$\u0017\r^1DY&,g\u000e^\n\u0004\u00031\u0013\u0006CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%AB!osJ+g\r\u0005\u0002T-6\tAK\u0003\u0002V\u000b\u0006)Q\u000f^5mg&\u0011q\u000b\u0016\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001*\u0001\u0006nCb\u0014V\r\u001e:jKN,\u0012\u0001\u0018\t\u0003\u001bvK!A\u0018(\u0003\u0007%sG/A\u0006nCb\u0014V\r\u001e:jKN\u0004\u0013A\u0006:fiJLxJ\\\"p]:,7\r^5p]\u0016\u0013(o\u001c:\u0016\u0003\t\u0004B!T2fc&\u0011AM\u0014\u0002\n\rVt7\r^5p]F\u0002\"A\u001a8\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u00016H\u0003\u0019a$o\\8u}%\tq*\u0003\u0002n\u001d\u00069\u0001/Y2lC\u001e,\u0017BA8q\u0005%!\u0006N]8xC\ndWM\u0003\u0002n\u001dB\u0011QJ]\u0005\u0003g:\u0013qAQ8pY\u0016\fg.A\fsKR\u0014\u0018p\u00148D_:tWm\u0019;j_:,%O]8sA\u0005AQ\u000e^*lkN+G/F\u0001x!\rAXp`\u0007\u0002s*\u0011!p_\u0001\nS6lW\u000f^1cY\u0016T!\u0001 (\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u007fs\n\u00191+\u001a;\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0017!C7u'.,8+\u001a;!\u0003UI7oQ8o]\u0016\u001cG/[8o\u000bb\u001cW\r\u001d;j_:$2!]A\u000b\u0011\u001d\t9\"\u0003a\u0001\u00033\t\u0011!\u001a\t\u0005\u00037\t\t$\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019\u0019G.[3oi*!\u00111EA\u0013\u0003%\t\u0007/[:feZ,'O\u0003\u0003\u0002(\u0005%\u0012!\u00024mS:\\'\u0002BA\u0016\u0003[\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005=\u0012AA5p\u0013\u0011\t\u0019$!\b\u0003\u0019\u0005\u0003\u0018.\u0012=dKB$\u0018n\u001c8\u0002\t5\f\u0017N\u001c\u000b\u0005\u0003s\ty\u0004E\u0002N\u0003wI1!!\u0010O\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005#\u00021\u0001\u0002D\u0005!\u0011M]4t!\u0015i\u0015QIA%\u0013\r\t9E\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0017\n\u0019F\u0004\u0003\u0002N\u0005=\u0003C\u00015O\u0013\r\t\tFT\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011Q\u000b\u0006\u0004\u0003#r\u0015a\u0001:v]R!\u0011\u0011HA.\u0011\u001d\t\te\u0003a\u0001\u0003\u0007\u001ab\u0001DA0\u0003K\u0012\u0006\u0003BA\u0001\u0003CJA!a\u0019\u0002\u0004\t1qJ\u00196fGR\u00042!SA4\u0013\r\tIg\u0011\u0002\u0017%\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006\u001cE.[3oi\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0019\u0011*a\u001c\n\u0007\u0005E4IA\u0006LC\u001a\\\u0017mQ8oM&<G\u0003BA;\u0003o\u0002\"!\u0013\u0007\t\u000f\u0005-d\u00021\u0001\u0002n\u0005IB.\u0019;fgR\u0014%o\\6fe\u000e{gNZ5h\r>\u0014X\n\u001e7t+\t\ti'A\u000fmCR,7\u000f\u001e\"s_.,'oQ8oM&<gi\u001c:Ni2\u001cx\fJ3r)\u0011\tI$!!\t\u0013\u0005\r\u0005#!AA\u0002\u00055\u0014a\u0001=%c\u0005QB.\u0019;fgR\u0014%o\\6fe\u000e{gNZ5h\r>\u0014X\n\u001e7tA\u00051B.[:uK:,'OU3d_:4\u0017nZ;sC\ndW-\u0006\u0002\u0002\fB)Q*!$\u0002\u0012&\u0019\u0011q\u0012(\u0003\r=\u0003H/[8o!\u0011\t\u0019*a*\u000e\u0005\u0005U%\u0002BAL\u00033\u000bqA\\3uo>\u00148N\u0003\u0003\u0002\u001c\u0006u\u0015AB2p[6|gNC\u0002G\u0003?SA!!)\u0002$\u00061\u0011\r]1dQ\u0016T!!!*\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0006U%A\u0006'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u000251L7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016|F%Z9\u0015\t\u0005e\u0012q\u0016\u0005\n\u0003\u0007\u001b\u0012\u0011!a\u0001\u0003\u0017\u000bq\u0003\\5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u0011\u0002\u0013\u0005\u0004\u0018n\u00117jK:$XCAA\\!\u0011\tY\"!/\n\t\u0005m\u0016Q\u0004\u0002\n\u0003BL7\t\\5f]R\f!\"\u00199j\u00072LWM\u001c;!\u0003-\u0019G.T8eK2\u001c\u0018\t]5\u0016\u0005\u0005\r\u0007\u0003BA\u000e\u0003\u000bLA!a2\u0002\u001e\t)2\t\\;ti\u0016\u0014H.\u001b8l-F\nG\u000e\u001d5b\u0003BL\u0017\u0001D2m\u001b>$W\r\\:Ba&\u0004\u0013aB2pe\u0016\f\u0005/[\u000b\u0003\u0003\u001f\u0004B!a\u0007\u0002R&!\u00111[A\u000f\u0005%\u0019uN]3Wc\u0005\u0003\u0018.\u0001\u0005d_J,\u0017\t]5!\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,WCAAn!\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)/a\u0002\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\fyN\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f1#\u001a=fGV$xN]*feZL7-Z0%KF$B!!\u000f\u0002p\"I\u00111\u0011\u000f\u0002\u0002\u0003\u0007\u00111\\\u0001\u0011Kb,7-\u001e;peN+'O^5dK\u0002\n!#\u001a=q_:,g\u000e^5bY\n\u000b7m[8gMV\u0011\u0011q\u001f\t\u0005\u0003s\fi0\u0004\u0002\u0002|*\u0019Q+!'\n\t\u0005}\u00181 \u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0001\ffqB|g.\u001a8uS\u0006d')Y2l_\u001a4w\fJ3r)\u0011\tID!\u0002\t\u0013\u0005\ru$!AA\u0002\u0005]\u0018aE3ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\u0004\u0013aB<bi\u000eDWM]\u000b\u0003\u0005\u001b\u00012!\u0013B\b\u0013\r\u0011\tb\u0011\u0002\u001a%6\u0014VmZ5p]\u0006dW*\u001a;bI\u0006$\u0018mV1uG\",'/A\u0006xCR\u001c\u0007.\u001a:`I\u0015\fH\u0003BA\u001d\u0005/A\u0011\"a!#\u0003\u0003\u0005\rA!\u0004\u0002\u0011]\fGo\u00195fe\u0002\n!b]:m\r\u0006\u001cGo\u001c:z+\t\u0011y\u0002\u0005\u0003\u0003\"\t-RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u0007M\u001cHN\u0003\u0003\u0003*\u0005e\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\t\t5\"1\u0005\u0002\u000b'Ndg)Y2u_JL\u0018aC:tY\u001a\u000b7\r^8ss\u0002\na\u0002\\6d\u0019>|7.\u001e9DC\u000eDW-\u0006\u0002\u00036AA!q\u0007B\u001d\u0003\u0013\u0012i$\u0004\u0002\u0002d&!!1HAr\u0005\u001dA\u0015m\u001d5NCB\u0004R!TAG\u0005\u007f\u00012!\u0013B!\u0013\r\u0011\u0019e\u0011\u0002\u001d%\u0016<\u0017n\u001c8bY2[7-T3uC\u0012\fG/\u0019'p_.,\boS3z\u0003=a7n\u0019'p_.,\boQ1dQ\u0016\u0004\u0013\u0001\u00057jgR\u001c\u0015\r\u001c7QC\u001e,7+\u001b>f\u0003Qa\u0017n\u001d;DC2d\u0007+Y4f'&TXm\u0018\u0013fcR!\u0011\u0011\bB'\u0011!\t\u0019)KA\u0001\u0002\u0004a\u0016!\u00057jgR\u001c\u0015\r\u001c7QC\u001e,7+\u001b>fA\u0005iA.[:u\u0007\u0006dGnQ8v]R\f\u0011\u0003\\5ti\u000e\u000bG\u000e\\\"pk:$x\fJ3r)\u0011\tIDa\u0016\t\u0011\u0005\rE&!AA\u0002q\u000ba\u0002\\5ti\u000e\u000bG\u000e\\\"pk:$\b%A\bhKRd5n\u0019'p_.,\boS3z)\u0019\u0011iDa\u0018\u0003d!9!\u0011\r\u0018A\u0002\u0005%\u0013!B8sO&#\u0007b\u0002B3]\u0001\u0007\u0011\u0011J\u0001\nG2,8\u000f^3s\u0013\u0012\fabZ3u\u0019.\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003l\te$1\u0010\t\u0007\u0003;\u0014iG!\u001d\n\t\t=\u0014q\u001c\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007#B'\u0002\u000e\nM\u0004cA%\u0003v%\u0019!qO\"\u0003'I+w-[8oC2d5nY'fi\u0006$\u0017\r^1\t\u000f\t\u0005t\u00061\u0001\u0002J!9!QM\u0018A\u0002\u0005%\u0013\u0001E5t\u001bVdG/\u001b+f]\u0006tGoU6v)\r\t(\u0011\u0011\u0005\b\u0005\u0007\u0003\u0004\u0019\u0001BC\u0003\u001da7nY*qK\u000e\u0004BAa\"\u0003\u000e6\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u000bi\"A\u0003n_\u0012,G.\u0003\u0003\u0003\u0010\n%%!K\"mkN$XM\u001d7j].4\u0016'\u00197qQ\u0006dunZ5dC2\\\u0015MZ6b\u00072,8\u000f^3s'B,7-\u0001\nhKRtU\r^<pe.lU\r^1eCR\fG\u0003\u0003BK\u0005?\u0013\tK!*\u0011\r\u0005u'Q\u000eBL!\u0015i\u0015Q\u0012BM!\rI%1T\u0005\u0004\u0005;\u001b%a\u0006*fO&|g.\u00197OKR<xN]6NKR\fG-\u0019;b\u0011\u001d\u0011\t'\ra\u0001\u0003\u0013BqAa)2\u0001\u0004\tI%A\u0003f]ZLE\rC\u0004\u0003(F\u0002\r!!\u0013\u0002\u001d9,Go^8sW&#\u0007+\u0019:b[\u00069\u0012n]\"p]:,7\r^5p]RK\b/\u001a)sSZ\fG/\u001a\u000b\u0004c\n5\u0006b\u0002BXe\u0001\u0007!\u0011W\u0001\u0010G>tg.Z2uS>tG+\u001f9fgB1!q\u0007BZ\u0003\u0013JAA!.\u0002d\n!A*[:u\u0003E9W\r\u001e#bi\u00064En\\<Q_2L7-\u001f\u000b\u0007\u0005w\u0013)M!3\u0011\r\u0005u'Q\u000eB_!\u0015i\u0015Q\u0012B`!\rI%\u0011Y\u0005\u0004\u0005\u0007\u001c%A\u0004#bi\u00064En\\<Q_2L7-\u001f\u0005\b\u0005\u000f\u001c\u0004\u0019AA%\u00039y'oZ1oSj\fG/[8o\u0013\u0012DqAa34\u0001\u0004\tI%A\u0007f]ZL'o\u001c8nK:$\u0018\nZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0003s\t\u0011bY8oM&<WO]3\u0015\t\u0005e\"Q\u001b\u0005\b\u0005/,\u0004\u0019\u0001Bm\u0003\u001d\u0019wN\u001c4jON\u0004DAa7\u0003fBA!q\u0007Bo\u0003\u0013\u0012\t/\u0003\u0003\u0003`\u0006\r(aA'baB!!1\u001dBs\u0019\u0001!ABa:\u0003V\u0006\u0005\t\u0011!B\u0001\u0005S\u00141a\u0018\u00132#\u0011\u0011YO!=\u0011\u00075\u0013i/C\u0002\u0003p:\u0013qAT8uQ&tw\rE\u0002N\u0005gL1A!>O\u0005\r\te._\u0001\u001aC\u0012$G*[:uK:,'OU3d_:4\u0017nZ;sC\ndW-A\u0007tkB\u0004xN\u001d;t/\u0006$8\r\u001b\u000b\u0002c\u0006i\u0011n]'uYN,e.\u00192mK\u0012,\u0012!]\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!!\u000f\u0004\u0006!91qA\u001dA\u0002\u00055\u0014!\u00038fo\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005e2QBB\t\u0011\u001d\u0019yA\u000fa\u0001\u0003[\n\u0011b\u001c7e\u0007>tg-[4\t\u000f\r\u001d!\b1\u0001\u0002n\u0005)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXCAB\f!\u0019\u0019Iba\u0007\u0002J5\t10\u0003\u0002\u007fw\u0006y!/Z2p]\u001aLw-\u001e:f\u001bRd7/\u0001\nhKR\u001c6\u000f\\\"mS\u0016tGoQ8oM&<G\u0003BB\u0012\u0007[\u0001Da!\n\u0004*AA!q\u0007Bo\u0003\u0013\u001a9\u0003\u0005\u0003\u0003d\u000e%BaCB\u0016{\u0005\u0005\t\u0011!B\u0001\u0005S\u00141a\u0018\u00137\u0011\u001d\tY'\u0010a\u0001\u0003[\n\u0001#\u001a=fGV$XmV5uQJ+GO]=\u0016\t\rM2\u0011\b\u000b\u0007\u0007k\u0019id!\u0014\u0011\r\u0005u'QNB\u001c!\u0011\u0011\u0019o!\u000f\u0005\u000f\rmbH1\u0001\u0003j\n\tA\u000bC\u0004\u0004@y\u0002\ra!\u0011\u0002\u0011M,\b\u000f\u001d7jKJ\u0004baa\u0011\u0004J\r]RBAB#\u0015\u0011\u00199%a9\u0002\u0011\u0019,hn\u0019;j_:LAaa\u0013\u0004F\tA1+\u001e9qY&,'\u000f\u0003\u0004\u0004Py\u0002\rAY\u0001\fg\"|W\u000f\u001c3SKR\u0014\u00180\u0006\u0003\u0004T\reCCCB+\u00077\u001ayf!\u0019\u0004dA1\u0011Q\u001cB7\u0007/\u0002BAa9\u0004Z\u0011911H C\u0002\t%\bbBB \u007f\u0001\u00071Q\f\t\u0007\u0007\u0007\u001aIea\u0016\t\r\r=s\b1\u0001c\u0011\u0015Qv\b1\u0001]\u0011\u001d\u0019)g\u0010a\u0001\u0007O\nA!\u001e8jiB!\u0011Q\\B5\u0013\u0011\u0019Y'a8\u0003\u0011QKW.Z+oSR,Baa\u001c\u0004xQq\u0011\u0011HB9\u0007s\u001ayh!!\u0004\u0004\u000e\u0015\u0005bBB \u0001\u0002\u000711\u000f\t\u0007\u0007\u0007\u001aIe!\u001e\u0011\t\t\r8q\u000f\u0003\b\u0007w\u0001%\u0019\u0001Bu\u0011\u001d\u0019Y\b\u0011a\u0001\u0007{\naAZ;ukJ,\u0007CBAo\u0005[\u001a)\b\u0003\u0004\u0004P\u0001\u0003\rA\u0019\u0005\u00065\u0002\u0003\r\u0001\u0018\u0005\b\u0007K\u0002\u0005\u0019AB4\u0011\u0019\u00199\t\u0011a\u00019\u00069\u0011\r\u001e;f[B$\u0018!B<bi\u000eDW\u0003BBG\u0007C#baa$\u0004\u0016\u000e\r\u0006\u0003BA\u0001\u0007#KAaa%\u0002\u0004\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016Dqaa&B\u0001\u0004\u0019I*\u0001\u0007tk\n\u001c8M]5qi&|g\u000eE\u0003J\u00077\u001by*C\u0002\u0004\u001e\u000e\u0013AbU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004BAa9\u0004\"\u0012911H!C\u0002\t%\bbBBE\u0003\u0002\u00071Q\u0015\t\u0006\u0013\u000e\u001d6qT\u0005\u0004\u0007S\u001b%!B,bi\u000eD\u0007")
public final class RmRegionalMetadataClient
implements RegionalMetadataClient,
Logging {
    public final KafkaConfig kafka$server$RmRegionalMetadataClient$$brokerConfig;
    private KafkaConfig latestBrokerConfigForMtls;
    private Option<ListenerReconfigurable> listenerReconfigurable;
    private final ApiClient apiClient;
    private final ClusterlinkV1alphaApi clModelsApi;
    private final CoreV1Api coreApi;
    private ScheduledExecutorService executorService;
    private ExponentialBackoff exponentialBackoff;
    private RmRegionalMetadataWatcher watcher;
    private final SslFactory sslFactory;
    private final HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache;
    private int listCallPageSize;
    private int listCallCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void run(String[] stringArray) {
        RmRegionalMetadataClient$.MODULE$.run(stringArray);
    }

    public static void main(String[] stringArray) {
        RmRegionalMetadataClient$.MODULE$.main(stringArray);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig latestBrokerConfigForMtls() {
        return this.latestBrokerConfigForMtls;
    }

    public void latestBrokerConfigForMtls_$eq(KafkaConfig x$1) {
        this.latestBrokerConfigForMtls = x$1;
    }

    public Option<ListenerReconfigurable> listenerReconfigurable() {
        return this.listenerReconfigurable;
    }

    public void listenerReconfigurable_$eq(Option<ListenerReconfigurable> x$1) {
        this.listenerReconfigurable = x$1;
    }

    private ApiClient apiClient() {
        return this.apiClient;
    }

    public ClusterlinkV1alphaApi clModelsApi() {
        return this.clModelsApi;
    }

    public CoreV1Api coreApi() {
        return this.coreApi;
    }

    private ScheduledExecutorService executorService() {
        return this.executorService;
    }

    private void executorService_$eq(ScheduledExecutorService x$1) {
        this.executorService = x$1;
    }

    public ExponentialBackoff exponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void exponentialBackoff_$eq(ExponentialBackoff x$1) {
        this.exponentialBackoff = x$1;
    }

    public RmRegionalMetadataWatcher watcher() {
        return this.watcher;
    }

    public void watcher_$eq(RmRegionalMetadataWatcher x$1) {
        this.watcher = x$1;
    }

    private SslFactory sslFactory() {
        return this.sslFactory;
    }

    public HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache() {
        return this.lkcLookupCache;
    }

    public int listCallPageSize() {
        return this.listCallPageSize;
    }

    public void listCallPageSize_$eq(int x$1) {
        this.listCallPageSize = x$1;
    }

    public int listCallCount() {
        return this.listCallCount;
    }

    public void listCallCount_$eq(int x$1) {
        this.listCallCount = x$1;
    }

    public Option<RegionalLkcMetadataLookupKey> getLkcLookupKey(String orgId, String clusterId) {
        if (this.lkcLookupCache().containsKey(clusterId)) {
            return this.lkcLookupCache().get(clusterId);
        }
        String string = null;
        int i = 0;
        boolean fetchMore = true;
        while (fetchMore) {
            ClusterlinkV1alphaLogicalKafkaClusterList response = this.clModelsApi().listClusterlinkV1alphaLogicalKafkaClustersForAllEnvironments(orgId, string, null, null, null, Predef$.MODULE$.int2Integer(this.listCallPageSize()));
            this.listCallCount_$eq(this.listCallCount() + 1);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getLkcLookupKey$1(response)));
            }
            response.getItems().forEach(item -> {
                String envId = item.getMetadata().getEnvironment();
                String lkcId = item.getMetadata().getName();
                RegionalLkcMetadataLookupKey lkcKey = new RegionalLkcMetadataLookupKey(orgId, envId);
                this.lkcLookupCache().put(lkcId, (Option<RegionalLkcMetadataLookupKey>)new Some((Object)lkcKey));
            });
            string = response.getMetadata().getContinue();
            if (string == null) {
                fetchMore = false;
            } else if (i > 200) {
                throw new IllegalStateException(new StringBuilder(76).append("More than 100k LKCs found in the org:").append(orgId).append(" or this is a bug, breaking out of loop").toString());
            }
            ++i;
        }
        return this.lkcLookupCache().getOrDefault(clusterId, (Option<RegionalLkcMetadataLookupKey>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Option<RegionalLkcMetadata>> getLkcMetadata(String orgId, String clusterId) {
        void executeWithRetry_executeWithRetry_unit;
        Supplier<Option> metadataSupplier = () -> {
            None$ none$;
            block9: {
                try {
                    if (orgId == null || clusterId == null) {
                        none$ = None$.MODULE$;
                        break block9;
                    }
                    Option<RegionalLkcMetadataLookupKey> lkcKey = this.getLkcLookupKey(orgId, clusterId);
                    if (lkcKey.isEmpty()) {
                        none$ = None$.MODULE$;
                        break block9;
                    }
                    String envId = ((RegionalLkcMetadataLookupKey)lkcKey.get()).environmentId();
                    ClusterlinkV1alphaLogicalKafkaCluster lkcResponse = this.clModelsApi().readClusterlinkV1alphaLogicalKafkaCluster(envId, clusterId, orgId, null);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getLkcMetadata$2(clusterId, lkcResponse)));
                    }
                    ClusterlinkV1alphaLogicalKafkaClusterSpec lkcSpec = lkcResponse.getSpec();
                    return new Some((Object)new RegionalLkcMetadata(this, orgId, envId, lkcSpec){
                        private final /* synthetic */ RmRegionalMetadataClient $outer;
                        private final String orgId$2;
                        private final String envId$1;
                        private final ClusterlinkV1alphaLogicalKafkaClusterSpec lkcSpec$1;

                        public String organizationId() {
                            return this.orgId$2;
                        }

                        public String environmentId() {
                            return this.envId$1;
                        }

                        public String networkId() {
                            return this.lkcSpec$1.getNetworkId();
                        }

                        public String intranetFqdn() {
                            return this.lkcSpec$1.getInternalUrl();
                        }

                        public boolean isMultiTenant() {
                            return this.$outer.isMultiTenantSku(this.lkcSpec$1);
                        }

                        public String toString() {
                            return new StringBuilder(95).append("RegionalLkcMetadata{organizationId=").append(this.organizationId()).append(", environmentId=").append(this.environmentId()).append(", networkId=").append(this.networkId()).append(", intranetFqdn=").append(this.intranetFqdn()).append(", isMultiTenant=").append(this.isMultiTenant()).append("}").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.orgId$2 = orgId$2;
                            this.envId$1 = envId$1;
                            this.lkcSpec$1 = lkcSpec$1;
                        }
                    });
                }
                catch (ApiException e) {
                    switch (e.getCode()) {
                        case 404: {
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getLkcMetadata$3(clusterId, orgId, e)));
                            }
                            return None$.MODULE$;
                        }
                    }
                    throw e;
                }
            }
            return none$;
        };
        Function1<Throwable, Object> executeWithRetry_shouldRetry = RmRegionalMetadataClient$.MODULE$.retryOnConnectionError();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        int executeWithRetry_executeWithRetry_maxRetries = RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries();
        CompletableFuture<Option<RegionalLkcMetadata>> executeWithRetry_executeWithRetry_future = new CompletableFuture<Option<RegionalLkcMetadata>>();
        Runnable executeWithRetry_executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$1(this, metadataSupplier, executeWithRetry_executeWithRetry_future, executeWithRetry_shouldRetry, executeWithRetry_executeWithRetry_maxRetries, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        this.executorService().schedule(executeWithRetry_executeWithRetry_runnable, 0L, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        return executeWithRetry_executeWithRetry_future;
    }

    public boolean isMultiTenantSku(ClusterlinkV1alphaLogicalKafkaClusterSpec lkcSpec) {
        return lkcSpec.getSku() != null && RmRegionalMetadataClient$.MODULE$.mtSkuSet().contains((Object)lkcSpec.getSku().toUpperCase(Locale.ROOT));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Option<RegionalNetworkMetadata>> getNetworkMetadata(String orgId, String envId, String networkIdParam) {
        void executeWithRetry_executeWithRetry_unit;
        Supplier<Option> metadataSupplier = () -> {
            None$ none$;
            try {
                if (orgId != null && envId != null && networkIdParam != null) {
                    ClusterlinkV1alphaSite networkResponse = this.clModelsApi().readClusterlinkV1alphaSite(envId, networkIdParam, orgId, null);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getNetworkMetadata$2(networkIdParam, networkResponse)));
                    }
                    return new Some((Object)new RegionalNetworkMetadata(this, networkIdParam, networkResponse){
                        private final /* synthetic */ RmRegionalMetadataClient $outer;
                        private final String networkIdParam$1;
                        private final ClusterlinkV1alphaSite networkResponse$1;

                        public String networkId() {
                            return this.networkIdParam$1;
                        }

                        public boolean isPrivate() {
                            List connectionTypes = this.networkResponse$1.getSpec().getConnectionTypes();
                            return this.$outer.isConnectionTypePrivate(connectionTypes);
                        }

                        public String toString() {
                            return new StringBuilder(65).append("RegionalNetworkMetadata{networkId=").append(this.networkIdParam$1).append(", isPrivate=").append(this.isPrivate()).append("}, connectionTypes=").append(this.networkResponse$1.getSpec().getConnectionTypes()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.networkIdParam$1 = networkIdParam$1;
                            this.networkResponse$1 = networkResponse$1;
                        }
                    });
                }
                none$ = None$.MODULE$;
            }
            catch (ApiException e) {
                switch (e.getCode()) {
                    case 404: {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getNetworkMetadata$3(networkIdParam, orgId, envId, e)));
                        }
                        return None$.MODULE$;
                    }
                }
                throw e;
            }
            return none$;
        };
        Function1<Throwable, Object> executeWithRetry_shouldRetry = RmRegionalMetadataClient$.MODULE$.retryOnConnectionError();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        int executeWithRetry_executeWithRetry_maxRetries = RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries();
        CompletableFuture<Option<RegionalNetworkMetadata>> executeWithRetry_executeWithRetry_future = new CompletableFuture<Option<RegionalNetworkMetadata>>();
        Runnable executeWithRetry_executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$1(this, metadataSupplier, executeWithRetry_executeWithRetry_future, executeWithRetry_shouldRetry, executeWithRetry_executeWithRetry_maxRetries, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        this.executorService().schedule(executeWithRetry_executeWithRetry_runnable, 0L, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        return executeWithRetry_executeWithRetry_future;
    }

    public boolean isConnectionTypePrivate(List<String> connectionTypes) {
        return connectionTypes != null && !connectionTypes.isEmpty() && !connectionTypes.contains("PUBLIC");
    }

    @Override
    public CompletableFuture<Option<DataFlowPolicy>> getDataFlowPolicy(String organizationId, String environmentId) {
        return CompletableFuture.completedFuture(None$.MODULE$);
    }

    @Override
    public void close() {
        OkHttpClient okClient;
        this.listenerReconfigurable().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.kafka$server$RmRegionalMetadataClient$$brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        if (this.executorService() != null) {
            this.executorService().shutdownNow();
            this.executorService_$eq(null);
        }
        if ((okClient = this.apiClient().getHttpClient()) != null) {
            okClient.dispatcher().executorService().shutdownNow();
            okClient.connectionPool().evictAll();
        }
        if (this.watcher() != null) {
            this.watcher().close();
            this.watcher_$eq(null);
        }
        this.sslFactory().close();
    }

    public void configure(Map<String, ?> configs) {
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl() == null) {
            throw new ConfigException("confluent.regional.resource.manager.endpoint", null, "Endpoint URL is not configured");
        }
        this.addListenerReconfigurable();
        String endpointUrl = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl();
        this.apiClient().setBasePath(endpointUrl);
        Integer numSchedulerThreads = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerClientSchedulerThreads();
        this.executorService_$eq(Executors.newScheduledThreadPool(Predef$.MODULE$.Integer2int(numSchedulerThreads), ThreadUtils.createThreadFactory((String)"rm-regional-metadata-client-thread-%d", (boolean)false)));
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl() != null) {
            this.watcher_$eq(new RmRegionalMetadataWatcher());
        }
        if (this.isMtlsEnabled()) {
            this.sslFactory().configure(this.getSslClientConfig(this.latestBrokerConfigForMtls()));
            this.reconfigureMtls();
            return;
        }
        if (this.watcher() != null) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl()).defaultLoadBalancingPolicy("round_robin").usePlaintext().build();
            this.watcher().configure(channel);
            return;
        }
    }

    private void addListenerReconfigurable() {
        ListenerName listenerToWatchForReconfiguration = ListenerName.normalised((String)new MtlsWithServerCertConfigs(this.kafka$server$RmRegionalMetadataClient$$brokerConfig).mtListenerToWatchForReconfiguration());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$addListenerReconfigurable$1(listenerToWatchForReconfiguration)));
        }
        this.listenerReconfigurable_$eq((Option<ListenerReconfigurable>)new Some((Object)new ListenerReconfigurable(this, listenerToWatchForReconfiguration){
            private final /* synthetic */ RmRegionalMetadataClient $outer;
            private final ListenerName listenerToWatchForReconfiguration$1;

            public ListenerName listenerName() {
                return this.listenerToWatchForReconfiguration$1;
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return SslConfigs.RECONFIGURABLE_CONFIGS;
            }

            public void validateReconfiguration(Map<String, ?> configs) {
            }

            public void reconfigure(Map<String, ?> configs) {
                this.$outer.reconfigure(this.$outer.kafka$server$RmRegionalMetadataClient$$brokerConfig, this.$outer.latestBrokerConfigForMtls());
            }

            public void configure(Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listenerToWatchForReconfiguration$1 = listenerToWatchForReconfiguration$1;
            }
        }));
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig.addReconfigurable((Reconfigurable)this.listenerReconfigurable().get());
    }

    @Override
    public boolean supportsWatch() {
        return this.watcher() != null;
    }

    private boolean isMtlsEnabled() {
        return this.apiClient().getBasePath().toLowerCase(Locale.ROOT).contains("https");
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (this.isMtlsEnabled()) {
            this.sslFactory().validateReconfiguration(this.getSslClientConfig(newConfig));
            return;
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.latestBrokerConfigForMtls_$eq(newConfig);
        if (this.isMtlsEnabled()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$reconfigure$1()));
            }
            this.sslFactory().reconfigure(this.getSslClientConfig(this.latestBrokerConfigForMtls()));
            this.reconfigureMtls();
            return;
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return (Set)CollectionConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
    }

    private void reconfigureMtls() {
        DefaultSslEngineFactory defaultSslEngineFactory = DefaultSslEngineFactory.castOrThrow((SslEngineFactory)this.sslFactory().sslEngineFactory());
        SSLSocketFactory sslSocketFactory = defaultSslEngineFactory.sslContext().getSocketFactory();
        KeyManager[] keyManagers = DefaultSslEngineFactory.keyManagers((SslEngineFactory)defaultSslEngineFactory);
        TrustManager[] trustManagers = DefaultSslEngineFactory.trustManagers((SslEngineFactory)defaultSslEngineFactory);
        Option trustManager = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManagers)).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RmRegionalMetadataClient.$anonfun$reconfigureMtls$1(p)));
        if (trustManager.isEmpty()) {
            throw new IllegalStateException("Unexpected trust managers, expected to find a X509TrustManager, but saw none");
        }
        OkHttpClient httpClient = this.apiClient().getHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager.get()).build();
        this.apiClient().setHttpClient(httpClient);
        if (this.watcher() != null) {
            ChannelCredentials creds = TlsChannelCredentials.newBuilder().keyManager(keyManagers).trustManager(trustManagers).build();
            String watchEndpointUrl = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl();
            ManagedChannel managedChannel = Grpc.newChannelBuilderForAddress((String)Utils.getHost((String)watchEndpointUrl), (int)Predef$.MODULE$.Integer2int(Utils.getPort((String)watchEndpointUrl)), (ChannelCredentials)creds).defaultLoadBalancingPolicy("round_robin").build();
            this.watcher().configure(managedChannel);
            return;
        }
    }

    public Map<String, ?> getSslClientConfig(KafkaConfig brokerConfig) {
        MtlsWithServerCertConfigs mtlsWithServerCertConfigs = new MtlsWithServerCertConfigs(brokerConfig);
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        Map<String, Object> mtlsConfigs = mtlsWithServerCertConfigs.mtlsConfigOverrides();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$getSslClientConfig$1(mtlsConfigs)));
        }
        return new AbstractConfig(sslConfigDef, mtlsConfigs).values();
    }

    /*
     * WARNING - void declaration
     */
    private <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry) {
        void executeWithRetry_unit;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        int executeWithRetry_maxRetries = RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries();
        CompletableFuture executeWithRetry_future = new CompletableFuture();
        Runnable executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$1(this, supplier, executeWithRetry_future, shouldRetry, executeWithRetry_maxRetries, (TimeUnit)executeWithRetry_unit);
        this.executorService().schedule(executeWithRetry_runnable, 0L, (TimeUnit)executeWithRetry_unit);
        return executeWithRetry_future;
    }

    public <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = () -> {
            int executeWithRetry_attempt = 1;
            try {
                Object executeWithRetry_result = supplier.get();
                future.complete(executeWithRetry_result);
                return;
            }
            catch (Throwable executeWithRetry_e) {
                if (BoxesRunTime.unboxToBoolean((Object)shouldRetry.apply((Object)executeWithRetry_e)) && executeWithRetry_attempt < maxRetries) {
                    long executeWithRetry_backoffDelay = this.exponentialBackoff().backoff((long)executeWithRetry_attempt);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$2(executeWithRetry_attempt, executeWithRetry_backoffDelay)), executeWithRetry_e);
                    }
                    Runnable executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$4(this, (Supplier)supplier, future, shouldRetry, maxRetries, unit, executeWithRetry_attempt);
                    this.executorService().schedule(executeWithRetry_runnable, executeWithRetry_backoffDelay, unit);
                    return;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$5()), executeWithRetry_e);
                }
                future.completeExceptionally(executeWithRetry_e);
                return;
            }
        };
        this.executorService().schedule(runnable, 0L, unit);
        return future;
    }

    private <T> void executeWithRetry(Supplier<T> supplier, CompletableFuture<T> future, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit, int attempt) {
        try {
            T result = supplier.get();
            future.complete(result);
            return;
        }
        catch (Throwable e) {
            if (BoxesRunTime.unboxToBoolean((Object)shouldRetry.apply((Object)e)) && attempt < maxRetries) {
                long backoffDelay = this.exponentialBackoff().backoff((long)attempt);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$2(attempt, backoffDelay)), e);
                }
                Runnable runnable = () -> {
                    int executeWithRetry_attempt = attempt + 1;
                    try {
                        Object executeWithRetry_result = supplier.get();
                        future.complete(executeWithRetry_result);
                        return;
                    }
                    catch (Throwable executeWithRetry_e) {
                        if (BoxesRunTime.unboxToBoolean((Object)shouldRetry.apply((Object)executeWithRetry_e)) && executeWithRetry_attempt < maxRetries) {
                            long executeWithRetry_backoffDelay = this.exponentialBackoff().backoff((long)executeWithRetry_attempt);
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$2(executeWithRetry_attempt, executeWithRetry_backoffDelay)), executeWithRetry_e);
                            }
                            Runnable executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$4(this, (Supplier)supplier, future, shouldRetry, maxRetries, unit, executeWithRetry_attempt);
                            this.executorService().schedule(executeWithRetry_runnable, executeWithRetry_backoffDelay, unit);
                            return;
                        }
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$5()), executeWithRetry_e);
                        }
                        future.completeExceptionally(executeWithRetry_e);
                        return;
                    }
                };
                this.executorService().schedule(runnable, backoffDelay, unit);
                return;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(RmRegionalMetadataClient.$anonfun$executeWithRetry$5()), e);
            }
            future.completeExceptionally(e);
            return;
        }
    }

    @Override
    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        if (this.watcher() == null) {
            throw new IllegalStateException(new StringBuilder(113).append("Watcher is not configured, please configure '").append("confluent.regional.resource.manager.watch.endpoint").append("' before using it.").toString());
        }
        return this.watcher().watch(subscription, watch);
    }

    public static final /* synthetic */ String $anonfun$getLkcLookupKey$1(ClusterlinkV1alphaLogicalKafkaClusterList response$1) {
        return new StringBuilder(19).append("Got list response: ").append(response$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getLkcMetadata$2(String clusterId$1, ClusterlinkV1alphaLogicalKafkaCluster lkcResponse$1) {
        return new StringBuilder(23).append("For ").append(clusterId$1).append(" got LKC response: ").append(lkcResponse$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getLkcMetadata$3(String clusterId$1, String orgId$2, ApiException e$1) {
        return new StringBuilder(43).append("Cluster ").append(clusterId$1).append(" not found in org ").append(orgId$2).append(" , apiException: ").append((Object)e$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getNetworkMetadata$2(String networkIdParam$1, ClusterlinkV1alphaSite networkResponse$1) {
        return new StringBuilder(27).append("For ").append(networkIdParam$1).append(" got network response: ").append(networkResponse$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getNetworkMetadata$3(String networkIdParam$1, String orgId$3, String envId$2, ApiException e$2) {
        return new StringBuilder(49).append("Network ").append(networkIdParam$1).append(" not found in org ").append(orgId$3).append(", env ").append(envId$2).append(" , apiException: ").append((Object)e$2).toString();
    }

    public static final /* synthetic */ String $anonfun$addListenerReconfigurable$1(ListenerName listenerToWatchForReconfiguration$1) {
        return new StringBuilder(39).append("Listener to watch for reconfiguration: ").append(listenerToWatchForReconfiguration$1).toString();
    }

    public static final /* synthetic */ String $anonfun$reconfigure$1() {
        return "Reconfiguring SSL for Regional Metadata Client";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureMtls$1(TrustManager p) {
        return p instanceof X509TrustManager;
    }

    public static final /* synthetic */ String $anonfun$getSslClientConfig$1(Map mtlsConfigs$1) {
        return new StringBuilder(13).append("mtlsConfigs= ").append(mtlsConfigs$1).toString();
    }

    public static final /* synthetic */ String $anonfun$executeWithRetry$2(int attempt$1, long backoffDelay$1) {
        return new StringBuilder(48).append("Failed to execute task, retrying attempt:").append(attempt$1).append(" in ").append(backoffDelay$1).append(" ms").toString();
    }

    public static final /* synthetic */ String $anonfun$executeWithRetry$5() {
        return "Failed to execute task";
    }

    public RmRegionalMetadataClient(KafkaConfig brokerConfig) {
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig = brokerConfig;
        Logging.$init$(this);
        this.latestBrokerConfigForMtls = brokerConfig;
        this.apiClient = new ApiClient();
        this.clModelsApi = new ClusterlinkV1alphaApi(this.apiClient());
        this.coreApi = new CoreV1Api(this.apiClient());
        this.exponentialBackoff = new ExponentialBackoff(250L, 2, 5000L, 0.2);
        this.sslFactory = new SslFactory(ConnectionMode.CLIENT);
        this.lkcLookupCache = new HashMap();
        this.listCallPageSize = 500;
        this.listCallCount = 0;
    }
}

