/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u00181\u0001]B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"I!\f\u0001B\u0001B\u0003%1L\u0018\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!9\bA!A!\u0002\u0013A\bB\u0003@\u0001\u0005\u0003\u0005\u000b\u0011B@\u0002\f!a\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0004\u0002\u0018!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0007\t\u0019\u0005\u0005\u0002A!A!\u0002\u0013\tY\"a\t\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\tY\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005%\u0003\u0002CA,\u0001\u0001\u0006I!a\u0013\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\"CA2\u0001\u0001\u0007I\u0011BA3\u0011!\tY\u0007\u0001Q!\n\u0005u\u0003\"CA7\u0001\u0001\u0007I\u0011BA.\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\t\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0015BA/\u0011-\t9\b\u0001a\u0001\u0002\u0004%I!!\u001f\t\u0017\u0005M\u0005\u00011AA\u0002\u0013%\u0011Q\u0013\u0005\f\u00033\u0003\u0001\u0019!A!B\u0013\tY\bC\u0004\u0002\u001c\u0002!\t&!(\t\u000f\u0005M\u0006\u0001\"\u0003\u0002\u001e\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA[\u0001\u0011%\u00111\u0019\u0005\b\u0003\u001f\u0004A\u0011BAO\u0011\u001d\t\t\u000e\u0001C\u0005\u0003;Cq!a5\u0001\t\u0013\t)\u000eC\u0004\u0002\\\u0002!I!!8\t\u000f\t\u0015\u0001\u0001\"\u0003\u0002\u001e\"9!q\u0001\u0001\u0005\n\u0005u\u0005b\u0002B\u0004\u0001\u0011E#\u0011\u0002\u0005\b\u0005+\u0001A\u0011AA.\u0011\u001d\u00119\u0002\u0001C!\u000539qAa\t1\u0011\u0003\u0011)C\u0002\u00040a!\u0005!q\u0005\u0005\b\u0003S9C\u0011\u0001B\u001d\u0011!\u0011Yd\nC\u0001a\tu\u0002\u0002\u0003B#O\u0011\u0005\u0001Ga\u0012\t\u0011\t-s\u0005\"\u00011\u0005\u001bB\u0011Ba\u0016(#\u0003%\tA!\u0017\t\u0013\t=t%%A\u0005\u0002\te\u0003\"\u0003B9OE\u0005I\u0011\u0001B-\u0005u\u0019E.^:uKJd\u0015N\\6DY\u0016\f'\u000fT5oWJ+g-\u001a:f]\u000e,'BA\u00193\u0003\u0011a\u0017N\\6\u000b\u0005M\"\u0014AB:feZ,'OC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005ejdB\u0001\u001e<\u001b\u0005\u0001\u0014B\u0001\u001f1\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011ah\u0010\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003yA\na\u0001\\5oW&#\u0007C\u0001\"K\u001b\u0005\u0019%B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011QG\u0012\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0007\n!Q+^5e\u0003!a\u0017N\\6OC6,\u0007C\u0001(X\u001d\tyU\u000b\u0005\u0002Q'6\t\u0011K\u0003\u0002Sm\u00051AH]8pizR\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u000ba\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011akU\u0001\ng\u000eDW\rZ;mKJ\u0004\"A\u000f/\n\u0005u\u0003$\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002[{\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002;C&\u0011!\r\r\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u000bCV$\bn\u001c:ju\u0016\u0014\bcA3gQ6\t1+\u0003\u0002h'\n1q\n\u001d;j_:\u0004\"!\u001b7\u000e\u0003)T!aY6\u000b\u0005M*\u0015BA7k\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000bY>\u001c\u0017\r\\!e[&t\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0015\tG-\\5o\u0015\t!X)A\u0004dY&,g\u000e^:\n\u0005Y\f(AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0013G>l\u0007\u000f\\3uS>t7)\u00197mE\u0006\u001c7\u000eE\u0002fsnL!A_*\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA3}\u0013\ti8K\u0001\u0003V]&$\u0018\u0001\u0002;j[\u0016\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0019\u0015!B;uS2\u001c\u0018\u0002BA\u0005\u0003\u0007\u0011A\u0001V5nK&\u0011a0P\u0001\u0006cV|G/\u0019\t\u0005\u0003#\t\u0019\"D\u00013\u0013\r\t)B\r\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006L1!!\u0004>\u00039!x\u000e]5d\u000fJ|W\u000f]*ju\u0016\u00042!ZA\u000f\u0013\r\tyb\u0015\u0002\u0004\u0013:$\u0018AC5oi\u0016\u0014h/\u00197Ng&\u0019\u0011QE\u001f\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0007sKR\u0014\u0018\u0010R3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\u001b\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013Q\t\t\u0003u\u0001AQ\u0001Q\u0007A\u0002\u0005CQ\u0001T\u0007A\u00025CQAW\u0007A\u0002mCQaX\u0007A\u0002\u0001DQaY\u0007A\u0002\u0011DQA\\\u0007A\u0002=DQa^\u0007A\u0002aDQA`\u0007A\u0002}Dq!!\u0004\u000e\u0001\u0004\ty\u0001C\u0005\u0002\u001a5\u0001\n\u00111\u0001\u0002\u001c!I\u0011\u0011E\u0007\u0011\u0002\u0003\u0007\u00111\u0004\u0005\n\u0003Oi\u0001\u0013!a\u0001\u00037\t!\u0002\\5oW\u001aKG\u000e^3s+\t\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfQ\u0001\u0004C\u000ed\u0017\u0002BA+\u0003\u001f\u0012\u0001$Q2dKN\u001c8i\u001c8ue>dWI\u001c;ss\u001aKG\u000e^3s\u0003-a\u0017N\\6GS2$XM\u001d\u0011\u0002\u0017U\u0004H-\u0019;fI\u0006\u001bGn]\u000b\u0003\u0003;\u00022!ZA0\u0013\r\t\tg\u0015\u0002\b\u0005>|G.Z1o\u0003=)\b\u000fZ1uK\u0012\f5\r\\:`I\u0015\fHcA>\u0002h!I\u0011\u0011N\t\u0002\u0002\u0003\u0007\u0011QL\u0001\u0004q\u0012\n\u0014\u0001D;qI\u0006$X\rZ!dYN\u0004\u0013!D;qI\u0006$X\r\u001a+pa&\u001c7/A\tva\u0012\fG/\u001a3U_BL7m]0%KF$2a_A:\u0011%\tI\u0007FA\u0001\u0002\u0004\ti&\u0001\bva\u0012\fG/\u001a3U_BL7m\u001d\u0011\u0002\u0017Q|\u0007/[2He>,\bo]\u000b\u0003\u0003w\u0002b!! \u0002\b\u00065e\u0002BA@\u0003\u0007s1\u0001UAA\u0013\u0005!\u0016bAAC'\u00069\u0001/Y2lC\u001e,\u0017\u0002BAE\u0003\u0017\u0013A\u0001T5ti*\u0019\u0011QQ*\u0011\t9\u000by)T\u0005\u0004\u0003#K&aA*fi\u0006yAo\u001c9jG\u001e\u0013x.\u001e9t?\u0012*\u0017\u000fF\u0002|\u0003/C\u0011\"!\u001b\u0018\u0003\u0003\u0005\r!a\u001f\u0002\u0019Q|\u0007/[2He>,\bo\u001d\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002 B!\u0011\u0011UAX\u001d\r\t\u0019k\u000f\b\u0005\u0003K\u000biK\u0004\u0003\u0002(\u0006-fb\u0001)\u0002*&\tQ'\u0003\u00024i%\u0011\u0011GM\u0005\u0004\u0003c{$A\u0003+bg.\u0014Vm];mi\u0006Y\u0001O]8dKN\u001c\u0018i\u00197t\u0003U\u0019G.Z1s\u0019&t7.Q2mg\u000e{W\u000e\u001d7fi\u0016$B!a(\u0002:\"9\u00111X\u000eA\u0002\u0005u\u0016\u0001E2sK\u0006$X-Q2mgJ+7/\u001e7u!\r\u0001\u0018qX\u0005\u0004\u0003\u0003\f(\u0001E\"sK\u0006$X-Q2mgJ+7/\u001e7u)\u0011\ty*!2\t\u000f\u0005\u001dG\u00041\u0001\u0002J\u0006\u0001B-\u001a7fi\u0016\f5\r\\:SKN,H\u000e\u001e\t\u0004a\u0006-\u0017bAAgc\n\u0001B)\u001a7fi\u0016\f5\r\\:SKN,H\u000e^\u0001\u000eaJ|7-Z:t)>\u0004\u0018nY:\u0002#A\u0014xnY3tgR{\u0007/[2t\u001f:\u001cW-A\tdY\u0016\f'/T5se>\u0014Hk\u001c9jGN$B!a(\u0002X\"9\u0011\u0011\\\u0010A\u0002\u00055\u0015A\u0002;pa&\u001c7/A\rdY\u0016\f'/T5se>\u0014Hk\u001c9jGN\u001cu.\u001c9mKR,G\u0003BAP\u0003?Dq!!9!\u0001\u0004\t\u0019/A\u0004sKN,H\u000e^:\u0011\u000f\u0005\u0015\u0018q^'\u0002t6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/\u0001\u0003vi&d'BAAw\u0003\u0011Q\u0017M^1\n\t\u0005E\u0018q\u001d\u0002\u0004\u001b\u0006\u0004\b#\u0002\"\u0002v\u0006e\u0018bAA|\u0007\nY1*\u00194lC\u001a+H/\u001e:f!\u0011\tYP!\u0001\u000e\u0005\u0005u(\u0002BA\u0000\u0003W\fA\u0001\\1oO&!!1AA\u007f\u0005\u00111v.\u001b3\u00023\u0011,G.\u001a;f\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y\u0001\r_:\u001cu.\u001c9mKRLwN\u001c\u000b\u0004w\n-\u0001b\u0002B\u0007G\u0001\u0007!qB\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007e\u0012\t\"C\u0002\u0003\u0014}\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fabZ3u+B$\u0017\r^3e\u0003\u000ed7/A\buCN\\G)Z:de&\u0004H/[8o)\t\u0011Y\u0002\u0005\u0003fM\nu\u0001c\u0001\u001e\u0003 %\u0019!\u0011\u0005\u0019\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQd\u00117vgR,'\u000fT5oW\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\t\u0003u\u001d\u001aRa\nB\u0015\u0005_\u00012!\u001aB\u0016\u0013\r\u0011ic\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\t\tE\"QG\u0007\u0003\u0005gQ1!!\u00025\u0013\u0011\u00119Da\r\u0003\u000f1{wmZ5oOR\u0011!QE\u0001\u0019g\"|W\u000f\u001c3DY\u0016\f'\u000fT5oWJ+g-\u001a:f]\u000e,GCBA/\u0005\u007f\u0011\t\u0005C\u0003AS\u0001\u0007\u0011\t\u0003\u0004\u0003D%\u0002\r\u0001Y\u0001\b[\u0006t\u0017mZ3s\u0003YA\u0017M\u001c3mK\u0012+G.\u001a;f\u0003\u000ed7OU3tk2$H\u0003BA/\u0005\u0013Bq!a2+\u0001\u0004\tI-\u0001\fiC:$G.Z\"sK\u0006$X-Q2mgJ+7/\u001e7u)\u0011\u0011yE!\u0016\u0011\u000f\u0015\u0014\t&!\u0018\u0002\u001c%\u0019!1K*\u0003\rQ+\b\u000f\\33\u0011\u001d\tYl\u000ba\u0001\u0003{\u000bA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0003\\)\"\u00111\u0004B/W\t\u0011y\u0006\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B5'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5$1\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'M\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00193\u0001")
public class ClusterLinkClearLinkReference
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final ClusterLinkMetadataManager metadataManager;
    private final Option<Authorizer> authorizer;
    private final ConfluentAdmin localAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int topicGroupSize;
    private final int retryDelayMs;
    private final AccessControlEntryFilter linkFilter;
    private boolean updatedAcls;
    private boolean updatedTopics;
    private List<Set<String>> topicGroups;

    public static int $lessinit$greater$default$12() {
        return ClusterLinkClearLinkReference$.MODULE$.$lessinit$greater$default$12();
    }

    public static int $lessinit$greater$default$11() {
        return ClusterLinkClearLinkReference$.MODULE$.$lessinit$greater$default$11();
    }

    public static int $lessinit$greater$default$10() {
        return ClusterLinkClearLinkReference$.MODULE$.$lessinit$greater$default$10();
    }

    private AccessControlEntryFilter linkFilter() {
        return this.linkFilter;
    }

    private boolean updatedAcls() {
        return this.updatedAcls;
    }

    private void updatedAcls_$eq(boolean x$1) {
        this.updatedAcls = x$1;
    }

    private boolean updatedTopics() {
        return this.updatedTopics;
    }

    private void updatedTopics_$eq(boolean x$1) {
        this.updatedTopics = x$1;
    }

    private List<Set<String>> topicGroups() {
        return this.topicGroups;
    }

    private void topicGroups_$eq(List<Set<String>> x$1) {
        this.topicGroups = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId, this.metadataManager)) {
            return this.onCompletion();
        }
        if (!this.updatedAcls() && this.authorizer.nonEmpty()) {
            return this.processAcls();
        }
        if (!this.updatedTopics()) {
            return this.processTopics();
        }
        ClusterLinkMetadataManager clusterLinkMetadataManager = this.metadataManager;
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithZkSupport) {
            return this.deleteClusterLinkMetadata();
        }
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            return this.onCompletion();
        }
        if (clusterLinkMetadataManager != null) {
            throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
        }
        throw new MatchError(null);
    }

    private ClusterLinkScheduler.TaskResult processAcls() {
        this.authorizer.foreach((Function1 & Serializable & scala.Serializable)authz -> {
            Iterable linkAcls = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authz.acls(new AclBindingFilter(ResourcePatternFilter.ANY, this.linkFilter()))).asScala();
            Iterable aclsToAdd = (Iterable)linkAcls.filterNot((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processAcls$2(acl)));
            if (linkAcls.isEmpty()) {
                this.updatedAcls_$eq(true);
                return this.processTopics();
            }
            if (aclsToAdd.nonEmpty()) {
                java.util.List localAcls = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)aclsToAdd.map((Function1 & Serializable & scala.Serializable)acl -> {
                    AccessControlEntry ace = new AccessControlEntry(acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
                    return new AclBinding(acl.pattern(), ace);
                }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
                CreateAclsResult createAclResult = $this.localAdmin.createAcls((Collection)localAcls);
                Iterable createAclsFuture = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclResult.values()).asScala()).values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsFuture.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$1 -> this.clearLinkAclsComplete(createAclResult), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
                return BoxedUnit.UNIT;
            }
            java.util.List aclsToRemove = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)linkAcls.map((Function1 & Serializable & scala.Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, (Collection)this.linkFilter().clusterLinkIds()).toFilter(), Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
            DeleteAclsResult deleteAclsResult = $this.localAdmin.deleteAcls((Collection)aclsToRemove);
            Iterable deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).values();
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$2 -> this.clearLinkAclsComplete(deleteAclsResult), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        if (this.updatedAcls()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
        }
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(CreateAclsResult createAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult)._1$mcZ$sp();
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$3 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), success ? 0L : (long)this.retryDelayMs);
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(DeleteAclsResult deleteAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult);
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$4 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), success ? 0L : (long)this.retryDelayMs);
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult processTopics() {
        Set<String> topicSet = this.metadataManager.getAllTopicsInCluster();
        this.topicGroups_$eq((List<Set<String>>)topicSet.grouped(this.topicGroupSize).toList());
        Map<String, ClusterLinkTopicState> mirrorTopics = this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkId);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Processing ").append(mirrorTopics.size()).append(" topics for mirror topic state removal for cluster link id ").append($this.linkId).toString());
        return this.processTopicsOnce();
    }

    private ClusterLinkScheduler.TaskResult processTopicsOnce() {
        if (this.topicGroups().isEmpty()) {
            this.updatedTopics_$eq(true);
            return this.deleteClusterLinkMetadata();
        }
        Map mirrorTopics = (Map)this.metadataManager.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)this.topicGroups().head())).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processTopicsOnce$1(this, entry)));
        if (mirrorTopics.nonEmpty()) {
            return this.clearMirrorTopics((Set<String>)mirrorTopics.keys().toSet());
        }
        this.topicGroups_$eq((List<Set<String>>)this.topicGroups().drop(1));
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$5 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), this.scheduleOnce$default$2());
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult clearMirrorTopics(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Clearing mirror topics for topics '").append(topics).append("' for cluster link id ").append($this.linkId).toString());
        try {
            scala.collection.immutable.Map ops = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.CLEAR), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = this.localAdmin.alterMirrors((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$6 -> this.clearMirrorTopicsComplete(result.values()), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Encountered error while clearing mirror topics. Will try again in ").append($this.retryDelayMs).append(" ms").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$7 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), this.retryDelayMs);
        }
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult clearMirrorTopicsComplete(java.util.Map<String, KafkaFuture<Void>> results) {
        if (((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(results).asScala()).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$clearMirrorTopicsComplete$1(this, x0$1)))) {
            this.topicGroups_$eq((List<Set<String>>)this.topicGroups().drop(1));
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$8 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), this.scheduleOnce$default$2());
        } else {
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$9 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)), this.retryDelayMs);
        }
        return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult deleteClusterLinkMetadata() {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            if (this.metadataManager.isLinkCoordinatorEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Deleting the metadata for link ").append($this.linkName).toString());
                DeleteClusterLinksResult result = this.localAdmin.deleteClusterLinks(Collections.singletonList(this.linkName), new DeleteClusterLinksOptions().deleteMetadata(true));
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)x$10 -> {
                    try {
                        result.all().get();
                        return this.onCompletion();
                    }
                    catch (Throwable ex) {
                        throw this.handleException$1(ex);
                    }
                }, new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
                return ClusterLinkScheduler$.MODULE$.inProgressTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
            }
            taskResult = this.onCompletion();
        }
        catch (Throwable ex) {
            throw this.handleException$1(ex);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearLinkReferenceCompleted", () -> $this.completionCallback.apply$mcV$sp());
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
    }

    public boolean getUpdatedAcls() {
        return this.updatedAcls();
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$processAcls$2(AclBinding acl) {
        return acl.entry().clusterLinkIds().contains(Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsOnce$1(ClusterLinkClearLinkReference $this, Tuple2 entry) {
        Uuid uuid = ((ClusterLinkTopicState)entry._2()).linkId();
        Uuid uuid2 = $this.linkId;
        return !(uuid != null ? !uuid.equals(uuid2) : uuid2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$clearMirrorTopicsComplete$1(ClusterLinkClearLinkReference $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Encountered UnknownTopicOrPartitionException while clearing mirror topic '").append(topic).append("'.").append(" Mirror topic may not exist").toString());
                    return true;
                }
                if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    return false;
                }
                throw new MatchError(null);
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return false;
            }
        }
        throw new MatchError(null);
    }

    private final Nothing$ handleException$1(Throwable ex) {
        ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(43).append("Failed to remove metadata for deleted link ").append(this.linkName).toString());
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to remove metadata for deleted link", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        throw e;
    }

    public ClusterLinkClearLinkReference(Uuid linkId, String linkName, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Option<Authorizer> authorizer, ConfluentAdmin localAdmin, Function0<BoxedUnit> completionCallback, Time time, ClusterLinkRequestQuota quota, int topicGroupSize, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.metadataManager = metadataManager;
        this.authorizer = authorizer;
        this.localAdmin = localAdmin;
        this.completionCallback = completionCallback;
        this.topicGroupSize = topicGroupSize;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearLinkReference", intervalMs, time, quota);
        this.linkFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(linkId));
        this.updatedAcls = false;
        this.updatedTopics = false;
    }
}

