/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.FetchResponseSize;
import kafka.utils.Logging;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0014)\u0001=B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")Q\t\u0001C\u0001\r\"A1\n\u0001b\u0001\n\u0003AC\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\u000b#\u0002\u0001\n\u0011aA!\u0002\u0013\u0011\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007E\u0002\u0001\u000b\u0011B+\t\u000f\r\u0004!\u0019!C\u0005C\"1A\r\u0001Q\u0001\nUC\u0001\"\u001a\u0001C\u0002\u0013\u0005\u0001F\u001a\u0005\u0007g\u0002\u0001\u000b\u0011B4\t\u000fQ\u0004!\u0019!C\u0005k\"9\u0011q\b\u0001!\u0002\u00131\bbBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002f\u0001!\t!!\u000e\t\u0011\u0005\u001d\u0004\u0001\"\u0001)\u0003SB\u0001\"!\u001d\u0001\t\u0003A\u0013\u0011\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!! \u0001\t\u0013\t)\u0004C\u0004\u0002\u0000\u0001!\t!!\u000e\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011q\u0011\u0001\u0005\n\u0005%e\u0001\u0002?\u0001\tuDQ!\u0012\u000f\u0005\u0002yDq!\u001a\u000fC\u0002\u0013\u0005a\r\u0003\u0004t9\u0001\u0006Ia\u001a\u0005\t\u007fr\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011\u0011\u0002\u000f!\u0002\u0013\t\u0019\u0001C\u0004\u0002\fq!\t!!\u0004\t\u000f\u0005}A\u0004\"\u0001\u0002\"!9\u00111\u0007\u000f\u0005\u0002\u0005U\u0002bBA\u001c9\u0011\u0005\u0011\u0011\b\u0005\b\u0003waB\u0011IA\u001f\u0005\u0005\u001aE.^:uKJd\u0015N\\6GKR\u001c\u0007NU3ta>t7/Z!mY>\u001c\u0017\r^8s\u0015\tI#&\u0001\u0003mS:\\'BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s1\nQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0011ahP\u0007\u0002U%\u0011\u0001I\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007C\u0001 D\u0013\t!%FA\u0006GKR\u001c\u0007.\u001a:Q_>d\u0017A\u0002\u001fj]&$h\bF\u0002H\u0013*\u0003\"\u0001\u0013\u0001\u000e\u0003!BQ\u0001P\u0002A\u0002uBQ!Q\u0002A\u0002\t\u000bQ\"[:Nk2$\u0018\u000eV3oC:$X#A'\u0011\u0005Er\u0015BA(3\u0005\u001d\u0011un\u001c7fC:\fa\"[:Nk2$\u0018\u000eV3oC:$\b%A\u0002yIE\u0002B!M*V+&\u0011AK\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005YkfBA,\\!\tA&'D\u0001Z\u0015\tQf&\u0001\u0004=e>|GOP\u0005\u00039J\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011ALM\u0001\u0010i>$\u0018\r\\\"p]\u001aLw\r\u0015:paV\tQ+\u0001\tu_R\fGnQ8oM&<\u0007K]8qA\u0005iQ.\u001b8D_:4\u0017n\u001a)s_B\fa\"\\5o\u0007>tg-[4Qe>\u0004\b%\u0001\bu_R\fG.\u00117m_\u000e\fG/\u001a3\u0016\u0003\u001d\u0004\"\u0001[9\u000e\u0003%T!A[6\u0002\r\u0005$x.\\5d\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\\8\u0002\tU$\u0018\u000e\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011\u0018N\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fq\u0002^8uC2\fE\u000e\\8dCR,G\rI\u0001\fC2dwnY$s_V\u00048/F\u0001w!\u00119\b0\u0016>\u000e\u0003-L!!_6\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002|95\t\u0001AA\bBY2|7-\u0019;j_:<%o\\;q'\ta\u0002\u0007F\u0001{\u000311W\r^2iKJ\u001cu.\u001e8u+\t\t\u0019\u0001E\u0002i\u0003\u000bI1!a\u0002j\u00055\tEo\\7jG&sG/Z4fe\u0006ia-\u001a;dQ\u0016\u00148i\\;oi\u0002\nq!Y2rk&\u0014X\r\u0006\u0003\u0002\u0010\u0005U\u0001c\u0001%\u0002\u0012%\u0019\u00111\u0003\u0015\u0003#\u0019+Go\u00195SKN\u0004xN\\:f'&TX\rC\u0004\u0002\u0018\t\u0002\r!!\u0007\u0002\u00151Lgn[\"p]\u001aLw\rE\u0002I\u00037I1!!\b)\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\be\u0016dW-Y:f)\u0011\t\u0019#!\u000b\u0011\u0007E\n)#C\u0002\u0002(I\u0012A!\u00168ji\"9\u00111F\u0012A\u0002\u00055\u0012\u0001B:ju\u0016\u00042!MA\u0018\u0013\r\t\tD\r\u0002\u0004\u0013:$\u0018!F5oGJ,W.\u001a8u\r\u0016$8\r[3s\u0007>,h\u000e\u001e\u000b\u0003\u0003G\t1\u0004Z3de\u0016lWM\u001c;B]\u0012<U\r\u001e$fi\u000eDWM]\"pk:$HCAA\u0017\u0003!!xn\u0015;sS:<G#A+\u0002\u0019\u0005dGn\\2He>,\bo\u001d\u0011\u0002\u001d=tg)\u001a;dQ\u0016\u00148\u000b^1siR!\u00111EA#\u0011\u001d\t9e\u0004a\u0001\u0003\u0013\na\u0001^3oC:$\b\u0003B\u0019\u0002LUK1!!\u00143\u0005\u0019y\u0005\u000f^5p]\u0006\trN\u001c$fi\u000eDWM]*ikR$wn\u001e8\u0015\t\u0005\r\u00121\u000b\u0005\b\u0003\u000f\u0002\u0002\u0019AA%\u0003I\t7-];je\u00164U\r^2i\u0005V4g-\u001a:\u0015\r\u0005=\u0011\u0011LA.\u0011\u001d\t9%\u0005a\u0001\u0003\u0013Bq!a\u0006\u0012\u0001\u0004\tI\"\u0001\nsK2,\u0017m]3GKR\u001c\u0007NQ;gM\u0016\u0014HCBA\u0012\u0003C\n\u0019\u0007C\u0004\u0002HI\u0001\r!!\u0013\t\u000f\u0005-\"\u00031\u0001\u0002.\u0005)!/Z:fi\u0006)R.\u001b8BY2|7-\u0019;fI\u001a{'\u000fV3oC:$XCAA6!\r\t\u0014QN\u0005\u0004\u0003_\u0012$\u0001\u0002'p]\u001e\fQ#\\1y\u00032dwnY1uK\u00124uN\u001d+f]\u0006tG/\u0001\nbY2|7-\u0019;j_:<%o\\;q\u0017\u0016LHcA+\u0002x!9\u0011q\t\fA\u0002\u0005%\u0013aC2p]\u001aLw\r\u0015:paN$\u0012AU\u0001\u0019[\u0006L(-Z%oSRL\u0017\r\\5{K\u0006cGn\\2bi>\u0014\u0018aC3ogV\u0014X-R7qif\fA\u0004^8uC2\u0004VM]&fs\u0006sG-\u0011<bS2\f'\r\\3CsR,7/\u0006\u0002\u0002\u0006B1\u0011gUA\u0017\u0003[\t\u0001\"\\5o\u0005f$Xm]\u000b\u0003\u0003[\u0001")
public class ClusterLinkFetchResponseAllocator
implements Logging {
    private final KafkaConfig brokerConfig;
    private final FetcherPool fetcherPool;
    private final boolean isMultiTenant;
    private final /* synthetic */ Tuple2 x$1;
    private final String totalConfigProp;
    private final String minConfigProp;
    private final AtomicLong totalAllocated;
    private final ConcurrentHashMap<String, AllocationGroup> allocGroups;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    private String totalConfigProp() {
        return this.totalConfigProp;
    }

    private String minConfigProp() {
        return this.minConfigProp;
    }

    public AtomicLong totalAllocated() {
        return this.totalAllocated;
    }

    private ConcurrentHashMap<String, AllocationGroup> allocGroups() {
        return this.allocGroups;
    }

    public synchronized void onFetcherStart(Option<String> tenant) {
        String key = this.allocationGroupKey(tenant);
        this.allocGroups().computeIfAbsent(key, x$2 -> new AllocationGroup()).incrementFetcherCount();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Added fetcher for key '").append(key).append("' in pool ").append($this.fetcherPool).append(", allocGroups=").append(this.allocGroups()).toString());
    }

    public synchronized void onFetcherShutdown(Option<String> tenant) {
        String key = this.allocationGroupKey(tenant);
        Option option = Option$.MODULE$.apply((Object)this.allocGroups().get(key));
        if (option instanceof Some) {
            AllocationGroup alloc = (AllocationGroup)((Some)option).value();
            int remaining = alloc.decrementAndGetFetcherCount();
            if (remaining == 0 && this.isMultiTenant()) {
                this.allocGroups().remove(key, alloc);
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Removed fetcher for key '").append(key).append("' in pool ").append($this.fetcherPool).append(", allocGroups=").append(this.allocGroups()).toString());
            if (remaining < 0) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Unexpected fetcher count ").append(remaining).append(" for allocation group with key '").append(key).append("' in pool ").append($this.fetcherPool).toString());
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Fetcher allocation group not found for key '").append(key).append("' in pool ").append($this.fetcherPool).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public FetchResponseSize acquireFetchBuffer(Option<String> tenant, ClusterLinkConfig linkConfig) {
        String key = this.allocationGroupKey(tenant);
        FetchResponseSize fetchResponseSize = (FetchResponseSize)Option$.MODULE$.apply((Object)this.allocGroups().get(key)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.acquire(linkConfig)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(55).append("Fetcher allocation group not found for tenant ").append(tenant).append(" in pool ").append($this.fetcherPool).toString());
        });
        this.totalAllocated().addAndGet(fetchResponseSize.responseSize());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Acquired fetch buffer size ").append(fetchResponseSize).append(" for key '").append(key).append("'in pool ").append($this.fetcherPool).append(", totalAllocated ").append(this.totalAllocated()).toString());
        return fetchResponseSize;
    }

    public void releaseFetchBuffer(Option<String> tenant, int size) {
        String key = this.allocationGroupKey(tenant);
        Option$.MODULE$.apply((Object)this.allocGroups().get(key)).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.release(size);
            return BoxedUnit.UNIT;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(46).append("Fetcher allocation group not found for tenant ").append(tenant).toString());
        });
        this.totalAllocated().addAndGet(0 - size);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Released fetch buffer size ").append(size).append(" for key '").append(key).append("' in pool ").append($this.fetcherPool).append(", totalAllocated ").append(this.totalAllocated()).toString());
    }

    public synchronized void reset() {
        long allocated;
        if (this.isMultiTenant()) {
            if (!this.allocGroups().isEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Expected no allocation groups during reset for multi-tenant allocator, found ").append(this.allocGroups()).toString());
            }
        } else if (this.allocGroups().size() != 1 || this.allocGroups().values().stream().anyMatch(alloc -> alloc.fetcherCount().get() != 0 || alloc.totalAllocated().get() != 0L)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Expected one empty default allocation group during reset, found ").append(this.allocGroups()).toString());
            this.allocGroups().clear();
            this.allocGroups().put("", new AllocationGroup());
        }
        if ((allocated = this.totalAllocated().getAndSet(0L)) != 0L) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Expected total allocated to be zero, found ").append(allocated).toString());
            return;
        }
    }

    public long minAllocatedForTenant() {
        if (!this.isMultiTenant()) {
            return this.totalAllocated().get();
        }
        Iterable groupTotals = (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.allocGroups().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)ClusterLinkFetchResponseAllocator.$anonfun$minAllocatedForTenant$1(x$5)), Iterable$.MODULE$.canBuildFrom());
        long first = BoxesRunTime.unboxToLong((Object)groupTotals.headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        return BoxesRunTime.unboxToLong((Object)groupTotals.foldLeft((Object)BoxesRunTime.boxToLong((long)first), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.min(x, y)));
    }

    public long maxAllocatedForTenant() {
        if (!this.isMultiTenant()) {
            return this.totalAllocated().get();
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.allocGroups().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ClusterLinkFetchResponseAllocator.$anonfun$maxAllocatedForTenant$1(x$6)), Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
    }

    private String allocationGroupKey(Option<String> tenant) {
        if (this.isMultiTenant()) {
            return String.valueOf(tenant.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        }
        return "";
    }

    private Tuple2<String, String> configProps() {
        FetcherPool fetcherPool = this.fetcherPool;
        if (FetcherPool$Default$.MODULE$.equals(fetcherPool)) {
            return new Tuple2((Object)"confluent.cluster.link.fetch.response.total.bytes", (Object)"confluent.cluster.link.fetch.response.min.bytes");
        }
        if (FetcherPool$InSync$.MODULE$.equals(fetcherPool)) {
            return new Tuple2((Object)"confluent.cluster.link.insync.fetch.response.total.bytes", (Object)"confluent.cluster.link.insync.fetch.response.min.bytes");
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown fetch pool ").append(this.fetcherPool).toString());
    }

    private void maybeInitializeAllocator() {
        if (!this.isMultiTenant()) {
            this.allocGroups().put("", new AllocationGroup());
            return;
        }
    }

    public void ensureEmpty() {
        if (this.totalAllocated().get() != 0L) {
            throw new IllegalStateException(new StringBuilder(47).append("Total allocated on this allocator is not zero: ").append(this.totalAllocated()).toString());
        }
        long sumOfAllocated = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.allocGroups().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ClusterLinkFetchResponseAllocator.$anonfun$ensureEmpty$1(x$7)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (sumOfAllocated != 0L) {
            throw new IllegalStateException(new StringBuilder(69).append("Sum of total allocated for all groups on this allocator is not zero: ").append(sumOfAllocated).toString());
        }
        int fetcherCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.allocGroups().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ClusterLinkFetchResponseAllocator.$anonfun$ensureEmpty$2(x$8)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (fetcherCount != 0) {
            throw new IllegalStateException(new StringBuilder(50).append("Number of fetchers on this allocator is not zero: ").append(fetcherCount).toString());
        }
        if (this.isMultiTenant() && !this.allocGroups().isEmpty()) {
            throw new IllegalStateException(new StringBuilder(40).append("Allocation groups haven't been cleared: ").append(this.allocGroups()).toString());
        }
        if (!this.isMultiTenant() && this.allocGroups().size() != 1) {
            throw new IllegalStateException(new StringBuilder(58).append("Unexpected allocation groups, expected one default entry: ").append(this.allocGroups()).toString());
        }
    }

    public Tuple2<Object, Object> kafka$server$link$ClusterLinkFetchResponseAllocator$$totalPerKeyAndAvailableBytes() {
        Integer total = this.brokerConfig.getInt(this.totalConfigProp());
        return new Tuple2.mcII.sp(Predef$.MODULE$.Integer2int(total) / package$.MODULE$.max(1, this.allocGroups().size()), (int)package$.MODULE$.max(0L, (long)Predef$.MODULE$.Integer2int(total) - this.totalAllocated().get()));
    }

    public int kafka$server$link$ClusterLinkFetchResponseAllocator$$minBytes() {
        return Predef$.MODULE$.Integer2int(this.brokerConfig.getInt(this.minConfigProp()));
    }

    public static final /* synthetic */ long $anonfun$minAllocatedForTenant$1(AllocationGroup x$5) {
        return x$5.totalAllocated().get();
    }

    public static final /* synthetic */ long $anonfun$maxAllocatedForTenant$1(AllocationGroup x$6) {
        return x$6.totalAllocated().get();
    }

    public static final /* synthetic */ long $anonfun$ensureEmpty$1(AllocationGroup x$7) {
        return x$7.totalAllocated().get();
    }

    public static final /* synthetic */ int $anonfun$ensureEmpty$2(AllocationGroup x$8) {
        return x$8.fetcherCount().get();
    }

    public ClusterLinkFetchResponseAllocator(KafkaConfig brokerConfig, FetcherPool fetcherPool) {
        this.brokerConfig = brokerConfig;
        this.fetcherPool = fetcherPool;
        Logging.$init$(this);
        ConfluentConfigs.ClusterLinkThreadAffinity clusterLinkThreadAffinity = brokerConfig.clusterLinkBackgroundThreadAffinity();
        ConfluentConfigs.ClusterLinkThreadAffinity clusterLinkThreadAffinity2 = ConfluentConfigs.ClusterLinkThreadAffinity.TENANT;
        this.isMultiTenant = !(clusterLinkThreadAffinity != null ? !clusterLinkThreadAffinity.equals(clusterLinkThreadAffinity2) : clusterLinkThreadAffinity2 != null);
        Tuple2<String, String> tuple2 = this.configProps();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String totalConfigProp = (String)tuple2._1();
        String minConfigProp = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)totalConfigProp, (Object)minConfigProp);
        this.totalConfigProp = (String)this.x$1._1();
        this.minConfigProp = (String)this.x$1._2();
        this.totalAllocated = new AtomicLong();
        this.allocGroups = new ConcurrentHashMap();
        this.maybeInitializeAllocator();
    }

    private class AllocationGroup {
        private final AtomicLong totalAllocated;
        private final AtomicInteger fetcherCount;

        public AtomicLong totalAllocated() {
            return this.totalAllocated;
        }

        public AtomicInteger fetcherCount() {
            return this.fetcherCount;
        }

        /*
         * WARNING - void declaration
         */
        public FetchResponseSize acquire(ClusterLinkConfig linkConfig) {
            void var4_4;
            void var3_3;
            Tuple2<Object, Object> tuple2 = this.kafka$server$link$ClusterLinkFetchResponseAllocator$AllocationGroup$$$outer().kafka$server$link$ClusterLinkFetchResponseAllocator$$totalPerKeyAndAvailableBytes();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int total = tuple2._1$mcI$sp();
            int available = tuple2._2$mcI$sp();
            int responseMaxBytes = package$.MODULE$.min((int)(var3_3 / package$.MODULE$.max(1, this.fetcherCount().get())), (int)var4_4);
            responseMaxBytes = package$.MODULE$.max(this.kafka$server$link$ClusterLinkFetchResponseAllocator$AllocationGroup$$$outer().kafka$server$link$ClusterLinkFetchResponseAllocator$$minBytes(), (int)package$.MODULE$.min((long)responseMaxBytes, (long)var3_3 - this.totalAllocated().get()));
            responseMaxBytes = package$.MODULE$.min(responseMaxBytes, Predef$.MODULE$.Integer2int(linkConfig.replicaFetchResponseMaxBytes()));
            if (this.totalAllocated().addAndGet(responseMaxBytes) > (long)var3_3) {
                int minResponseBytes = this.kafka$server$link$ClusterLinkFetchResponseAllocator$AllocationGroup$$$outer().kafka$server$link$ClusterLinkFetchResponseAllocator$$minBytes();
                this.totalAllocated().addAndGet(0 - responseMaxBytes + minResponseBytes);
                responseMaxBytes = minResponseBytes;
            }
            int partitionMaxBytes = BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)responseMaxBytes), (Object)linkConfig.replicaFetchResponseMaxBytes()) ? Predef$.MODULE$.Integer2int(linkConfig.replicaFetchMaxBytes()) : package$.MODULE$.min(package$.MODULE$.max(this.kafka$server$link$ClusterLinkFetchResponseAllocator$AllocationGroup$$$outer().kafka$server$link$ClusterLinkFetchResponseAllocator$$minBytes(), responseMaxBytes / 2), Predef$.MODULE$.Integer2int(linkConfig.replicaFetchMaxBytes()));
            return new FetchResponseSize(partitionMaxBytes, responseMaxBytes);
        }

        public void release(int size) {
            if (this.totalAllocated().addAndGet(0 - size) < 0L) {
                throw new IllegalStateException("Total size is less than zero");
            }
        }

        public void incrementFetcherCount() {
            this.fetcherCount().incrementAndGet();
        }

        public int decrementAndGetFetcherCount() {
            return this.fetcherCount().decrementAndGet();
        }

        public String toString() {
            return new StringBuilder(47).append("AllocationGroup(fetcherCount=").append(this.fetcherCount()).append(", totalAllocated=").append(this.totalAllocated()).append(")").toString();
        }

        public /* synthetic */ ClusterLinkFetchResponseAllocator kafka$server$link$ClusterLinkFetchResponseAllocator$AllocationGroup$$$outer() {
            return ClusterLinkFetchResponseAllocator.this;
        }

        public AllocationGroup() {
            if (ClusterLinkFetchResponseAllocator.this == null) {
                throw null;
            }
            this.totalAllocated = new AtomicLong();
            this.fetcherCount = new AtomicInteger();
        }
    }
}

