/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AsyncSend;
import kafka.server.BrokerTopicStats;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetchResponseAllocator;
import kafka.server.link.ClusterLinkFetcher;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$AwaitingFetchResponse$;
import kafka.server.link.ClusterLinkFetcherThread$AwaitingListOffsetResponse$;
import kafka.server.link.ClusterLinkFetcherThread$FetcherShutdown$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeFetch$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTransitionTierStates$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTruncate$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.FetchResponseSize;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u001e=\u0001\rC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Qa\u0010\u0001B\u0001B\u0003%q0!\u0002\t\u0015\u00055\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003/A!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005=\u0002BCA\u001b\u0001\t\u0005\t\u0015!\u0003\u00028!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005-\u0003A!A!\u0002\u0013\ti\u0005\u0003\u0006\u0002T\u0001\u0011\t\u0011)A\u0005\u0003+B!\"a\u0017\u0001\u0005\u0003\u0005\u000b\u0011BA/\u0011)\t\u0019\u0007\u0001B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003W\u0002!\u0011!Q\u0001\n\u00055\u0004bCA:\u0001\t\u0015\r\u0011\"\u0011=\u0003kB!\"! \u0001\u0005\u0003\u0005\u000b\u0011BA<\u0011)\ty\b\u0001B\u0001B\u0003%\u0011\u0011\u0011\u0005\u000b\u0003\u000f\u0003!\u0011!Q\u0001\n\u0005%\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\n\u0003\u000b\u0004!\u0019!C!\u0003\u000fD\u0001\"a4\u0001A\u0003%\u0011\u0011\u001a\u0005\n\u0003#\u0004!\u0019!C!\u0003'D\u0001\"a7\u0001A\u0003%\u0011Q\u001b\u0005\n\u0003;\u0004!\u0019!C!\u0003?D\u0001\"!=\u0001A\u0003%\u0011\u0011\u001d\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003kD\u0001B!\u0003\u0001A\u0003%\u0011q\u001f\u0005\n\u0005\u0017\u0001\u0001\u0019!C\t\u0005\u001bA\u0011B!\u0006\u0001\u0001\u0004%\tBa\u0006\t\u0011\t\r\u0002\u0001)Q\u0005\u0005\u001fA\u0011B!\f\u0001\u0001\u0004%\tBa\f\t\u0013\t-\u0003\u00011A\u0005\u0012\t5\u0003\u0002\u0003B)\u0001\u0001\u0006KA!\r\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!\u0011\f\u0001\u0005R\tm\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005w\u0002A\u0011\u000bB,\u0011\u001d\u0011i\b\u0001C)\u0005/BqAa \u0001\t#\u0012\t\tC\u0004\u0003\u0018\u0002!\tF!'\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u001a\u0001\u0005\u0012\t5\u0007b\u0002Bn\u0001\u0011E#q\u000b\u0005\b\u0005;\u0004A\u0011\u000bBp\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005/BqA!<\u0001\t\u0003\u0012y\u000fC\u0004\u0003r\u0002!\tEa\u0016\t\u000f\tM\b\u0001\"\u0015\u0003X!9!Q\u001f\u0001\u0005\u0002\t5\u0001b\u0002B|\u0001\u0011\u0005#\u0011 \u0002#\u00072,8\u000f^3s\u0019&t7NR3uG\",'oV5uQNC\u0017M]3e)\"\u0014X-\u00193\u000b\u0005ur\u0014\u0001\u00027j].T!a\u0010!\u0002\rM,'O^3s\u0015\u0005\t\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0003\"!\u0012$\u000e\u0003qJ!a\u0012\u001f\u0003%\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]\u0001\u0005]\u0006lW-F\u0001K!\tYEK\u0004\u0002M%B\u0011Q\nU\u0007\u0002\u001d*\u0011qJQ\u0001\u0007yI|w\u000e\u001e \u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'B\u000bQA\\1nK\u0002\na\u0001\\5oW&#\u0007C\u0001.c\u001b\u0005Y&B\u0001/^\u0003\u0019\u0019w.\\7p]*\u0011\u0011I\u0018\u0006\u0003?\u0002\fa!\u00199bG\",'\"A1\u0002\u0007=\u0014x-\u0003\u0002d7\n!Q+^5e\u0003%1W\r^2iKJLE\r\u0005\u0002gO6\t\u0001+\u0003\u0002i!\n\u0019\u0011J\u001c;\u0002\u0017\u0019,Go\u00195feB{w\u000e\u001c\t\u0003W2l\u0011AP\u0005\u0003[z\u00121BR3uG\",'\u000fU8pY\u0006A1\r\\5f]RLE-\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002ri6\t!O\u0003\u0002t\u0001\u000691\r\\;ti\u0016\u0014\u0018BA;s\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fAb\u001d5be\u0016$G\u000b\u001b:fC\u0012\u0004\"!\u0012=\n\u0005ed$AH\"mkN$XM\u001d'j].\u001c\u0006.\u0019:fI\u001a+Go\u00195feRC'/Z1e\u0003-\t7/\u001f8d'\u0016tG-\u001a:\u0011\u0005-d\u0018BA??\u0005%\t5/\u001f8d'\u0016tG-A\u0006bgft7\rT3bI\u0016\u0014\bcA#\u0002\u0002%\u0019\u00111\u0001\u001f\u0003=\rcWo\u001d;fe2Kgn[!ts:\u001cG*Z1eKJ,e\u000e\u001a)pS:$\u0018\u0002BA\u0004\u0003\u0013\ta\u0001\\3bI\u0016\u0014\u0018bAA\u0006}\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00042s_.,'oQ8oM&<\u0007cA6\u0002\u0012%\u0019\u00111\u0003 \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007cA#\u0002\u001a%\u0019\u00111\u0004\u001f\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\ndYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\rE\u0002F\u0003CI1!a\t=\u0005M\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u000391W\r^2iKJl\u0015M\\1hKJ\u00042!RA\u0015\u0013\r\tY\u0003\u0010\u0002\u001a\u00072,8\u000f^3s\u0019&t7NR3uG\",'/T1oC\u001e,'/\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u00191.!\r\n\u0007\u0005MbH\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\u0001\u0002/Y;tK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004W\u0006e\u0012bAA\u001e}\t\u0001\u0002+Y;tK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0013Kb\u0004xN\\3oi&\fGNQ1dW>4g\r\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)eW\u0001\u0006kRLGn]\u0005\u0005\u0003\u0013\n\u0019E\u0001\nFqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0017A\u0003:fa2L7-Y'heB\u00191.a\u0014\n\u0007\u0005EcH\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0007-\f9&C\u0002\u0002Zy\u0012ABU3qY&\u001c\u0017-U;pi\u0006\f!c\u00197vgR,'\u000fT5oW6+GO]5dgB\u0019Q)a\u0018\n\u0007\u0005\u0005DH\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004B!!\u0011\u0002h%!\u0011\u0011NA\"\u0005\u0011!\u0016.\\3\u0002-\u0019,Go\u00195SKN\u0004xN\\:f\u00032dwnY1u_J\u00042!RA8\u0013\r\t\t\b\u0010\u0002\"\u00072,8\u000f^3s\u0019&t7NR3uG\"\u0014Vm\u001d9p]N,\u0017\t\u001c7pG\u0006$xN]\u0001\u0012G2,8\u000f^3s\u0019&t7n\u00117jK:$XCAA<!\r)\u0015\u0011P\u0005\u0004\u0003wb$\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\u0006\u00112\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;!\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u0003\n\u0019)\u0003\u0003\u0002\u0006\u0006\r#A\u0003'pO\u000e{g\u000e^3yi\u00061A/\u001a8b]R\u0004BAZAF\u0015&\u0019\u0011Q\u0012)\u0003\r=\u0003H/[8o\u0003\u0019a\u0014N\\5u}Q\u0011\u00141SAK\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019\r\u0005\u0002F\u0001!)\u0001j\u0007a\u0001\u0015\")\u0001l\u0007a\u00013\")Am\u0007a\u0001K\")\u0011n\u0007a\u0001U\")an\u0007a\u0001\u0015\")qn\u0007a\u0001a\")ao\u0007a\u0001o\")!p\u0007a\u0001w\")ap\u0007a\u0001\u007f\"9\u0011QB\u000eA\u0002\u0005=\u0001bBA\u000b7\u0001\u0007\u0011q\u0003\u0005\b\u0003;Y\u0002\u0019AA\u0010\u0011\u001d\t)c\u0007a\u0001\u0003OAq!!\f\u001c\u0001\u0004\ty\u0003C\u0004\u00026m\u0001\r!a\u000e\t\u000f\u0005u2\u00041\u0001\u0002@!9\u00111J\u000eA\u0002\u00055\u0003bBA*7\u0001\u0007\u0011Q\u000b\u0005\b\u00037Z\u0002\u0019AA/\u0011\u001d\t\u0019g\u0007a\u0001\u0003KBq!a\u001b\u001c\u0001\u0004\ti\u0007C\u0004\u0002tm\u0001\r!a\u001e\t\u000f\u0005}4\u00041\u0001\u0002\u0002\"9\u0011qQ\u000eA\u0002\u0005%\u0015!\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.Z\u000b\u0003\u0003\u0013\u00042a[Af\u0013\r\tiM\u0010\u0002\u0011)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016\faCZ3uG\"$\u0016.\u001a:Ti\u0006$X-T1dQ&tW\rI\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!!6\u0011\u0007-\f9.C\u0002\u0002Zz\u0012\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%A\beK\u0012L7-\u0019;fIRC'/Z1e+\t\t\t\u000fE\u0003g\u0003\u0017\u000b\u0019\u000f\u0005\u0003\u0002f\u00065XBAAt\u0015\u0011\tI/a;\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u007fuKA!a<\u0002h\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003A!W\rZ5dCR,G\r\u00165sK\u0006$\u0007%A\u0007tQV$Hm\\<o\u0019\u0006$8\r[\u000b\u0003\u0003o\u0004B!!?\u0003\u00065\u0011\u00111 \u0006\u0005\u0003{\fy0\u0001\u0006d_:\u001cWO\u001d:f]RTA!!;\u0003\u0002)\u0011!1A\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\b\u0005m(AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u000fg\",H\u000fZ8x]2\u000bGo\u00195!\u0003E\u0019\b.\u001e;e_^t\u0017J\\5uS\u0006$X\rZ\u000b\u0003\u0005\u001f\u00012A\u001aB\t\u0013\r\u0011\u0019\u0002\u0015\u0002\b\u0005>|G.Z1o\u0003U\u0019\b.\u001e;e_^t\u0017J\\5uS\u0006$X\rZ0%KF$BA!\u0007\u0003 A\u0019aMa\u0007\n\u0007\tu\u0001K\u0001\u0003V]&$\b\"\u0003B\u0011K\u0005\u0005\t\u0019\u0001B\b\u0003\rAH%M\u0001\u0013g\",H\u000fZ8x]&s\u0017\u000e^5bi\u0016$\u0007\u0005K\u0002'\u0005O\u00012A\u001aB\u0015\u0013\r\u0011Y\u0003\u0015\u0002\tm>d\u0017\r^5mK\u0006aa-\u001a;dQ\u0016\u00148\u000b^1uKV\u0011!\u0011\u0007\t\u0005\u0005g\u0011)E\u0004\u0003\u00036\t\u0005c\u0002\u0002B\u001c\u0005\u007fqAA!\u000f\u0003>9\u0019QJa\u000f\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014b\u0001B\"y\u0005A2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s)\"\u0014X-\u00193\n\t\t\u001d#\u0011\n\u0002\r\r\u0016$8\r[3s'R\fG/\u001a\u0006\u0004\u0005\u0007b\u0014\u0001\u00054fi\u000eDWM]*uCR,w\fJ3r)\u0011\u0011IBa\u0014\t\u0013\t\u0005\u0002&!AA\u0002\tE\u0012!\u00044fi\u000eDWM]*uCR,\u0007\u0005K\u0002*\u0005O\ta\u0001Z8X_J\\GC\u0001B\r\u00035i\u0017-\u001f2f)J,hnY1uKR\u0011!Q\f\t\u0007\u0005?\u0012IG!\u001c\u000e\u0005\t\u0005$\u0002\u0002B2\u0005K\nq!\\;uC\ndWMC\u0002\u0003hA\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YG!\u0019\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u00045\n=\u0014b\u0001B97\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!G2iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef|eMZ:fiN$BA!\u0007\u0003x!9!\u0011\u0010\u0017A\u0002\tu\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0002\u00155\f\u0017PY3GKR\u001c\u0007.A\rnCf\u0014W\r\u0016:b]NLG/[8o)&,'o\u0015;bi\u0016\u001c\u0018!\u0007;sk:\u001c\u0017\r^3U_\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$BA!\u0007\u0003\u0004\"9!QQ\u0018A\u0002\t\u001d\u0015!\u00077bi\u0016\u001cH/\u00129pG\"\u001chi\u001c:QCJ$\u0018\u000e^5p]N\u0004\u0002B!#\u0003\f\n5$qR\u0007\u0003\u0005KJAA!$\u0003f\t\u0019Q*\u00199\u0011\t\tE%1S\u0007\u0002\u0001%!!QSA\u0005\u0005%)\u0005o\\2i\t\u0006$\u0018-A\nqe>\u001cWm]:GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0004\u0003\u001a\tm%\u0011\u0018\u0005\b\u0005;\u0003\u0004\u0019\u0001BP\u0003E\u0019Xm]:j_:\u0004\u0016M\u001d;ji&|gn\u001d\t\t\u0005C\u0013\u0019K!\u001c\u0003&6\u0011\u0011q`\u0005\u0005\u0005\u001b\u000by\u0010\u0005\u0003\u0003(\nMf\u0002\u0002BU\u0005_k!Aa+\u000b\u0007\t56,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\tLa+\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\tU&q\u0017\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\tE&1\u0016\u0005\b\u0005w\u0003\u0004\u0019\u0001B_\u000311W\r^2i%\u0016\fX/Z:u!\u0011\u00119Ka0\n\t\t\u0005'q\u0017\u0002\b\u0005VLG\u000eZ3s\u0003=yg.Q:z]\u000e\u0014Vm\u001d9p]N,G\u0003\u0002B\r\u0005\u000fDqA!32\u0001\u0004\u0011y!A\tsKF,Xm\u001d;Tk\u000e\u001cWm]:gk2\f!#\u001e9eCR,g)\u001a;dQ\u0016\u00148\u000b^1uKR!!q\u0002Bh\u0011\u001d\u0011\tN\ra\u0001\u0005'\f\u0001c\u001d;bi\u0016$&/\u00198tM>\u0014X.\u001a:\u0011\u000f\u0019\u0014)N!\r\u0003Z&\u0019!q\u001b)\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u00024\u0002\f\nE\u0012!C:jO:\fG.\u00117m\u0003Y9\u0018-\u001b;G_J\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\r\u0005CDqAa95\u0001\u0004\u0011)/A\u0005cC\u000e\\wN\u001a4NgB\u0019aMa:\n\u0007\t%\bK\u0001\u0003M_:<\u0017!H7bs\n,\u0007K]8dKN\u001cx+Y5uS:<\u0007+\u0019:uSRLwN\\:\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGC\u0001B\b\u00035\tw/Y5u'\",H\u000fZ8x]\u0006QqN\\*ikR$wn\u001e8\u0002\u0013%\u001c(\t\\8dW\u0016$\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003)\u0003")
public class ClusterLinkFetcherWithSharedThread
extends ClusterLinkFetcher {
    private final String name;
    private final int fetcherId;
    private final FetcherPool fetcherPool;
    private final BrokerEndPoint sourceBroker;
    private final ClusterLinkSharedFetcherThread sharedThread;
    private final AsyncSend asyncSender;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Time time;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final TierStateMachine fetchTierStateMachine;
    private final BrokerTopicStats brokerTopicStats;
    private final Option<ShutdownableThread> dedicatedThread;
    private final CountDownLatch shutdownLatch;
    private volatile boolean shutdownInitiated;
    private volatile ClusterLinkFetcherThread.FetcherState fetcherState;

    public String name() {
        return this.name;
    }

    @Override
    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    @Override
    public TierStateMachine fetchTierStateMachine() {
        return this.fetchTierStateMachine;
    }

    @Override
    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    @Override
    public Option<ShutdownableThread> dedicatedThread() {
        return this.dedicatedThread;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public boolean shutdownInitiated() {
        return this.shutdownInitiated;
    }

    public void shutdownInitiated_$eq(boolean x$1) {
        this.shutdownInitiated = x$1;
    }

    public ClusterLinkFetcherThread.FetcherState fetcherState() {
        return this.fetcherState;
    }

    public void fetcherState_$eq(ClusterLinkFetcherThread.FetcherState x$1) {
        this.fetcherState = x$1;
    }

    @Override
    public void doWork() {
        this.asyncSender.maybeSendPendingRequest();
        long now = this.time.milliseconds();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions && ((ClusterLinkFetcherThread.AwaitingPartitions)x0$1).deadlineMs() <= now) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        if (this.shutdownInitiated()) {
            if (this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)state -> {
                ClusterLinkFetcherThread.FetcherState fetcherState = state;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState == null ? clusterLinkFetcherThread$FetcherShutdown$ != null : !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$)) {
                    return new Some((Object)ClusterLinkFetcherThread$FetcherShutdown$.MODULE$);
                }
                return None$.MODULE$;
            })) {
                this.onShutdown();
                return;
            }
            return;
        }
        if (!this.isBlocked()) {
            try {
                ClusterLinkFetcherThread.FetcherState fetcherState;
                ClusterLinkFetcherThread.FetcherState fetcherState2 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTruncate$ clusterLinkFetcherThread$MaybeTruncate$ = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
                if (!(fetcherState2 != null ? !fetcherState2.equals(clusterLinkFetcherThread$MaybeTruncate$) : clusterLinkFetcherThread$MaybeTruncate$ != null)) {
                    this.maybeTruncate();
                }
                if ((fetcherState = this.fetcherState()) instanceof ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets) {
                    ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets maybeCheckpointRecoveryOffsets = (ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets)fetcherState;
                    this.checkpointRecoveryOffsets(maybeCheckpointRecoveryOffsets.partitions());
                }
                ClusterLinkFetcherThread.FetcherState fetcherState3 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeFetch$ clusterLinkFetcherThread$MaybeFetch$ = ClusterLinkFetcherThread$MaybeFetch$.MODULE$;
                if (!(fetcherState3 != null ? !fetcherState3.equals(clusterLinkFetcherThread$MaybeFetch$) : clusterLinkFetcherThread$MaybeFetch$ != null)) {
                    this.maybeFetch();
                }
                ClusterLinkFetcherThread.FetcherState fetcherState4 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTransitionTierStates$ clusterLinkFetcherThread$MaybeTransitionTierStates$ = ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$;
                if (!(fetcherState4 != null ? !fetcherState4.equals(clusterLinkFetcherThread$MaybeTransitionTierStates$) : clusterLinkFetcherThread$MaybeTransitionTierStates$ != null)) {
                    this.maybeTransitionTierStates();
                }
                ClusterLinkFetcherThread.FetcherState fetcherState5 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$ clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ = ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$;
                if (!(fetcherState5 == null ? clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ != null : !fetcherState5.equals(clusterLinkFetcherThread$MaybeProcessWaitingPartitions$)) || this.fetcherState() instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                    this.maybeProcessWaitingPartitions();
                }
                this.completeDelayedFetchRequests();
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected exception in fetcher thread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$10 -> new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$));
                return;
            }
        }
    }

    @Override
    public ArrayBuffer<TopicPartition> maybeTruncate() {
        ArrayBuffer<TopicPartition> truncatingPartitions = super.maybeTruncate();
        if (this.asyncSender.hasPendingRequest()) {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$11 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse(truncatingPartitions)));
        } else {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$12 -> new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(truncatingPartitions)));
        }
        return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
        super.checkpointRecoveryOffsets(topicPartitions);
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$13 -> new Some((Object)ClusterLinkFetcherThread$MaybeFetch$.MODULE$));
    }

    @Override
    public void maybeFetch() {
        super.maybeFetch();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return None$.MODULE$;
            }
            if ($this.asyncSender.hasPendingRequest()) {
                return new Some((Object)ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$);
            }
            return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
        });
    }

    @Override
    public void maybeTransitionTierStates() {
        super.maybeTransitionTierStates();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$14 -> new Some((Object)ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$));
    }

    @Override
    public void truncateToEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> latestEpochsForPartitions) {
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetchEpochEndOffsets(latestEpochsForPartitions, (Function1<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)endOffsets -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$1(this, latestEpochsForPartitions, endOffsets);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, t);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void processFetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchRequest.Builder fetchRequest) {
        FetchResponseSize fetchSize = this.acquireFetchBuffer();
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetch(fetchRequest, (Function1<Map<TopicPartition, FetchResponseData.PartitionData>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseData -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$1(this, sessionPartitions, fetchSize, responseData);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$2(this, fetchRequest, fetchSize, t);
            return BoxedUnit.UNIT;
        });
    }

    private void onAsyncResponse(boolean requestSuccessful) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse) {
                ArrayBuffer<TopicPartition> partitions = ((ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse)x0$1).partitions();
                if (requestSuccessful) {
                    return new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(partitions));
                }
            }
            if (ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$.equals(x0$1) && requestSuccessful) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
            }
            if (ClusterLinkFetcherThread$AwaitingListOffsetResponse$.MODULE$.equals(x0$1) && requestSuccessful) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            if (x0$1.isAwaitingResponse()) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            if (!this.shutdownInitiated()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Ignoring unexpected response in state ").append(this.fetcherState()).append(", requestSuccessful=").append(requestSuccessful).toString());
            }
            return None$.MODULE$;
        });
    }

    public boolean updateFetcherState(Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>> stateTransformer) {
        boolean bl;
        this.partitionMapLock().lockInterruptibly();
        try {
            bl = ((Option)stateTransformer.apply((Object)this.fetcherState())).exists((Function1 & Serializable & scala.Serializable)newState -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherWithSharedThread.$anonfun$updateFetcherState$1(this, newState)));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return bl;
    }

    @Override
    public void signalAll() {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)state -> {
            if (state instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        this.clusterLinkClient().networkClient().wakeup();
        super.signalAll();
    }

    @Override
    public void waitForReadyPartitions(long backoffMs) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$15 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingPartitions($this.time.milliseconds() + backoffMs)));
    }

    private void maybeProcessWaitingPartitions() {
        Set<TopicPartition> waitingPartitions = this.fetchWaitingPartitions();
        if (waitingPartitions.nonEmpty()) {
            ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetchLatestOffsets(waitingPartitions, (Function1<Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)latestOffsets -> {
                ClusterLinkFetcherWithSharedThread.$anonfun$maybeProcessWaitingPartitions$1(this, latestOffsets);
                return BoxedUnit.UNIT;
            }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                ClusterLinkFetcherWithSharedThread.$anonfun$maybeProcessWaitingPartitions$2(this, waitingPartitions, t);
                return BoxedUnit.UNIT;
            });
        }
        if (this.asyncSender.hasPendingRequest()) {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$16 -> new Some((Object)ClusterLinkFetcherThread$AwaitingListOffsetResponse$.MODULE$));
            return;
        }
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)currentState -> {
            ClusterLinkFetcherThread.FetcherState fetcherState = currentState;
            ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$ clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ = ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$;
            if (!(fetcherState != null ? !fetcherState.equals(clusterLinkFetcherThread$MaybeProcessWaitingPartitions$) : clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ != null)) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
    }

    @Override
    public boolean initiateShutdown() {
        this.shutdownInitiated_$eq(true);
        return super.initiateShutdown();
    }

    @Override
    public void awaitShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Awaiting shared fetcher thread shutdown.");
        this.clusterLinkClient().networkClient().wakeup();
        this.shutdownLatch().await();
        this.sharedThread.threadPool().removeFetcher(this.sourceBroker.id(), this, this.sharedThread);
        super.awaitShutdown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed shared fetcher thread shutdown.");
    }

    @Override
    public void onShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shared fetcher thread is shutting down.");
        this.shutdownLatch().countDown();
    }

    public boolean isBlocked() {
        return this.fetcherState().isBlocked();
    }

    public String toString() {
        return new StringBuilder(77).append("ClusterLinkFetcherWithSharedThread(fetcherId=").append(this.fetcherId).append(", sourceBrokerId=").append(this.sourceBroker.id()).append(", fetcherPool=").append(this.fetcherPool.name()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$1(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Map endOffsets) {
        $this.onAsyncResponse(true);
        $this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)latestEpochsForPartitions$1, (Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)endOffsets);
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$2(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Throwable t) {
        $this.onAsyncResponse(false);
        if (t instanceof IOException ? true : t instanceof NetworkException) {
            $this.clusterLinkMetadata.requestUpdate();
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).append(", request for metadata").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$1(ClusterLinkFetcherWithSharedThread $this, java.util.Map sessionPartitions$1, FetchResponseSize fetchSize$1, Map responseData) {
        try {
            $this.onAsyncResponse(true);
            $this.processFetchResponse(sessionPartitions$1, (Map<TopicPartition, FetchResponseData.PartitionData>)responseData);
        }
        finally {
            $this.releaseFetchBuffer(fetchSize$1);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$2(ClusterLinkFetcherWithSharedThread $this, FetchRequest.Builder fetchRequest$1, FetchResponseSize fetchSize$1, Throwable t) {
        try {
            $this.onAsyncResponse(false);
            $this.processFetchFailure(fetchRequest$1, t);
        }
        finally {
            $this.releaseFetchBuffer(fetchSize$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateFetcherState$1(ClusterLinkFetcherWithSharedThread $this, ClusterLinkFetcherThread.FetcherState newState) {
        block5: {
            block4: {
                if (!$this.shutdownInitiated()) break block4;
                ClusterLinkFetcherThread.FetcherState fetcherState = newState;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState != null ? !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$) : clusterLinkFetcherThread$FetcherShutdown$ != null) break block5;
            }
            ClusterLinkFetcherThread.FetcherState fetcherState = newState;
            ClusterLinkFetcherThread.FetcherState fetcherState2 = $this.fetcherState();
            if (fetcherState == null ? fetcherState2 != null : !fetcherState.equals(fetcherState2)) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating fetcher state from old=").append($this.fetcherState()).append(" to new=").append(newState).toString());
                $this.fetcherState_$eq(newState);
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$maybeProcessWaitingPartitions$1(ClusterLinkFetcherWithSharedThread $this, Map latestOffsets) {
        $this.onAsyncResponse(true);
        $this.handleSourceOffsets((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)latestOffsets);
    }

    public static final /* synthetic */ void $anonfun$maybeProcessWaitingPartitions$2(ClusterLinkFetcherWithSharedThread $this, Set waitingPartitions$1, Throwable t) {
        $this.onAsyncResponse(false);
        if (t instanceof IOException ? true : t instanceof NetworkException) {
            $this.clusterLinkMetadata.requestUpdate();
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Failed to fetch latest offsets for ").append(waitingPartitions$1).append(", request for metadata").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Failed to fetch latest offsets for ").append(waitingPartitions$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public ClusterLinkFetcherWithSharedThread(String name, Uuid linkId, int fetcherId, FetcherPool fetcherPool, String clientId, BrokerEndPoint sourceBroker, ClusterLinkSharedFetcherThread sharedThread, AsyncSend asyncSender, ClusterLinkAsyncLeaderEndPoint asyncLeader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, ClusterLinkFetchResponseAllocator fetchResponseAllocator, ClusterLinkNetworkClient clusterLinkClient, LogContext logContext, Option<String> tenant) {
        this.name = name;
        this.fetcherId = fetcherId;
        this.fetcherPool = fetcherPool;
        this.sourceBroker = sourceBroker;
        this.sharedThread = sharedThread;
        this.asyncSender = asyncSender;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.time = time;
        this.clusterLinkClient = clusterLinkClient;
        super(name, fetcherId, fetcherPool, asyncLeader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, clusterLinkMetrics, time, fetchResponseAllocator, clusterLinkClient, (Option<LogContext>)new Some((Object)logContext), tenant);
        this.fetchTierStateMachine = new ConfluentReplicaFetcherTierStateMachine(this.leader(), replicaMgr, exponentialBackoff);
        this.brokerTopicStats = replicaMgr.brokerTopicStats();
        this.dedicatedThread = None$.MODULE$;
        this.shutdownLatch = new CountDownLatch(1);
        this.shutdownInitiated = false;
        this.fetcherState = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
    }
}

