/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkMetrics$ {
    public static ClusterLinkMetrics$ MODULE$;
    private final String metricsGroup;
    private final long expirationInSeconds;

    static {
        new ClusterLinkMetrics$();
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public long expirationInSeconds() {
        return this.expirationInSeconds;
    }

    public String activeClientConnectionsCountSensorName() {
        return new StringBuilder(30).append("link-client-connections").append("-sensor").toString();
    }

    public MetricName activeClientConnectionsCountMetricName() {
        return new MetricName(new StringBuilder(29).append("link-client-connections").append("-total").toString(), "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String clientConnectionsThrottleSensorName() {
        return new StringBuilder(39).append("link-client-connections-throttle").append("-sensor").toString();
    }

    public MetricName clientConnectionsThrottleRateMetricName() {
        return new MetricName(new StringBuilder(37).append("link-client-connections-throttle").append("-rate").toString(), "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String throttleTimeSensorName(String linkName) {
        return new StringBuilder(29).append("linked-fetcher-throttle-time-").append(linkName).toString();
    }

    public String unavailabilitySensorName(String linkName) {
        return new StringBuilder(17).append("link-unavailable-").append(linkName).toString();
    }

    public String kafka$server$link$ClusterLinkMetrics$$linkCountDescription(ClusterLinkConfig.LinkMode linkMode) {
        if (ClusterLinkConfig.LinkMode.DESTINATION.equals(linkMode)) {
            return "Number of destination links for this cluster.";
        }
        if (ClusterLinkConfig.LinkMode.SOURCE.equals(linkMode)) {
            return "Number of source links for this cluster.";
        }
        if (ClusterLinkConfig.LinkMode.BIDIRECTIONAL.equals(linkMode)) {
            return "Number of bidirectional links for this cluster.";
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unsupported cluster link mode ").append(linkMode).toString());
    }

    public String kafka$server$link$ClusterLinkMetrics$$controllerReverseConnectionDescription(ConnectionMode connectionMode) {
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            return "Number of persistent reverse connections for this link from the remote cluster to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            return "Number of persistent reverse connections for this link from this broker to the remote link coordinator.";
        }
        throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported cluster link connection mode ").append(connectionMode).toString());
    }

    public String kafka$server$link$ClusterLinkMetrics$$reverseConnectionDescription(ConnectionMode connectionMode) {
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            return "Total number of reverse connections for this link from remote brokers to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            return "Total number of reverse connections for this link from this broker to remote brokers.";
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Unsupported connection mode ").append(connectionMode).toString());
    }

    public Map<String, String> linkModeTag(ClusterLinkConfig.LinkMode linkMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)linkMode.lowerCaseName())}));
    }

    public Map<String, String> linkTypeTag(LinkType linkType) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployed-link-type"), (Object)linkType.lowerCaseName())}));
    }

    public Map<String, String> connectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection-mode"), (Object)connectionMode.lowerCaseName())}));
    }

    public Map<String, String> remoteLinkConnectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remote-link-connection-mode"), (Object)connectionMode.lowerCaseName())}));
    }

    public Map<String, String> stateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)state)}));
    }

    public Map<String, String> remoteLinkStateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remote-link-state"), (Object)state)}));
    }

    public Map<String, String> reasonTag(String reason) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)}));
    }

    public Map<String, String> taskNameTag(String taskName) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"task-name"), (Object)taskName)}));
    }

    public Map<String, String> poolTag(String pool) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pool"), (Object)pool)}));
    }

    public int activeClientConnectionsCount(Metrics metrics) {
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(this.activeClientConnectionsCountMetricName());
        if (kafkaMetric != null) {
            return (int)BoxesRunTime.unboxToDouble((Object)kafkaMetric.metricValue());
        }
        return 0;
    }

    private ClusterLinkMetrics$() {
        MODULE$ = this;
        this.metricsGroup = "cluster-link-metrics";
        this.expirationInSeconds = TimeUnit.MINUTES.toSeconds(10L);
    }
}

