/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkBatchAdmin$;
import kafka.server.link.ClusterLinkBatchingAdmin;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors$;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkPeriodicTasks;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrors;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrors$;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkRepairMirrors$;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkStopMirrors;
import kafka.server.link.ClusterLinkStopMirrors$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTransitionMirrors;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0012%\u0001-B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\"B+\u0001\t\u00031\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u0013\t\u0004\u0001\u0019!a\u0001\n\u0013\u0019\u0007\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011%q\u0007\u00011A\u0001B\u0003&A\r\u0003\u0005t\u0001\t\u0007I\u0011\u0001\u0013u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\t)\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0012\u0001\t\u0007I\u0011AA\u0013\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u001d\u0002\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0011!\tI\u0004\u0001Q\u0001\n\u0005M\u0002\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\t)\u0005\u0001Q\u0001\n\u0005}\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011AA*\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r'AF\"mkN$XM\u001d'j].$\u0016m]6NC:\fw-\u001a:\u000b\u0005\u00152\u0013\u0001\u00027j].T!a\n\u0015\u0002\rM,'O^3s\u0015\u0005I\u0013!B6bM.\f7\u0001A\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024m5\tAG\u0003\u00026Q\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0015Ig\u000eZ3y+\u0005Q\u0004CA\u0017<\u0013\tadFA\u0002J]R\fa!\u001b8eKb\u0004\u0013AE2mkN$XM\u001d'j].l\u0015M\\1hKJ\u0004\"\u0001Q!\u000e\u0003\u0011J!A\u0011\u0013\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u000b\u001ak\u0011AJ\u0005\u0003\u000f\u001a\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006!A/[7f!\tQ5+D\u0001L\u0015\t)DJ\u0003\u0002N\u001d\u000611m\\7n_:T!!K(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013A\u0001V5nK\u00061A(\u001b8jiz\"Ra\u0016-Z5n\u0003\"\u0001\u0011\u0001\t\u000ba2\u0001\u0019\u0001\u001e\t\u000by2\u0001\u0019A \t\u000b\r3\u0001\u0019\u0001#\t\u000b!3\u0001\u0019A%\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u00010\u0011\u0005\u0001{\u0016B\u00011%\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002!1|7-\u00197BI6Lgn\u00117jK:$X#\u00013\u0011\u0005\u0001+\u0017B\u00014%\u0005U\u0019E.^:uKJd\u0015N\\6M_\u000e\fG.\u00113nS:\fA\u0003\\8dC2\fE-\\5o\u00072LWM\u001c;`I\u0015\fHCA5m!\ti#.\u0003\u0002l]\t!QK\\5u\u0011\u001di'\"!AA\u0002\u0011\f1\u0001\u001f\u00132\u0003EawnY1m\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\t\u0015\u0003\u0017A\u0004\"!L9\n\u0005It#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001f1|7-\u00197CCR\u001c\u0007.\u00113nS:,\u0012!\u001e\t\u0003\u0001ZL!a\u001e\u0013\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006\u0001Bn\\2bY\n\u000bGo\u00195BI6Lg\u000eI\u0001\u0019G2,8\u000f^3s\u0019&t7\u000eU3sS>$\u0017n\u0019+bg.\u001cX#A>\u0011\u0005\u0001c\u0018BA?%\u0005a\u0019E.^:uKJd\u0015N\\6QKJLw\u000eZ5d)\u0006\u001c8n]\u0001\u001aG2,8\u000f^3s\u0019&t7\u000eU3sS>$\u0017n\u0019+bg.\u001c\b%\u0001\fdYV\u001cH/\u001a:MS:\\7\u000b^8q\u001b&\u0014(o\u001c:t+\t\t\u0019\u0001E\u0002A\u0003\u000bI1!a\u0002%\u0005Y\u0019E.^:uKJd\u0015N\\6Ti>\u0004X*\u001b:s_J\u001c\u0018aF2mkN$XM\u001d'j].\u001cFo\u001c9NSJ\u0014xN]:!\u0003\u0001\u001aG.^:uKJd\u0015N\\6SKZ,'o]3B]\u0012\u001cv/\u00199NSJ\u0014xN]:\u0016\u0005\u0005=\u0001c\u0001!\u0002\u0012%\u0019\u00111\u0003\u0013\u0003A\rcWo\u001d;fe2Kgn\u001b*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'o]\u0001\"G2,8\u000f^3s\u0019&t7NU3wKJ\u001cX-\u00118e'^\f\u0007/T5se>\u00148\u000fI\u0001\u001cG2,8\u000f^3s\u0019&t7nQ8om\u0016\u0014H\u000fV8NSJ\u0014xN]:\u0016\u0005\u0005m\u0001c\u0001!\u0002\u001e%\u0019\u0011q\u0004\u0013\u0003C\rcWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+pa&\u001c7\u000fV8NSJ\u0014xN]:\u00029\rdWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p\u001b&\u0014(o\u001c:tA\u0005A2\r\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004\u0018-\u001b:NSJ\u0014xN]:\u0016\u0005\u0005\u001d\u0002c\u0001!\u0002*%\u0019\u00111\u0006\u0013\u00031\rcWo\u001d;fe2Kgn\u001b*fa\u0006L'/T5se>\u00148/A\rdYV\u001cH/\u001a:MS:\\'+\u001a9bSJl\u0015N\u001d:peN\u0004\u0013AJ2mkN$XM\u001d'j].\u001cE.Z1s'R\f'\u000f^(gMN,Go\u001d$pe6K'O]8sgV\u0011\u00111\u0007\t\u0004\u0001\u0006U\u0012bAA\u001cI\t13\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M]*uCJ$xJ\u001a4tKR\u001chi\u001c:NSJ\u0014xN]:\u0002O\rdWo\u001d;fe2Kgn[\"mK\u0006\u00148\u000b^1si>3gm]3ug\u001a{'/T5se>\u00148\u000fI\u0001(G2,8\u000f^3s\u0019&t7\u000e\u0015:fa\u0006\u0014X\rU3oI&twMU3ti>\u0014X-T5se>\u00148/\u0006\u0002\u0002@A\u0019\u0001)!\u0011\n\u0007\u0005\rCEA\u0014DYV\u001cH/\u001a:MS:\\\u0007K]3qCJ,\u0007+\u001a8eS:<'+Z:u_J,W*\u001b:s_J\u001c\u0018\u0001K2mkN$XM\u001d'j].\u0004&/\u001a9be\u0016\u0004VM\u001c3j]\u001e\u0014Vm\u001d;pe\u0016l\u0015N\u001d:peN\u0004\u0013\u0001E:dQ\u0016$W\u000f\\3s'R\f'\u000f^3e+\t\tY\u0005E\u0002.\u0003\u001bJ1!a\u0014/\u0005\u001d\u0011un\u001c7fC:\f1#\\1zE\u0016\u001cF/\u0019:u'\u000eDW\rZ;mKJ$\u0012AX\u0001\u0016O\u0016$xJ]\"sK\u0006$X\rT8dC2\fE-\\5o)\u0005!\u0017\u0001\u00079s_\u000e,7o]'jeJ|'o\u0015;bi\u0016\u001c\u0005.\u00198hKRI\u0011.!\u0018\u0002x\u0005\u0005\u00151\u0012\u0005\b\u0003?z\u0002\u0019AA1\u0003\u0015!x\u000e]5d!\u0011\t\u0019'!\u001d\u000f\t\u0005\u0015\u0014Q\u000e\t\u0004\u0003OrSBAA5\u0015\r\tYGK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=d&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\n)H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_r\u0003bBA=?\u0001\u0007\u00111P\u0001\f[&\u0014(o\u001c:Ti\u0006$X\rE\u0002A\u0003{J1!a %\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dq!a! \u0001\u0004\t))\u0001\u0005pY\u0012\u001cF/\u0019;f!\u0015i\u0013qQA>\u0013\r\tII\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u00055u\u00041\u0001\u0002\u0010\u0006i1\r\\5f]Rl\u0015M\\1hKJ\u00042\u0001QAI\u0013\r\t\u0019\n\n\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0003E!(/\u00198tSRLwN\\'jeJ|'o]\u000b\u0003\u00033\u0003b!a'\u0002&\u0006-f\u0002BAO\u0003CsA!a\u001a\u0002 &\tq&C\u0002\u0002$:\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\u0006%&aA*fc*\u0019\u00111\u0015\u0018\u0011\u0007\u0001\u000bi+C\u0002\u00020\u0012\u0012Ad\u00117vgR,'\u000fT5oWR\u0013\u0018M\\:ji&|g.T5se>\u00148/\u0001\u000fp]2Kgn[\"p_J$\u0017N\\1u_J\u0014Vm]5h]\u0006$\u0018n\u001c8\u0015\u0007%\f)\fC\u0004\u00028\u0006\u0002\r!!/\u0002\r1Lgn[%e!\u0011\tY,!0\u000e\u00031K1!a0M\u0005\u0011)V/\u001b3\u0002\u0011MDW\u000f\u001e3po:$\u0012!\u001b")
public class ClusterLinkTaskManager
implements Logging {
    private final int index;
    private final ClusterLinkManager clusterLinkManager;
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private volatile ClusterLinkLocalAdmin localAdminClient;
    private final ClusterLinkBatchAdmin localBatchAdmin;
    private final ClusterLinkPeriodicTasks clusterLinkPeriodicTasks;
    private final ClusterLinkStopMirrors clusterLinkStopMirrors;
    private final ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors;
    private final ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors;
    private final ClusterLinkRepairMirrors clusterLinkRepairMirrors;
    private final ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors;
    private final ClusterLinkPreparePendingRestoreMirrors clusterLinkPreparePendingRestoreMirrors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int index() {
        return this.index;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkLocalAdmin localAdminClient() {
        return this.localAdminClient;
    }

    private void localAdminClient_$eq(ClusterLinkLocalAdmin x$1) {
        this.localAdminClient = x$1;
    }

    public ClusterLinkBatchAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    public ClusterLinkPeriodicTasks clusterLinkPeriodicTasks() {
        return this.clusterLinkPeriodicTasks;
    }

    public ClusterLinkStopMirrors clusterLinkStopMirrors() {
        return this.clusterLinkStopMirrors;
    }

    public ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors() {
        return this.clusterLinkReverseAndSwapMirrors;
    }

    public ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors() {
        return this.clusterLinkConvertToMirrors;
    }

    public ClusterLinkRepairMirrors clusterLinkRepairMirrors() {
        return this.clusterLinkRepairMirrors;
    }

    public ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors() {
        return this.clusterLinkClearStartOffsetsForMirrors;
    }

    public ClusterLinkPreparePendingRestoreMirrors clusterLinkPreparePendingRestoreMirrors() {
        return this.clusterLinkPreparePendingRestoreMirrors;
    }

    public boolean schedulerStarted() {
        return this.scheduler().isStarted();
    }

    public ClusterLinkScheduler maybeStartScheduler() {
        if (!this.scheduler().isStarted()) {
            synchronized (this) {
                if (!this.scheduler().isStarted()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Starting scheduler ").append(this.index()).toString());
                    this.scheduler().startup();
                    this.transitionMirrors().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        x$1.startup();
                        return BoxedUnit.UNIT;
                    });
                    this.clusterLinkPeriodicTasks().startup();
                }
            }
        }
        return this.scheduler();
    }

    public ClusterLinkLocalAdmin getOrCreateLocalAdmin() {
        if (this.localAdminClient() == null) {
            synchronized (this) {
                if (this.localAdminClient() == null) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Creating local admin client for scheduler ").append(this.index()).toString());
                    this.localAdminClient_$eq(this.clusterLinkManager.createLocalAdmin(this.maybeStartScheduler(), this.index()));
                }
            }
        }
        return this.localAdminClient();
    }

    public void processMirrorStateChange(String topic, ClusterLinkTopicState mirrorState, Option<ClusterLinkTopicState> oldState, ClusterLinkDestClientManager clientManager) {
        if (!this.clusterLinkManager.metadataManager().isLinkCoordinator(mirrorState.linkName())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("Not starting tasks for mirror state ").append(mirrorState.state()).append(" for topic '").append(topic).append("' since this broker is not the link coordinator for cluster link '").append(mirrorState.linkName()).append("'").toString());
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Processing mirror state ").append(mirrorState.state()).append(" for topic '").append(topic).append("', oldState ").append(oldState).toString());
        this.clusterLinkStopMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkConvertToMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkReverseAndSwapMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkRepairMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkClearStartOffsetsForMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkPreparePendingRestoreMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
    }

    private Seq<ClusterLinkTransitionMirrors> transitionMirrors() {
        return new .colon.colon((Object)this.clusterLinkStopMirrors(), (List)new .colon.colon((Object)this.clusterLinkReverseAndSwapMirrors(), (List)new .colon.colon((Object)this.clusterLinkConvertToMirrors(), (List)new .colon.colon((Object)this.clusterLinkRepairMirrors(), (List)new .colon.colon((Object)this.clusterLinkClearStartOffsetsForMirrors(), (List)new .colon.colon((Object)this.clusterLinkPreparePendingRestoreMirrors(), (List)Nil$.MODULE$))))));
    }

    public void onLinkCoordinatorResignation(Uuid linkId) {
        this.transitionMirrors().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdownTasks(linkId, "coordinator resignation", x$2.shutdownTasks$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Shutting down task manager with scheduler ").append(this.index()).toString());
        this.transitionMirrors().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.transitionMirrors().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdownAllTasks();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkPeriodicTasks().shutdown();
        this.clusterLinkPeriodicTasks().shutdownAllTasks();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.localBatchAdmin()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.localAdminClient()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTaskManager(int index, ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, Time time) {
        ClusterLinkBatchAdmin clusterLinkBatchAdmin;
        void apply_admin;
        this.index = index;
        this.clusterLinkManager = clusterLinkManager;
        this.brokerConfig = brokerConfig;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(35).append("[ClusterLinkTaskManager brokerId=").append(brokerConfig.brokerId()).append("] ").toString());
        this.scheduler = new ClusterLinkScheduler(index, ClusterLinkScheduler$.MODULE$.$lessinit$greater$default$2());
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> $this.clusterLinkManager.brokerMetrics().localAdminRequestTimeSensor();
        Function0 & Serializable & scala.Serializable intersect2 = (Function0 & Serializable & scala.Serializable)() -> $this.clusterLinkManager.brokerMetrics().localAdminQueueTimeSensor();
        ClusterLinkScheduler clusterLinkScheduler = this.scheduler();
        JFunction0.mcI.sp & Serializable & scala.Serializable intersect3 = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminMaxInFlightRequests());
        JFunction0.mcI.sp & Serializable & scala.Serializable intersect4 = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminRequestBatchSize());
        Function0 & Serializable & scala.Serializable intersect5 = (Function0 & Serializable & scala.Serializable)() -> this.getOrCreateLocalAdmin();
        if (ClusterLinkBatchAdmin$.MODULE$ == null) {
            throw null;
        }
        if (Predef$.MODULE$.Integer2int(this.brokerConfig.clusterLinkAdminRequestBatchSize()) <= 1) {
            clusterLinkBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0<ConfluentAdmin>)apply_admin);
        } else {
            void apply_requestTimeSensor;
            void apply_queueTimeSensor;
            void apply_maxInFlight;
            void apply_adminBatchSize;
            void apply_scheduler;
            if (apply_scheduler == null) {
                throw new IllegalArgumentException("Scheduler must be provided for batching admin");
            }
            clusterLinkBatchAdmin = new ClusterLinkBatchingAdmin((Function0<ConfluentAdmin>)apply_admin, (Function0<Object>)apply_adminBatchSize, (Function0<Object>)apply_maxInFlight, (ClusterLinkScheduler)apply_scheduler, time, (Function0<Sensor>)apply_queueTimeSensor, (Function0<Sensor>)apply_requestTimeSensor);
        }
        this.localBatchAdmin = clusterLinkBatchAdmin;
        this.clusterLinkPeriodicTasks = new ClusterLinkPeriodicTasks(brokerConfig, clusterLinkManager, this.scheduler(), time);
        this.clusterLinkStopMirrors = new ClusterLinkStopMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkStopMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkReverseAndSwapMirrors = new ClusterLinkReverseAndSwapMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkReverseAndSwapMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkConvertToMirrors = new ClusterLinkConvertTopicsToMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkConvertTopicsToMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkRepairMirrors = new ClusterLinkRepairMirrors(brokerConfig, clusterLinkManager, this.scheduler(), this.localBatchAdmin(), time, ClusterLinkRepairMirrors$.MODULE$.$lessinit$greater$default$6());
        this.clusterLinkClearStartOffsetsForMirrors = new ClusterLinkClearStartOffsetsForMirrors(brokerConfig, clusterLinkManager, this.scheduler(), this.localBatchAdmin(), time, ClusterLinkClearStartOffsetsForMirrors$.MODULE$.$lessinit$greater$default$6());
        this.clusterLinkPreparePendingRestoreMirrors = new ClusterLinkPreparePendingRestoreMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkPreparePendingRestoreMirrors$.MODULE$.$lessinit$greater$default$5());
    }
}

