/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.yammer.metrics.core.Histogram;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerServerMetrics$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u001c9\u0005}B\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t1\u0002\u0011\t\u0011)A\u00053\")q\f\u0001C\u0005A\"9Q\r\u0001b\u0001\n\u00131\u0007B\u0002:\u0001A\u0003%q\rC\u0004t\u0001\t\u0007I\u0011\u0002;\t\ra\u0004\u0001\u0015!\u0003v\u0011\u001dI\bA1A\u0005\n\u0019DaA\u001f\u0001!\u0002\u00139\u0007bB>\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007y\u0002\u0001\u000b\u0011B;\t\u000fu\u0004!\u0019!C\u0001}\"9\u0011q\u0004\u0001!\u0002\u0013y\b\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0015\u0002\"CA\u0017\u0001\t\u0007I\u0011AA\u0012\u0011!\ty\u0003\u0001Q\u0001\n\u0005\u0015\u0002\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I\u0011AA\u001a\u0011!\ty\u0004\u0001Q\u0001\n\u0005U\u0002\"CA!\u0001\t\u0007I\u0011AA\u001a\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005U\u0002\"CA#\u0001\t\u0007I\u0011AA\u001a\u0011!\t9\u0005\u0001Q\u0001\n\u0005U\u0002\"CA%\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA\u001a\u0011!\ty\u0005\u0001Q\u0001\n\u0005U\u0002\"CA)\u0001\t\u0007I\u0011AA\u001a\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005U\u0002\"CA+\u0001\t\u0007I\u0011AA\u001a\u0011!\t9\u0006\u0001Q\u0001\n\u0005U\u0002\"CA-\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0006\u0001Q\u0001\n\u0005U\u0002\"CA/\u0001\t\u0007I\u0011AA0\u0011!\t9\u0007\u0001Q\u0001\n\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002 \u001e9\u00111\u0015\u001d\t\u0002\u0005\u0015fAB\u001c9\u0011\u0003\t9\u000b\u0003\u0004`[\u0011\u0005\u0011q\u0016\u0005\n\u0003ck#\u0019!C\u0005\u0003gC\u0001\"a/.A\u0003%\u0011Q\u0017\u0005\b\u0003{kC\u0011BA`\r\u0019\tY/\f\u0004\u0002n\"Q\u0011q\u0019\u001a\u0003\u0002\u0003\u0006I!a?\t\r}\u0013D\u0011AA\u007f\u0011\u001d\u0011)A\rC!\u0005\u000fAqAa\u0006.\t\u0003\u0011IBA\nCe>\\WM]*feZ,'/T3ue&\u001c7O\u0003\u0002:u\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002<y\u000511/\u001a:wKJT\u0011!P\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\t\u0013\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001\\1oO*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0019y%M[3diB\u0011\u0011)S\u0005\u0003\u0015\n\u0013Q\"Q;u_\u000ecwn]3bE2,\u0017aB7fiJL7m\u001d\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u0017>S!\u0001U)\u0002\r\r|W.\\8o\u0015\ti$K\u0003\u0002T)\u00061\u0011\r]1dQ\u0016T\u0011!V\u0001\u0004_J<\u0017BA,O\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0011!,X\u0007\u00027*\u0011AlT\u0001\u0006kRLGn]\u0005\u0003=n\u0013A\u0001V5nK\u00061A(\u001b8jiz\"2!Y2e!\t\u0011\u0007!D\u00019\u0011\u0015Y5\u00011\u0001M\u0011\u0015A6\u00011\u0001Z\u0003m\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u0011&\u001cHOT1nKV\tq\r\u0005\u0002ia6\t\u0011N\u0003\u0002kW\u0006!1m\u001c:f\u0015\tYEN\u0003\u0002n]\u00061\u00110Y7nKJT\u0011a\\\u0001\u0004G>l\u0017BA9j\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u001dE\u0006$8\r\u001b)s_\u000e,7o]5oORKW.\u001a%jgRt\u0015-\\3!\u0003]\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u0011&\u001cH/F\u0001v!\tAg/\u0003\u0002xS\nI\u0001*[:u_\u001e\u0014\u0018-\\\u0001\u0019E\u0006$8\r\u001b)s_\u000e,7o]5oORKW.\u001a%jgR\u0004\u0013!\u00052bi\u000eD7+\u001b>f\u0011&\u001cHOT1nK\u0006\u0011\"-\u0019;dQNK'0\u001a%jgRt\u0015-\\3!\u00035\u0011\u0017\r^2i'&TX\rS5ti\u0006q!-\u0019;dQNK'0\u001a%jgR\u0004\u0013A\u00077bgR\f\u0005\u000f\u001d7jK\u0012LU.Y4f!J|g/\u001a8b]\u000e,W#A@\u0011\r\u0005\u0005\u0011qBA\n\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB1u_6L7M\u0003\u0003\u0002\n\u0005-\u0011AC2p]\u000e,(O]3oi*\u0019\u0011Q\u0002#\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\t\u0019AA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r#\u0006)\u0011.\\1hK&!\u0011QDA\f\u0005IiU\r^1eCR\f\u0007K]8wK:\fgnY3\u000271\f7\u000f^!qa2LW\rZ%nC\u001e,\u0007K]8wK:\fgnY3!\u0003YiW\r^1eCR\fGj\\1e\u000bJ\u0014xN]\"pk:$XCAA\u0013!\u0011\t\t!a\n\n\t\u0005%\u00121\u0001\u0002\u000b\u0003R|W.[2M_:<\u0017aF7fi\u0006$\u0017\r^1M_\u0006$WI\u001d:pe\u000e{WO\u001c;!\u0003]iW\r^1eCR\f\u0017\t\u001d9ms\u0016\u0013(o\u001c:D_VtG/\u0001\rnKR\fG-\u0019;b\u0003B\u0004H._#se>\u00148i\\;oi\u0002\n1\u0004\\1ti\u0006\u0003\b\u000f\\5fIJ+7m\u001c:e\u001f\u001a47/\u001a;OC6,WCAA\u001b!\u0011\t9$!\u000f\u000e\u0003=K!!](\u000291\f7\u000f^!qa2LW\r\u001a*fG>\u0014Hm\u00144gg\u0016$h*Y7fA\u0005qB.Y:u\u0003B\u0004H.[3e%\u0016\u001cwN\u001d3US6,7\u000f^1na:\u000bW.Z\u0001 Y\u0006\u001cH/\u00119qY&,GMU3d_J$G+[7fgR\fW\u000e\u001d(b[\u0016\u0004\u0013A\u00077bgR\f\u0005\u000f\u001d7jK\u0012\u0014VmY8sI2\u000bw-T:OC6,\u0017a\u00077bgR\f\u0005\u000f\u001d7jK\u0012\u0014VmY8sI2\u000bw-T:OC6,\u0007%\u0001\u000enKR\fG-\u0019;b\u0019>\fG-\u0012:s_J\u001cu.\u001e8u\u001d\u0006lW-A\u000enKR\fG-\u0019;b\u0019>\fG-\u0012:s_J\u001cu.\u001e8u\u001d\u0006lW\rI\u0001\u001c[\u0016$\u0018\rZ1uC\u0006\u0003\b\u000f\\=FeJ|'oQ8v]Rt\u0015-\\3\u000295,G/\u00193bi\u0006\f\u0005\u000f\u001d7z\u000bJ\u0014xN]\"pk:$h*Y7fA\u0005\u0001C.Y:u\u0003B\u0004H.[3e\u00136\fw-\u001a'bi\u0016t7-_'t\u001b\u0006Dh*Y7f\u0003\u0005b\u0017m\u001d;BaBd\u0017.\u001a3J[\u0006<W\rT1uK:\u001c\u00170T:NCbt\u0015-\\3!\u0003)b\u0017m\u001d;BaBd\u0017.\u001a3J[\u0006<W\rT1uK:\u001c\u00170T::se\u0002VM]2f]RLG.\u001a(b[\u0016\f1\u0006\\1ti\u0006\u0003\b\u000f\\5fI&k\u0017mZ3MCR,gnY=NgfJ\u0014\bU3sG\u0016tG/\u001b7f\u001d\u0006lW\rI\u0001*Y\u0006\u001cH/\u00119qY&,G-S7bO\u0016d\u0015\r^3oGfl5/O\u001dQKJ\u001cWM\u001c;jY\u0016t\u0015-\\3\u0002U1\f7\u000f^!qa2LW\rZ%nC\u001e,G*\u0019;f]\u000eLXj]\u001d:!\u0016\u00148-\u001a8uS2,g*Y7fA\u0005IC.Y:u\u0003B\u0004H.[3e\u00136\fw-\u001a'bi\u0016t7-_'tkA\u0002VM]2f]RLG.\u001a(b[\u0016\f!\u0006\\1ti\u0006\u0003\b\u000f\\5fI&k\u0017mZ3MCR,gnY=NgV\u0002\u0004+\u001a:dK:$\u0018\u000e\\3OC6,\u0007%A\u000fmCN$\u0018\t\u001d9mS\u0016$\u0017*\\1hK2\u000bG/\u001a8dsN+gn]8s+\t\t\t\u0007E\u0002N\u0003GJ1!!\u001aO\u0005\u0019\u0019VM\\:pe\u0006qB.Y:u\u0003B\u0004H.[3e\u00136\fw-\u001a'bi\u0016t7-_*f]N|'\u000fI\u0001\u0006G2|7/\u001a\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0003\u0003g\nQa]2bY\u0006LA!a\u001e\u0002r\t!QK\\5u\u0003e)\b\u000fZ1uK\n\u000bGo\u00195Qe>\u001cWm]:j]\u001e$\u0016.\\3\u0015\t\u00055\u0014Q\u0010\u0005\b\u0003\u007f:\u0003\u0019AAA\u0003%)G.\u00199tK\u0012t5\u000f\u0005\u0003\u0002p\u0005\r\u0015\u0002BAC\u0003c\u0012A\u0001T8oO\u0006yQ\u000f\u001d3bi\u0016\u0014\u0015\r^2i'&TX\r\u0006\u0003\u0002n\u0005-\u0005bBAGQ\u0001\u0007\u0011qR\u0001\u0005g&TX\r\u0005\u0003\u0002p\u0005E\u0015\u0002BAJ\u0003c\u00121!\u00138u\u0003\u0001*\b\u000fZ1uK2\u000b7\u000f^!qa2LW\rZ%nC\u001e,\u0007K]8wK:\fgnY3\u0015\t\u00055\u0014\u0011\u0014\u0005\b\u00037K\u0003\u0019AA\n\u0003)\u0001(o\u001c<f]\u0006t7-Z\u0001\u0012Y\u0006\u001cH/\u00119qY&,Gm\u00144gg\u0016$HCAAA\u0003Qa\u0017m\u001d;BaBd\u0017.\u001a3US6,7\u000f^1na\u0006\u0019\"I]8lKJ\u001cVM\u001d<fe6+GO]5dgB\u0011!-L\n\u0004[\u0005%\u0006\u0003BA8\u0003WKA!!,\u0002r\t1\u0011I\\=SK\u001a$\"!!*\u0002\u001f5,GO]5d\u000fJ|W\u000f\u001d(b[\u0016,\"!!.\u0011\u0007\u0005\u000b9,C\u0002\u0002:\n\u0013aa\u0015;sS:<\u0017\u0001E7fiJL7m\u0012:pkBt\u0015-\\3!\u0003%\tG\rZ'fiJL7-\u0006\u0003\u0002B\u0006MGCBAb\u0003K\f9\u000f\u0006\u0003\u0002n\u0005\u0015\u0007bBAdc\u0001\u0007\u0011\u0011Z\u0001\u0005MVt7\r\u0005\u0005\u0002p\u0005-\u0017\u0011QAh\u0013\u0011\ti-!\u001d\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAi\u0003'd\u0001\u0001B\u0004\u0002VF\u0012\r!a6\u0003\u0003Q\u000bB!!7\u0002`B!\u0011qNAn\u0013\u0011\ti.!\u001d\u0003\u000f9{G\u000f[5oOB!\u0011qNAq\u0013\u0011\t\u0019/!\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003Lc\u0001\u0007A\nC\u0004\u0002jF\u0002\r!!\u000e\u0002\t9\fW.\u001a\u0002\n\rVt7mR1vO\u0016,B!a<\u0002zN!!\u0007QAy!\u0015i\u00151_A|\u0013\r\t)P\u0014\u0002\u0006\u000f\u0006,x-\u001a\t\u0005\u0003#\fI\u0010B\u0004\u0002VJ\u0012\r!a6\u0011\u0011\u0005=\u00141ZAA\u0003o$B!a@\u0003\u0004A)!\u0011\u0001\u001a\u0002x6\tQ\u0006C\u0004\u0002HR\u0002\r!a?\u0002\u000bY\fG.^3\u0015\r\u0005](\u0011\u0002B\n\u0011\u001d\u0011Y!\u000ea\u0001\u0005\u001b\taaY8oM&<\u0007cA'\u0003\u0010%\u0019!\u0011\u0003(\u0003\u00195+GO]5d\u0007>tg-[4\t\u000f\tUQ\u00071\u0001\u0002\u0002\u0006\u0019an\\<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u0014YB!\b\t\u000b-3\u0004\u0019\u0001'\t\u000ba3\u0004\u0019A-")
public final class BrokerServerMetrics
implements AutoCloseable {
    private final Metrics metrics;
    private final Time time;
    private final com.yammer.metrics.core.MetricName batchProcessingTimeHistName;
    private final Histogram batchProcessingTimeHist;
    private final com.yammer.metrics.core.MetricName batchSizeHistName;
    private final Histogram batchSizeHist;
    private final AtomicReference<MetadataProvenance> lastAppliedImageProvenance;
    private final AtomicLong metadataLoadErrorCount;
    private final AtomicLong metadataApplyErrorCount;
    private final MetricName lastAppliedRecordOffsetName;
    private final MetricName lastAppliedRecordTimestampName;
    private final MetricName lastAppliedRecordLagMsName;
    private final MetricName metadataLoadErrorCountName;
    private final MetricName metadataApplyErrorCountName;
    private final MetricName lastAppliedImageLatencyMsMaxName;
    private final MetricName lastAppliedImageLatencyMs999PercentileName;
    private final MetricName lastAppliedImageLatencyMs99PercentileName;
    private final MetricName lastAppliedImageLatencyMs50PercentileName;
    private final Sensor lastAppliedImageLatencySensor;

    public static BrokerServerMetrics apply(Metrics metrics, Time time) {
        return BrokerServerMetrics$.MODULE$.apply(metrics, time);
    }

    private com.yammer.metrics.core.MetricName batchProcessingTimeHistName() {
        return this.batchProcessingTimeHistName;
    }

    private Histogram batchProcessingTimeHist() {
        return this.batchProcessingTimeHist;
    }

    private com.yammer.metrics.core.MetricName batchSizeHistName() {
        return this.batchSizeHistName;
    }

    private Histogram batchSizeHist() {
        return this.batchSizeHist;
    }

    public AtomicReference<MetadataProvenance> lastAppliedImageProvenance() {
        return this.lastAppliedImageProvenance;
    }

    public AtomicLong metadataLoadErrorCount() {
        return this.metadataLoadErrorCount;
    }

    public AtomicLong metadataApplyErrorCount() {
        return this.metadataApplyErrorCount;
    }

    public MetricName lastAppliedRecordOffsetName() {
        return this.lastAppliedRecordOffsetName;
    }

    public MetricName lastAppliedRecordTimestampName() {
        return this.lastAppliedRecordTimestampName;
    }

    public MetricName lastAppliedRecordLagMsName() {
        return this.lastAppliedRecordLagMsName;
    }

    public MetricName metadataLoadErrorCountName() {
        return this.metadataLoadErrorCountName;
    }

    public MetricName metadataApplyErrorCountName() {
        return this.metadataApplyErrorCountName;
    }

    public MetricName lastAppliedImageLatencyMsMaxName() {
        return this.lastAppliedImageLatencyMsMaxName;
    }

    public MetricName lastAppliedImageLatencyMs999PercentileName() {
        return this.lastAppliedImageLatencyMs999PercentileName;
    }

    public MetricName lastAppliedImageLatencyMs99PercentileName() {
        return this.lastAppliedImageLatencyMs99PercentileName;
    }

    public MetricName lastAppliedImageLatencyMs50PercentileName() {
        return this.lastAppliedImageLatencyMs50PercentileName;
    }

    public Sensor lastAppliedImageLatencySensor() {
        return this.lastAppliedImageLatencySensor;
    }

    @Override
    public void close() {
        KafkaYammerMetrics.defaultRegistry().removeMetric(this.batchProcessingTimeHistName());
        KafkaYammerMetrics.defaultRegistry().removeMetric(this.batchSizeHistName());
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{this.lastAppliedRecordOffsetName(), this.lastAppliedRecordTimestampName(), this.lastAppliedRecordLagMsName(), this.metadataLoadErrorCountName(), this.metadataApplyErrorCountName(), this.lastAppliedImageLatencyMsMaxName(), this.lastAppliedImageLatencyMs999PercentileName(), this.lastAppliedImageLatencyMs99PercentileName(), this.lastAppliedImageLatencyMs50PercentileName()})).foreach((Function1 & Serializable & scala.Serializable)x$1 -> $this.metrics.removeMetric(x$1));
    }

    public void updateBatchProcessingTime(long elapsedNs) {
        this.batchProcessingTimeHist().update(TimeUnit.NANOSECONDS.toMicros(elapsedNs));
    }

    public void updateBatchSize(int size) {
        this.batchSizeHist().update(size);
    }

    public void updateLastAppliedImageProvenance(MetadataProvenance provenance) {
        this.lastAppliedImageProvenance().set(provenance);
        long now = this.time.milliseconds();
        this.lastAppliedImageLatencySensor().record((double)(now - provenance.lastContainedLogTimeMs()), now);
    }

    public long lastAppliedOffset() {
        return this.lastAppliedImageProvenance().get().lastContainedOffset();
    }

    public long lastAppliedTimestamp() {
        return this.lastAppliedImageProvenance().get().lastContainedLogTimeMs();
    }

    /*
     * WARNING - void declaration
     */
    public BrokerServerMetrics(Metrics metrics, Time time) {
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_func;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_name;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_func2;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_name2;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_func3;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_name3;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_func4;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_name4;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_func5;
        void kafka$server$metadata$BrokerServerMetrics$$addMetric_name5;
        void var3_3;
        this.metrics = metrics;
        this.time = time;
        this.batchProcessingTimeHistName = KafkaMetricsGroup.explicitMetricName((String)"kafka.server", (String)"BrokerMetadataListener", (String)"MetadataBatchProcessingTimeUs", Collections.emptyMap());
        this.batchProcessingTimeHist = KafkaYammerMetrics.defaultRegistry().newHistogram(this.batchProcessingTimeHistName(), true);
        this.batchSizeHistName = KafkaMetricsGroup.explicitMetricName((String)"kafka.server", (String)"BrokerMetadataListener", (String)"MetadataBatchSizes", Collections.emptyMap());
        this.batchSizeHist = KafkaYammerMetrics.defaultRegistry().newHistogram(this.batchSizeHistName(), true);
        this.lastAppliedImageProvenance = new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY);
        this.metadataLoadErrorCount = new AtomicLong(0L);
        this.metadataApplyErrorCount = new AtomicLong(0L);
        this.lastAppliedRecordOffsetName = metrics.metricName("last-applied-record-offset", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The offset of the last record from the cluster metadata partition that was applied by the broker");
        this.lastAppliedRecordTimestampName = metrics.metricName("last-applied-record-timestamp", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The timestamp of the last record from the cluster metadata partition that was applied by the broker");
        this.lastAppliedRecordLagMsName = metrics.metricName("last-applied-record-lag-ms", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The difference between now and the timestamp of the last record from the cluster metadata partition that was applied by the broker");
        this.metadataLoadErrorCountName = metrics.metricName("metadata-load-error-count", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The number of errors encountered by the BrokerMetadataListener while loading the metadata log and generating a new MetadataDelta based on it.");
        this.metadataApplyErrorCountName = metrics.metricName("metadata-apply-error-count", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The number of errors encountered by the BrokerMetadataPublisher while applying a new MetadataImage based on the latest MetadataDelta.");
        this.lastAppliedImageLatencyMsMaxName = metrics.metricName("last-applied-image-latency-ms-max", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The max apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs999PercentileName = metrics.metricName("last-applied-image-latency-ms-999percentile", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The p999 apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs99PercentileName = metrics.metricName("last-applied-image-latency-ms-99percentile", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The p99 apply latency of the last image from the cluster metadata partition.");
        this.lastAppliedImageLatencyMs50PercentileName = metrics.metricName("last-applied-image-latency-ms-50percentile", BrokerServerMetrics$.MODULE$.kafka$server$metadata$BrokerServerMetrics$$metricGroupName(), "The p50 apply latency of the last image from the cluster metadata partition.");
        Sensor sensor = metrics.sensor("last-applied-image-latency");
        sensor.add(this.lastAppliedImageLatencyMsMaxName(), (MeasurableStat)new Max());
        Percentile lastAppliedRecordLatencyMs50Percentile = new Percentile(this.lastAppliedImageLatencyMs50PercentileName(), 50.0);
        Percentile lastAppliedRecordLatencyMs99Percentile = new Percentile(this.lastAppliedImageLatencyMs99PercentileName(), 99.0);
        Percentile lastAppliedRecordLatencyMs999Percentile = new Percentile(this.lastAppliedImageLatencyMs999PercentileName(), 99.9);
        int maxTotalTimeMs = 30000;
        int totalBucketSizeInBytes = maxTotalTimeMs * 4;
        Percentiles lastAppliedRecordLatencyMsPercentiles = new Percentiles(totalBucketSizeInBytes, (double)maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{lastAppliedRecordLatencyMs50Percentile, lastAppliedRecordLatencyMs99Percentile, lastAppliedRecordLatencyMs999Percentile});
        sensor.add((CompoundStat)lastAppliedRecordLatencyMsPercentiles);
        this.lastAppliedImageLatencySensor = var3_3;
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$1 -> this.lastAppliedImageProvenance().get().lastContainedOffset();
        MetricName metricName = this.lastAppliedRecordOffsetName();
        if (BrokerServerMetrics$.MODULE$ == null) {
            throw null;
        }
        metrics.addMetric((MetricName)kafka$server$metadata$BrokerServerMetrics$$addMetric_name5, new FuncGauge(kafka$server$metadata$BrokerServerMetrics$$addMetric_func5));
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect2 = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> this.lastAppliedImageProvenance().get().lastContainedLogTimeMs();
        MetricName metricName2 = this.lastAppliedRecordTimestampName();
        if (BrokerServerMetrics$.MODULE$ == null) {
            throw null;
        }
        metrics.addMetric((MetricName)kafka$server$metadata$BrokerServerMetrics$$addMetric_name4, new FuncGauge(kafka$server$metadata$BrokerServerMetrics$$addMetric_func4));
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect3 = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)now -> now - this.lastAppliedImageProvenance().get().lastContainedLogTimeMs();
        MetricName metricName3 = this.lastAppliedRecordLagMsName();
        if (BrokerServerMetrics$.MODULE$ == null) {
            throw null;
        }
        metrics.addMetric((MetricName)kafka$server$metadata$BrokerServerMetrics$$addMetric_name3, new FuncGauge(kafka$server$metadata$BrokerServerMetrics$$addMetric_func3));
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect4 = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$3 -> this.metadataLoadErrorCount().get();
        MetricName metricName4 = this.metadataLoadErrorCountName();
        if (BrokerServerMetrics$.MODULE$ == null) {
            throw null;
        }
        metrics.addMetric((MetricName)kafka$server$metadata$BrokerServerMetrics$$addMetric_name2, new FuncGauge(kafka$server$metadata$BrokerServerMetrics$$addMetric_func2));
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect5 = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$4 -> this.metadataApplyErrorCount().get();
        MetricName metricName5 = this.metadataApplyErrorCountName();
        if (BrokerServerMetrics$.MODULE$ == null) {
            throw null;
        }
        metrics.addMetric((MetricName)kafka$server$metadata$BrokerServerMetrics$$addMetric_name, new FuncGauge(kafka$server$metadata$BrokerServerMetrics$$addMetric_func));
    }

    private static final class FuncGauge<T>
    implements Gauge<T> {
        private final Function1<Object, T> func;

        public T value(MetricConfig config, long now) {
            return (T)this.func.apply((Object)BoxesRunTime.boxToLong((long)now));
        }

        public FuncGauge(Function1<Object, T> func) {
            this.func = func;
        }
    }
}

