/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kafka.server.DelayedOperationKey;
import kafka.tier.TierUnfetchedTimestampAndOffset;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.OffsetIndexFetchRequest;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import kafka.tier.fetcher.TierFetcherMetrics;
import kafka.tier.fetcher.TimestampIndexFetchRequest;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.TimestampOffset;

public class PendingOffsetForTimestampSync
extends PendingOffsetForTimestamp {
    PendingOffsetForTimestampSync(CancellationContext cancellationContext, TierObjectStore tierObjectStore, Map<TopicPartition, TierUnfetchedTimestampAndOffset> timestamps, Optional<TierFetcherMetrics> tierFetcherMetrics, Consumer<DelayedOperationKey> fetchCompletionCallback, Time time, Consumer<Runnable> fetchCancellationCallback) {
        super(cancellationContext, tierObjectStore, timestamps, tierFetcherMetrics, fetchCompletionCallback, time, Uuid.randomUuid(), "PendingOffsetForTimestampSync(%s)", fetchCancellationCallback);
    }

    @Override
    public void run() {
        log.debug("Starting offsetForTimestamp. requestId={}, timestamps={}.", (Object)this.requestId, (Object)this.timestamps);
        long executionStartTimeMs = this.time.hiResClockMs();
        long queuedTimeMs = executionStartTimeMs - this.creationTimeMs;
        this.tierFetcherMetrics.ifPresent(metrics -> metrics.queuedTimeMs().record((double)queuedTimeMs));
        for (Map.Entry entry : this.timestamps.entrySet()) {
            TopicPartition topicPartition = (TopicPartition)entry.getKey();
            TierUnfetchedTimestampAndOffset tierTimestampAndOffset = (TierUnfetchedTimestampAndOffset)entry.getValue();
            ObjectMetadata objectMetadata = tierTimestampAndOffset.metadata;
            long targetTimestamp = tierTimestampAndOffset.timestamp;
            try {
                if (!this.fetchable(topicPartition)) continue;
                TimestampOffset indexOffsetTimestamp = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)this.cancellationContext, (TierObjectStore)this.tierObjectStore, (ObjectMetadata)objectMetadata, (long)targetTimestamp).startTimestampOffset;
                if (!this.fetchable(topicPartition)) continue;
                OffsetPosition offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)this.cancellationContext, (TierObjectStore)this.tierObjectStore, (ObjectMetadata)objectMetadata, (long)indexOffsetTimestamp.offset).startOffsetPosition;
                if (!this.fetchable(topicPartition)) continue;
                TierObjectStoreResponse response = this.tierObjectStore.getObjectStoreFragment(objectMetadata, FragmentType.SEGMENT, Long.valueOf(offsetPosition.position));
                Throwable throwable = null;
                try {
                    Optional<Long> offsetOpt = this.reader.offsetForTimestamp(this.cancellationContext, response.getInputStream(), targetTimestamp, tierTimestampAndOffset.objectSize);
                    this.putOffsetResult(topicPartition, offsetOpt, targetTimestamp);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Exception e) {
                this.handlePartitionError(topicPartition, tierTimestampAndOffset, e);
            }
        }
        long timeTakenMs = this.time.hiResClockMs() - executionStartTimeMs;
        this.tierFetcherMetrics.ifPresent(metrics -> metrics.fetchOffsetForTimestampTotalTimeMs().record((double)timeTakenMs));
        String logMsg = String.format("Complete PendingOffsetForTimestampSync for %d partitions, requestId=%s, queuedTimeMs=%d, executionTimeMs=%d", this.results.size(), this.requestId.toString(), queuedTimeMs, timeTakenMs);
        if (timeTakenMs > 5000L) {
            log.info(logMsg);
        } else {
            log.debug(logMsg);
        }
        this.complete();
    }
}

