/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import kafka.log.MergedLog;
import kafka.tier.state.FileTierPartitionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTierPartitionStateUploadObject {
    private static final Logger log = LoggerFactory.getLogger(FileTierPartitionStateUploadObject.class);
    private static final String DELIMITER = "_";
    private final String baseName;
    private final Algorithm checksumAlgorithm;

    public FileTierPartitionStateUploadObject(String baseName, Algorithm checksumAlgorithm) {
        this.baseName = baseName;
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public String encodeRecoveryUploadName() {
        return FileTierPartitionState.recoveryUploadFilePath(this.baseName, this.checksumAlgorithm).toString();
    }

    public Path getRecoveryUploadPath(String rootDir) {
        return Paths.get(rootDir, new String[0]).resolve(this.encodeRecoveryUploadName());
    }

    public static boolean isRecoveryUploadFile(String fileName) {
        return fileName.contains(MergedLog.TierStateSuffix() + FileTierPartitionState.StateFileType.RECOVERY_UPLOAD.suffix);
    }

    public static FileTierPartitionStateUploadObject decodeUploadName(String fileName) {
        if (!FileTierPartitionStateUploadObject.isRecoveryUploadFile(fileName)) {
            throw new IllegalArgumentException(fileName + " does not contain `.tierstate.recovery-upload` as part of name");
        }
        String[] suffixArr = fileName.split(FileTierPartitionState.StateFileType.RECOVERY_UPLOAD.suffix);
        if (suffixArr.length > 2) {
            throw new IllegalArgumentException(fileName + " contains multiple `.recovery-upload` as part of name");
        }
        String checksumSuffix = "";
        if (suffixArr.length == 2) {
            checksumSuffix = suffixArr[1];
        }
        Algorithm checksumAlgorithm = Algorithm.toAlgorithm((String)checksumSuffix);
        return new FileTierPartitionStateUploadObject(suffixArr[0], checksumAlgorithm);
    }

    public static void cleanupRecoveryUploads(String logDirPath, boolean checksumEnabled) throws IOException {
        Algorithm algorithm = checksumEnabled ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
        Path basePathInst = Paths.get(logDirPath, new String[0]);
        ArrayList<Path> partitionLogDirs = new ArrayList<Path>();
        try (DirectoryStream stream = FilesWrapper.newDirectoryStream((Path)basePathInst);){
            for (Path path : stream) {
                if (!path.toFile().isDirectory()) continue;
                partitionLogDirs.add(path);
            }
        }
        for (Path partitionLogDir : partitionLogDirs) {
            String basePath = MergedLog.tierStateFile(partitionLogDir.toFile(), 0L, "").toString();
            Path recoveryUploadPath = FileTierPartitionState.recoveryUploadFilePath(basePath, algorithm);
            try {
                FilesWrapper.deleteIfExists((Path)recoveryUploadPath);
            }
            catch (IOException e) {
                log.error("Failed to delete recovery upload file: " + recoveryUploadPath, (Throwable)e);
                throw e;
            }
        }
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public String baseName() {
        return this.baseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTierPartitionStateUploadObject that = (FileTierPartitionStateUploadObject)o;
        return this.baseName.equals(that.baseName) && this.checksumAlgorithm == that.checksumAlgorithm;
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.checksumAlgorithm);
    }

    public String toString() {
        return "FileTierPartitionStateUploadObject{baseName=" + this.baseName + ", checksumAlgorithm=" + this.checksumAlgorithm + '}';
    }
}

