/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import kafka.tier.store.objects.ObjectType;

public class FragmentLocation {
    private final String objectPath;
    private final ObjectType objectType;
    private final long startByteOffset;
    private final Long endByteOffsetExclusive;

    public FragmentLocation(String objectPath, ObjectType objectType) {
        this(objectPath, objectType, 0L, null);
    }

    public FragmentLocation(String objectPath, ObjectType objectType, long startByteOffset, Long endByteOffsetExclusive) {
        if (startByteOffset < 0L) {
            throw new IllegalArgumentException(String.format("startByteOffset must be non-negative. startByteOffset: %d", startByteOffset));
        }
        if (endByteOffsetExclusive != null && endByteOffsetExclusive < startByteOffset) {
            throw new IllegalArgumentException(String.format("endOffset, when specified, cannot be less than startByteOffset. endByteOffsetExclusive: %d, startByteOffset: %d", endByteOffsetExclusive, startByteOffset));
        }
        if (!objectType.suffix().equals(ObjectType.getObjectTypeSuffix(objectPath))) {
            throw new IllegalArgumentException(String.format("suffix of objectType and objectPath must match,objectPath: %s, objectType: %s", objectPath, objectType.name()));
        }
        this.objectPath = objectPath;
        this.objectType = objectType;
        this.startByteOffset = startByteOffset;
        this.endByteOffsetExclusive = endByteOffsetExclusive;
    }

    public String objectPath() {
        return this.objectPath;
    }

    public ObjectType objectType() {
        return this.objectType;
    }

    public long startByteOffset() {
        return this.startByteOffset;
    }

    public Optional<Long> endByteOffsetExclusive() {
        return Optional.ofNullable(this.endByteOffsetExclusive);
    }

    public long toByteOffsetStartInObject(@Nullable Long relativeByteOffsetStart) {
        if (relativeByteOffsetStart != null && relativeByteOffsetStart < 0L) {
            throw new IllegalArgumentException(String.format("relativeByteOffsetStart cannot be negative, relativeByteOffsetStart = %d", relativeByteOffsetStart));
        }
        if (relativeByteOffsetStart != null && relativeByteOffsetStart > this.endByteOffsetExclusive().orElse(Long.MAX_VALUE) - this.startByteOffset()) {
            throw new IllegalArgumentException(String.format("Illegal relative start offset value %d greater than or equal to the size of the fragment %d", relativeByteOffsetStart, this.endByteOffsetExclusive().orElse(Long.MAX_VALUE) - this.startByteOffset()));
        }
        return relativeByteOffsetStart != null ? this.startByteOffset() + relativeByteOffsetStart : this.startByteOffset();
    }

    public Long toByteOffsetEndExclusiveInObject(@Nullable Long relativeByteOffsetEndExclusive) {
        if (relativeByteOffsetEndExclusive != null && relativeByteOffsetEndExclusive < 0L) {
            throw new IllegalArgumentException(String.format("relativeByteOffsetEndExclusive cannot be negative, relativeByteOffsetEndExclusive = %d", relativeByteOffsetEndExclusive));
        }
        return relativeByteOffsetEndExclusive != null ? Long.valueOf(this.boundEndOffsetExclusive(relativeByteOffsetEndExclusive + this.startByteOffset())) : (Long)this.endByteOffsetExclusive().orElse(null);
    }

    private long boundEndOffsetExclusive(long offset) {
        return Math.min(offset, this.endByteOffsetExclusive().orElse(Long.MAX_VALUE));
    }

    public String toString() {
        return String.format("FragmentLocation(objectPath = %s, startByteOffset = %d,endByteOffsetExclusive = %s)", this.objectPath(), this.startByteOffset(), this.endByteOffsetExclusive());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentLocation that = (FragmentLocation)o;
        return Objects.equals(this.objectPath(), that.objectPath()) && this.startByteOffset() == that.startByteOffset() && Objects.equals(this.endByteOffsetExclusive(), that.endByteOffsetExclusive());
    }

    public int hashCode() {
        return Objects.hash(this.objectPath(), this.startByteOffset(), this.endByteOffsetExclusive());
    }
}

