/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeMap;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig;
import kafka.tools.TerseFailure;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.TreeSet;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StorageTool$
implements Logging {
    public static StorageTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new StorageTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode;
        None$ message = None$.MODULE$;
        try {
            exitCode = this.execute(args, System.out);
        }
        catch (FormatterException e) {
            exitCode = 1;
            message = new Some((Object)e.getMessage());
        }
        catch (TerseFailure e) {
            exitCode = 1;
            message = new Some((Object)e.getMessage());
        }
        message.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            System.err.println(x$1);
            return BoxedUnit.UNIT;
        });
        Exit.exit((int)exitCode, (String)((String)message.orNull(Predef$.MODULE$.$conforms())));
    }

    public int execute(String[] args, PrintStream printStream) {
        Namespace namespace;
        try {
            namespace = this.parseArguments(args);
        }
        catch (HelpScreenException helpScreenException) {
            return 0;
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            return 1;
        }
        Namespace namespace2 = namespace;
        String command = namespace2.getString("command");
        Option config = Option$.MODULE$.apply((Object)namespace2.getString("config")).flatMap((Function1 & Serializable & scala.Serializable)p -> new Some((Object)new KafkaConfig(Utils.loadProps((String)p))));
        if ("info".equals(command)) {
            Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
            return this.infoCommand(printStream, ((KafkaConfig)config.get()).processRoles().nonEmpty(), directories);
        }
        if ("format".equals(command)) {
            this.runFormatCommand(namespace2, (KafkaConfig)config.get(), printStream);
            return 0;
        }
        if ("random-uuid".equals(command)) {
            printStream.println(Uuid.randomUuid());
            return 0;
        }
        throw new RuntimeException(new StringBuilder(16).append("Unknown command ").append(command).toString());
    }

    public void runFormatCommand(Namespace namespace, KafkaConfig config, PrintStream printStream) {
        if (config.processRoles().isEmpty()) {
            throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
        }
        Formatter formatter = new Formatter().setPrintStream(printStream).setNodeId(config.nodeId()).setClusterId(namespace.getString("cluster_id")).setUnstableFeatureVersionsEnabled(Predef$.MODULE$.Boolean2boolean(config.unstableFeatureVersionsEnabled())).setIgnoreFormatted(Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("ignore_formatted"))).setControllerListenerName((String)config.controllerListenerNames().head()).setMetadataLogDirectory(config.metadataLogDir());
        Option option = Option$.MODULE$.apply((Object)namespace.getString("release_version"));
        if (option instanceof Some) {
            String releaseVersion = (String)((Some)option).value();
            formatter.setReleaseVersion(MetadataVersion.fromVersionString((String)releaseVersion));
        } else if (None$.MODULE$.equals(option)) {
            Option$.MODULE$.apply(config.originals().get("inter.broker.protocol.version")).foreach((Function1 & Serializable & scala.Serializable)v -> formatter.setReleaseVersion(MetadataVersion.fromVersionString((String)v.toString())));
        } else {
            throw new MatchError((Object)option);
        }
        Option$.MODULE$.apply((Object)namespace.getList("feature")).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            StorageTool$.$anonfun$runFormatCommand$2(formatter, x$1);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)namespace.getString("initial_controllers")).foreach((Function1 & Serializable & scala.Serializable)v -> formatter.setInitialControllers(DynamicVoters.parse((String)v)));
        if (Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("standalone"))) {
            formatter.setInitialControllers(this.createStandaloneDynamicVoters(config));
        }
        if (!Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("no_initial_controllers")) && config.processRoles().contains((Object)ProcessRole.ControllerRole) && config.quorumVoters().isEmpty() && !formatter.initialVoters().isPresent()) {
            throw new TerseFailure("Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.");
        }
        Option$.MODULE$.apply((Object)namespace.getList("add_scram")).foreach((Function1 & Serializable & scala.Serializable)scramArgs -> formatter.setScramArguments(scramArgs));
        this.configToLogDirectories(config).foreach((Function1 & Serializable & scala.Serializable)x$2 -> formatter.addDirectory(x$2));
        formatter.run();
    }

    public DynamicVoters createStandaloneDynamicVoters(KafkaConfig config) {
        if (!config.processRoles().contains((Object)ProcessRole.ControllerRole)) {
            throw new TerseFailure("You can only use --standalone on a controller.");
        }
        if (config.effectiveAdvertisedControllerListeners().isEmpty()) {
            throw new RuntimeException("No controller listeners found.");
        }
        EndPoint listener = (EndPoint)config.effectiveAdvertisedControllerListeners().head();
        String host = listener.host() == null ? "localhost" : listener.host();
        return DynamicVoters.parse((String)new StringBuilder(3).append(config.nodeId()).append("@").append(host).append(":").append(listener.port()).append(":").append(Uuid.randomUuid()).toString());
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser2 = ArgumentParsers.newArgumentParser((String)"kafka-storage", (boolean)true, (String)"-", (String)"@").description("The Kafka storage tool.");
        Subparsers subparsers = parser2.addSubparsers().dest("command");
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        subparsers.addParser("random-uuid").help("Print a random UUID.");
        new .colon.colon((Object)infoParser, (List)new .colon.colon((Object)formatParser, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)parser -> parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).help("The Kafka configuration file to use."));
        formatParser.addArgument(new String[]{"--cluster-id", "-t"}).action((ArgumentAction)Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument(new String[]{"--add-scram", "-S"}).action((ArgumentAction)Arguments.append()).help(new StringOps(Predef$.MODULE$.augmentString("A SCRAM_CREDENTIAL to add to the __cluster_metadata log e.g.\n              |'SCRAM-SHA-256=[name=alice,password=alice-secret]'\n              |'SCRAM-SHA-512=[name=alice,iterations=8192,salt=\"N3E=\",saltedpassword=\"YCE=\"]'")).stripMargin());
        formatParser.addArgument(new String[]{"--ignore-formatted", "-g"}).action((ArgumentAction)Arguments.storeTrue());
        formatParser.addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help(new StringBuilder(93).append("The release version to use for the initial feature settings. The minimum is ").append(MetadataVersion.IBP_3_0_IV0).append("; the default is ").append(MetadataVersion.LATEST_PRODUCTION).toString());
        formatParser.addArgument(new String[]{"--feature", "-f"}).help("The setting to use for a specific feature, in feature=level format. For example: `kraft.version=1`.").action((ArgumentAction)Arguments.append());
        MutuallyExclusiveGroup reconfigurableQuorumOptions = formatParser.addMutuallyExclusiveGroup();
        reconfigurableQuorumOptions.addArgument(new String[]{"--standalone", "-s"}).help("Used to initialize a controller as a single-node dynamic quorum.").action((ArgumentAction)Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument(new String[]{"--no-initial-controllers", "-N"}).help("Used to initialize a server without a dynamic quorum topology.").action((ArgumentAction)Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument(new String[]{"--initial-controllers", "-I"}).help("Used to initialize a server with a specific dynamic quorum topology. The argument is a comma-separated list of id@hostname:port:directory. The same values must be used to format all nodes. For example:\n0@example.com:8082:JEXY6aqzQY-32P5TStzaFg,1@example.com:8083:MvDxzVmcRsaTz33bUuRU6A,2@example.com:8084:07R5amHmR32VDA6jHkGbTA\n").action((ArgumentAction)Arguments.store());
        return parser2.parseArgs(args);
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet directories = new TreeSet((Ordering)Ordering.String$.MODULE$);
        directories.$plus$plus$eq(config.logDirs());
        Option$.MODULE$.apply((Object)config.metadataLogDir()).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return directories.toSeq();
    }

    public int infoCommand(PrintStream stream, boolean kraftMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef prevMetadata = ObjectRef.create((Object)None$.MODULE$);
        ((IterableLike)directories.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)directory -> {
            BoxedUnit boxedUnit;
            block8: {
                Path directoryPath = Paths.get(directory, new String[0]);
                if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        return problems.$plus$eq((Object)new StringBuilder(15).append(directoryPath).append(" does not exist").toString());
                    }
                    return problems.$plus$eq((Object)new StringBuilder(19).append(directoryPath).append(" is not a directory").toString());
                }
                foundDirectories.$plus$eq((Object)((Object)directoryPath).toString());
                Path metaPath = directoryPath.resolve("meta.properties");
                if (!Files.exists(metaPath, new LinkOption[0])) {
                    return problems.$plus$eq((Object)new StringBuilder(18).append(directoryPath).append(" is not formatted.").toString());
                }
                Properties properties = PropertiesUtils.readPropertiesFile((String)((Object)metaPath).toString());
                try {
                    MetaProperties curMetadata = new MetaProperties.Builder(properties).build();
                    if (((Option)prevMetadata$1.elem).isEmpty()) {
                        prevMetadata$1.elem = new Some((Object)curMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).clusterId().equals(curMetadata.clusterId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched cluster IDs between storage directories.");
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).nodeId().equals(curMetadata.nodeId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched node IDs between storage directories.");
                        break block8;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    boxedUnit = problems.$plus$eq((Object)new StringBuilder(16).append("Error loading ").append(metaPath).append(": ").append(e.getMessage()).toString());
                }
            }
            return boxedUnit;
        });
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            if (kraftMode) {
                if (prev.version().equals((Object)MetaPropertiesVersion.V0)) {
                    return problems.$plus$eq((Object)"The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version().equals((Object)MetaPropertiesVersion.V1)) {
                return problems.$plus$eq((Object)"The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public Tuple2<String, Short> parseNameAndLevel(String input) {
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException(new StringBuilder(57).append("Can't parse feature=level string ").append(input).append(": equals sign not found.").toString());
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            return new Tuple2((Object)name, (Object)Predef$.MODULE$.short2Short(new StringOps(Predef$.MODULE$.augmentString(levelString)).toShort()));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(new StringBuilder(63).append("Can't parse feature=level string ").append(input).append(": ").append("unable to parse ").append(levelString).append(" as a short.").toString());
        }
    }

    public Map<String, Short> featureNamesAndLevels(java.util.List<String> features) {
        ArrayBuffer scalaFeatures = new ArrayBuffer();
        features.forEach(x$3 -> scalaFeatures.$plus$eq(x$3));
        return ((TraversableOnce)scalaFeatures.map((Function1 & Serializable & scala.Serializable)feature -> {
            Tuple2<String, Short> nameAndLevel = MODULE$.parseNameAndLevel((String)feature);
            return new Tuple2(nameAndLevel._1(), nameAndLevel._2());
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$runFormatCommand$2(Formatter formatter$1, java.util.List x$1) {
        MODULE$.featureNamesAndLevels(x$1).foreach((Function1 & Serializable & scala.Serializable)kv -> formatter$1.setFeatureLevel((String)kv._1(), (Short)kv._2()));
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, MetaProperties prev) {
        TreeMap sortedOutput = new TreeMap();
        prev.toProperties().entrySet().forEach(e -> sortedOutput.put(e.getKey().toString(), e.getValue().toString()));
        stream$1.println(new StringBuilder(16).append("Found metadata: ").append(sortedOutput).toString());
        stream$1.println("");
    }

    private StorageTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

