/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.multitenant.ByokMetadata;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.quota.ElasticCkuDefinitionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KafkaLogicalClusterMetadata
extends LogicalClusterMetadata {
    private static final Logger log = LoggerFactory.getLogger(KafkaLogicalClusterMetadata.class);
    public static final String KAFKA_LOGICAL_CLUSTER_TYPE = "kafka";
    public static final String HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "healthcheck";
    public static final String LINK_HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "link-healthcheck";
    public static final Double DEFAULT_REQUEST_PERCENTAGE_PER_BROKER = 250.0;
    public static final Double DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER = 250.0;
    public static final Integer DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE = 0;
    public static final Long DEFAULT_HEALTHCHECK_MAX_PRODUCER_RATE = 0xA00000L;
    public static final Long DEFAULT_HEALTHCHECK_MAX_CONSUMER_RATE = 0xA00000L;
    public static final Long DEFAULT_MIN_NETWORK_BYTE_RATE = 1024L;
    private final String logicalClusterId;
    private final String physicalClusterId;
    private final String logicalClusterName;
    private final String organizationId;
    private final String environmentId;
    private final String accountId;
    private final String k8sClusterId;
    private final String logicalClusterType;
    private final Long storageBytes;
    private Long producerByteRate;
    private final Map<ElasticCkuDefinitionKey, Integer> elasticCkuMetadata;
    private final Integer cku;
    private Long consumerByteRate;
    private final Double brokerRequestPercentage;
    private final Integer networkQuotaOverhead;
    private final LifecycleMetadata lifecycleMetadata;
    private final ByokMetadata byokMetadata;
    private final Integer maxPartitions;
    private final boolean healthCheckLKC;
    private final Double brokerLinkRequestPercentage;

    @JsonCreator
    public KafkaLogicalClusterMetadata(@JsonProperty(value="logical_cluster_id") String logicalClusterId, @JsonProperty(value="physical_cluster_id") String physicalClusterId, @JsonProperty(value="logical_cluster_name") String logicalClusterName, @JsonProperty(value="account_id") String accountId, @JsonProperty(value="k8s_cluster_id") String k8sClusterId, @JsonProperty(value="logical_cluster_type") String logicalClusterType, @JsonProperty(value="storage_bytes") Long storageBytes, @JsonProperty(value="network_ingress_byte_rate") Long producerByteRate, @JsonProperty(value="network_egress_byte_rate") Long consumerByteRate, @JsonProperty(value="max_network_ingress_byte_rate") Long maxProducerByteRate, @JsonProperty(value="max_network_egress_byte_rate") Long maxConsumerByteRate, @JsonProperty(value="broker_request_percentage") Long brokerRequestPercentage, @JsonProperty(value="network_quota_overhead") Integer networkQuotaOverhead, @JsonProperty(value="metadata") LifecycleMetadata lifecycleMetadata, @JsonProperty(value="byok_metadata") ByokMetadata byokMetadata, @JsonProperty(value="max_partitions") Integer maxPartitions, @JsonProperty(value="org_resource_id") String organizationId, @JsonProperty(value="environment_id") String environmentId, @JsonProperty(value="broker_link_request_percentage") Long brokerLinkRequestPercentage, @JsonProperty(value="elastic_cku_metadata") Map<ElasticCkuDefinitionKey, Integer> elasticCkuMetadata, @JsonProperty(value="cku") Integer cku) {
        this.logicalClusterId = logicalClusterId;
        this.physicalClusterId = physicalClusterId;
        this.logicalClusterName = logicalClusterName;
        this.accountId = accountId;
        this.k8sClusterId = k8sClusterId;
        this.logicalClusterType = logicalClusterType;
        this.storageBytes = storageBytes;
        this.cku = cku;
        this.healthCheckLKC = HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(logicalClusterType) || LINK_HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(logicalClusterType);
        Long validProducerByteRate = producerByteRate;
        if (validProducerByteRate != null) {
            validProducerByteRate = Math.max(maxProducerByteRate != null ? maxProducerByteRate : 0L, Math.max(DEFAULT_MIN_NETWORK_BYTE_RATE, producerByteRate));
        } else if (this.isHealthcheckLogicalCluster()) {
            validProducerByteRate = DEFAULT_HEALTHCHECK_MAX_PRODUCER_RATE;
        }
        Long validConsumerByteRate = consumerByteRate;
        if (validConsumerByteRate != null) {
            validConsumerByteRate = Math.max(maxConsumerByteRate != null ? maxConsumerByteRate : 0L, Math.max(DEFAULT_MIN_NETWORK_BYTE_RATE, consumerByteRate));
        } else if (this.isHealthcheckLogicalCluster()) {
            validConsumerByteRate = DEFAULT_HEALTHCHECK_MAX_CONSUMER_RATE;
        }
        this.elasticCkuMetadata = KafkaLogicalClusterMetadata.isValidElasticCkuMetadataMap(elasticCkuMetadata) ? elasticCkuMetadata : null;
        if (this.elasticCkuMetadata != null && !this.healthCheckLKC) {
            this.producerByteRate = (long)this.elasticCkuMetadata.get(ElasticCkuDefinitionKey.MAX_ELASTIC_CKU).intValue() * (long)this.elasticCkuMetadata.get(ElasticCkuDefinitionKey.PRODUCE).intValue();
            if (validProducerByteRate != null) {
                this.producerByteRate = Math.min(this.producerByteRate, validProducerByteRate);
            }
            this.consumerByteRate = (long)this.elasticCkuMetadata.get(ElasticCkuDefinitionKey.MAX_ELASTIC_CKU).intValue() * (long)this.elasticCkuMetadata.get(ElasticCkuDefinitionKey.FETCH).intValue();
            if (validConsumerByteRate != null) {
                this.consumerByteRate = Math.min(this.consumerByteRate, validConsumerByteRate);
            }
            if (!this.producerByteRate.equals(validProducerByteRate) || !this.consumerByteRate.equals(validConsumerByteRate)) {
                log.warn("Unexpected override of static produce and consume quota limit for lkc from Elastic CKU Metadata: {} Expected produce and consume: {} {}, Actual produce and consume: {} {}", new Object[]{this.logicalClusterId, validProducerByteRate, validConsumerByteRate, this.producerByteRate, this.consumerByteRate});
            }
        } else {
            this.producerByteRate = validProducerByteRate;
            this.consumerByteRate = validConsumerByteRate;
        }
        this.brokerRequestPercentage = brokerRequestPercentage == null || brokerRequestPercentage == 0L ? DEFAULT_REQUEST_PERCENTAGE_PER_BROKER : (double)brokerRequestPercentage.longValue();
        this.networkQuotaOverhead = networkQuotaOverhead == null ? DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE : networkQuotaOverhead;
        this.lifecycleMetadata = lifecycleMetadata;
        this.byokMetadata = byokMetadata;
        this.maxPartitions = maxPartitions;
        this.organizationId = organizationId;
        this.environmentId = environmentId != null ? environmentId : accountId;
        this.brokerLinkRequestPercentage = brokerLinkRequestPercentage == null || brokerLinkRequestPercentage == 0L ? DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER : (double)brokerLinkRequestPercentage.longValue();
    }

    public static KafkaLogicalClusterMetadata fromProtobuf(LogicalCluster lc) {
        LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.ElasticCKUMetadata elasticCKUMetadata = lc.getLogicalClusterConfig().getKafka().getElasticCkuMetadata();
        if (KafkaLogicalClusterMetadata.isEmptyElasticCkuMetadata(elasticCKUMetadata)) {
            log.info("Elastic CKU Metric Definition is null in protobuf for lkc: {}", (Object)lc.getLogicalClusterId());
            elasticCKUMetadata = null;
        } else if (!KafkaLogicalClusterMetadata.isValidElasticCkuMetadata(elasticCKUMetadata)) {
            log.error("Elastic CKU Metric Definition {} is not valid in protobuf for lkc: {}", (Object)elasticCKUMetadata, (Object)lc.getLogicalClusterId());
            elasticCKUMetadata = null;
        }
        LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok byok = null;
        LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig kafkaConfig = lc.getLogicalClusterConfigOrBuilder().getKafka();
        if (kafkaConfig.hasByok() && !ByokMetadata.isValidByokProto(byok = kafkaConfig.getByok())) {
            log.error("BYOK definition is not valid in protobuf for lkc: {}", (Object)lc.getLogicalClusterId());
            byok = null;
        }
        log.info("Elastic CKU Metric Definition passed to creation of KafkaLogicalClusterMetadata is: {} for lkc: {}", (Object)elasticCKUMetadata, (Object)lc.getLogicalClusterId());
        return new KafkaLogicalClusterMetadata(lc.getLogicalClusterId(), lc.getPhysicalClusterId(), lc.getLogicalClusterName(), lc.getAccountId(), lc.getK8SClusterId(), lc.getLogicalClusterType(), lc.getStorageBytes() > 0L ? Long.valueOf(lc.getStorageBytes()) : null, lc.getNetworkIngressByteRate(), lc.getNetworkEgressByteRate(), lc.getMaxNetworkIngressByteRate(), lc.getMaxNetworkEgressByteRate(), lc.getBrokerRequestPercentage(), 0, new LifecycleMetadata(lc.getLogicalClusterId(), lc.getPhysicalClusterId(), KafkaLogicalClusterMetadata.timeStampToDate(lc.getCreated()), lc.hasDeactivated() && !KafkaLogicalClusterMetadata.isZeroTimestamp(lc.getDeactivated()) ? KafkaLogicalClusterMetadata.timeStampToDate(lc.getDeactivated()) : null), ByokMetadata.loadFromByokProto(byok), lc.getMaxPartitions() > 0 ? Integer.valueOf(lc.getMaxPartitions()) : null, lc.getOrgResourceId().isEmpty() ? null : lc.getOrgResourceId(), lc.getEnvironmentId(), lc.getBrokerRequestPercentage(), KafkaLogicalClusterMetadata.getElasticCkuDefinitionFromMetadata(elasticCKUMetadata), lc.getLogicalClusterConfig().getKafka().getCku());
    }

    private static boolean isEmptyElasticCkuMetadata(LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.ElasticCKUMetadata elasticCkuMetadata) {
        return elasticCkuMetadata.getIngressInBytes() == 0 && elasticCkuMetadata.getEgressInBytes() == 0 && elasticCkuMetadata.getConnectionsPerSecond() == 0 && elasticCkuMetadata.getTotalClientConnections() == 0 && elasticCkuMetadata.getRequestsPerSecond() == 0 && elasticCkuMetadata.getMinEckuCount() == 0 && elasticCkuMetadata.getMaxEckuCount() == 0 && elasticCkuMetadata.getPartitions().getCompactedCount() == 0 && elasticCkuMetadata.getPartitions().getNonCompactedCount() == 0 && elasticCkuMetadata.getFlexibleFanout().getTotalThroughputBytes() == 0;
    }

    private static boolean isValidElasticCkuMetadataMap(Map<ElasticCkuDefinitionKey, Integer> elasticCkuMetadata) {
        return elasticCkuMetadata != null && elasticCkuMetadata.get(ElasticCkuDefinitionKey.PRODUCE) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.FETCH) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.CONNECTION_COUNT) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.CONNECTION_ATTEMPT) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.REQUEST_COUNT) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.MIN_ELASTIC_CKU) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.MAX_ELASTIC_CKU) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT) >= 0 && elasticCkuMetadata.get(ElasticCkuDefinitionKey.TOTAL_THROUGHPUT) >= 0;
    }

    private static boolean isValidElasticCkuMetadata(LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.ElasticCKUMetadata elasticCkuMetadata) {
        return elasticCkuMetadata.getIngressInBytes() >= 0 && elasticCkuMetadata.getEgressInBytes() >= 0 && elasticCkuMetadata.getConnectionsPerSecond() >= 0 && elasticCkuMetadata.getTotalClientConnections() >= 0 && elasticCkuMetadata.getRequestsPerSecond() >= 0 && elasticCkuMetadata.getMinEckuCount() >= 0 && elasticCkuMetadata.getMaxEckuCount() >= 0 && elasticCkuMetadata.getPartitions().getCompactedCount() >= 0 && elasticCkuMetadata.getPartitions().getNonCompactedCount() >= 0 && elasticCkuMetadata.getFlexibleFanout().getTotalThroughputBytes() >= 0;
    }

    private static Map<ElasticCkuDefinitionKey, Integer> getElasticCkuDefinitionFromMetadata(LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.ElasticCKUMetadata elasticCkuMetadata) {
        if (elasticCkuMetadata == null) {
            return null;
        }
        HashMap<ElasticCkuDefinitionKey, Integer> definition = new HashMap<ElasticCkuDefinitionKey, Integer>();
        definition.put(ElasticCkuDefinitionKey.PRODUCE, elasticCkuMetadata.getIngressInBytes());
        definition.put(ElasticCkuDefinitionKey.FETCH, elasticCkuMetadata.getEgressInBytes());
        definition.put(ElasticCkuDefinitionKey.CONNECTION_ATTEMPT, elasticCkuMetadata.getConnectionsPerSecond());
        definition.put(ElasticCkuDefinitionKey.CONNECTION_COUNT, elasticCkuMetadata.getTotalClientConnections());
        definition.put(ElasticCkuDefinitionKey.REQUEST_COUNT, elasticCkuMetadata.getRequestsPerSecond());
        definition.put(ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT, elasticCkuMetadata.getPartitions().getNonCompactedCount());
        definition.put(ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT, elasticCkuMetadata.getPartitions().getCompactedCount());
        definition.put(ElasticCkuDefinitionKey.MIN_ELASTIC_CKU, elasticCkuMetadata.getMinEckuCount());
        definition.put(ElasticCkuDefinitionKey.MAX_ELASTIC_CKU, elasticCkuMetadata.getMaxEckuCount());
        definition.put(ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, elasticCkuMetadata.getFlexibleFanout().getTotalThroughputBytes());
        return definition;
    }

    public Date creationDate() {
        return null;
    }

    @JsonProperty
    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    @JsonProperty
    public String physicalClusterId() {
        return this.physicalClusterId;
    }

    @JsonProperty
    public String logicalClusterName() {
        return this.logicalClusterName;
    }

    @JsonProperty
    public String accountId() {
        return this.accountId;
    }

    @JsonProperty
    public Integer cku() {
        return this.cku;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @JsonProperty
    public String environmentId() {
        return this.environmentId;
    }

    @JsonProperty
    public String k8sClusterId() {
        return this.k8sClusterId;
    }

    @JsonProperty
    public String logicalClusterType() {
        return this.logicalClusterType;
    }

    @JsonProperty
    public Long storageBytes() {
        return this.storageBytes;
    }

    @JsonProperty
    public Long producerByteRate() {
        return this.producerByteRate;
    }

    @JsonProperty
    public Long consumerByteRate() {
        return this.consumerByteRate;
    }

    @JsonProperty
    public Double brokerRequestPercentage() {
        return this.brokerRequestPercentage;
    }

    @JsonProperty
    public Double brokerLinkRequestPercentage() {
        return this.brokerLinkRequestPercentage;
    }

    @JsonProperty
    public Integer networkQuotaOverhead() {
        return this.networkQuotaOverhead;
    }

    @JsonProperty
    public LifecycleMetadata lifecycleMetadata() {
        return this.lifecycleMetadata;
    }

    @JsonProperty
    public ByokMetadata byokMetadata() {
        return this.byokMetadata;
    }

    @JsonProperty
    public Map<ElasticCkuDefinitionKey, Integer> elasticCkuMetadata() {
        return this.elasticCkuMetadata;
    }

    @JsonProperty
    public Integer maxPartitions() {
        return this.maxPartitions;
    }

    public boolean isValid() {
        return this.isKafkaLogicalCluster() || this.isHealthcheckLogicalCluster();
    }

    boolean isKafkaLogicalCluster() {
        return KAFKA_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    public final boolean isHealthcheckLogicalCluster() {
        return this.healthCheckLKC;
    }

    public boolean isActive() {
        return this.lifecycleMetadata == null || this.lifecycleMetadata.deletionDate() == null;
    }

    public QuotaConfig quotaConfig(double linkRequestPercentageMultipler) {
        double multiplier = 1.0 + (double)this.networkQuotaOverhead().intValue() / 100.0;
        Long producerByteRate = this.producerByteRate() == null ? null : Long.valueOf((long)(multiplier * (double)this.producerByteRate().longValue()));
        Long consumerByteRate = this.consumerByteRate() == null ? null : Long.valueOf((long)(multiplier * (double)this.consumerByteRate().longValue()));
        return new QuotaConfig(producerByteRate, consumerByteRate, this.brokerRequestPercentage(), null, null, this.brokerRequestPercentage() * linkRequestPercentageMultipler, QuotaConfig.UNLIMITED_QUOTA);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KafkaLogicalClusterMetadata that = (KafkaLogicalClusterMetadata)((Object)o);
        return Objects.equals(this.logicalClusterId, that.logicalClusterId) && Objects.equals(this.physicalClusterId, that.physicalClusterId) && Objects.equals(this.logicalClusterName, that.logicalClusterName) && Objects.equals(this.accountId, that.accountId) && Objects.equals(this.k8sClusterId, that.k8sClusterId) && Objects.equals(this.logicalClusterType, that.logicalClusterType) && Objects.equals(this.storageBytes, that.storageBytes) && Objects.equals(this.producerByteRate, that.producerByteRate) && Objects.equals(this.consumerByteRate, that.consumerByteRate) && Objects.equals(this.brokerRequestPercentage, that.brokerRequestPercentage) && Objects.equals(this.networkQuotaOverhead, that.networkQuotaOverhead) && Objects.equals(this.lifecycleMetadata, that.lifecycleMetadata) && Objects.equals(this.byokMetadata, that.byokMetadata) && Objects.equals(this.maxPartitions, that.maxPartitions) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId) && Objects.equals(this.brokerLinkRequestPercentage, that.brokerLinkRequestPercentage) && Objects.equals(this.elasticCkuMetadata, that.elasticCkuMetadata) && Objects.equals(this.cku, that.cku);
    }

    public int hashCode() {
        return Objects.hash(this.logicalClusterId, this.physicalClusterId, this.logicalClusterName, this.accountId, this.k8sClusterId, this.logicalClusterType, this.storageBytes, this.producerByteRate, this.consumerByteRate, this.brokerRequestPercentage, this.networkQuotaOverhead, this.lifecycleMetadata, this.byokMetadata, this.maxPartitions, this.organizationId, this.environmentId, this.brokerLinkRequestPercentage, this.elasticCkuMetadata, this.cku);
    }

    public String toString() {
        return "LogicalClusterMetadata(logicalClusterId=" + this.logicalClusterId + ", physicalClusterId=" + this.physicalClusterId + ", logicalClusterName=" + this.logicalClusterName + ", organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", accountId=" + this.accountId + ", k8sClusterId=" + this.k8sClusterId + ", logicalClusterType=" + this.logicalClusterType + ", storageBytes=" + this.storageBytes + ", producerByteRate=" + this.producerByteRate + ", consumerByteRate=" + this.consumerByteRate + ", brokerRequestPercentage=" + this.brokerRequestPercentage + ", brokerLinkRequestPercentage=" + this.brokerLinkRequestPercentage + ", networkQuotaOverhead=" + this.networkQuotaOverhead + ", lifecycleMetadata=" + this.lifecycleMetadata + ", maxPartitions=" + this.maxPartitions + ", elasticCkuMetadata=" + this.elasticCkuMetadata + ", cku=" + this.cku + ')';
    }

    private static Date timeStampToDate(Timestamp timestamp) {
        return Date.from(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
    }

    protected static boolean isZeroTimestamp(Timestamp timestamp) {
        return timestamp.getSeconds() == 0L && timestamp.getNanos() == 0;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LifecycleMetadata {
        private final String logicalClusterName;
        private final String physicalK8sNamespace;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        private final Date creationDate;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        private final Date deletionDate;

        @JsonCreator
        public LifecycleMetadata(@JsonProperty(value="name") String logicalClusterName, @JsonProperty(value="namespace") String physicalK8sNamespace, @JsonProperty(value="creationTimestamp") Date creationDate, @JsonProperty(value="deletionTimestamp") Date deletionDate) {
            this.logicalClusterName = logicalClusterName;
            this.physicalK8sNamespace = physicalK8sNamespace;
            this.creationDate = creationDate;
            this.deletionDate = deletionDate;
        }

        @JsonProperty
        public String logicalClusterName() {
            return this.logicalClusterName;
        }

        @JsonProperty
        public String physicalK8sNamespace() {
            return this.physicalK8sNamespace;
        }

        @JsonProperty
        public Date creationDate() {
            return this.creationDate;
        }

        @JsonProperty
        public Date deletionDate() {
            return this.deletionDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifecycleMetadata that = (LifecycleMetadata)o;
            return Objects.equals(this.logicalClusterName, that.logicalClusterName) && Objects.equals(this.physicalK8sNamespace, that.physicalK8sNamespace) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.deletionDate, that.deletionDate);
        }

        public int hashCode() {
            return Objects.hash(this.logicalClusterName, this.physicalK8sNamespace, this.creationDate, this.deletionDate);
        }

        public String toString() {
            return "LifecycleMetadata{logicalClusterName='" + this.logicalClusterName + '\'' + ", physicalK8sNamespace='" + this.physicalK8sNamespace + '\'' + ", creationDate=" + this.creationDate + ", deletionDate=" + this.deletionDate + '}';
        }
    }
}

