/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.metadata.TopicPlacement;

public interface TopicReplicaAssignor {
    public Optional<List<List<Integer>>> computeAssignmentForNewTopic(NewPartitions var1, Optional<TopicPlacement> var2, Set<Integer> var3) throws ApiException;

    public Optional<List<List<Integer>>> computeAssignmentForExistingTopic(NewPartitions var1, Optional<TopicPlacement> var2, Set<Integer> var3) throws ApiException;

    public static class NewPartitions {
        private final String topic;
        private final int totalPartitions;
        private final int firstNewPartition;
        private final short replicationFactor;

        public NewPartitions(String topic, int totalPartitions, int firstNewPartition, short replicationFactor) {
            this.topic = topic;
            this.totalPartitions = totalPartitions;
            this.firstNewPartition = firstNewPartition;
            this.replicationFactor = replicationFactor;
        }

        public String topic() {
            return this.topic;
        }

        public int totalPartitions() {
            return this.totalPartitions;
        }

        public int firstNewPartition() {
            return this.firstNewPartition;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public boolean isNewTopic() {
            return this.firstNewPartition == 0;
        }

        public String toString() {
            return "NewPartitions{topic='" + this.topic + "', totalPartitions=" + this.totalPartitions + ", firstNewPartition=" + this.firstNewPartition + ", replicationFactor=" + this.replicationFactor + "}";
        }
    }
}

