/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Locale;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.common.TenantHelpers;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;

public class ClusterLinkConfigChangeEvent
extends MetadataCollectorEvent {
    private final String logicalClusterId;
    private final String clusterLink;
    private final ClusterLinkConfig newConfig;

    public ClusterLinkConfigChangeEvent(ZKMetadataCollector collector, String logicalClusterId, String linkName, ClusterLinkConfig newConfig, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.clusterLink = linkName;
        this.newConfig = newConfig;
    }

    public void run() throws Exception {
        String localClusterId;
        String remoteClusterId;
        ConnectionMode connectionMode;
        ClusterLinkConfig.LinkMode linkMode;
        Uuid clusterLinkId;
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Updating cluster link config for cluster link {} with new clusterLinkConfig {}", (Object)this.clusterLink, (Object)this.newConfig);
        MetadataEvent metadataEvent = context.localStore().clusterLinkMetadataEvent(this.clusterLink);
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        if (metadataEvent != null) {
            ClusterLinkMetadata clusterLinkMetadata = metadataEvent.getClusterLinkMetadata();
            clusterLinkId = Uuid.fromString((String)clusterLinkMetadata.getClusterLinkId());
            linkMode = ClusterLinkConfig.LinkMode.fromString((String)clusterLinkMetadata.getLinkMode().toString().toLowerCase(Locale.ROOT));
            connectionMode = ConnectionMode.fromString(clusterLinkMetadata.getConnectionMode().toString().toLowerCase(Locale.ROOT));
            remoteClusterId = clusterLinkMetadata.getRemoteClusterId();
            localClusterId = clusterLinkMetadata.getLocalClusterId();
        } else if (!context.cacheInitialized() && context.clusterLinkInfo(this.clusterLink) != null) {
            ClusterLinkInfo clusterLinkInfo = context.removeClusterLinkFromInitialSnapshot(this.clusterLink);
            clusterLinkId = clusterLinkInfo.clusterLinkId();
            linkMode = clusterLinkInfo.linkMode();
            connectionMode = clusterLinkInfo.connectionMode();
            remoteClusterId = clusterLinkInfo.remoteClusterId();
            localClusterId = clusterLinkInfo.localClusterId();
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore {} because cluster link is not available in local cache or initial snapshot", (Object)this);
            }
            return;
        }
        MetadataEvent newMetadataEvent = MetadataEventUtils.clusterLinkMetadataEvent(TenantHelpers.extractLogicalName(this.clusterLink), clusterLinkId, linkMode, connectionMode, remoteClusterId, localClusterId, null, eventTimestamp);
        context.localStore().addClusterLinkMetadataEvent(this.logicalClusterId, this.clusterLink, newMetadataEvent);
        MetadataChange clusterLinkMetadataChange = MetadataEventUtils.entityUpdateEvent(this.logicalClusterId, newMetadataEvent);
        this.emitClusterLinkDeltaEvent(context, clusterLinkMetadataChange);
    }

    public String toString() {
        return "ClusterLinkConfigChangeEvent(clusterLink=" + this.clusterLink + ")";
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof CollectorContextNotInitializedException) {
            LOG.trace("Ignore {} because it's a non-active collector", (Object)this);
        } else {
            LOG.error("Unexpected error handling {}", (Object)this, (Object)e);
            this.recordEventHandleError();
        }
    }
}

