/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import kafka.durability.ondemand.OnDemandAuditJobOrchestrator;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandAudit {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnDemandAudit.class);

    public static void main(String[] args) throws Exception {
        LOGGER.debug("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = OnDemandAudit.createComparatorParser();
        Namespace res = cliParser.parseArgs(args);
        String bootstrapServers = res.getString("bootstrap-servers");
        boolean startAuditJob = res.getBoolean("run-audit");
        boolean getAuditJobStatus = res.getBoolean("status");
        boolean stopAuditJob = res.getBoolean("stop");
        Integer brokerId = res.getInt("broker-id");
        if (startAuditJob) {
            boolean forceStart = res.getBoolean("force");
            boolean compactionCheckNeeded = res.getBoolean("compaction-check");
            OnDemandAuditJobOrchestrator onDemandAuditJobOrchestrator = new OnDemandAuditJobOrchestrator(bootstrapServers, forceStart, compactionCheckNeeded);
            String topicPartitionConfigFile = res.getString("topic-partition-file");
            String topicName = res.getString("topic-name");
            boolean cluster = res.getBoolean("cluster");
            Integer partition = res.getInt("partition");
            if (topicPartitionConfigFile != null) {
                LOGGER.info("Starting on demand audit job for {}", (Object)topicPartitionConfigFile);
                onDemandAuditJobOrchestrator.startOnDemandAuditJobBasedOnConfig(topicPartitionConfigFile);
            } else if (brokerId != null) {
                if (topicName != null && partition != null) {
                    LOGGER.info("Starting on demand audit job for topic {} and partition {} on broker {}", new Object[]{topicName, partition, brokerId});
                    onDemandAuditJobOrchestrator.startOnDemandJobForTopicPartitionOnBroker(topicName, Collections.singleton(partition), brokerId);
                } else if (topicName == null && partition == null) {
                    LOGGER.info("Starting on demand audit job for all partitions on broker {}", (Object)brokerId);
                    onDemandAuditJobOrchestrator.startOnDemandAuditJobForBroker(brokerId);
                } else {
                    System.out.println("Invalid arguments. Either provide both --topic-name and --partition or none when using --brokerid");
                    Exit.exit((int)0);
                }
            } else if (topicName != null) {
                if (partition == null) {
                    LOGGER.info("Starting on demand audit job for all partitions for topic {}", (Object)topicName);
                    onDemandAuditJobOrchestrator.startOnDemandAuditJobForTopic(topicName);
                } else {
                    LOGGER.info("Starting on demand audit job for topic {} and partitions {}", (Object)topicName, (Object)partition);
                    onDemandAuditJobOrchestrator.startOnDemandJobForTopicPartition(topicName, Collections.singleton(partition));
                }
            } else if (cluster) {
                LOGGER.info("Starting on demand audit job for entire cluster");
                onDemandAuditJobOrchestrator.startOnDemandAuditJobForCluster();
            } else {
                System.out.println("Invalid arguments.");
                Exit.exit((int)0);
            }
        } else if (getAuditJobStatus) {
            Integer auditJobId = res.getInt("job-id");
            if (auditJobId == null) {
                System.out.println("Please specify an audit job id");
                Exit.exit((int)0);
            }
            boolean detail = res.getBoolean("detail");
            OnDemandAuditJobOrchestrator onDemandAuditJobOrchestrator = new OnDemandAuditJobOrchestrator(bootstrapServers, null, null);
            if (brokerId != null) {
                LOGGER.info("Fetching status for audit job currently running on broker {}", (Object)brokerId);
                onDemandAuditJobOrchestrator.getAuditJobStatus(Optional.of(brokerId), detail, auditJobId);
            } else {
                LOGGER.info("Fetching status for audit jobs currently running in the cluster");
                onDemandAuditJobOrchestrator.getAuditJobStatus(Optional.empty(), detail, auditJobId);
            }
        } else if (stopAuditJob) {
            LOGGER.info("Stopping audit jobs currently running in the cluster");
            OnDemandAuditJobOrchestrator onDemandAuditJobOrchestrator = new OnDemandAuditJobOrchestrator(bootstrapServers, null, null);
            onDemandAuditJobOrchestrator.stopAuditJobs();
        } else {
            System.out.println("Invalid arguments.");
            Exit.exit((int)0);
        }
    }

    private static ArgumentParser createComparatorParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)OnDemandAudit.class.getName()).defaultHelp(true).description("Start audit jobs for given Topic and Partitions");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("bootstrap-servers")}).dest("bootstrap-servers").type(String.class).metavar(new String[]{"HOST1:PORT1[,HOST2:PORT2[...]]"}).action((ArgumentAction)Arguments.store()).setDefault((Object)"localhost:9071").help("Comma-separated list of broker urls (host:port) to connect to. This is required for all commands.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("force")}).dest("force").action((ArgumentAction)Arguments.storeTrue()).help("Stops the existing job and starts a new one");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("compaction-check")}).dest("compaction-check").action((ArgumentAction)Arguments.storeTrue()).help("Performs compaction check if set to true");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("partition")}).dest("partition").type(Integer.class).help("Runs audit job on specified partition");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("broker-id")}).dest("broker-id").type(Integer.class).help("Runs audit job on all partitions for specified broker");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("detail")}).dest("detail").action((ArgumentAction)Arguments.storeTrue()).help("Returns detail status if set to true");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("job-id")}).dest("job-id").type(Integer.class).help("Retrieve status for given audit job id");
        MutuallyExclusiveGroup commandTypeGroup = parser.addMutuallyExclusiveGroup().required(true);
        commandTypeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("run-audit")}).dest("run-audit").action((ArgumentAction)Arguments.storeTrue()).help("Starts an audit job");
        commandTypeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("status")}).dest("status").action((ArgumentAction)Arguments.storeTrue()).help("Gets audit job status for entire cluster");
        commandTypeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("stop")}).dest("stop").action((ArgumentAction)Arguments.storeTrue()).help("Stops any currently running audit jobs in the cluster");
        MutuallyExclusiveGroup group = parser.addMutuallyExclusiveGroup();
        group.addArgument(new String[]{RecoveryUtils.makeArgument("topic-name")}).dest("topic-name").type(String.class).help("Runs audit job for all partitions for specified topic name");
        group.addArgument(new String[]{RecoveryUtils.makeArgument("topic-partition-file")}).dest("topic-partition-file").type(String.class).help("Name of the file contains the list of topic partitions to be audited");
        group.addArgument(new String[]{RecoveryUtils.makeArgument("cluster")}).dest("cluster").action((ArgumentAction)Arguments.storeTrue()).help("Runs audit job for all brokers in the cluster");
        return parser;
    }
}

