/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.MergedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\ruv!B#G\u0011\u0003Ye!B'G\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0013A\u0006\"\u00029\u0002\t\u0013\t\bbBA\u0002\u0003\u0011%\u0011Q\u0001\u0005\b\u00037\tA\u0011AA\u000f\r\u0015ie\tAA\u0014\u0011%\t\u0019f\u0002B\u0001B\u0003%Q\r\u0003\u0006\u0002\u0010\u001d\u0011\t\u0011)A\u0005\u0003#A!\"!\u0016\b\u0005\u0003\u0005\u000b\u0011BA,\u0011)\t\u0019g\u0002B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003g:!\u0011!Q\u0001\n\u0005U\u0004BCA>\u000f\t\u0005\t\u0015!\u0003\u0002X!Q\u0011QP\u0004\u0003\u0002\u0003\u0006I!a \t\u0015\u0005%uA!A!\u0002\u0013\tY\t\u0003\u0006\u0002\u0016\u001e\u0011\t\u0011)A\u0005\u0003/C!\"!)\b\u0005\u0003\u0005\u000b\u0011BAR\u0011)\tIk\u0002BC\u0002\u0013\u0005\u00111\u0016\u0005\u000b\u00037<!\u0011!Q\u0001\n\u00055\u0006BCAo\u000f\t\u0005\t\u0015!\u0003\u0002`\"Q\u0011Q]\u0004\u0003\u0002\u0003\u0006I!a:\t\u0015\u00055xA!A!\u0002\u0013\ty\u000f\u0003\u0006\u0002|\u001e\u0011\t\u0011)A\u0005\u0003{Da!V\u0004\u0005\u0002\tM\u0001\"\u0003B\u001b\u000f\t\u0007I\u0011\u0002B\u001c\u0011!\u0011)e\u0002Q\u0001\n\te\u0002\"\u0003B$\u000f\t\u0007I\u0011\u0001B%\u0011!\u00119f\u0002Q\u0001\n\t-\u0003\"\u0003B-\u000f\t\u0007I\u0011\u0002B.\u0011!\u0011\u0019g\u0002Q\u0001\n\tu\u0003\"\u0003B3\u000f\t\u0007I\u0011\u0002B4\u0011\u001d\u0011Ig\u0002Q\u0001\n\u0015D\u0011Ba\u001b\b\u0005\u0004%IA!\u001c\t\u0011\tUt\u0001)A\u0005\u0005_B\u0011Ba\u001e\b\u0005\u0004%IA!\u001f\t\u0011\t\u0005u\u0001)A\u0005\u0005wB\u0011\"!\u0001\b\u0005\u0004%IAa!\t\u000f\t\u0015u\u0001)A\u00053\"I!qQ\u0004C\u0002\u0013%!\u0011\u0012\u0005\t\u0005\u001b;\u0001\u0015!\u0003\u0003\f\"I!qR\u0004C\u0002\u0013\u0005#\u0011\u0013\u0005\t\u00053;\u0001\u0015!\u0003\u0003\u0014\"I!1T\u0004C\u0002\u0013%!Q\u0014\u0005\t\u0005K;\u0001\u0015!\u0003\u0003 \"I!qU\u0004C\u0002\u0013%!\u0011\u0016\u0005\t\u0005o;\u0001\u0015!\u0003\u0003,\"I!\u0011X\u0004C\u0002\u0013%!1\u0018\u0005\t\u0005\u0007<\u0001\u0015!\u0003\u0003>\"I!QY\u0004C\u0002\u0013\u0005#q\u0019\u0005\t\u0005\u001f<\u0001\u0015!\u0003\u0003J\"I!\u0011[\u0004C\u0002\u0013%!1\u001b\u0005\t\u00057<\u0001\u0015!\u0003\u0003V\"I!Q\\\u0004A\u0002\u0013%!q\u001c\u0005\n\u0005k<\u0001\u0019!C\u0005\u0005oD\u0001B!@\bA\u0003&!\u0011\u001d\u0005\b\u0005\u007f<A\u0011AB\u0001\u0011\u001d\u0019\u0019a\u0002C\u0001\u0007\u0003Aqa!\u0002\b\t\u0003\u001a9\u0001C\u0004\u0004\u001c\u001d!\te!\b\t\u000f\rUs\u0001\"\u0003\u0004X!91QM\u0004\u0005\n\r\u001d\u0004bBB5\u000f\u0011%11\u000e\u0005\b\u0007[:A\u0011BB8\u0011\u001d\u0019\th\u0002C\u0005\u0007gBqaa\u001f\b\t\u0013\u0019i\bC\u0004\u0004\u0018\u001e!\te!'\t\u000f\r\u0005v\u0001\"\u0011\u0004$\"91\u0011X\u0004\u0005B\rm\u0016\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s\u0015\t9\u0005*\u0001\u0003sC\u001a$(\"A%\u0002\u000b-\fgm[1\u0004\u0001A\u0011A*A\u0007\u0002\r\n\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM]\n\u0003\u0003=\u0003\"\u0001U*\u000e\u0003ES\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)F\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001L\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\u0007e\u000b7\r\u0005\u0002[?6\t1L\u0003\u0002];\u0006\u0011\u0011n\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003GS2,\u0007\"\u00022\u0004\u0001\u0004I\u0016A\u00027pO\u0012K'\u000fC\u0003e\u0007\u0001\u0007Q-\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u00015R\u001b\u0005I'B\u00016K\u0003\u0019a$o\\8u}%\u0011A.U\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m#\u0006YAn\\2l\t\u0006$\u0018\rR5s)\t\u0011x\u0010\u0005\u0002t{6\tAO\u0003\u0002vm\u0006!Q\u000f^5m\u0015\t9\b0\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0013fT!A_>\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0018aA8sO&\u0011a\u0010\u001e\u0002\t\r&dW\rT8dW\"1\u0011\u0011\u0001\u0003A\u0002e\u000bq\u0001Z1uC\u0012K'/\u0001\niCN$\u0015N\u001a4fe\u0016tG\u000fT8h\t&\u0014H\u0003BA\u0004\u0003\u001b\u00012\u0001UA\u0005\u0013\r\tY!\u0015\u0002\b\u0005>|G.Z1o\u0011\u001d\ty!\u0002a\u0001\u0003#\taaY8oM&<\u0007\u0003BA\n\u0003/i!!!\u0006\u000b\u0005]D\u0015\u0002BA\r\u0003+\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006IR.Y=cK\u0012+G.\u001a;f\u001b\u0016$\u0018\rZ1uC2{w\rR5s)\u0011\ty\"!\n\u0011\u0007A\u000b\t#C\u0002\u0002$E\u0013A!\u00168ji\"9\u0011q\u0002\u0004A\u0002\u0005EQ\u0003BA\u0015\u0003k\u0019baB(\u0002,\u0005\u001d\u0003#\u0002'\u0002.\u0005E\u0012bAA\u0018\r\nY!+\u00194u\u001b\u0006t\u0017mZ3s!\u0011\t\u0019$!\u000e\r\u0001\u00119\u0011qG\u0004C\u0002\u0005e\"!\u0001+\u0012\t\u0005m\u0012\u0011\t\t\u0004!\u0006u\u0012bAA #\n9aj\u001c;iS:<\u0007c\u0001)\u0002D%\u0019\u0011QI)\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti\u0005S\u0001\u0006kRLGn]\u0005\u0005\u0003#\nYEA\u0004M_\u001e<\u0017N\\4\u0002\u0013\rdWo\u001d;fe&#\u0017AE7fi\u0006$\u0017\r^1M_\u001e$\u0015N]+vS\u0012\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;B\u0018AB2p[6|g.\u0003\u0003\u0002b\u0005m#\u0001B+vS\u0012\fQa]3sI\u0016\u0004b!a\u001a\u0002p\u0005ERBAA5\u0015\u0011\tY'!\u001c\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r\tiF^\u0005\u0005\u0003c\nIGA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u00033\n9(\u0003\u0003\u0002z\u0005m#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\bi>\u0004\u0018nY%e\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005\u0015QQ\u0007\u0003\u0003\u0007SA!!\u0014\u0002\\%!\u0011qQAB\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011QRAI\u001b\t\tyI\u0003\u0003\u0002\n\u0006m\u0013\u0002BAJ\u0003\u001f\u0013q!T3ue&\u001c7/\u0001\u000bfqR,'O\\1m\u0017J\u000bg\r^'fiJL7m\u001d\t\u0005\u00033\u000bi*\u0004\u0002\u0002\u001c*\u0011q\t_\u0005\u0005\u0003?\u000bYJ\u0001\u000bFqR,'O\\1m\u0017J\u000bg\r^'fiJL7m]\u0001\u0014i\"\u0014X-\u00193OC6,\u0007K]3gSb|\u0005\u000f\u001e\t\u0005!\u0006\u0015V-C\u0002\u0002(F\u0013aa\u00149uS>t\u0017\u0001H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/Z\u000b\u0003\u0003[\u0003b!a,\u00028\u0006mVBAAY\u0015\u0011\t\u0019,!.\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002v;&!\u0011\u0011XAY\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003{\u000by,a1\u0002P6\u0011\u0011QW\u0005\u0005\u0003\u0003\f)LA\u0002NCB\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013l\u0016\u0001\u00027b]\u001eLA!!4\u0002H\n9\u0011J\u001c;fO\u0016\u0014\b\u0003BAi\u0003/l!!a5\u000b\u0007\u0005UW,A\u0002oKRLA!!7\u0002T\n\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n\u0001CY8piN$(/\u00199TKJ4XM]:\u0011\r\u0005u\u0016\u0011]Ah\u0013\u0011\t\u0019/!.\u0003\u0015\r{G\u000e\\3di&|g.\u0001\bm_\u000e\fG\u000eT5ti\u0016tWM]:\u0011\t\u0005e\u0015\u0011^\u0005\u0005\u0003W\fYJA\u0005F]\u0012\u0004x.\u001b8ug\u0006\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gT1!!>w\u0003\u00151\u0017-\u001e7u\u0013\u0011\tI0a=\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002%QLWM](cU\u0016\u001cGo\u0015;pe\u0016|\u0005\u000f\u001e\t\u0007\u0003{\u000byPa\u0001\n\t\t\u0005\u0011Q\u0017\u0002\t\u001fB$\u0018n\u001c8bYB!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011!B:u_J,'b\u0001B\u0007\u0011\u0006!A/[3s\u0013\u0011\u0011\tBa\u0002\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016$\u0002E!\u0006\u0003\u0018\te!1\u0004B\u000f\u0005?\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006B\u0016\u0005[\u0011yC!\r\u00034A!AjBA\u0019\u0011\u0019\t\u0019\u0006\u0007a\u0001K\"9\u0011q\u0002\rA\u0002\u0005E\u0001bBA+1\u0001\u0007\u0011q\u000b\u0005\b\u0003GB\u0002\u0019AA3\u0011\u001d\t\u0019\b\u0007a\u0001\u0003kBq!a\u001f\u0019\u0001\u0004\t9\u0006C\u0004\u0002~a\u0001\r!a \t\u000f\u0005%\u0005\u00041\u0001\u0002\f\"9\u0011Q\u0013\rA\u0002\u0005]\u0005bBAQ1\u0001\u0007\u00111\u0015\u0005\b\u0003SC\u0002\u0019AAW\u0011\u001d\ti\u000e\u0007a\u0001\u0003?Dq!!:\u0019\u0001\u0004\t9\u000fC\u0004\u0002nb\u0001\r!a<\t\u000f\u0005m\b\u00041\u0001\u0002~\u000611\r\\8tK\u0012,\"A!\u000f\u0011\t\tm\"\u0011I\u0007\u0003\u0005{QAAa\u0010\u00022\u00061\u0011\r^8nS\u000eLAAa\u0011\u0003>\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fqa\u00197pg\u0016$\u0007%A\u0006ba&4VM]:j_:\u001cXC\u0001B&!\u0011\u0011iEa\u0015\u000e\u0005\t=#b\u0001B)q\u000691\r\\5f]R\u001c\u0018\u0002\u0002B+\u0005\u001f\u00121\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\tu\u0003\u0003BAM\u0005?JAA!\u0019\u0002\u001c\na\u0011+^8sk6\u001cuN\u001c4jO\u0006Y!/\u00194u\u0007>tg-[4!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001f\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u000bY><7i\u001c8uKb$XC\u0001B8!\u0011\t\tI!\u001d\n\t\tM\u00141\u0011\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\tm\u0004cA:\u0003~%\u0019!q\u0010;\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0016\u0003e\u000b\u0001\u0002Z1uC\u0012K'\u000fI\u0001\fI\u0006$\u0018\rR5s\u0019>\u001c7.\u0006\u0002\u0003\fB!\u0001+!*s\u00031!\u0017\r^1ESJdunY6!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!1\u0013\t\u0005\u00033\u0013)*\u0003\u0003\u0003\u0018\u0006m%!\u0004*fa2L7-\u0019;fI2{w-\u0001\bsKBd\u0017nY1uK\u0012dun\u001a\u0011\u0002\u00159,Go\u00115b]:,G.\u0006\u0002\u0003 B!\u0011\u0011\u0014BQ\u0013\u0011\u0011\u0019+a'\u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!1\u0016\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*\u0019!\u0011\u0017;\u0002\u000bQLW.\u001a:\n\t\tU&q\u0016\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\tu\u0006c\u0001'\u0003@&\u0019!\u0011\u0019$\u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!\u0003\u0019\u0019G.[3oiV\u0011!\u0011\u001a\t\u0007\u00033\u0013Y-!\r\n\t\t5\u00171\u0014\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013\u0001D2mS\u0016tG\u000f\u0012:jm\u0016\u0014XC\u0001Bk!\u0019\tIJa6\u00022%!!\u0011\\AN\u0005UY\u0015MZ6b%\u00064Go\u00117jK:$HI]5wKJ\fQb\u00197jK:$HI]5wKJ\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\t\u0005\b#\u0002)\u0002&\n\r\b\u0003\u0002Bs\u0005cl!Aa:\u000b\t\u0005M&\u0011\u001e\u0006\u0004\u0013\n-(\u0002\u0002Bw\u0005_\f\u0011bY8oM2,XM\u001c;\u000b\u0003qKAAa=\u0003h\niQI^3oi\u0016CXmY;u_J\fA\"\u001a=fGV$xN]0%KF$B!a\b\u0003z\"I!1 \u001c\u0002\u0002\u0003\u0007!\u0011]\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u0003\u001d\u0019H/\u0019:ukB$\"!a\b\u0002\u0011MDW\u000f\u001e3po:\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0003?\u0019I\u0001C\u0004\u0004\fi\u0002\ra!\u0004\u0002\u00111L7\u000f^3oKJ\u0004baa\u0004\u0004\u0016\u0005Eb\u0002BAM\u0007#IAaa\u0005\u0002\u001c\u0006Q!+\u00194u\u00072LWM\u001c;\n\t\r]1\u0011\u0004\u0002\t\u0019&\u001cH/\u001a8fe*!11CAN\u00035A\u0017M\u001c3mKJ+\u0017/^3tiRQ1qDB\u0017\u0007{\u00199ea\u0013\u0011\r\u0005=\u0016qWB\u0011!\u0011\u0019\u0019c!\u000b\u000e\u0005\r\u0015\"\u0002BB\u0014\u00037\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007W\u0019)C\u0001\u0006Ba&lUm]:bO\u0016Dqaa\f<\u0001\u0004\u0019\t$A\u0004d_:$X\r\u001f;\u0011\t\rM2\u0011H\u0007\u0003\u0007kQAaa\u000e\u0002\\\u0005A!/Z9vKN$8/\u0003\u0003\u0004<\rU\"A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0007\u007fY\u0004\u0019AB!\u0003\u0019AW-\u00193feB!11GB\"\u0013\u0011\u0019)e!\u000e\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\u0019Ie\u000fa\u0001\u0007C\tqA]3rk\u0016\u001cH\u000fC\u0004\u0004Nm\u0002\raa\u0014\u0002\u001b\r\u0014X-\u0019;fIRKW.Z't!\r\u00016\u0011K\u0005\u0004\u0007'\n&\u0001\u0002'p]\u001e\fQ$\\1zE\u0016\u0014U/\u001b7e%\u00064Go\u00158baNDw\u000e^'b]\u0006<WM\u001d\u000b\u0003\u00073\u0002R\u0001UAS\u00077\u0002Ba!\u0018\u0004b5\u00111q\f\u0006\u0004\u000f\n-\u0011\u0002BB2\u0007?\u0012Ac\u0013*bMR\u001cf.\u00199tQ>$X*\u00198bO\u0016\u0014\u0018a\u00042vS2$'+\u00194u\u00072LWM\u001c;\u0015\u0005\t%\u0017a\u00052vS2$g*\u001a;x_J\\7\t[1o]\u0016dGC\u0001BP\u00035\u0019'/Z1uK\u0012\u000bG/\u0019#jeR\t\u0011,\u0001\tck&dG-T3uC\u0012\fG/\u0019'pOR\u00111Q\u000f\t\u0004\u0019\u000e]\u0014bAB=\r\n\u00012*\u00194lC6+G/\u00193bi\u0006dunZ\u0001\u0013EVLG\u000e\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0002\u0004\u0000A9\u0001k!!\u0004\u0006\u000eE\u0015bABB#\n1A+\u001e9mKJ\u0002Baa\"\u0004\u000e6\u00111\u0011\u0012\u0006\u0005\u0007\u0017\u000bY&A\u0004oKR<xN]6\n\t\r=5\u0011\u0012\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0005\u001b\u001a\u0019*\u0003\u0003\u0004\u0016\n=#!\u0004(fi^|'o[\"mS\u0016tG/\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0016\u0005\rm\u0005\u0003BAM\u0007;KAaa(\u0002\u001c\nqA*Z1eKJ\fe\u000eZ#q_\u000eD\u0017!\u0003<pi\u0016\u0014hj\u001c3f)\u0019\u0019)k!,\u00048B)\u0001+!*\u0004(B!\u0011\u0011LBU\u0013\u0011\u0019Y+a\u0017\u0003\t9{G-\u001a\u0005\b\u0007_\u001b\u0005\u0019ABY\u0003\tIG\rE\u0002Q\u0007gK1a!.R\u0005\rIe\u000e\u001e\u0005\b\u0007\u0017\u0019\u0005\u0019ABC\u0003-\u0011XmY8sIN+'\u000fZ3\u0016\u0005\u0005\u0015\u0004")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> serde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final ExternalKRaftMetrics externalKRaftMetrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig kafkaConfig) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(kafkaConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics, this.externalKRaftMetrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationTimer().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clientDriver().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.netChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.replicatedLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.destroy();
                return BoxedUnit.UNIT;
            }), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.executor().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.shutdown()), this, CoreUtils$.MODULE$.swallow$default$3());
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains((Object)ProcessRole.ControllerRole)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                return Optional.of(new File($this.config.metadataLogDir(), MergedLog$.MODULE$.logDirName($this.topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.clusterId, this.config.nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde(), (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Features.KRAFT_VERSION.supportedVersionRange(), this.raftConfig(), (RaftTracer)new CompositeRaftTracer((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)tracers.elem)).asJava(), this.logContext()));
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        void listenerName2 = var2_2;
        void netClient2 = var3_3;
        return new KafkaNetworkChannel(this.time, (ListenerName)listenerName2, (KafkaClient)netClient2, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = MergedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$7 -> this.client().traceLogStartOffsetChange(), x$8 -> this.client().traceLogSnapshotGeneration());
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    @Override
    public RecordSerde<T> recordSerde() {
        return this.serde;
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> serde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, ExternalKRaftMetrics externalKRaftMetrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.serde = serde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.externalKRaftMetrics = externalKRaftMetrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        Logging.$init$(this);
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
        this.executor = None$.MODULE$;
    }
}

