/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113AAC\u0006\u0001!!AQ\u0003\u0001BC\u0002\u0013%a\u0003\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u0018\u0011!)\u0003A!b\u0001\n\u00131\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u00119\u0002!Q1A\u0005\n=B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006u\u0001!\te\u000f\u0005\u0006\u0005\u0002!\te\u0011\u0002\u001e'R\u0014\u0018n\u0019;D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC*\u0011A\"D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0017%\u0011Ac\u0003\u0002 \u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0017\u0001\u0002;j[\u0016,\u0012a\u0006\t\u00031\tj\u0011!\u0007\u0006\u00035m\tQ!\u001e;jYNT!\u0001H\u000f\u0002\r\r|W.\\8o\u0015\tqaD\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<\u0017BA\u0012\u001a\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0017E,x\u000e^1TK:\u001cxN]\u000b\u0002OA\u0011\u0001fK\u0007\u0002S)\u0011!fG\u0001\b[\u0016$(/[2t\u0013\ta\u0013F\u0001\u0004TK:\u001cxN]\u0001\rcV|G/Y*f]N|'\u000fI\u0001\u001fG>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006l\u0015M\\1hKJ,\u0012\u0001\r\t\u0003%EJ!AM\u0006\u0003=\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018aH2p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"BAN\u001c9sA\u0011!\u0003\u0001\u0005\u0006+\u001d\u0001\ra\u0006\u0005\u0006K\u001d\u0001\ra\n\u0005\u0006]\u001d\u0001\r\u0001M\u0001\u000bSN,\u0005pY3fI\u0016$W#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000f\t{w\u000e\\3b]\u00061!/Z2pe\u0012$\"\u0001R$\u0011\u0005u*\u0015B\u0001$?\u0005\u0011)f.\u001b;\t\u000b!K\u0001\u0019A%\u0002\u000fA,'/\\5ugB\u0011QHS\u0005\u0003\u0017z\u0012a\u0001R8vE2,\u0007")
public class StrictControllerMutationQuota
extends AbstractControllerMutationQuota {
    private final Time time;
    private final Sensor quotaSensor;
    private final ControllerMutationQuotaManager controllerMutationQuotaManager;

    private Time time() {
        return this.time;
    }

    private Sensor quotaSensor() {
        return this.quotaSensor;
    }

    private ControllerMutationQuotaManager controllerMutationQuotaManager() {
        return this.controllerMutationQuotaManager;
    }

    @Override
    public boolean isExceeded() {
        return this.lastThrottleTimeMs() > 0L;
    }

    @Override
    public void record(double permits) {
        long timeMs = this.time().milliseconds();
        try {
            Sensor sensor = this.quotaSensor();
            synchronized (sensor) {
                this.quotaSensor().checkQuotas(timeMs);
                this.quotaSensor().record(permits, timeMs, false);
            }
        }
        catch (QuotaViolationException e) {
            this.updateThrottleTime(e, timeMs);
            throw new ThrottlingQuotaExceededException((int)this.lastThrottleTimeMs(), Errors.THROTTLING_QUOTA_EXCEEDED.message());
        }
    }

    public StrictControllerMutationQuota(Time time, Sensor quotaSensor, ControllerMutationQuotaManager controllerMutationQuotaManager) {
        this.time = time;
        this.quotaSensor = quotaSensor;
        this.controllerMutationQuotaManager = controllerMutationQuotaManager;
        super(time, controllerMutationQuotaManager);
    }
}

