/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStatus;
import kafka.server.FetcherPool;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSensorFactory;
import kafka.server.link.ClusterLinkSensorFactory$;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.FetcherRemoveReason;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskSensorsManager;
import kafka.server.link.TaskType;
import kafka.server.link.UnavailableLinkReason;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\rux!B&M\u0011\u0003\u0019f!B+M\u0011\u00031\u0006\"B/\u0002\t\u0003qf\u0001B0\u0002\u0001\u0001DQ!X\u0002\u0005\u00025DQ\u0001]\u0002\u0005\u0002EDQ!^\u0002\u0005\u0002EDaA^\u0002\u0005\u00021;\b\u0002CA\u0011\u0007\u0011\u0005A*a\t\t\u0011\u0005\u001d3\u0001\"\u0001M\u0003\u0013Bq!a\u001c\u0004\t\u0003a\u0015\u000fC\u0004\u0002r\r!\t!a\u001d\t\u000f\u0005U4\u0001\"\u0001\u0002x\u00191\u00111W\u0001\u0001\u0003kC!\"a/\u000e\u0005\u000b\u0007I\u0011AA_\u0011)\t)-\u0004B\u0001B\u0003%\u0011q\u0018\u0005\u0007;6!\t!a2\t\u0013\u00055WB1A\u0005\u0002\u0005=\u0007\u0002CAl\u001b\u0001\u0006I!!5\t\u000f\u0005eW\u0002\"\u0003\u0002\\\")\u0001/\u0004C\u0001c\")Q/\u0004C\u0001c\"9a/\u0004C\u0001\u0019\u00065\b\u0002CAz\u001b\u0011\u0005A*!>\t\u0011\u0005eX\u0002\"\u0001M\u0003wDq!!\u001d\u000e\t\u0003\t\u0019\bC\u0004\u0002\u00006!\tA!\u0001\t\u000f\t-R\u0002\"\u0001\u0003.!9!qI\u0007\u0005\u0002\t%\u0003b\u0002B,\u001b\u0011\u0005#\u0011\f\u0005\b\u0005[jA\u0011\tB8\u0011\u001d\u0011\u0019*\u0004C!\u0005+3aA!(\u0002\u0001\t}\u0005B\u0003BWA\t\u0015\r\u0011\"\u0001\u00030\"Q!Q\u0018\u0011\u0003\u0002\u0003\u0006IA!-\t\u0015\t}\u0006E!b\u0001\n\u0003\u0011\t\r\u0003\u0006\u0003D\u0002\u0012\t\u0011)A\u0005\u0003\u0017Aa!\u0018\u0011\u0005\u0002\t\u0015\u0007bBAmA\u0011%\u00111\u001c\u0005\u0006a\u0002\"\t%\u001d\u0005\bm\u0002\"\t\u0005\u0014Bg\u0011\u0015)\b\u0005\"\u0011r\u0011\u001d\t\t\b\tC!\u0003gBqAa5!\t\u0003\u0012)\u000eC\u0004\u0003Z\u0002\"\tEa7\t\u000f\r\u0005\u0001\u0005\"\u0011\u0004\u0004!91q\u0004\u0011\u0005B\r\u0005\u0002bBB$A\u0011\u00053\u0011\n\u0004\u0007\u0007\u001f\n\u0001a!\u0015\t\u0015\re\u0003G!b\u0001\n\u0003\u0011\t\r\u0003\u0006\u0004\\A\u0012\t\u0011)A\u0005\u0003\u0017A!b!\u00181\u0005\u000b\u0007I\u0011AB0\u0011)\u0019Y\u0007\rB\u0001B\u0003%1\u0011\r\u0005\u000b\u0007[\u0002$\u0011!Q\u0001\n\r=\u0004BCA4a\t\u0005\t\u0015!\u0003\u0004r!1Q\f\rC\u0001\u0007oB\u0011ba!1\u0005\u0004%\ta!\"\t\u0011\r\u001d\u0005\u0007)A\u0005\u0007_B\u0011b!#1\u0005\u0004%Iaa#\t\u0011\rE\u0005\u0007)A\u0005\u0007\u001bC\u0011ba%1\u0005\u0004%Ia!&\t\u0011\r\u0005\u0006\u0007)A\u0005\u0007/C\u0011ba)1\u0005\u0004%\ta!*\t\u0011\r5\u0006\u0007)A\u0005\u0007OC\u0011ba,1\u0005\u0004%\ta!-\t\u0011\re\u0006\u0007)A\u0005\u0007gC\u0011ba/1\u0005\u0004%\ta!0\t\u0011\r\u0015\u0007\u0007)A\u0005\u0007\u007fC1ba21\u0001\u0004\u0005\r\u0011\"\u0001\u0004J\"Y1\u0011\u001b\u0019A\u0002\u0003\u0007I\u0011ABj\u0011-\u0019I\u000e\ra\u0001\u0002\u0003\u0006Kaa3\t\u000bA\u0004D\u0011I9\t\u000bU\u0004D\u0011I9\t\u000f\rm\u0007\u0007\"\u0011\u0004^\"911\u001e\u0019\u0005B\r5\u0018!E\"mkN$XM\u001d'j].4\u0015-\u001b7fI*\u0011QJT\u0001\u0005Y&t7N\u0003\u0002P!\u000611/\u001a:wKJT\u0011!U\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0016!D\u0001M\u0005E\u0019E.^:uKJd\u0015N\\6GC&dW\rZ\n\u0003\u0003]\u0003\"\u0001W.\u000e\u0003eS\u0011AW\u0001\u0006g\u000e\fG.Y\u0005\u00039f\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001T\u000591U\r^2iKJl\u0015M\\1hKJ\u001cBaA,bOB\u0011!-\u001a\b\u0003)\u000eL!\u0001\u001a'\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003?\u001aT!\u0001\u001a'\u0011\u0005!\\W\"A5\u000b\u0005)\u0004\u0016!B;uS2\u001c\u0018B\u00017j\u0005\u001daunZ4j]\u001e$\u0012A\u001c\t\u0003_\u000ei\u0011!A\u0001\bgR\f'\u000f^;q)\u0005\u0011\bC\u0001-t\u0013\t!\u0018L\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0004ebl\b\"B=\b\u0001\u0004Q\u0018!\u00038fo\u000e{gNZ5h!\t!60\u0003\u0002}\u0019\n\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\t\u000by<\u0001\u0019A@\u0002\u0017U\u0004H-\u0019;fI.+\u0017p\u001d\t\u0007\u0003\u0003\t9!a\u0003\u000e\u0005\u0005\r!bAA\u00033\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00111\u0001\u0002\u0004'\u0016$\b\u0003BA\u0007\u00037qA!a\u0004\u0002\u0018A\u0019\u0011\u0011C-\u000e\u0005\u0005M!bAA\u000b%\u00061AH]8pizJ1!!\u0007Z\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011D-\u0002;\u0005$G\rT5oW\u0016$g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$2A]A\u0013\u0011\u001d\t9\u0003\u0003a\u0001\u0003S\t!\u0002]1si&$\u0018n\u001c8t!\u0019\tY#!\u000e\u0002<9!\u0011QFA\u0019\u001d\u0011\t\t\"a\f\n\u0003iK1!a\rZ\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\tA\u0011\n^3sC\ndWMC\u0002\u00024e\u0003B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\u0002\u0016aB2mkN$XM]\u0005\u0005\u0003\u000b\nyDA\u0005QCJ$\u0018\u000e^5p]\u0006\u0001#/Z7pm\u0016d\u0015N\\6fI\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\u0015\u0011\u00181JA3\u0011\u001d\t9#\u0003a\u0001\u0003\u001b\u0002b!!\u0001\u0002\b\u0005=\u0003\u0003BA)\u0003Cj!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0007G>lWn\u001c8\u000b\u0007E\u000bIF\u0003\u0003\u0002\\\u0005u\u0013AB1qC\u000eDWM\u0003\u0002\u0002`\u0005\u0019qN]4\n\t\u0005\r\u00141\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t9'\u0003a\u0001\u0003S\naA]3bg>t\u0007c\u0001+\u0002l%\u0019\u0011Q\u000e'\u0003'\u0019+Go\u00195feJ+Wn\u001c<f%\u0016\f7o\u001c8\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0002\u001b\r,(O]3oi\u000e{gNZ5h+\u0005Q\u0018\u0001\u00069beRLG/[8o\u001b&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0005\u0002z\u00055\u0015\u0011SAR!\u0011\tY(a\"\u000f\t\u0005u\u00141Q\u0007\u0003\u0003\u007fRA!!!\u0002T\u00059!/\u001a9mS\u000e\f\u0017\u0002BAC\u0003\u007f\nQBU3qY&\u001c\u0017m\u0015;biV\u001c\u0018\u0002BAE\u0003\u0017\u0013!\"T5se>\u0014\u0018J\u001c4p\u0015\u0011\t))a \t\u000f\u0005=E\u00021\u0001\u0002P\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAJ\u0019\u0001\u0007\u0011QS\u0001\u0016a\u0016\u00148/[:uK:$X*\u001b:s_J\u001cF/\u0019;f!\u0011\t9*!(\u000f\t\u0005m\u0014\u0011T\u0005\u0005\u00037\u000bY)\u0001\u0006NSJ\u0014xN]%oM>LA!a(\u0002\"\n)1\u000b^1uK*!\u00111TAF\u0011\u001d\t)\u000b\u0004a\u0001\u0003O\u000bQ#\u001e8bm\u0006LG.\u00192mK2Kgn\u001b*fCN|g\u000eE\u0003Y\u0003S\u000bi+C\u0002\u0002,f\u0013aa\u00149uS>t\u0007c\u0001+\u00020&\u0019\u0011\u0011\u0017'\u0003+Us\u0017M^1jY\u0006\u0014G.\u001a'j].\u0014V-Y:p]\ni1\t\\5f]Rl\u0015M\\1hKJ\u001cR!D,\u00028\u001e\u00042AYA]\u0013\r\t\u0019LZ\u0001\fi\u0006\u001c8.T1oC\u001e,'/\u0006\u0002\u0002@B\u0019A+!1\n\u0007\u0005\rGJ\u0001\fDYV\u001cH/\u001a:MS:\\G+Y:l\u001b\u0006t\u0017mZ3s\u00031!\u0018m]6NC:\fw-\u001a:!)\u0011\tI-a3\u0011\u0005=l\u0001bBA^!\u0001\u0007\u0011qX\u0001\ng\u000eDW\rZ;mKJ,\"!!5\u0011\u0007Q\u000b\u0019.C\u0002\u0002V2\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005IQ\r_2faRLwN\u001c\u000b\u0003\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0003mC:<'BAAt\u0003\u0011Q\u0017M^1\n\t\u0005-\u0018\u0011\u001d\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o)\u0015\u0011\u0018q^Ay\u0011\u0015Ih\u00031\u0001{\u0011\u0015qh\u00031\u0001\u0000\u0003%\tG\r\u001a+pa&\u001c7\u000fF\u0002s\u0003oDa!a=\u0018\u0001\u0004y\u0018\u0001\u0004:f[>4X\rV8qS\u000e\u001cHc\u0001:\u0002~\"1\u0011\u0011 \rA\u0002}\fACZ3uG\"$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHC\u0002B\u0002\u0005?\u00119\u0003\u0005\u0005\u0002\u0002\t\u0015\u00111\u0002B\u0005\u0013\u0011\u00119!a\u0001\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0003\f\tU!\u0011D\u0007\u0003\u0005\u001bQAAa\u0004\u0003\u0012\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\tM\u0011Q]\u0001\u0005kRLG.\u0003\u0003\u0003\u0018\t5!!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0019\u0001La\u0007\n\u0007\tu\u0011LA\u0002J]RDqA!\t\u001b\u0001\u0004\u0011\u0019#\u0001\u0004u_BL7m\u001d\t\u0007\u0003\u001b\u0011)#a\u0003\n\t\u0005%\u0011q\u0004\u0005\b\u0005SQ\u0002\u0019\u0001B\r\u0003%!\u0018.\\3pkRl5/A\bgKR\u001c\u0007\u000eV8qS\u000eLeNZ8t)\u0019\u0011yC!\u000f\u0003FAA\u0011\u0011\u0001B\u0003\u0003\u0017\u0011\t\u0004\u0005\u0004\u0003\f\tU!1\u0007\t\u0004)\nU\u0012b\u0001B\u001c\u0019\n!2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY%oM>DqAa\u000f\u001c\u0001\u0004\u0011i$A\ru_BL7m],ji\"\u001cF/\u0019:u\u001f\u001a47/\u001a;Ta\u0016\u001c\u0007\u0003CA\u0001\u0005\u000b\tYAa\u0010\u0011\u0007a\u0013\t%C\u0002\u0003De\u0013A\u0001T8oO\"9!\u0011F\u000eA\u0002\te\u0011!\u0004:fa2L7-Y*uCR,8\u000f\u0006\u0003\u0003L\tU\u0003\u0003CA\u0001\u0005\u000b\tyE!\u0014\u0011\r\t-!Q\u0003B(!\u0011\tiD!\u0015\n\t\tM\u0013q\b\u0002\u0010!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;vg\"9\u0011q\u0005\u000fA\u0002\u00055\u0013a\u0004;bg.$Um]2sSB$\u0018n\u001c8\u0015\t\tm#1\r\t\u00061\u0006%&Q\f\t\u0004)\n}\u0013b\u0001B1\u0019\nyA+Y:l\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003fu\u0001\rAa\u001a\u0002\u0011Q\f7o\u001b+za\u0016\u00042\u0001\u0016B5\u0013\r\u0011Y\u0007\u0014\u0002\t)\u0006\u001c8\u000eV=qK\u0006!\"/Z4jgR,'\u000fT1{sJ+7o\\;sG\u0016$2A\u001dB9\u0011\u001d\u0011\u0019H\ba\u0001\u0005k\nA\u0002\\1{sJ+7o\\;sG\u0016\u0004DAa\u001e\u0003\u0002B)AK!\u001f\u0003~%\u0019!1\u0010'\u0003\u00191\u000b'0\u001f*fg>,(oY3\u0011\t\t}$\u0011\u0011\u0007\u0001\t1\u0011\u0019I!\u001d\u0002\u0002\u0003\u0005)\u0011\u0001BC\u0005\ryF\u0005N\t\u0005\u0005\u000f\u0013i\tE\u0002Y\u0005\u0013K1Aa#Z\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0017BH\u0013\r\u0011\t*\u0017\u0002\u0004\u0003:L\u0018a\b9vE2L7MR1dS:<\u0017\t\u001a3ji&|g.\u00197UCN\\G+\u001f9fgR\u0011!q\u0013\t\u0007\u0003\u0003\u0011IJa\u001a\n\t\tm\u00151\u0001\u0002\u0004'\u0016\f(!E\"p]:,7\r^5p]6\u000bg.Y4feN1\u0001e\u0016BQ\u0005O\u00032A\u0019BR\u0013\r\u0011)K\u001a\u0002\u0019\u0013:\u0014w.\u001e8e\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014\bc\u00012\u0003*&\u0019!1\u00164\u00033=+HOY8v]\u0012\u001cuN\u001c8fGRLwN\\'b]\u0006<WM]\u0001\tY&t7\u000eR1uCV\u0011!\u0011\u0017\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*\u0019!q\u0017)\u0002\u0005i\\\u0017\u0002\u0002B^\u0005k\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0001\nY&t7\u000eR1uC\u0002\n1\u0003\\8dC2dunZ5dC2\u001cE.^:uKJ,\"!a\u0003\u0002)1|7-\u00197M_\u001eL7-\u00197DYV\u001cH/\u001a:!)\u0019\u00119M!3\u0003LB\u0011q\u000e\t\u0005\b\u0005[+\u0003\u0019\u0001BY\u0011\u001d\u0011y,\na\u0001\u0003\u0017!RA\u001dBh\u0005#DQ!\u001f\u0015A\u0002iDQA \u0015A\u0002}\fA\u0002\\5oW\u000ecWo\u001d;feN,\"Aa6\u0011\r\u0005\u0005!\u0011TA\u0006\u0003E)g.\u00192mK\u000ecWo\u001d;fe2Kgn\u001b\u000b\u0006e\nu'q\u001d\u0005\b\u0005?d\u0003\u0019\u0001Bq\u00035qW\r^<pe.\u001cE.[3oiB\u0019AKa9\n\u0007\t\u0015HJ\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]RDqA!;-\u0001\u0004\u0011Y/A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\u0015A\u0016\u0011\u0016Bw!\u0011\u0011yO!@\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\t](\u0011`\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0005w\f9&A\u0004dY&,g\u000e^:\n\t\t}(\u0011\u001f\u0002\u0015\u0003\u0012l\u0017N\\'fi\u0006$\u0017\r^1NC:\fw-\u001a:\u00021A\u0014xnY3tgJ+g/\u001a:tK\u000e{gN\\3di&|g\u000eF\u0003s\u0007\u000b\u0019)\u0002C\u0004\u0004\b5\u0002\ra!\u0003\u0002\u000f\rD\u0017M\u001c8fYB!11BB\t\u001b\t\u0019iA\u0003\u0003\u0004\u0010\u0005M\u0013a\u00028fi^|'o[\u0005\u0005\u0007'\u0019iA\u0001\u0007LC\u001a\\\u0017m\u00115b]:,G\u000eC\u0004\u0004\u00185\u0002\ra!\u0007\u0002\u0017I,g/\u001a:tK:{G-\u001a\t\u0005\u0007\u0017\u0019Y\"\u0003\u0003\u0004\u001e\r5!a\u0003*fm\u0016\u00148/\u001a(pI\u0016\f!$\u001b8ji&\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N$baa\t\u0004.\ru\u0002CBA\u0001\u00053\u001b)\u0003\u0005\u0004\u0003\f\tU1q\u0005\t\u0005\u0003?\u001cI#\u0003\u0003\u0004,\u0005\u0005(\u0001\u0002,pS\u0012Dqaa\f/\u0001\u0004\u0019\t$A\rj]&$\u0018.\u0019;f\u0007>tg.Z2uS>t'+Z9vKN$\b\u0003BB\u001a\u0007si!a!\u000e\u000b\t\r]\u00121K\u0001\te\u0016\fX/Z:ug&!11HB\u001b\u0005\u0005Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d\u0019yD\fa\u0001\u0007\u0003\naB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u00044\r\r\u0013\u0002BB#\u0007k\u0011aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\np]J+g/\u001a:tK\u000e{gN\\3di&|g\u000eF\u0003s\u0007\u0017\u001ai\u0005C\u0004\u0004\b=\u0002\ra!\u0003\t\u000f\r]q\u00061\u0001\u0004\u001a\tAb)Y5mK\u0012\u001cE.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0014\tA:61\u000b\t\u0004E\u000eU\u0013bAB,M\nYA*\u001b8l\u001b\u0016$(/[2t\u0003!a\u0017N\\6OC6,\u0017!\u00037j].t\u0015-\\3!\u0003\u001diW\r\u001e:jGN,\"a!\u0019\u0011\t\r\r4qM\u0007\u0003\u0007KRAa!\u0018\u0002T%!1\u0011NB3\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\ri\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e\u001f\t\u00061\u0006%\u00161\u0002\t\u0004)\u000eM\u0014bAB;\u0019\n\u0001b)Y5mK\u0012d\u0015N\\6SK\u0006\u001cxN\u001c\u000b\u000b\u0007s\u001aYh! \u0004\u0000\r\u0005\u0005CA81\u0011\u001d\u0019If\u000ea\u0001\u0003\u0017Aqa!\u00188\u0001\u0004\u0019\t\u0007C\u0004\u0004n]\u0002\raa\u001c\t\u000f\u0005\u001dt\u00071\u0001\u0004r\u00051A/\u001a8b]R,\"aa\u001c\u0002\u000fQ,g.\u00198uA\u0005\u0011RO\u001c9sK\u001aL\u00070\u001a3MS:\\g*Y7f+\t\u0019i\t\u0005\u0003\u0002`\u000e=\u0015\u0002BA\u000f\u0003C\f1#\u001e8qe\u00164\u0017\u000e_3e\u0019&t7NT1nK\u0002\nA\u0001^1hgV\u00111q\u0013\t\t\u00073\u001byj!$\u0002\f5\u001111\u0014\u0006\u0005\u0007;\u000b\u0019!A\u0005j[6,H/\u00192mK&!!qABN\u0003\u0015!\u0018mZ:!\u0003e1\u0017-\u001b7fI2Kgn[\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\r\u001d\u0006\u0003BA)\u0007SKAaa+\u0002T\tQQ*\u001a;sS\u000et\u0015-\\3\u00025\u0019\f\u0017\u000e\\3e\u0019&t7nQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u000f\u0019\f7\r^8ssV\u001111\u0017\t\u0004)\u000eU\u0016bAB\\\u0019\nA2\t\\;ti\u0016\u0014H*\u001b8l'\u0016t7o\u001c:GC\u000e$xN]=\u0002\u0011\u0019\f7\r^8ss\u0002\n!\u0003^1tWN+gn]8sg6\u000bg.Y4feV\u00111q\u0018\t\u0004)\u000e\u0005\u0017bABb\u0019\n\u0011B+Y:l'\u0016t7o\u001c:t\u001b\u0006t\u0017mZ3s\u0003M!\u0018m]6TK:\u001cxN]:NC:\fw-\u001a:!\u0003ya\u0017N\\6GC&dWO]3SKR\u0014\u00180\u0011;uK6\u0004Ho]*f]N|'/\u0006\u0002\u0004LB!11MBg\u0013\u0011\u0019ym!\u001a\u0003\rM+gn]8s\u0003\tb\u0017N\\6GC&dWO]3SKR\u0014\u00180\u0011;uK6\u0004Ho]*f]N|'o\u0018\u0013fcR\u0019!o!6\t\u0013\r]W)!AA\u0002\r-\u0017a\u0001=%c\u0005yB.\u001b8l\r\u0006LG.\u001e:f%\u0016$(/_!ui\u0016l\u0007\u000f^:TK:\u001cxN\u001d\u0011\u00027\rdWo\u001d;fe2Kgn\u001b+bg.\f5\r^5wKN+gn]8s)\u0019\u0019Yma8\u0004b\"9!QM%A\u0002\t\u001d\u0004bBBr\u0013\u0002\u00071Q]\u0001\u0018SNl\u0015N\u001d:peN#\u0018\r^3Ue\u0006t7/\u001b;j_:\u00042\u0001WBt\u0013\r\u0019I/\u0017\u0002\b\u0005>|G.Z1o\u0003q\u0019G.^:uKJd\u0015N\\6UCN\\\u0017J\\#se>\u00148+\u001a8t_J$\u0002ba3\u0004p\u000eE81\u001f\u0005\b\u0005KR\u0005\u0019\u0001B4\u0011\u001d\u0019\u0019O\u0013a\u0001\u0007KDqa!>K\u0001\u0004\u001990A\u0005feJ|'oQ8eKB\u0019Ak!?\n\u0007\rmHJA\u0007UCN\\WI\u001d:pe\u000e{G-\u001a")
public final class ClusterLinkFailed {

    public static class ClientManager
    implements ClusterLinkFactory.ClientManager,
    Logging {
        private final ClusterLinkTaskManager taskManager;
        private final ClusterLinkScheduler scheduler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ClientManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public boolean isActiveLinkCoordinator() {
            return ClusterLinkFactory.ClientManager.isActiveLinkCoordinator$(this);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public ClusterLinkTaskManager taskManager() {
            return this.taskManager;
        }

        @Override
        public ClusterLinkScheduler scheduler() {
            return this.scheduler;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up failed client manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down failed client manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        public void addTopics(Set<String> addTopics) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Adding topics ").append(addTopics).append(" for failed client manager").toString());
        }

        public void removeTopics(Set<String> removeTopics) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Removing topics ").append(removeTopics).append(" for failed client manager").toString());
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        public Map<String, CompletableFuture<Object>> fetchTopicPartitions(scala.collection.immutable.Set<String> topics, int timeoutMs) {
            throw this.exception();
        }

        public Map<String, CompletableFuture<ClusterLinkTopicInfo>> fetchTopicInfos(Map<String, Object> topicsWithStartOffsetSpec, int timeoutMs) {
            throw new InvalidClusterLinkException("Cluster link is in failed state.");
        }

        public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
            throw this.exception();
        }

        @Override
        public Option<TaskDescription> taskDescription(TaskType taskType) {
            throw this.exception();
        }

        @Override
        public void registerLazyResource(LazyResource<?> lazyResource) {
            throw this.exception();
        }

        @Override
        public Seq<TaskType> publicFacingAdditionalTaskTypes() {
            throw this.exception();
        }

        public ClientManager(ClusterLinkTaskManager taskManager) {
            this.taskManager = taskManager;
            ClusterLinkFactory.ClientManager.$init$(this);
            Logging.$init$(this);
            this.scheduler = taskManager.scheduler();
        }
    }

    public static class ConnectionManager
    implements ClusterLinkFactory.InboundConnectionManager,
    ClusterLinkFactory.OutboundConnectionManager {
        private final ClusterLinkData linkData;
        private final String localLogicalCluster;

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ConnectionManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public boolean active() {
            return ClusterLinkFactory.ConnectionManager.active$(this);
        }

        @Override
        public void onControllerChange(boolean isActive) {
            ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
        }

        @Override
        public void onLinkMetadataPartitionLeaderChange() {
            ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
        }

        @Override
        public int persistentConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
        }

        @Override
        public int reverseConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.ConnectionManager.lazyResources$(this);
        }

        @Override
        public boolean isLinkCoordinator() {
            return ClusterLinkFactory.ConnectionManager.isLinkCoordinator$(this);
        }

        @Override
        public Option<Object> linkCoordinatorId() {
            return ClusterLinkFactory.ConnectionManager.linkCoordinatorId$(this);
        }

        @Override
        public ClusterLinkData linkData() {
            return this.linkData;
        }

        @Override
        public String localLogicalCluster() {
            return this.localLogicalCluster;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            throw this.exception();
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public Seq<String> linkClusters() {
            return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()), Seq$.MODULE$.canBuildFrom());
        }

        @Override
        public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
            throw this.exception();
        }

        @Override
        public void processReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection is no longer required");
        }

        @Override
        public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
            throw new NetworkException("Cluster link has failed, connection cannot be created");
        }

        public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection not required any more");
        }

        public ConnectionManager(ClusterLinkData linkData, String localLogicalCluster) {
            this.linkData = linkData;
            this.localLogicalCluster = localLogicalCluster;
            ClusterLinkFactory.ConnectionManager.$init$(this);
        }
    }

    public static class FailedClusterLinkMetrics
    implements ClusterLinkFactory.LinkMetrics {
        private final String linkName;
        private final Metrics metrics;
        private final Option<String> tenant;
        private final String unprefixedLinkName;
        private final scala.collection.immutable.Map<String, String> tags;
        private final MetricName failedLinkCountMetricName;
        private final ClusterLinkSensorFactory factory;
        private final TaskSensorsManager taskSensorsManager;
        private Sensor linkFailureRetryAttemptsSensor;

        public String linkName() {
            return this.linkName;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Option<String> tenant() {
            return this.tenant;
        }

        private String unprefixedLinkName() {
            return this.unprefixedLinkName;
        }

        private scala.collection.immutable.Map<String, String> tags() {
            return this.tags;
        }

        public MetricName failedLinkCountMetricName() {
            return this.failedLinkCountMetricName;
        }

        public ClusterLinkSensorFactory factory() {
            return this.factory;
        }

        public TaskSensorsManager taskSensorsManager() {
            return this.taskSensorsManager;
        }

        public Sensor linkFailureRetryAttemptsSensor() {
            return this.linkFailureRetryAttemptsSensor;
        }

        public void linkFailureRetryAttemptsSensor_$eq(Sensor x$1) {
            this.linkFailureRetryAttemptsSensor = x$1;
        }

        @Override
        public void startup() {
            this.metrics().addMetric(this.failedLinkCountMetricName(), (x$1, x$2) -> 1.0);
            this.linkFailureRetryAttemptsSensor_$eq(this.factory().createSensorForTotalAndRateMetrics((Option<String>)new Some((Object)this.linkName()), (Option<Sensor>)None$.MODULE$, "link-failure-retry-attempts", "link failure retry attempts", this.factory().createSensorForTotalAndRateMetrics$default$5()));
            this.taskSensorsManager().createFailedLinkTasksSensors(this.factory());
        }

        @Override
        public void shutdown() {
            this.metrics().removeMetric(this.failedLinkCountMetricName());
            this.metrics().removeSensor(this.linkFailureRetryAttemptsSensor().name());
            this.taskSensorsManager().removeSensors();
        }

        @Override
        public Sensor clusterLinkTaskActiveSensor(TaskType taskType, boolean isMirrorStateTransition) {
            return this.taskSensorsManager().activeSensor(taskType, isMirrorStateTransition);
        }

        @Override
        public Sensor clusterLinkTaskInErrorSensor(TaskType taskType, boolean isMirrorStateTransition, TaskErrorCode errorCode) {
            return this.taskSensorsManager().inErrorSensor(taskType, isMirrorStateTransition, errorCode);
        }

        public FailedClusterLinkMetrics(String linkName, Metrics metrics, Option<String> tenantPrefix2, FailedLinkReason reason) {
            this.linkName = linkName;
            this.metrics = metrics;
            this.tenant = tenantPrefix2.map((Function1 & Serializable & scala.Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix));
            this.unprefixedLinkName = (String)this.tenant().map((Function1 & Serializable & scala.Serializable)t -> this.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.linkName());
            this.tags = ((TraversableOnce)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason.name())), (List)new .colon.colon((Object)this.tenant().map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
            this.failedLinkCountMetricName = new MetricName("broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), "Number of failed cluster links at the broker.", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
            this.factory = new ClusterLinkSensorFactory(metrics, this.tags(), ClusterLinkSensorFactory$.MODULE$.apply$default$3());
            this.taskSensorsManager = new TaskSensorsManager(linkName, this.tags(), metrics);
        }
    }

    public static class FetcherManager
    implements ClusterLinkFactory.FetcherManager,
    Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public boolean isEmpty() {
            return ClusterLinkFactory.FetcherManager.isEmpty$(this);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.FetcherManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public void maybeNotifyReadyForFetch(Partition partition) {
            ClusterLinkFactory.FetcherManager.maybeNotifyReadyForFetch$(this, partition);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.FetcherManager.lazyResources$(this);
        }

        @Override
        public int fetcherCount() {
            return ClusterLinkFactory.FetcherManager.fetcherCount$(this);
        }

        @Override
        public int fetcherCount(FetcherPool pool) {
            return ClusterLinkFactory.FetcherManager.fetcherCount$(this, pool);
        }

        @Override
        public int throttledPartitionCount() {
            return ClusterLinkFactory.FetcherManager.throttledPartitionCount$(this);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up failed fetcher manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down failed fetcher manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void addLinkedFetcherForPartitions(Iterable<Partition> partitions) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Adding linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void removeLinkedFetcherForPartitions(Set<TopicPartition> partitions, FetcherRemoveReason reason) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Removing linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void shutdownIdleFetcherThreads() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down idle fetcher threads for failed fetcher manager");
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public ReplicaStatus.MirrorInfo partitionMirrorState(TopicPartition topicPartition, ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason) {
            return new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.LINK_FAILED, -1L, -1L);
        }

        public FetcherManager() {
            ClusterLinkFactory.FetcherManager.$init$(this);
            Logging.$init$(this);
        }
    }
}

