/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.time.Duration;
import java.util.ServiceLoader;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkManager$ {
    public static ClusterLinkManager$ MODULE$;
    private final String LocalTenantPrefixProp;
    private final String LinkNameProp;
    private final String LinkMetricsModeProp;
    private final String IsMultiTenantProp;
    private final String migrateBootstrapOverrideTaskName;

    static {
        new ClusterLinkManager$();
    }

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public String LocalTenantPrefixProp() {
        return this.LocalTenantPrefixProp;
    }

    public String LinkNameProp() {
        return this.LinkNameProp;
    }

    public String LinkMetricsModeProp() {
        return this.LinkMetricsModeProp;
    }

    public String IsMultiTenantProp() {
        return this.IsMultiTenantProp;
    }

    public String migrateBootstrapOverrideTaskName() {
        return this.migrateBootstrapOverrideTaskName;
    }

    public ClientInterceptor prefixInterceptor(String localTenantPrefix, String clusterLinkPrefix, String linkName, ClusterLinkConfig.LinkMode linkModeForMetrics, Metrics metrics, boolean isMultiTenant, boolean clusterLinkPrefixConsumerGroup, boolean clusterLinkEnableMetricsReductionAdvanced, String ccloudIntranetHostSuffixes) {
        if (!linkName.startsWith(localTenantPrefix)) {
            throw new IllegalStateException(new StringBuilder(57).append("Tenant interceptor request for link '").append(linkName).append("' without prefix '").append(localTenantPrefix).append("''").toString());
        }
        String unprefixedLinkName = linkName.substring(localTenantPrefix.length());
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LocalTenantPrefixProp()), (Object)localTenantPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LinkNameProp()), (Object)unprefixedLinkName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LinkMetricsModeProp()), (Object)linkModeForMetrics), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)clusterLinkPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp()), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPrefixConsumerGroup)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IsMultiTenantProp()), (Object)BoxesRunTime.boxToBoolean((boolean)isMultiTenant)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.cluster.link.enable.metrics.reduction.advanced"), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkEnableMetricsReductionAdvanced)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.ccloud.intranet.host.suffixes"), (Object)ccloudIntranetHostSuffixes)}))).asJava();
        if (isMultiTenant) {
            return (ClientInterceptor)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ClientInterceptor.class)).asScala()).find((Function1 & Serializable & scala.Serializable)interceptor -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManager$.$anonfun$prefixInterceptor$1(configs, metrics, interceptor))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new InvalidClusterLinkException("Cluster link interceptor not found");
            });
        }
        Some interceptor2 = new Some((Object)((ClientInterceptor)Class.forName("io.confluent.kafka.link.ClusterLinkInterceptor").newInstance()));
        interceptor2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.configure(configs);
            return BoxedUnit.UNIT;
        });
        interceptor2.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.configureMetrics(metrics);
            return BoxedUnit.UNIT;
        });
        return (ClientInterceptor)interceptor2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InvalidClusterLinkException("Cluster link interceptor not found");
        });
    }

    public int hashValue(String name, int max) {
        return Utils.toPositive((int)Utils.murmur2((byte[])name.getBytes())) % max;
    }

    public AclBindingFilterTransformer aclBindingFilterTransform(Option<String> tenantPrefix, boolean isMultiTenant) {
        if (isMultiTenant && tenantPrefix.isDefined()) {
            return (AclBindingFilterTransformer)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(AclBindingFilterTransformer.class)).asScala()).find((Function1 & Serializable & scala.Serializable)transformer -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManager$.$anonfun$aclBindingFilterTransform$1(tenantPrefix, transformer))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new InvalidClusterLinkException("AclBindingFilterTransformer implementation not found.");
            });
        }
        return new IdentityAclBindingFilterTransformer();
    }

    public <T> void runAndCloseAdmin(KafkaFuture<T> result, Function1<KafkaFuture<T>, BoxedUnit> cb, boolean useTemporaryClient, ClusterLinkLocalAdmin admin) {
        try {
            cb.apply(result);
        }
        finally {
            if (useTemporaryClient) {
                admin.close(Duration.ZERO);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$prefixInterceptor$1(java.util.Map configs$1, Metrics metrics$1, ClientInterceptor interceptor) {
        try {
            interceptor.configure(configs$1);
            interceptor.configureMetrics(metrics$1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aclBindingFilterTransform$1(Option tenantPrefix$1, AclBindingFilterTransformer transformer) {
        try {
            transformer.configure((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.LocalTenantPrefixProp()), tenantPrefix$1.get())}))));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ClusterLinkManager$() {
        MODULE$ = this;
        this.LocalTenantPrefixProp = "cluster.link.local.tenant.prefix";
        this.LinkNameProp = "cluster.link.name";
        this.LinkMetricsModeProp = "cluster.link.metrics.mode";
        this.IsMultiTenantProp = "multi.tenant.enabled";
        this.migrateBootstrapOverrideTaskName = "MigrateBootstrapOverride";
    }
}

