/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionStatus;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.FollowerRestorePoint;

public interface TierPartitionState {
    public void setTieredPartitionRecoveryWorkflowCb(Consumer<RecoveryOperation> var1);

    public TopicPartition topicPartition();

    public Optional<TopicIdPartition> topicIdPartition();

    public File dir();

    public Optional<Long> startOffset() throws IOException;

    public boolean setTopicId(UUID var1) throws IOException;

    public long committedEndOffset() throws IOException;

    public long endOffset() throws IOException;

    public long dataEndOffset() throws IOException;

    public long compactDirtyStartOffset() throws IOException;

    public CompactStats lastCompactStats() throws IOException;

    public CompactStats accumulatedCompactStats() throws IOException;

    public OffsetAndEpoch lastLocalMaterializedSrcOffsetAndEpoch();

    public long lastSnapshotTimestampMs();

    public UUID lastSnapshotId();

    public UUID lastCommittedSnapshotId();

    public int numSegments();

    public int numSegments(long var1, long var3);

    public Iterator<TierLogSegment> segments();

    public Iterator<TierLogSegment> segments(long var1, long var3);

    public List<SegmentState> segmentInMemoryMetadataRange(long var1, long var3);

    public Optional<SegmentState> previousMetadataBeforeOffset(long var1);

    public FollowerRestorePoint followerRestorePoint(long var1);

    public Optional<TierLogSegment> metadata(long var1) throws IOException;

    public Collection<TierLogSegment> fencedSegments();

    public Collection<TierLogSegment> compactedSegments();

    public AppendResult append(AbstractTierMetadata var1, OffsetAndEpoch var2);

    public RestoreResult processRestoreEvents(AbstractTierMetadata var1, Optional<ByteBuffer> var2, TierPartitionStatus var3, OffsetAndEpoch var4);

    public RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete var1, ByteBuffer var2, OffsetAndEpoch var3);

    public long totalSize() throws IOException;

    public long stateFileSize();

    public int tierEpoch() throws IOException;

    public boolean isTieringEnabled();

    public boolean mayContainTieredData();

    public boolean maybeOpenChannelOnOffsetTieredException() throws IOException;

    public boolean setTieringEnabled() throws IOException;

    public void setTieringDisabled();

    public boolean flush() throws IOException;

    public Path backupStateForRecovery();

    public boolean validateChecksum() throws IOException, InstantiationException, IllegalAccessException;

    public void beginCatchup();

    public void onCatchUpComplete();

    public void beginDiscover();

    public void onDiscoverComplete();

    public CompletableFuture<TierLogSegment> materializeUptoOffset(long var1) throws IOException;

    public CompletableFuture<TierLogSegment> materializeUptoObjectIdAndRestoreEpoch(long var1, UUID var3, int var4) throws IOException;

    public CompletableFuture<Optional<TierLogSegment>> materializeUptoLeaderEpoch(int var1) throws IOException;

    public CompletableFuture<Boolean> trackMetadataInitialization(int var1) throws IOException;

    public TierPartitionStatus status();

    public long materializationLag();

    public void updateDir(File var1) throws IOException;

    public void delete() throws IOException;

    public void close() throws IOException;

    public void closeHandlers() throws IOException;

    public static enum RecoveryOperation {
        FREEZE_MERGED_LOG_START_OFFSET,
        RECOMPUTE_MERGED_LOG_START_OFFSET,
        UNFREEZE_MERGED_LOG_START_OFFSET;

    }

    public static enum RestoreResult {
        SUCCEEDED,
        FAILED;

    }

    public static enum AppendResult {
        NOT_TIERABLE,
        FENCED,
        ACCEPTED,
        FAILED,
        RESTORE_FENCED;

    }
}

