/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import kafka.log.AbortedTransactionMetadata;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierLogCompactionFatalException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.CompactStats;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.store.objects.CompactedSegmentUpload;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter$;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001\u0002\r\u001a\u0001\tB\u0011\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u001d\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\ta\u0002\u0011\t\u0011)A\u0005u!A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011)\t9\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\t\t\u0004\u0001C)\u0003gAq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005\u0002CAp\u0001\u0011\u0005\u0011$!9\t\u000f\t}\u0001\u0001\"\u0011\u0003\"!9!Q\u0007\u0001\u0005B\t]\"a\u0003+jKJ\u001cE.Z1oKJT!AG\u000e\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002\u001d;\u0005)A/Y:lg*\u0011adH\u0001\u0005i&,'OC\u0001!\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019z\u0012a\u00017pO&\u0011\u0001&\n\u0002\b\u00072,\u0017M\\3s\u0003%ygMZ:fi6\u000b\u0007\u000f\u0005\u0002,m5\tAF\u0003\u0002'[)\u0011afL\u0001\nS:$XM\u001d8bYNT!\u0001M\u0019\u0002\u000fM$xN]1hK*\u0011\u0001E\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028Y\tIqJ\u001a4tKRl\u0015\r]\u0005\u0003S\u001d\nA\"[8Ck\u001a4WM]*ju\u0016\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u00121!\u00138u\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0017a\u00053va\n+hMZ3s\u0019>\fGMR1di>\u0014\bCA\u001eD\u0013\t!EH\u0001\u0004E_V\u0014G.Z\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"a\u0012&\u000e\u0003!S!!S\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0005-C%!\u0003+ie>$H\u000f\\3s\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004\"AT(\u000e\u0003eI!\u0001U\r\u0003+QKWM]\"p[B\f7\r^5p]6+GO]5dg\u0006!A/[7f!\t\u0019v+D\u0001U\u0015\tIUK\u0003\u0002Wc\u000511m\\7n_:L!\u0001\u0017+\u0003\tQKW.Z\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB\u00111LX\u0007\u00029*\u0011Q,H\u0001\u0006gR|'/Z\u0005\u0003?r\u0013q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\baV$Xj\u001c3f!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0004d_:4\u0017n\u001a\u0006\u0003MF\naa]3sm\u0016\u0014\u0018B\u00015d\u0005q\u0019VmZ7f]RlU\r^1eCR\fG*Y=pkR\u0004V\u000f^'pI\u0016\f\u0011\u0003^5feR{\u0007/[2BaB,g\u000eZ3s!\tYg.D\u0001m\u0015\tiW$A\u0003u_BL7-\u0003\u0002pY\n\tB+[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\u0004GRD\bCA:w\u001b\u0005!(BA;\u001e\u0003\u001d1W\r^2iKJL!a\u001e;\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0013\rDWmY6E_:,\u0007#B\u001e{y\u0006\u0005\u0011BA>=\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002~}6\tQ+\u0003\u0002\u0000+\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA\u001e\u0002\u0004%\u0019\u0011Q\u0001\u001f\u0003\tUs\u0017\u000e^\u0001\fe\u0016$(/\u001f)pY&\u001c\u0017\u0010E\u0002\\\u0003\u0017I1!!\u0004]\u0005i!\u0016.\u001a:PE*,7\r^*u_J,'+\u001a;ssB{G.[2z\u0003\u0019a\u0014N\\5u}Qq\u00121CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012q\u0006\t\u0003\u001d\u0002AQ!K\bA\u0002)BQ!O\bA\u0002iBQ\u0001Q\bA\u0002iBQ!Q\bA\u0002\tCQ!R\bA\u0002\u0019CQ\u0001T\bA\u00025CQ!U\bA\u0002ICQ!W\bA\u0002iCQ\u0001Y\bA\u0002\u0005DQ![\bA\u0002)DQ\u0001]\bA\u0002iBQ!]\bA\u0002IDQ\u0001_\bA\u0002eDq!a\u0002\u0010\u0001\u0004\tI!\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!\u000e\u0011\t\u0005]\u0012Q\t\b\u0005\u0003s\t\t\u0005E\u0002\u0002<qj!!!\u0010\u000b\u0007\u0005}\u0012%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007b\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002Dq\nQa\u00197fC:$B!a\u0014\u0002bA91(!\u0015\u0002V\u0005m\u0013bAA*y\t1A+\u001e9mKJ\u00022aOA,\u0013\r\tI\u0006\u0010\u0002\u0005\u0019>tw\rE\u0002%\u0003;J1!a\u0018&\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011\u001d\t\u0019'\u0005a\u0001\u0003K\n\u0011b\u00197fC:\f'\r\\3\u0011\u0007\u0011\n9'C\u0002\u0002j\u0015\u00121b\u00117fC:\u0004\u0016M]1ng\u0006YAm\u001c+jKJ\u001cE.Z1o)\u0019\ty%a\u001c\u0002t!9\u0011\u0011\u000f\nA\u0002\u0005\u0015\u0014aC2mK\u0006t\u0007+\u0019:b[NDq!!\u001e\u0013\u0001\u0004\t)&A\u0006dkJ\u0014XM\u001c;US6,\u0017AF;qI\u0006$X\r\u001a'bgR\u001cE.Z1o\u001f\u001a47/\u001a;\u0015\r\u0005U\u00131PA@\u0011\u001d\tih\u0005a\u0001\u0003+\na\u0002\u001d:pa>\u001cX\rZ(gMN,G\u000fC\u0004\u0002\u0002N\u0001\r!a!\u0002!\r|W\u000e]1di\u000e{W\u000e\u001d7fi\u0016$\u0007cA\u001e\u0002\u0006&\u0019\u0011q\u0011\u001f\u0003\u000f\t{w\u000e\\3b]\u0006Y2M]3bi\u0016\fe\u000eZ,sSR,7i\\7nSR\fe\u000eZ*xCB$B#!\u0001\u0002\u000e\u0006U\u0015\u0011UAS\u0003S\u000bY+!1\u0002X\u0006m\u0007B\u0002\u0014\u0015\u0001\u0004\ty\tE\u0002%\u0003#K1!a%&\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005]E\u00031\u0001\u0002\u001a\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u00037\u000bi*D\u0001\u001e\u0013\r\ty*\b\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Da!a)\u0015\u0001\u0004Q\u0014!\u0003;jKJ,\u0005o\\2i\u0011\u001d\t9\u000b\u0006a\u0001\u00037\nQa\u001d;biNDq!!!\u0015\u0001\u0004\t\u0019\tC\u0004\u0002.R\u0001\r!a,\u0002\u001dM|WO]2f'\u0016<W.\u001a8ugB1\u0011\u0011WA\\\u0003wk!!a-\u000b\u0007\u0005UF(\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00024\nA\u0011\n^3sC\ndW\rE\u0002%\u0003{K1!a0&\u00059!\u0016.\u001a:M_\u001e\u001cVmZ7f]RDq!a1\u0015\u0001\u0004\t)-\u0001\u000beKN$\u0018N\\1uS>twJ\u00196fGRLEm\u001d\t\u0007\u0003c\u000b9,a2\u0011\t\u0005%\u00171[\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006!Q\u000f^5m\u0015\t\t\t.\u0001\u0003kCZ\f\u0017\u0002BAk\u0003\u0017\u0014A!V+J\t\"9\u0011\u0011\u001c\u000bA\u0002\u0005U\u0013\u0001\u00054jeN$8\t\\3b]>3gm]3u\u0011\u001d\ti\u000e\u0006a\u0001\u0003+\nq\u0002\\1ti\u000ecW-\u00198PM\u001a\u001cX\r^\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015)\u0005\r\u0018q_A}\u0005\u0007\u00119A!\u0003\u0003\f\tU!\u0011\u0004B\u000f!\u001dY\u0014\u0011KAs\u0003c\u0004b!a:\u0002n\u0006mVBAAu\u0015\u0011\tY/a-\u0002\u000f5,H/\u00192mK&!\u0011q^Au\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0004W\u0005M\u0018bAA{Y\tQAj\\4TK\u001elWM\u001c;\t\r\u0019*\u0002\u0019AAH\u0011\u001d\tY0\u0006a\u0001\u0003{\f\u0001b]3h[\u0016tGo\u001d\t\u0007\u0003O\fy0a/\n\t\t\u0005\u0011\u0011\u001e\u0002\u0006#V,W/\u001a\u0005\u0007\u0005\u000b)\u0002\u0019\u0001\u0016\u0002\u00075\f\u0007\u000fC\u0004\u0002vU\u0001\r!!\u0016\t\u000f\u0005\u001dV\u00031\u0001\u0002\\!9!QB\u000bA\u0002\t=\u0011a\u0005;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007c\u0001\u0013\u0003\u0012%\u0019!1C\u0013\u00035\rcW-\u00198fIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\t]Q\u00031\u0001\u0002V\u0005)B.Z4bGf$U\r\\3uK\"{'/\u001b>p]6\u001b\bb\u0002B\u000e+\u0001\u0007\u0011QK\u0001 kB\u0004XM\u001d\"pk:$wJ\u001a4tKR|em\u00117fC:Lgn\u001a*pk:$\u0007bBAL+\u0001\u0007\u0011\u0011T\u0001\fY><7+Z4nK:$8\u000f\u0006\u0005\u0003$\t-\"Q\u0006B\u0019!\u0019\t\t,a.\u0003&A\u0019AEa\n\n\u0007\t%REA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\t\r\u00192\u0002\u0019AAH\u0011\u001d\u0011yC\u0006a\u0001\u0003+\nAA\u001a:p[\"9!1\u0007\fA\u0002\u0005U\u0013A\u0001;p\u0003i\u0019w\u000e\u001c7fGR\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)!\u0011ID!\u0015\u0003T\t]\u0003C\u0002B\u001e\u0005\u000b\u0012YE\u0004\u0003\u0003>\t\u0005c\u0002BA\u001e\u0005\u007fI\u0011!P\u0005\u0004\u0005\u0007b\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u000f\u0012IE\u0001\u0003MSN$(b\u0001B\"yA\u00191F!\u0014\n\u0007\t=CF\u0001\u0006BE>\u0014H/\u001a3Uq:DaAJ\fA\u0002\u0005=\u0005b\u0002B+/\u0001\u0007\u0011QK\u0001\u0006gR\f'\u000f\u001e\u0005\b\u00053:\u0002\u0019AA+\u0003\r)g\u000e\u001a")
public class TierCleaner
extends Cleaner {
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final TierObjectStore tierObjectStore;
    private final SegmentMetadataLayoutPutMode putMode;
    private final TierTopicAppender tierTopicAppender;
    private final int leaderEpoch;
    private final CancellationContext ctx;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final TierObjectStoreRetryPolicy retryPolicy;

    @Override
    public String loggerName() {
        return TierCleaner.class.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        this.checkDone.apply((Object)cleanable.log().topicPartition());
        Tuple2<Object, CleanerStats> tuple2 = this.doTierClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, CleanerStats> doTierClean(CleanParams cleanParams, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Beginning cleaning of log ").append(cleanParams.log().name()).append(" with ").append(cleanParams).toString());
        Option option = ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cleanParams.log().localLogSegments(0L, cleanParams.firstDirtyOffset())).asScala()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanParams.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        if (cleanParams.topicIdPartition().isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(72).append("CleanParams for tiered compactions must have a valid topic id partition ").append(cleanParams).toString());
        }
        AbstractLog log = cleanParams.log();
        TopicIdPartition topicIdPartition = (TopicIdPartition)cleanParams.topicIdPartition().get();
        CleanerStats stats = new CleanerStats(this.time, this.tierCompactionMetrics.cleanerMetrics());
        long firstDirtyOffset = cleanParams.firstDirtyOffset();
        long upperBoundOffset = cleanParams.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, firstDirtyOffset, upperBoundOffset, super.offsetMap(), stats);
        if (super.offsetMap().latestOffset() == -1L) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for %s has latest offset of -1, no offsets to compact")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)stats);
        }
        long endOffset = super.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("CompactionTask for ").append(topicIdPartition).append(" endOffset: ").append(endOffset).append(" upperBoundOffset: ").append(upperBoundOffset).toString());
        Queue tieredSegments = (Queue)new Queue().$plus$plus$eq(log.tieredLogSegments(cleanParams.startOffset(), endOffset));
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)tieredSegments.lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.maxTimestamp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cleaning log tiered segments for cleaning ").append(tieredSegments.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.metadata(), Queue$.MODULE$.canBuildFrom())).append(" vs ").append(log.tieredLogSegments().toList()).toString());
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        while (tieredSegments.nonEmpty()) {
            void var23_17;
            void var22_16;
            Tuple2<ListBuffer<TierLogSegment>, LogSegment> tuple2 = this.cleanSegments(log, (Queue<TierLogSegment>)tieredSegments, super.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs, upperBoundOffset, topicIdPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer segmentsUsed = (ListBuffer)tuple2._1();
            LogSegment cleanedSegment = (LogSegment)tuple2._2();
            void segmentsUsed2 = var22_16;
            void cleanedSegment2 = var23_17;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TierCleaner.$anonfun$doTierClean$9(topicIdPartition, (ListBuffer)segmentsUsed2, tieredSegments)));
            try {
                java.util.List<FragmentDescriptionWrapper> list;
                if (segmentsUsed2.isEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append(topicIdPartition).append(": cleanSegments cleaned no segment because some source segments are deleted. ").append("Continue to clean next source segment").toString());
                    continue;
                }
                if (cleanedSegment2.size() == 0) {
                    boolean compactCompleted = true;
                    long firstCleanOffset = cleanParams.startOffset();
                    long lastCleanOffset = this.updatedLastCleanOffset(((TierLogSegment)segmentsUsed2.last()).endOffset(), compactCompleted);
                    this.info((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TierCleaner.$anonfun$doTierClean$11(topicIdPartition, (ListBuffer)segmentsUsed2)));
                    this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)segmentsUsed2, (Iterable<UUID>)Nil$.MODULE$, firstCleanOffset, lastCleanOffset);
                    continue;
                }
                Option<ByteBuffer> producerStateOpt = TierLogCompactionUtils$.MODULE$.fetchProducerState(this.tierObjectStore, (TierLogSegment)segmentsUsed2.last(), this.ctx, this.retryPolicy);
                Option<ByteBuffer> epochStateOpt = TierLogCompactionUtils$.MODULE$.fetchEpochState(this.tierObjectStore, (TierLogSegment)segmentsUsed2.last(), this.ctx, this.retryPolicy);
                long nextOffset = ((TierLogSegment)segmentsUsed2.last()).endOffset() + 1L;
                java.util.List completedAbortedTxns = cleanedSegment2.collectAbortedTxns((long)cleanedSegment2.baseOffset(), (long)nextOffset, (boolean)true).abortedTransactions;
                java.util.List ongoingAbortedTxns = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)transactionMetadata.ongoingAbortedTxns().values().filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$doTierClean$12(x$16)))).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.abortedTxn(), Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.lastOffset()), (Ordering)Ordering.Long$.MODULE$)).asJava();
                ArrayList abortedTxns = new ArrayList(completedAbortedTxns.size() + ongoingAbortedTxns.size());
                abortedTxns.addAll(completedAbortedTxns);
                abortedTxns.addAll(ongoingAbortedTxns);
                Optional abortedTxnsBytes = AbortedTxn.serialize(abortedTxns);
                OpaqueData opaqueData = (OpaqueData)Option$.MODULE$.apply((Object)this.tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable & scala.Serializable)() -> OpaqueData.ZEROED);
                try {
                    list = FragmentDescriptionWrapper.createFragmentDescriptionsList(topicIdPartition, this.putMode, cleanedSegment2.size(), cleanedSegment2.offsetIndex().length(), cleanedSegment2.timeIndex().length(), BoxesRunTime.unboxToInt((Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(abortedTxnsBytes)).map((Function1 & Serializable & scala.Serializable)bb -> BoxesRunTime.boxToInteger((int)TierCleaner.$anonfun$doTierClean$16(bb))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), BoxesRunTime.unboxToInt((Object)epochStateOpt.map((Function1 & Serializable & scala.Serializable)bb -> BoxesRunTime.boxToInteger((int)TierCleaner.$anonfun$doTierClean$18(bb))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), BoxesRunTime.unboxToInt((Object)producerStateOpt.map((Function1 & Serializable & scala.Serializable)bb -> BoxesRunTime.boxToInteger((int)TierCleaner.$anonfun$doTierClean$20(bb))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
                }
                catch (IllegalArgumentException e) {
                    throw new TierLogCompactionFatalException(new StringBuilder(90).append("CompactionTask failed ").append("while attempting to describe the metadata layout of a segment from ").append(topicIdPartition).append(".").toString(), (Throwable)e);
                }
                java.util.List<FragmentDescriptionWrapper> fragmentDescriptionsList = list;
                TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, this.leaderEpoch, UUID.randomUUID(), Optional.empty(), cleanedSegment2.baseOffset(), cleanedSegment2.readNextOffset() - 1L, cleanedSegment2.largestTimestamp(), cleanedSegment2.getFirstBatchTimestamp(), cleanedSegment2.size(), epochStateOpt.isDefined(), abortedTxnsBytes.isPresent(), producerStateOpt.isDefined(), TierUploadType.Compaction, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), opaqueData, Optional.of(fragmentDescriptionsList));
                TierLogCompactionUtils$.MODULE$.writeUploadInitiateMarker(uploadInitiate, topicIdPartition, this.time, this.tierTopicAppender);
                ObjectMetadata objectStoreMetadata = new ObjectMetadata(topicIdPartition, uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), opaqueData, uploadInitiate.segmentAndMetadataLayout().orElse(null));
                this.tierObjectStore.putSegment(new CompactedSegmentUpload(this.putMode, objectStoreMetadata, cleanedSegment2.log().file(), cleanedSegment2.offsetIndex().file(), cleanedSegment2.timeIndex().file(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(producerStateOpt)), (Optional<ByteBuffer>)abortedTxnsBytes, (Optional<ByteBuffer>)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(epochStateOpt))));
                boolean compactCompleted = tieredSegments.isEmpty();
                long firstCleanOffset = cleanParams.startOffset();
                long lastCleanOffset = this.updatedLastCleanOffset(uploadInitiate.endOffset(), compactCompleted);
                this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)segmentsUsed2, (Iterable<UUID>)new .colon.colon((Object)uploadInitiate.objectId(), (List)Nil$.MODULE$), firstCleanOffset, lastCleanOffset);
            }
            finally {
                if (cleanedSegment2 == null) continue;
                cleanedSegment2.deleteIfExists();
            }
        }
        stats.bufferUtilization_$eq(super.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    private long updatedLastCleanOffset(long proposedOffset, boolean compactCompleted) {
        if (proposedOffset >= super.offsetMap().latestOffset()) {
            return super.offsetMap().latestOffset();
        }
        if (compactCompleted) {
            return super.offsetMap().latestOffset();
        }
        return proposedOffset;
    }

    private void createAndWriteCommitAndSwap(AbstractLog log, TopicIdPartition topicIdPartition, int tierEpoch, CleanerStats stats, boolean compactCompleted, Iterable<TierLogSegment> sourceSegments, Iterable<UUID> destinationObjectIds, long firstCleanOffset, long lastCleanOffset) {
        java.util.Set sourceObjectIds = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)sourceSegments.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.metadata().objectId(), Iterable$.MODULE$.canBuildFrom())).toSet()).asJava();
        CompactStats compactStats = compactCompleted ? new CompactStats(stats.bytesRead(), stats.bytesWritten(), stats.mapBytesRead()) : CompactStats.EMPTY;
        TierCompactionCommitAndSwap commitAndSwap = new TierCompactionCommitAndSwap(topicIdPartition, tierEpoch, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), UUID.randomUUID(), sourceObjectIds, (java.util.Set<UUID>)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)destinationObjectIds.toSet()).asJava()), firstCleanOffset, lastCleanOffset, compactStats);
        TierLogCompactionUtils$.MODULE$.writeCommitAndSwapMarker(commitAndSwap, topicIdPartition, this.time, this.tierTopicAppender);
    }

    public Tuple2<ListBuffer<TierLogSegment>, LogSegment> cleanSegments(AbstractLog log, Queue<TierLogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, long upperBoundOffsetOfCleaningRound, TopicIdPartition topicIdPartition) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Cleaning log ").append(log.name()).append(" cleanSegments tiered segments ").append(segments).toString());
        ListBuffer segmentsUsed = new ListBuffer();
        ChecksumParams checksumParams = new ChecksumParams(log.checksumParams().checksumStoreOpt(), log.checksumParams().e2eChecksumEnabledForTopic(), false);
        LogSegment cleanedSegment = MergedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((TierLogSegment)segments.head()).baseOffset(), true, checksumParams);
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleanedSegment.txnIndex()));
        Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
        boolean cleanedSegmentDone = false;
        int targetSegmentSize = log.config().segmentSize;
        int minSegmentSize = log.config().confluentLogConfig().tierCleanerCompactSegmentMinBytes;
        int maxSegmentSize = Integer.MAX_VALUE;
        while (segments.nonEmpty() && !cleanedSegmentDone) {
            TierLogSegment currentSegment = (TierLogSegment)segments.head();
            cleanedSegmentDone = !TierLogCompactionUtils$.MODULE$.shouldCompactNextSourceSegmentIntoDestSegment(topicIdPartition, cleanedSegment, currentSegment, targetSegmentSize, minSegmentSize, maxSegmentSize);
            if (cleanedSegmentDone) continue;
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions(this.tierObjectStore, currentSegment, this.ctx, this.retryPolicy);
            transactionMetadata.addAbortedTransactions(abortedTransactions);
            boolean retainLegacyDeletesAndTxnMarkers = currentSegment.maxTimestamp() > legacyDeleteHorizonMs;
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append(topicIdPartition).append(": cleaning ").append(currentSegment).append(" into ").append(cleanedSegment.baseOffset()).append(" ").append("with upper bound deleteHorizonMs=").append(legacyDeleteHorizonMs).append(", retainDeletesAndTxnMarkers=").append(retainLegacyDeletesAndTxnMarkers).append(".").toString());
                segments.dequeue();
                if (currentSegment.endOffset() < log.logStartOffset()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append(topicIdPartition).append(": end offset of segment ").append(currentSegment).append(" is smaller than log start offset ").append(log.logStartOffset()).append(". ").append("Discard current result and continue to clean next segments.").toString());
                    segmentsUsed.clear();
                    cleanedSegmentDone = true;
                    continue;
                }
                segmentsUsed.$plus$eq((Object)currentSegment);
                TierLogSegmentReadAdapter segmentAdapter = TierLogSegmentReadAdapter$.MODULE$.apply(currentSegment, this.tierObjectStore, this.ctx, this.retryPolicy);
                this.cleanInto(log.topicPartition(), segmentAdapter, cleanedSegment, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, upperBoundOffsetOfCleaningRound, stats, currentTime, log.config().confluentLogConfig().logCleanerTimestampValidationEnable);
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append(topicIdPartition).append(": LogSegmentOffsetOverflowException cause to abort, ").append(e.getCause()).toString());
                try {
                    try {
                        cleanedSegment.deleteIfExists();
                    }
                    catch (Exception deleteException) {
                        e.addSuppressed((Throwable)deleteException);
                    }
                }
                catch (Throwable throwable) {
                    throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
                }
                throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
            }
        }
        cleanedSegment.onBecomeInactiveSegment();
        return new Tuple2((Object)segmentsUsed, (Object)cleanedSegment);
    }

    @Override
    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return log.tieredLogSegments(from, to).map((Function1 & Serializable & scala.Serializable)x$20 -> TierLogSegmentReadAdapter$.MODULE$.apply((TierLogSegment)x$20, $this.tierObjectStore, $this.ctx, $this.retryPolicy)).dropWhile((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$logSegments$2(from, x$21))).toList();
    }

    @Override
    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        Iterator<TierLogSegment> tieredSegments = log.tieredLogSegments(start, end);
        HashSet abortedTxnSet = new HashSet();
        tieredSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions($this.tierObjectStore, (TierLogSegment)segment, $this.ctx, $this.retryPolicy);
            return (HashSet)abortedTxnSet.$plus$plus$eq(abortedTransactions);
        });
        return abortedTxnSet.toList();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$9(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1, Queue tieredSegments$1) {
        return new StringBuilder(55).append("Cleaning ").append(topicIdPartition$6).append(", after cleanSegments we have used ").append(segmentsUsed$1).append(" with ").append(tieredSegments$1).append(" left").toString();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$11(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1) {
        return new StringBuilder(87).append("Fully deleting all segments for ").append(topicIdPartition$6).append(" due to empty generated segment source source segments ").append(segmentsUsed$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$doTierClean$12(AbortedTransactionMetadata x$16) {
        return x$16.lastRetainedBatchOffset().nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$16(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$18(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ int $anonfun$doTierClean$20(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, TierLogSegmentReadAdapter x$21) {
        return x$21.endOffset() < from$1;
    }

    public TierCleaner(OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierTopicAppender tierTopicAppender, int leaderEpoch, CancellationContext ctx, Function1<TopicPartition, BoxedUnit> checkDone, TierObjectStoreRetryPolicy retryPolicy) {
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        this.tierObjectStore = tierObjectStore;
        this.putMode = putMode;
        this.tierTopicAppender = tierTopicAppender;
        this.leaderEpoch = leaderEpoch;
        this.ctx = ctx;
        this.checkDone = checkDone;
        this.retryPolicy = retryPolicy;
        super(-1, offsetMap, ioBufferSize, maxIoBufferSize, dupBufferLoadFactor, throttler, time, checkDone, tierCompactionMetrics.cleanerMetrics());
        this.logIdent_$eq(new StringBuilder(14).append("TierCleaner ").append(this.id()).append(": ").toString());
    }
}

