/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Optional;
import kafka.log.MergedLog;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;

public class DumpTierPartitionState {
    private static final String DIR_ARG = "directory";
    private static final String PRINT_CHECKSUM_ARG = RecoveryUtils.makeArgument("print-checksum");
    private static final String PRINT_HEADERS_ARG = RecoveryUtils.makeArgument("print-headers");

    public static void main(String[] args) throws Exception {
        Namespace parsedArgs = DumpTierPartitionState.parseArgs(DumpTierPartitionState.createArgParser(), args);
        if (parsedArgs == null) {
            return;
        }
        boolean hasPrintChecksum = parsedArgs.getBoolean(PRINT_CHECKSUM_ARG);
        boolean hasPrintHeaderOnly = parsedArgs.getBoolean(PRINT_HEADERS_ARG);
        String path = ((String)parsedArgs.getList(DIR_ARG).get(0)).trim();
        File dir = new File(path);
        DumpTierPartitionState.checkDirectory(dir);
        if (hasPrintHeaderOnly) {
            int errors;
            if (hasPrintChecksum) {
                System.err.println(String.format("%s is not supported when %s is supplied", PRINT_CHECKSUM_ARG, PRINT_HEADERS_ARG));
                System.exit(1);
            }
            if ((errors = DumpTierPartitionState.dumpTierStateHeaders(dir)) > 0) {
                System.err.println(String.format("ERROR: Could not print the headers for %d file(s)!", errors));
                System.exit(1);
            }
        } else {
            TopicPartition topicPartition = MergedLog.parseTopicPartitionName(dir);
            System.out.println("Reading tier partition state for " + topicPartition);
            DumpTierPartitionState.dumpTierStates(topicPartition, dir, hasPrintHeaderOnly, hasPrintChecksum);
        }
    }

    private static Namespace parseArgs(ArgumentParser parser, String[] args) throws ArgumentParserException {
        try {
            return parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            if (e instanceof HelpScreenException) {
                return null;
            }
            throw e;
        }
    }

    private static void checkDirectory(File dir) {
        if (!dir.isDirectory()) {
            System.err.println(String.format("ERROR! The provided path: %s is not a valid directory.", dir));
            System.exit(1);
        }
        if (!dir.exists()) {
            System.err.println(String.format("ERROR! The provided directory: %s does not exist.", dir));
            System.exit(1);
        }
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)DumpTierPartitionState.class.getName()).defaultHelp(true).description("Dumps tier partition state files to standard out.");
        parser.addArgument(new String[]{DIR_ARG}).nargs(1).type(String.class).required(true).help(String.format("The topic-partition log directory containing tier state files, or the root log directory if %s is supplied.", PRINT_HEADERS_ARG));
        parser.addArgument(new String[]{PRINT_CHECKSUM_ARG}).dest(PRINT_CHECKSUM_ARG).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Print details related to the checksum of the tier partition state file.");
        parser.addArgument(new String[]{PRINT_HEADERS_ARG}).dest(PRINT_HEADERS_ARG).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Print only the header of every tier partition state file in the provided root log directory.");
        return parser;
    }

    private static int dumpTierStateHeaders(File rootDir) {
        System.out.print("[");
        File[] dirs = rootDir.listFiles();
        ArrayList<String> tierStates = new ArrayList<String>();
        int errors = 0;
        for (File dir : dirs) {
            TopicPartition topicPartition;
            if (!dir.isDirectory()) continue;
            try {
                topicPartition = MergedLog.parseTopicPartitionName(dir);
            }
            catch (KafkaException e) {
                System.err.println(String.format("WARN: Skipping sub-directory with invalid topic partition: %s", dir.getAbsolutePath()));
                continue;
            }
            for (File ftpsFile : dir.listFiles()) {
                Optional<Header> headerOpt;
                if (!ftpsFile.isFile() || !MergedLog.isTierStateFile(ftpsFile)) continue;
                try (CheckedFileIO fileChannel = CheckedFileIO.open((Path)ftpsFile.toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});){
                    headerOpt = FileTierPartitionState.readHeader(fileChannel);
                }
                catch (IOException e) {
                    ++errors;
                    System.err.println("ERROR: Could not get the header due to an error for file: " + ftpsFile);
                    e.printStackTrace();
                    continue;
                }
                if (headerOpt.isPresent()) {
                    tierStates.add(String.format("{\"topicPartition\": \"%s\", \"path\": \"%s\", \"header\": %s}", topicPartition, ftpsFile.getAbsolutePath(), headerOpt.get().toJson()));
                    continue;
                }
                ++errors;
                System.err.println("ERROR: Empty header found in file " + ftpsFile);
            }
        }
        System.out.print(String.join((CharSequence)",", tierStates));
        System.out.print("]");
        return errors;
    }

    private static void dumpTierStates(TopicPartition topicPartition, File dir, boolean headerOnly, boolean printChecksum) {
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !MergedLog.isTierStateFile(file)) continue;
            System.out.println("Dumping state in file " + file);
            DumpTierPartitionState.dumpTierState(topicPartition, file, headerOnly, printChecksum);
        }
    }

    public static void dumpTierState(TopicPartition topicPartition, File ftpsFile, boolean headerOnly, boolean printChecksum) {
        try (CheckedFileIO fileChannel = CheckedFileIO.open((Path)ftpsFile.toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});){
            Optional<Header> headerOpt;
            if (printChecksum) {
                System.out.println(fileChannel);
            }
            if (!(headerOpt = FileTierPartitionState.readHeader(fileChannel)).isPresent()) {
                System.out.println("Empty header");
                return;
            }
            System.out.println(headerOpt.get());
            if (headerOnly) {
                return;
            }
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                System.out.println("Empty file");
                return;
            }
            while (iteratorOpt.get().hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iteratorOpt.get().next();
                ObjectMetadata objectMetadata = new ObjectMetadata(metadata);
                System.out.println(metadata + " => " + objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath());
            }
        }
        catch (IOException e) {
            System.err.println("ERROR: Caught exception for file " + ftpsFile);
            e.printStackTrace();
        }
    }
}

