/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ByokMetadata {
    private final CloudProvider cloudProvider;
    private final String keyArn;
    private final String roleArn;
    private final String clientId;
    private final String keyId;
    private final String tenantId;
    private final String vaultId;

    @JsonCreator
    public ByokMetadata(@JsonProperty(value="cloudProvider") Integer cloudProvider, @JsonProperty(value="keyArn") String keyArn, @JsonProperty(value="roleArn") String roleArn, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="keyId") String keyId, @JsonProperty(value="tenantId") String tenantId, @JsonProperty(value="vaultId") String vaultId) {
        this.cloudProvider = CloudProvider.forId(cloudProvider);
        this.keyArn = keyArn;
        this.roleArn = roleArn;
        this.clientId = clientId;
        this.keyId = keyId;
        this.tenantId = tenantId;
        this.vaultId = vaultId;
    }

    public static ByokMetadata loadFromByokProto(LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok byok) {
        if (byok == null) {
            return null;
        }
        ByokMetadata byokMetadata = null;
        switch (byok.getProviderCase()) {
            case AWS: {
                LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok.Aws awsByok = byok.getAws();
                byokMetadata = ByokMetadata.makeForAws(awsByok.getKeyArn(), awsByok.getRoleArn());
                break;
            }
            case AZURE: {
                LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok.Azure azureByok = byok.getAzure();
                byokMetadata = ByokMetadata.makeForAzure(azureByok.getClientId(), azureByok.getKeyId(), azureByok.getTenantId(), azureByok.getVaultId());
                break;
            }
            case GCP: {
                LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok.Gcp gcpByok = byok.getGcp();
                byokMetadata = ByokMetadata.makeForGcp(gcpByok.getKeyId());
                break;
            }
            case PROVIDER_NOT_SET: {
                throw new IllegalArgumentException("Expected cloud provider to be set for non-null / non-empty BYOK protobuf object.");
            }
        }
        return byokMetadata;
    }

    public static boolean isValidByokProto(LogicalCluster.LogicalClusterConfig.LogicalKafkaConfig.Byok byok) {
        if (byok != null) {
            switch (byok.getProviderCase()) {
                case AWS: {
                    return !byok.getAws().getKeyArn().isEmpty() && !byok.getAws().getRoleArn().isEmpty();
                }
                case AZURE: {
                    return !byok.getAzure().getClientId().isEmpty() && !byok.getAzure().getKeyId().isEmpty() && !byok.getAzure().getVaultId().isEmpty() && !byok.getAzure().getTenantId().isEmpty();
                }
                case GCP: {
                    return !byok.getGcp().getKeyId().isEmpty();
                }
            }
        }
        return false;
    }

    private static ByokMetadata makeForAws(String keyArn, String roleArn) {
        return new ByokMetadata(CloudProvider.AWS.id(), keyArn, roleArn, null, null, null, null);
    }

    private static ByokMetadata makeForAzure(String clientId, String keyId, String tenantId, String vaultId) {
        return new ByokMetadata(CloudProvider.AZURE.id(), null, null, clientId, keyId, tenantId, vaultId);
    }

    private static ByokMetadata makeForGcp(String keyId) {
        return new ByokMetadata(CloudProvider.GCP.id(), null, null, null, keyId, null, null);
    }

    @JsonProperty
    public CloudProvider cloudProvider() {
        return this.cloudProvider;
    }

    @JsonProperty
    public String keyArn() {
        return this.keyArn;
    }

    @JsonProperty
    public String roleArn() {
        return this.roleArn;
    }

    @JsonProperty
    public String clientId() {
        return this.clientId;
    }

    @JsonProperty
    public String keyId() {
        return this.keyId;
    }

    @JsonProperty
    public String tenantId() {
        return this.tenantId;
    }

    @JsonProperty
    public String vaultId() {
        return this.vaultId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByokMetadata that = (ByokMetadata)o;
        return Objects.equals((Object)this.cloudProvider, (Object)that.cloudProvider) && Objects.equals(this.keyArn, that.keyArn) && Objects.equals(this.roleArn, that.roleArn) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.vaultId, that.vaultId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cloudProvider, this.keyArn, this.roleArn, this.clientId, this.keyId, this.tenantId, this.vaultId});
    }

    public String toString() {
        return "ByokMetadata{cloudProvider='" + (Object)((Object)this.cloudProvider) + '\'' + ", keyArn='" + this.keyArn + '\'' + ", roleArn=" + this.roleArn + '\'' + ", clientId=" + this.clientId + '\'' + ", keyId=" + this.keyId + '\'' + ", tenantId=" + this.tenantId + '\'' + ", vaultId=" + this.vaultId + '}';
    }

    public static enum CloudProvider {
        UNKNOWN(-1),
        AWS(1),
        AZURE(2),
        GCP(3);

        private final int id;
        private static final Map<Integer, CloudProvider> INT_ENUM_MAP;

        private CloudProvider(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static CloudProvider forId(int id) {
            return INT_ENUM_MAP.getOrDefault(id, UNKNOWN);
        }

        static {
            INT_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(CloudProvider.values()).collect(Collectors.toMap(CloudProvider::id, Function.identity())));
        }
    }
}

