/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersMetadata;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.BrokerAdditionDescriptionInternal;
import kafka.common.BrokerRemovalDescriptionInternal;
import kafka.common.CellLoadDescriptionInternal;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.NoOpClusterBalanceManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClusterBalanceManager
extends MetadataPublisher {
    public static final Logger LOG = LoggerFactory.getLogger((String)ClusterBalanceManager.class.getSimpleName());

    public void scheduleZkBrokerRemoval(List<Integer> var1, boolean var2, TopicsMetadataSnapshot var3, AliveBrokersMetadata var4, BalanceManagerOperationInvocationClientCallback var5);

    public void scheduleKraftBrokerRemoval(List<Integer> var1, boolean var2, BalanceManagerOperationInvocationClientCallback var3);

    public void onBrokersStartup(Set<Integer> var1, Set<Integer> var2, AliveBrokersMetadata var3);

    public void onBrokersFailure(Set<Integer> var1);

    public void onAlteredExclusions(Set<Integer> var1, Set<Integer> var2);

    public void brokerRemovals(BalanceManagerStatusQueryClientCallback<List<BrokerRemovalDescriptionInternal>> var1);

    public void brokerAdditions(BalanceManagerStatusQueryClientCallback<List<BrokerAdditionDescriptionInternal>> var1);

    public void balancerStatus(BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal> var1);

    public void evenClusterLoadStatus(BalanceManagerStatusQueryClientCallback<EvenClusterLoadStatusDescriptionInternal> var1);

    public void triggerEvenClusterLoadTask(List<String> var1, BalanceManagerOperationInvocationClientCallback var2);

    public void computeEvenClusterLoadPlan(List<String> var1, BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> var2);

    public void onBrokerHealthChange(Set<Integer> var1, Set<Integer> var2, AliveBrokersMetadata var3);

    public void cellLoad(List<Integer> var1, BalanceManagerStatusQueryClientCallback<CellLoadDescriptionInternal> var2);

    public static ClusterBalanceManager clusterBalanceManager(KafkaConfig config) {
        String clusterBalanceClassName = "io.confluent.databalancer.SbcDataBalanceManager";
        try {
            if (config.getString("confluent.balancer.class") != null) {
                clusterBalanceClassName = config.getString("confluent.balancer.class");
            }
            Class<?> dataBalancerClass = Class.forName(clusterBalanceClassName);
            ClusterBalanceManager dataManager = null;
            dataManager = (ClusterBalanceManager)dataBalancerClass.getConstructor(KafkaConfig.class, Optional.class).newInstance(config, Optional.empty());
            LOG.info("Instantiating ClusterBalanceManager with an instance of " + clusterBalanceClassName);
            return dataManager;
        }
        catch (Exception e) {
            LOG.error("ClusterBalancer: Unable to load cluster balancer class " + clusterBalanceClassName + " Ran into Exception " + e.getMessage(), (Throwable)e);
            return new NoOpClusterBalanceManager(clusterBalanceClassName, e);
        }
    }

    public static interface BalanceManagerStatusQueryClientCallback<R> {
        public void respond(ApiError var1, Optional<R> var2);
    }

    public static interface BalanceManagerOperationInvocationClientCallback {
        public void respond(ApiError var1);
    }
}

