/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.image.publisher.TenantMetricsPublisher;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaSnapshot;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.quota.ElasticCkuDefinitionKey;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r%r!\u0002\u001c8\u0011\u0003qd!\u0002!8\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%\ta\u0013\u0005\u0007;\u0006\u0001\u000b\u0011\u0002'\t\u000by\u000bA\u0011A0\t\u000f\r\r\u0012\u0001\"\u0003\u0004&\u0019!\u0001i\u000e\u0001b\u0011!qwA!b\u0001\n\u0003y\u0007\u0002C:\b\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q<!Q1A\u0005\u0002UD\u0001\"_\u0004\u0003\u0002\u0003\u0006IA\u001e\u0005\tu\u001e\u0011)\u0019!C\u0001w\"Aqp\u0002B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u001d\u0011)\u0019!C\u0001\u0003\u0007A!\"!\b\b\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\tyb\u0002BC\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003w9!\u0011!Q\u0001\n\u0005\r\u0002BCA\u001f\u000f\t\u0015\r\u0011\"\u0001\u0002@!Q\u00111J\u0004\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u00055sA!b\u0001\n\u0003\ty\u0005\u0003\u0006\u0002`\u001d\u0011\t\u0011)A\u0005\u0003#Ba\u0001S\u0004\u0005\u0002\u0005\u0005\u0004\"CA9\u000f\t\u0007I\u0011AA:\u0011!\t)i\u0002Q\u0001\n\u0005U\u0004\"CAD\u000f\u0001\u0007I\u0011BAE\u0011%\t\tj\u0002a\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002 \u001e\u0001\u000b\u0015BAF\u0011%\tIk\u0002a\u0001\n\u0013\tI\tC\u0005\u0002,\u001e\u0001\r\u0011\"\u0003\u0002.\"A\u0011\u0011W\u0004!B\u0013\tY\tC\u0005\u00026\u001e\u0001\r\u0011\"\u0003\u0002\n\"I\u0011qW\u0004A\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003{;\u0001\u0015)\u0003\u0002\f\"I\u0011\u0011Y\u0004A\u0002\u0013%\u0011\u0011\u0012\u0005\n\u0003\u0007<\u0001\u0019!C\u0005\u0003\u000bD\u0001\"!3\bA\u0003&\u00111\u0012\u0005\b\u0003\u001b<A\u0011AAh\u0011\u001d\tYn\u0002C\u0005\u0003;Dq!a?\b\t\u0013\ti\u0010C\u0004\u0003\b\u001d!IA!\u0003\t\u000f\t=q\u0001\"\u0001\u0003\u0012!9!\u0011I\u0004\u0005\u0002\t\r\u0003b\u0002B4\u000f\u0011\u0005!\u0011\u000e\u0005\b\u0005c:A\u0011\u0001B:\u0011\u001d\u00119h\u0002C\u0001\u0005sBqAa!\b\t\u0003\u0011)\tC\u0004\u0003\u0010\u001e!\tA!%\t\u000f\teu\u0001\"\u0001\u0003\u001c\"9!qU\u0004\u0005\u0002\t%\u0006B\u0002BV\u000f\u0011\u00053\nC\u0004\u0003.\u001e!\tEa,\t\u000f\tmv\u0001\"\u0001\u0003>\"9!QY\u0004\u0005\n\t\u001d\u0017\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0015\tA\u0014(A\u0003rk>$\u0018M\u0003\u0002;w\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005a\u0014!B6bM.\f7\u0001\u0001\t\u0003\u007f\u0005i\u0011a\u000e\u0002\u0011#V|G/Y\"p_J$\u0017N\\1u_J\u001c\"!\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta(A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u00031\u00032!\u0014)S\u001b\u0005q%BA(E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003#:\u00131aU3u!\t\u0019&L\u0004\u0002U1B\u0011Q\u000bR\u0007\u0002-*\u0011q+P\u0001\u0007yI|w\u000e\u001e \n\u0005e#\u0015A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017#\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQ!\u00199qYf$2\u0003\u0019Bg\u0005#\u0014\u0019Na=\u0004\u0006\r=1\u0011CB\n\u0007C\u0001\"aP\u0004\u0014\t\u001d\u0011%\r\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kn\nQ!\u001e;jYNL!a\u001a3\u0003\u000f1{wmZ5oOB\u0011\u0011\u000e\\\u0007\u0002U*\u00111nO\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055T'\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-\u0001\u0005ce>\\WM]%e+\u0005\u0001\bCA\"r\u0013\t\u0011HIA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017E,x\u000e^1D_:4\u0017nZ\u000b\u0002mB\u0011qh^\u0005\u0003q^\u0012a#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:D_:4\u0017nZ\u0001\rcV|G/Y\"p]\u001aLw\rI\u0001\u0012cV|G/Y*uCR,W*\u00198bO\u0016\u0014X#\u0001?\u0011\u0005}j\u0018B\u0001@8\u0005E\tVo\u001c;b'R\fG/Z'b]\u0006<WM]\u0001\u0013cV|G/Y*uCR,W*\u00198bO\u0016\u0014\b%A\u0005tG\",G-\u001e7feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0011)H/\u001b7\u000b\u0007-\fyAC\u0002=\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r]1dQ\u0016T!!a\u0006\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0005%!!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0016S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3s+\t\t\u0019\u0003\u0005\u0004\u0002&\u0005E\u0012QG\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002\f\u00055\"BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012q\u0005\u0002\t'V\u0004\b\u000f\\5feB\u0019\u0011.a\u000e\n\u0007\u0005e\"NA\u0007J]R,'O\\1m\u0003\u0012l\u0017N\\\u0001\u0017S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3sA\u0005I2\r\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2l+\t\t\t\u0005\u0005\u0003\u0002D\u0005\u001dSBAA#\u0015\rA\u0014QB\u0005\u0005\u0003\u0013\n)EA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AG2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0015\u0011\t\u0005M\u00131L\u0007\u0003\u0003+R1!ZA,\u0015\u0011\tI&a\u0004\u0002\r\r|W.\\8o\u0013\u0011\ti&!\u0016\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u0010A\u0006\r\u0014QMA4\u0003S\nY'!\u001c\u0002p!)aN\u0006a\u0001a\")AO\u0006a\u0001m\")!P\u0006a\u0001y\"9\u0011\u0011\u0001\fA\u0002\u0005\u0015\u0001bBA\u0010-\u0001\u0007\u00111\u0005\u0005\b\u0003{1\u0002\u0019AA!\u0011\u001d\tiE\u0006a\u0001\u0003#\n\u0001\"[:BGRLg/Z\u000b\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u007f\nY#\u0001\u0006d_:\u001cWO\u001d:f]RLA!a!\u0002z\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\"[:BGRLg/\u001a\u0011\u0002=\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\fWCAAF!\r\u0019\u0015QR\u0005\u0004\u0003\u001f#%\u0001\u0002'p]\u001e\f!E\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1`I\u0015\fH\u0003BAK\u00037\u00032aQAL\u0013\r\tI\n\u0012\u0002\u0005+:LG\u000fC\u0005\u0002\u001ej\t\t\u00111\u0001\u0002\f\u0006\u0019\u0001\u0010J\u0019\u0002?\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\f\u0007\u0005K\u0002\u001c\u0003G\u00032aQAS\u0013\r\t9\u000b\u0012\u0002\tm>d\u0017\r^5mK\u0006q\"M]8lKJ$VM\\1oi2KW.\u001b;D_:\u001cX/\\3s#V|G/Y\u0001#EJ|7.\u001a:UK:\fg\u000e\u001e'j[&$8i\u001c8tk6,'/U;pi\u0006|F%Z9\u0015\t\u0005U\u0015q\u0016\u0005\n\u0003;k\u0012\u0011!a\u0001\u0003\u0017\u000bqD\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u\u0007>t7/^7feF+x\u000e^1!Q\rq\u00121U\u0001'EJ|7.\u001a:J]R,'O\\1m)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\f\u0017A\u000b2s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC~#S-\u001d\u000b\u0005\u0003+\u000bY\fC\u0005\u0002\u001e\u0002\n\t\u00111\u0001\u0002\f\u00069#M]8lKJLe\u000e^3s]\u0006dG+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1!Q\r\t\u00131U\u0001'EJ|7.\u001a:J]R,'O\\1m)\u0016t\u0017M\u001c;MS6LGoQ8ogVlWM])v_R\f\u0017A\u000b2s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG\u000fT5nSR\u001cuN\\:v[\u0016\u0014\u0018+^8uC~#S-\u001d\u000b\u0005\u0003+\u000b9\rC\u0005\u0002\u001e\u000e\n\t\u00111\u0001\u0002\f\u00069#M]8lKJLe\u000e^3s]\u0006dG+\u001a8b]Rd\u0015.\\5u\u0007>t7/^7feF+x\u000e^1!Q\r!\u00131U\u0001\ng\u0016$\u0018i\u0019;jm\u0016$B!!&\u0002R\"9\u00111[\u0013A\u0002\u0005U\u0017AB1di&4X\rE\u0002D\u0003/L1!!7E\u0005\u001d\u0011un\u001c7fC:\f1cZ3u\u0005J|7.\u001a:Rk>$\u0018\rT5nSR$b!a8\u0002f\u0006=\bcA\"\u0002b&\u0019\u00111\u001d#\u0003\r\u0011{WO\u00197f\u0011\u001d\t9O\na\u0001\u0003S\f\u0011\"];pi\u0006$\u0016\u0010]3\u0011\t\u0005\r\u00131^\u0005\u0005\u0003[\f)EA\bDY&,g\u000e^)v_R\fG+\u001f9f\u0011\u001d\t\tP\na\u0001\u0003g\f!\"\u001a8uSRLH+\u001f9f!\u0019\t)0a>S%6\u0011\u00111F\u0005\u0005\u0003s\fYCA\u0002NCB\fA$\u001e9eCR,'I]8lKJ$VM\\1oiF+x\u000e^1MS6LG\u000f\u0006\u0004\u0002\u0016\u0006}(1\u0001\u0005\b\u0005\u00039\u0003\u0019AAF\u00035\u0001(o\u001c3vG\u0016\u0014\u0018+^8uC\"9!QA\u0014A\u0002\u0005-\u0015!D2p]N,X.\u001a:Rk>$\u0018-\u0001\u0013va\u0012\fG/\u001a\"s_.,'/\u00138uKJt\u0017\r\u001c+f]\u0006tG/U;pi\u0006d\u0015.\\5u)\u0019\t)Ja\u0003\u0003\u000e!9!\u0011\u0001\u0015A\u0002\u0005-\u0005b\u0002B\u0003Q\u0001\u0007\u00111R\u0001\u000eG>l\u0007/\u001e;f#V|G/Y:\u0015\u0011\u0005U%1\u0003B\u000b\u0005cAQA\\\u0015A\u0002ADqAa\u0006*\u0001\u0004\u0011I\"\u0001\u0007rk>$\u0018-\u00128ue&,7\u000f\u0005\u0004\u0003\u001c\t\u0015\"1\u0006\b\u0005\u0005;\u0011\tCD\u0002V\u0005?I\u0011!R\u0005\u0004\u0005G!\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0011IC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011\u0019\u0003\u0012\t\u0004\u007f\t5\u0012b\u0001B\u0018o\tQ\u0012+^8uC\u0016sG/\u001b;z\u0003:$7i\u001c8tk6\u0004H/[8og\"9!1G\u0015A\u0002\tU\u0012\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u001d\u0019%q\u0007B\u001e\u0003+K1A!\u000fE\u0005%1UO\\2uS>t\u0017\u0007E\u0002@\u0005{I1Aa\u00108\u0005E\u0011V\r]8siF+x\u000e^1SKN,H\u000e^\u0001\u000eI\u0016\u001c8M]5cKF+x\u000e^1\u0015\t\t\u0015#Q\f\t\b\u0007\n\u001d#1\nB,\u0013\r\u0011I\u0005\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t5#1K\u0007\u0003\u0005\u001fRAA!\u0015\u0002X\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003V\t=#AB#se>\u00148\u000fE\u0002@\u00053J1Aa\u00178\u0005A\tVo\u001c;b\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003`)\u0002\rA!\u0019\u0002\u0017E,x\u000e^1F]RLG/\u001f\t\u0004\u007f\t\r\u0014b\u0001B3o\tY\u0011+^8uC\u0016sG/\u001b;z\u0003I\tXo\u001c;bgR{\u0007/[2D_:4\u0017nZ:\u0016\u0005\t-\u0004\u0003BA{\u0005[JAAa\u001c\u0002,\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007A\u0014)\bC\u0004\u0003`1\u0002\rA!\u0019\u0002'Y\fG.\u001b3bi\u0016\fVo\u001c;b\u000b:$\u0018\u000e^=\u0015\t\tm$\u0011\u0011\t\u0006\u0007\nu$1J\u0005\u0004\u0005\u007f\"%AB(qi&|g\u000eC\u0004\u0003`5\u0002\rA!\u0019\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0002\u0016\n\u001d%1\u0012\u0005\u0007\u0005\u0013s\u0003\u0019\u00019\u0002+E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8JI\"1!Q\u0012\u0018A\u0002A\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\t)Ja%\u0003\u0016\"1!\u0011R\u0018A\u0002ADqA!$0\u0001\u0004\u00119\n\u0005\u0003D\u0005{\u0002\u0018aB:uCJ$X\u000f\u001d\u000b\u0005\u0003+\u0013i\nC\u0004\u0003 B\u0002\rA!)\u0002AI,GO]5fm\u0016\fVo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\t\u0005\u0007\n\r\u0006/C\u0002\u0003&\u0012\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\u0011MDW\u000f\u001e3po:$\"!!&\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003+\u0013\t\fC\u0004\u00034N\u0002\rA!.\u0002\u00139,woQ8oM&<\u0007cA5\u00038&\u0019!\u0011\u00186\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\u0016\n}&1\u0019\u0005\b\u0005\u0003$\u0004\u0019\u0001B[\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u00034R\u0002\rA!.\u0002-%\u001c8\t\\5f]R\fVo\u001c;b)f\u0004XMV1mS\u0012$B!!6\u0003J\"1!1Z\u001bA\u0002I\u000b\u0011a\u001d\u0005\b\u0005\u001f,\u0001\u0019\u0001B[\u0003\u0019\u0019wN\u001c4jO\"9\u0011\u0011A\u0003A\u0002\u0005\u0015\u0001b\u0002Bk\u000b\u0001\u0007!q[\u0001\u0017i\u0016t\u0017M\u001c;NKR\u0014\u0018nY:Qk\nd\u0017n\u001d5feB)1I! \u0003ZB!!1\u001cBx\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!\u00039vE2L7\u000f[3s\u0015\u0011\u0011\u0019O!:\u0002\u000b%l\u0017mZ3\u000b\u0007q\u00129O\u0003\u0003\u0003j\n-\u0018!C2p]\u001adW/\u001a8u\u0015\t\u0011i/\u0001\u0002j_&!!\u0011\u001fBo\u0005Y!VM\\1oi6+GO]5dgB+(\r\\5tQ\u0016\u0014\bb\u0002B{\u000b\u0001\u0007!q_\u0001\u0014[VdG/\u001b+f]\u0006tG/T3uC\u0012\fG/\u0019\t\u0006\u0007\nu$\u0011 \t\u0005\u0005w\u001c\t!\u0004\u0002\u0003~*!!q`A\u0007\u0003-iW\u000f\u001c;ji\u0016t\u0017M\u001c;\n\t\r\r!Q \u0002\u0014\u001bVdG/\u001b+f]\u0006tG/T3uC\u0012\fG/\u0019\u0005\b\u0007\u000f)\u0001\u0019AB\u0005\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042![B\u0006\u0013\r\u0019iA\u001b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d\ty\"\u0002a\u0001\u0003GAq!!\u0010\u0006\u0001\u0004\t\t\u0005C\u0004\u0004\u0016\u0015\u0001\raa\u0006\u0002\u000f5,GO]5dgB!1\u0011DB\u000f\u001b\t\u0019YB\u0003\u0003\u0004\u0016\u0005]\u0013\u0002BB\u0010\u00077\u0011q!T3ue&\u001c7\u000fC\u0004\u0002N\u0015\u0001\r!!\u0015\u0002-E,x\u000e^1D_>\u0014H-\u001b8bi>\u00148i\u001c8gS\u001e$2A^B\u0014\u0011\u001d\u0011yM\u0002a\u0001\u0005k\u0003")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile long brokerTenantLimitProducerQuota;
    private volatile long brokerTenantLimitConsumerQuota;
    private volatile long brokerInternalTenantLimitProducerQuota;
    private volatile long brokerInternalTenantLimitConsumerQuota;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig kafkaConfig, Scheduler scheduler, Option<TenantMetricsPublisher> option, Option<MultiTenantMetadata> option2, ReplicaManager replicaManager, Supplier<InternalAdmin> supplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinator$ quotaCoordinator$ = QuotaCoordinator$.MODULE$;
        if (quotaCoordinator$ == null) {
            throw null;
        }
        QuotaCoordinatorConfig apply_quotaConfig = quotaCoordinator$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(kafkaConfig);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, option, option2, replicaManager, clusterLevelQuotaCallback, metrics, time);
        return new QuotaCoordinator(kafkaConfig.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, supplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    private long brokerTenantLimitProducerQuota() {
        return this.brokerTenantLimitProducerQuota;
    }

    private void brokerTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerTenantLimitProducerQuota = x$1;
    }

    private long brokerTenantLimitConsumerQuota() {
        return this.brokerTenantLimitConsumerQuota;
    }

    private void brokerTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerTenantLimitConsumerQuota = x$1;
    }

    private long brokerInternalTenantLimitProducerQuota() {
        return this.brokerInternalTenantLimitProducerQuota;
    }

    private void brokerInternalTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerInternalTenantLimitProducerQuota = x$1;
    }

    private long brokerInternalTenantLimitConsumerQuota() {
        return this.brokerInternalTenantLimitConsumerQuota;
    }

    private void brokerInternalTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerInternalTenantLimitConsumerQuota = x$1;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    private double getBrokerQuotaLimit(ClientQuotaType quotaType, java.util.Map<String, String> entityType) {
        String string = entityType.get("tenant");
        String string2 = "lkc-internal-tenant";
        if (string != null && string.equals(string2)) {
            if (ClientQuotaType.FETCH.equals(quotaType)) {
                return this.brokerInternalTenantLimitConsumerQuota();
            }
            if (ClientQuotaType.PRODUCE.equals(quotaType)) {
                return this.brokerInternalTenantLimitProducerQuota();
            }
            throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
        }
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            return this.brokerTenantLimitConsumerQuota();
        }
        if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            return this.brokerTenantLimitProducerQuota();
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
    }

    private void updateBrokerTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    private void updateBrokerInternalTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerInternalTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerInternalTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable & scala.Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
            scala.collection.immutable.Map $anonfun$computeQuotas$11_storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)$anonfun$computeQuotas$11_storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries)));
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            return new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                scala.collection.immutable.Map brokerQuotaEntries = (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)((QuotaEntry)((Some)option2).value()).computedQuotas().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        int brokerId = x0$1._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)((TraversableOnce)((TraversableLike)perBrokerQuotas.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            if (x0$3 != null) {
                                String quotaType = (String)x0$3._1();
                                QuotaValue quotaValue = (QuotaValue)x0$3._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                            }
                            throw new MatchError(null);
                        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$5(x$2)));
                if (!brokerQuotaEntries.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$6(x$3)))) {
                    return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
                }
                return new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)brokerQuotaEntries));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException(new StringBuilder(114).append("Updating client bandwidth throttle config require ").append("'").append("confluent.quota.tenant.broker.max.producer.rate").append("' to be positive").toString());
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException(new StringBuilder(115).append("Updating client bandwidth throttle config require ").append("'").append("confluent.quota.tenant.broker.max.consumer.rate").append("'  to be positive").toString());
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate()) < 0L) {
            throw new ConfigException(new StringBuilder(132).append("Updating client internal bandwidth throttle config require ").append("'").append("confluent.quota.tenant.internal.broker.max.producer.rate").append("' to be positive").toString());
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate()) < 0L) {
            throw new ConfigException(new StringBuilder(133).append("Updating client internal bandwidth throttle config require ").append("'").append("confluent.quota.tenant.internal.broker.max.consumer.rate").append("'  to be positive").toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        Integer n = newConfig.confluentConfig().quotasExpirationTimeMs();
                        Integer n2 = oldConfig.confluentConfig().quotasExpirationTimeMs();
                        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                            this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
                        }
                        Long l = newConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                        Long l2 = oldConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                        if (l != null ? !((Object)l).equals(l2) : l2 != null) break block7;
                        Long l3 = newConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                        Long l4 = oldConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                        if (!(l3 == null ? l4 != null : !((Object)l3).equals(l4))) break block8;
                    }
                    this.updateBrokerTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()));
                }
                Long l = newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate();
                Long l5 = oldConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate();
                if (l != null ? !((Object)l).equals(l5) : l5 != null) break block9;
                Long l6 = newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate();
                Long l7 = oldConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate();
                if (!(l6 == null ? l7 != null : !((Object)l6).equals(l7))) break block10;
            }
            this.updateBrokerInternalTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate()));
            return;
        }
    }

    private boolean isClientQuotaTypeValid(String s) {
        block3: {
            block2: {
                String string = s;
                String string2 = ClientQuotaType.PRODUCE.toString();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = s;
                String string4 = ClientQuotaType.FETCH.toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ long $anonfun$computeQuotas$4(java.util.Map elasticCkuDef) {
        return elasticCkuDef.getOrDefault(ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, Predef$.MODULE$.int2Integer(0)).longValue();
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        if ($this.isClientQuotaTypeValid(quotaConsumption.quotaType())) {
            java.util.Map entityType = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaEntry$1.quotaEntity().entityTypes()).asJava();
            long totalPerECKUThroughputLimit = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.clusterLevelQuotaCallback().elasticCkuDefinition(entityType)).map((Function1 & Serializable & scala.Serializable)elasticCkuDef -> BoxesRunTime.boxToLong((long)QuotaCoordinator.$anonfun$computeQuotas$4(elasticCkuDef))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            Double produceClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.PRODUCE, entityType);
            Double fetchClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.FETCH, entityType);
            double totalThroughputLimit = totalPerECKUThroughputLimit > 0L ? Predef$.MODULE$.Double2double(produceClusterQuotaLimit) + Predef$.MODULE$.Double2double(fetchClusterQuotaLimit) : 0.0;
            QuotaSnapshot produceQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.PRODUCE.toString(), Predef$.MODULE$.Double2double(produceClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.PRODUCE, entityType));
            QuotaSnapshot fetchQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.FETCH.toString(), Predef$.MODULE$.Double2double(fetchClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.FETCH, entityType));
            quotaEntry$1.updateConsumptionAndRecomputeQuotas($this.quotaConfig(), brokerId$1, quotaConsumption, produceQuotaSnapshot, fetchQuotaSnapshot, totalThroughputLimit, $this.time().milliseconds());
            return;
        }
        quotaEntry$1.updateConsumption(brokerId$1, quotaConsumption, $this.time().milliseconds());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable & scala.Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$11(QuotaCoordinator $this, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1, Map responseStatus) {
        scala.collection.immutable.Map storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((TraversableOnce)x$1._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$3(QuotaCoordinator $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            String quotaType = (String)x0$2._1();
            return $this.isClientQuotaTypeValid(quotaType);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$5(Tuple2 x$2) {
        return ((TraversableOnce)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$6(Tuple2 x$3) {
        return ((TraversableOnce)x$3._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        Logging.$init$(this);
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
        this.brokerTenantLimitProducerQuota = quotaConfig.quotasBrokerLimitProducer();
        this.brokerTenantLimitConsumerQuota = quotaConfig.quotasBrokerLimitConsumer();
        this.brokerInternalTenantLimitProducerQuota = quotaConfig.quotasBrokerInternalLimitProducer();
        this.brokerInternalTenantLimitConsumerQuota = quotaConfig.quotasBrokerInternalLimitConsumer();
    }
}

