/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent$TruncationType$;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.DestLogEpochChangeEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.events.controller.AbstractControllerDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize$;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001\u0002\u001a4\u0001iB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011)\u0019!C!\u000f\"IQ\n\u0001B\u0001B\u0003%\u0001J\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bA!\"a\u0007\u0001\u0005\u0004%\teMA\u000f\u0011!\tY\u0003\u0001Q\u0001\n\u0005}\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\u000b\u0003o\u0001\u0001R1A\u0005B\u0005e\u0002bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+C\u0001\"a,\u0001\t\u0003\u0019\u0014\u0011\u0017\u0005\u000b\u0003\u000b\u0004\u0011\u0013!C\u0001g\u0005\u001d\u0007BCAo\u0001E\u0005I\u0011A\u001a\u0002`\"A\u00111\u001d\u0001\u0005\u0002M\n)\u000f\u0003\u0006\u0003\u0016\u0001\t\n\u0011\"\u00014\u0003\u000fD!Ba\u0006\u0001#\u0003%\taMAp\u0011!\u0011I\u0002\u0001C\u0001g\tm\u0001b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\n\u0005+\u0002\u0011\u0013!C\u0005\u0005/B\u0001Ba\u0017\u0001\t\u0003\u0019$Q\f\u0005\u000b\u0005W\u0002\u0011\u0013!C\u0001g\u0005\u001d\u0007B\u0003B7\u0001E\u0005I\u0011A\u001a\u0002`\"A!q\u000e\u0001\u0005\u0002M\u0012\t\b\u0003\u0006\u0003\u0002\u0002\t\n\u0011\"\u00014\u0003\u000fD\u0001Ba!\u0001\t\u0003\u0019$Q\u0011\u0005\u000b\u0005+\u0003\u0011\u0013!C\u0001g\u0005\u001d\u0007\u0002\u0003BL\u0001\u0011\u00051G!'\t\u0011\tu\u0005\u0001\"\u00014\u0005?C\u0001Ba*\u0001\t\u0003\u0019$\u0011\u0016\u0005\u000b\u0005s\u0003\u0011\u0013!C\u0001g\u0005\u001d\u0007\u0002\u0003B^\u0001\u0011\u00051G!0\t\u0011\t-\u0007\u0001\"\u00014\u0005\u001bD\u0001B!7\u0001\t\u0003\u0019$1\u001c\u0005\u000b\u0005W\u0004\u0011\u0013!C\u0001g\u0005\u001d\u0007\u0002\u0003Bw\u0001\u0011\u00051Ga<\t\u0015\t}\b!%A\u0005\u0002M\n9\rC\u0004\u0004\u0002\u0001!Iaa\u0001\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!91q\u0004\u0001\u0005\u0002\r\u0005\u0002bBB\u0014\u0001\u0011\u00051\u0011\u0006\u0005\n\u0007c\u0001\u0011\u0013!C\u0001\u0003\u000f<\u0011ba\r4\u0003\u0003E\ta!\u000e\u0007\u0011I\u001a\u0014\u0011!E\u0001\u0007oAq!a\u00030\t\u0003\u0019y\u0004C\u0005\u0004B=\n\n\u0011\"\u0001\u0004D\t\t#I]8lKJ$UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{K*\u0011A'N\u0001\u0010[\u0006$XM]5bY&T\u0018\r^5p]*\u0011agN\u0001\u000bIV\u0014\u0018MY5mSRL(\"\u0001\u001d\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000f\t\u0003yuj\u0011aM\u0005\u0003}M\u00121%\u00112tiJ\f7\r\u001e#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TX-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r;\u0014AB:feZ,'/\u0003\u0002F\u0005\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u00013c+\u0005A\u0005CA%L\u001b\u0005Q%B\u0001$6\u0013\ta%J\u0001\u0007EkJ\f'-\u001b7jif$%)A\u0002eE\u0002J!AR\u001f\u0002\u0011I,\u0007o\u001c:uKJ\u0004\"!\u0015+\u000e\u0003IS!aU\u001b\u0002\u000b\u0005,H-\u001b;\n\u0005U\u0013&!D!vI&$(+\u001a9peR,'/\u0001\u0003uS6,\u0007C\u0001-c\u001b\u0005I&B\u0001.\\\u0003\u0015)H/\u001b7t\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003qyS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111-\u0017\u0002\u0005)&lW-A\u000ejO:|'/\u001a3Fm\u0016tG\u000fV=qKN$vNY3M_\u001e<W\r\u001a\t\u0004M&\\W\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\r=\u0003H/[8o!\ra7O\u001e\b\u0003[F\u0004\"A\\4\u000e\u0003=T!\u0001]\u001d\u0002\rq\u0012xn\u001c;?\u0013\t\u0011x-\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u00141aU3u\u0015\t\u0011x\rE\u0002x\u0003\u000bq!\u0001_@\u000f\u0005elhB\u0001>}\u001d\tq70C\u00019\u0013\t1t'\u0003\u0002\u007fk\u00051QM^3oiNLA!!\u0001\u0002\u0004\u0005\u0019B)\u001e:bE&d\u0017\u000e^=Fm\u0016tG\u000fV=qK*\u0011a0N\u0005\u0005\u0003\u000f\tIAA\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004XM\u0003\u0003\u0002\u0002\u0005\r\u0011A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\u0002\u0005\u0002=\u0001!)qh\u0002a\u0001\u0001\")ai\u0002a\u0001\u0011\")qj\u0002a\u0001!\")ak\u0002a\u0001/\"9Am\u0002I\u0001\u0002\u0004)\u0017!\u0003<bY&$\u0017\r^8s+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)cM\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017\u0002BA\u0015\u0003G\u0011qB\u0011:pW\u0016\u0014h+\u00197jI\u0006$xN]\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u0004\u0013A\u00037pO\u001e,'OT1nKV\u0011\u0011\u0011\u0007\t\u0004Y\u0006M\u0012bAA\u001bk\n11\u000b\u001e:j]\u001e\fa\u0001\\8hO\u0016\u0014XCAA\u001e!\u0011\ti$a\u0013\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nAb]2bY\u0006dwnZ4j]\u001eTA!!\u0012\u0002H\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002J\u0005\u00191m\\7\n\t\u00055\u0013q\b\u0002\u0007\u0019><w-\u001a:\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u0005\u0003'\nI\u0006E\u0002g\u0003+J1!a\u0016h\u0005\u001d\u0011un\u001c7fC:Dq!a\u0017\r\u0001\u0004\ti&\u0001\u0004sK\u000e|'\u000f\u001a\t\t\u0003?\nI'!\u001c\u0002n5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0005d_:\u001cX/\\3s\u0015\r\t9'X\u0001\bG2LWM\u001c;t\u0013\u0011\tY'!\u0019\u0003\u001d\r{gn];nKJ\u0014VmY8sIB)a-a\u001c\u0002t%\u0019\u0011\u0011O4\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0019\f)(C\u0002\u0002x\u001d\u0014AAQ=uK\u0006AR.\u0019;fe&\fG.\u001b>f\u0013:TWm\u0019;fIN#\u0018\r^3\u0015\t\u0005u\u00141\u0011\t\u0004M\u0006}\u0014bAAAO\n!QK\\5u\u0011\u001d\t))\u0004a\u0001\u0003\u000f\u000b\u0001#\u001b8kK\u000e$8\u000b^1uK\u00163XM\u001c;\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017SA!!$\u0002\u0004\u00051!M]8lKJLA!!%\u0002\f\n\u0001\u0012J\u001c6fGR\u001cF/\u0019;f\u000bZ,g\u000e^\u0001\u001d[\u0006$XM]5bY&TXm\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u)!\ti(a&\u0002\"\u0006-\u0006bBAM\u001d\u0001\u0007\u00111T\u0001\u0012_\u001a47/\u001a;DQ\u0006tw-Z#wK:$\b\u0003BAE\u0003;KA!a(\u0002\f\n\trJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005\rf\u00021\u0001\u0002&\u0006)1\u000f^1uKB\u0019\u0011*a*\n\u0007\u0005%&J\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\u00055f\u00021\u0001\u00022\u0005AQ.\u001a;bI\u0006$\u0018-\u0001\u000fnCR,'/[1mSj,G)\u001a7fi\u0016\u0014VmY8sI\u00163XM\u001c;\u0015\u0015\u0005u\u00141WA_\u0003\u007f\u000b\t\rC\u0004\u00026>\u0001\r!a.\u0002%\u0011,G.\u001a;f%\u0016\u001cwN\u001d3t\u000bZ,g\u000e\u001e\t\u0005\u0003\u0013\u000bI,\u0003\u0003\u0002<\u0006-%A\u0005#fY\u0016$XMU3d_J$7/\u0012<f]RDq!a)\u0010\u0001\u0004\t)\u000bC\u0005\u0002.>\u0001\n\u00111\u0001\u00022!I\u00111Y\b\u0011\u0002\u0003\u0007\u00111K\u0001\u001ckB$\u0017\r^3P]2L8i\\7nSR\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0002M5\fG/\u001a:jC2L'0\u001a#fY\u0016$XMU3d_J$WI^3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002J*\"\u0011\u0011GAfW\t\ti\r\u0005\u0003\u0002P\u0006eWBAAi\u0015\u0011\t\u0019.!6\u0002\u0013Ut7\r[3dW\u0016$'bAAlO\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0017\u0011\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AJ7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKJ+7m\u001c:e\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001d\u0016\u0005\u0003'\nY-A\u0010nCR,'/[1mSj,\u0007*[4i/\u0006$XM]7be.\u001c\u0005.\u00198hKN$\u0002#! \u0002h\u0006M\u0018Q B\u0004\u0005\u001b\u0011yA!\u0005\t\u000f\u0005%(\u00031\u0001\u0002l\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BAw\u0003_l\u0011aW\u0005\u0004\u0003c\\&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003k\u0014\u0002\u0019AA|\u0003\u0015)\u0007o\\2i!\r1\u0017\u0011`\u0005\u0004\u0003w<'aA%oi\"9\u0011q \nA\u0002\t\u0005\u0011a\u00015x[B\u0019aMa\u0001\n\u0007\t\u0015qM\u0001\u0003M_:<\u0007b\u0002B\u0005%\u0001\u0007!1B\u0001\u0004SN\u0014\b\u0003\u00027t\u0003oDq!a)\u0013\u0001\u0004\t)\u000bC\u0005\u0002.J\u0001\n\u00111\u0001\u00022!I!1\u0003\n\u0011\u0002\u0003\u0007\u00111K\u0001\u0017iJLwmZ3sK\u0012\u0014\u00150\u00129pG\"\u001c\u0005.\u00198hK\u0006IS.\u0019;fe&\fG.\u001b>f\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIY\n\u0011&\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012:\u0014a\u0004;sk:\u001c\u0017\r^3Ge>lWI\u001c3\u0015\r\u0005u$Q\u0004B\u0010\u0011\u001d\ty0\u0006a\u0001\u0005\u0003AqA!\t\u0016\u0001\u0004\u0011\u0019#A\u000bnSJ\u0014xN]\"bG\",W\t]8dQ\u000eC\u0017-\u001b8\u0011\u0011\t\u0015\"qFA|\u0005\u0003i!Aa\n\u000b\t\t%\"1F\u0001\b[V$\u0018M\u00197f\u0015\r\u0011icZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0019\u0005O\u0011q\u0001S1tQ6\u000b\u0007/A\u0011nC.,w)\u001a8fe&\u001c7\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\b\u00038\tu\"q\tB%\u0005\u001b\u0012yEa\u0015\u0011\t\u0005%%\u0011H\u0005\u0005\u0005w\tYI\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\u0011yD\u0006a\u0001\u0005\u0003\n!!\u001b3\u0011\t\u00055(1I\u0005\u0004\u0005\u000bZ&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t)P\u0006a\u0001\u0003oDqAa\u0013\u0017\u0001\u0004\u0011\t!A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBA\u0000-\u0001\u0007!\u0011\u0001\u0005\b\u0005#2\u0002\u0019AA|\u0003\u0019qw\u000eZ3JI\"I!\u0011\u0002\f\u0011\u0002\u0003\u0007!1B\u0001,[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\f\u0016\u0005\u0005\u0017\tY-\u0001\fnCR,'/[1mSj,7\u000b^1si>3gm]3u))\tiHa\u0018\u0003d\t\u0015$q\r\u0005\b\u0005CB\u0002\u0019\u0001B\u001c\u0003Y\u0019H/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBAR1\u0001\u0007\u0011Q\u0015\u0005\n\u0003[C\u0002\u0013!a\u0001\u0003cA\u0011B!\u001b\u0019!\u0003\u0005\r!a\u0015\u0002\u0017Y\fG.\u001b3bi\u0016Du+T\u0001![\u0006$XM]5bY&TXm\u0015;beR|eMZ:fi\u0012\"WMZ1vYR$3'\u0001\u0011nCR,'/[1mSj,7\u000b^1si>3gm]3uI\u0011,g-Y;mi\u0012\"\u0014aG7bi\u0016\u0014\u0018.\u00197ju\u0016,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0005\u0002~\tM$Q\u0010B@\u0011\u001d\u0011)h\u0007a\u0001\u0005o\n\u0001#\u001a9pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u0005%%\u0011P\u0005\u0005\u0005w\nYI\u0001\tFa>\u001c\u0007n\u00115b]\u001e,WI^3oi\"9\u00111U\u000eA\u0002\u0005\u0015\u0006\"CAW7A\u0005\t\u0019AA\u0019\u0003\u0015j\u0017\r^3sS\u0006d\u0017N_3Fa>\u001c\u0007n\u00115b]\u001e,WI^3oi\u0012\"WMZ1vYR$3'\u0001\u0012nCR,'/[1mSj,G)Z:u\u0019><W\t]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\t\u0003{\u00129I!%\u0003\u0014\"9!\u0011R\u000fA\u0002\t-\u0015a\u00063fgRdunZ#q_\u000eD7\t[1oO\u0016,e/\u001a8u!\u0011\tII!$\n\t\t=\u00151\u0012\u0002\u0018\t\u0016\u001cH\u000fT8h\u000bB|7\r[\"iC:<W-\u0012<f]RDq!a)\u001e\u0001\u0004\t)\u000bC\u0005\u0002.v\u0001\n\u00111\u0001\u00022\u0005aS.\u0019;fe&\fG.\u001b>f\t\u0016\u001cH\u000fT8h\u000bB|7\r[\"iC:<W-\u0012<f]R$C-\u001a4bk2$HeM\u0001\u0013iJ,hnY1uK\u0016\u0003xn\u00195DQ\u0006Lg\u000e\u0006\u0003\u0002~\tm\u0005bBAR?\u0001\u0007\u0011QU\u0001\u0015I>$&/\u001e8dCR,W\t]8dQ\u000eC\u0017-\u001b8\u0015\r\u0005u$\u0011\u0015BR\u0011\u001d\u0011Y\u0005\ta\u0001\u0005\u0003AqA!*!\u0001\u0004\u0011\u0019#\u0001\u0006fa>\u001c\u0007n\u00115bS:\f\u0011$\\1uKJL\u0017\r\\5{K&\u001b&+\u0012=qC:$WI^3oiRA\u0011Q\u0010BV\u0005k\u00139\fC\u0004\u0003.\u0006\u0002\rAa,\u0002\u001d%\u001c(/\u0012=qC:$WI^3oiB!\u0011\u0011\u0012BY\u0013\u0011\u0011\u0019,a#\u0003\u001d%\u001b(/\u0012=qC:$WI^3oi\"9\u00111U\u0011A\u0002\u0005\u0015\u0006\"CAWCA\u0005\t\u0019AA\u0019\u0003\rj\u0017\r^3sS\u0006d\u0017N_3J'J+\u0005\u0010]1oI\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM\nq$\\1uKJL\u0017\r\\5{KJ+G/\u001a8uS>t7\t[1oO\u0016,e/\u001a8u)\u0019\tiHa0\u0003J\"9!\u0011Y\u0012A\u0002\t\r\u0017\u0001\u0006:fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000f\u0005\u0003\u0002\n\n\u0015\u0017\u0002\u0002Bd\u0003\u0017\u0013ACU3uK:$\u0018n\u001c8DQ\u0006tw-Z#wK:$\bbBARG\u0001\u0007\u0011QU\u0001\u001b[\u0006$XM]5bY&TX\rR3mKR,\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003{\u0012y\rC\u0004\u0003R\u0012\u0002\rAa5\u0002)\u0011,G.\u001a;f!\u0006\u0014H/\u001b;j_:,e/\u001a8u!\u0011\tII!6\n\t\t]\u00171\u0012\u0002\u0015\t\u0016dW\r^3QCJ$\u0018\u000e^5p]\u00163XM\u001c;\u0002K5\fG/\u001a:jC2L'0Z\"mkN$XM\u001d'j].$&/\u001e8dCRLwN\\#wK:$H\u0003CA?\u0005;\u00149O!;\t\u000f\t}W\u00051\u0001\u0003b\u0006Q2\r\\;ti\u0016\u0014H*\u001b8l)J,hnY1uS>tWI^3oiB!\u0011\u0011\u0012Br\u0013\u0011\u0011)/a#\u00035\rcWo\u001d;fe2Kgn\u001b+sk:\u001c\u0017\r^5p]\u00163XM\u001c;\t\u000f\u0005\rV\u00051\u0001\u0002&\"I\u0011QV\u0013\u0011\u0002\u0003\u0007\u0011\u0011G\u00010[\u0006$XM]5bY&TXm\u00117vgR,'\u000fT5oWR\u0013XO\\2bi&|g.\u0012<f]R$C-\u001a4bk2$HeM\u0001\"[\u0006$XM]5bY&TX-T5se>\u00148\u000b^1uK\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\t\u0003{\u0012\tPa?\u0003~\"9!1_\u0014A\u0002\tU\u0018AF7jeJ|'o\u0015;bi\u0016\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u0005%%q_\u0005\u0005\u0005s\fYI\u0001\fNSJ\u0014xN]*uCR,7\t[1oO\u0016,e/\u001a8u\u0011\u001d\t\u0019k\na\u0001\u0003KC\u0011\"!,(!\u0003\u0005\r!!\r\u0002W5\fG/\u001a:jC2L'0Z'jeJ|'o\u0015;bi\u0016\u001c\u0005.\u00198hK\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM\n\u0001#\\1uKJL\u0017\r\\5{KN#\u0018\r^3\u0015\u0011\u0005u4QAB\u0004\u0007\u0013Aq!a)*\u0001\u0004\t)\u000bC\u0004\u0002v&\u0002\r!a>\t\u000f\r-\u0011\u00061\u0001\u0003B\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0013gR\fG.\u001a+pa&\u001c\u0017\nZ#wK:$8\u000f\u0006\u0004\u0002T\rE1Q\u0004\u0005\b\u0007'Q\u0003\u0019AB\u000b\u0003\u0015)g/\u001a8u!\u0011\u00199b!\u0007\u000e\u0005\u0005\r\u0011\u0002BB\u000e\u0003\u0007\u0011q#\u00112tiJ\f7\r\u001e#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;\t\u000f\u0005\r&\u00061\u0001\u0002&\u0006I2\r[3dW6K7o]5oOR{\u0007/[2EK2,G/[8o)\u0019\tiha\t\u0004&!911C\u0016A\u0002\rU\u0001bBARW\u0001\u0007\u0011QU\u0001\u0012Q\u0006tG\r\\3Ti\u0006dW-\u0012<f]R\u001cH\u0003CA*\u0007W\u0019ica\f\t\u000f\rMA\u00061\u0001\u0004\u0016!9\u00111\u0015\u0017A\u0002\u0005\u0015\u0006\"CAWYA\u0005\t\u0019AA\u0019\u0003mA\u0017M\u001c3mKN#\u0018\r\\3Fm\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005\t#I]8lKJ$UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{KB\u0011AhL\n\u0004_\re\u0002c\u00014\u0004<%\u00191QH4\u0003\r\u0005s\u0017PU3g)\t\u0019)$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007\u000bR3!ZAf\u0001")
public class BrokerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private Logger logger;
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final Option<Set<Enumeration.Value>> ignoredEventTypesTobeLogged;
    private final BrokerValidator validator;
    private volatile boolean bitmap$0;

    public static Option<Set<Enumeration.Value>> $lessinit$greater$default$5() {
        return BrokerDurabilityEventsMaterialize$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public BrokerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return BrokerDurabilityEventsMaterialize.class.getName();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        String metadata = new StringBuilder(24).append("Durability audits topic ").append(Utils$.MODULE$.consumerRecordMetadata(record)).toString();
        this.reporter.addDAConsumerProcessedRecords(1L);
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (healthCheckEvent.nodeId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (event instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)event;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains((Object)event.eventType())))) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Ignoring event ").append(event).append(", since the local db state of the topic partition: ").append(event.topicIdPartition().topicPartition()).append(" is empty").toString());
            }
            return false;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)event.eventType())))) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current state is: ").append(state).append(", state ts: ").append(state.latestTimestamp()).append(", record ts: ").append(record.timestamp()).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current epoch is ").append(state.latestEpoch()).append(" and state ts: ").append(state.latestTimestamp()).append(", record ts: ").append(record.timestamp()).toString());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            if (this.ignoredEventTypesTobeLogged.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains((Object)event.eventType())))) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).append(" ").append(metadata).toString());
                return true;
            }
            if (event instanceof AbstractControllerDurabilityEvent) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Broker materialization rejected for ControllerDurabilityEvent ").append(event).toString());
                return false;
            }
            if (event instanceof ClusterLinkTruncationEvent) {
                ClusterLinkTruncationEvent clusterLinkTruncationEvent = (ClusterLinkTruncationEvent)event;
                this.materializeClusterLinkTruncationEvent(clusterLinkTruncationEvent, state, this.materializeClusterLinkTruncationEvent$default$3());
            } else if (event instanceof MirrorStateChangeEvent) {
                MirrorStateChangeEvent mirrorStateChangeEvent = (MirrorStateChangeEvent)event;
                this.materializeMirrorStateChangeEvent(mirrorStateChangeEvent, state, metadata);
            } else if (event instanceof DestLogEpochChangeEvent) {
                DestLogEpochChangeEvent destLogEpochChangeEvent = (DestLogEpochChangeEvent)event;
                this.materializeDestLogEpochChangeEvent(destLogEpochChangeEvent, state, metadata);
            } else {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("DurabilityMaterialization: Ignoring unexpected durability event type ").append(event.eventType()).append(": ").append(event).append(",").append(" ").append(metadata).toString());
                return false;
            }
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        if (this.ignoredEventTypesTobeLogged.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains((Object)event.eventType())))) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        return true;
    }

    private void materializeInjectedState(InjectStateEvent injectStateEvent) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(injectStateEvent.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (injectStateEvent.removePartition()) {
            this.db().deletePartition(injectStateEvent.topicIdPartition().topicPartition());
        } else {
            if (injectStateEvent.epoch() != -1) {
                state.latestEpoch_$eq(injectStateEvent.epoch());
            }
            if (injectStateEvent.highWatermark() != -1L) {
                state.highWatermark_$eq(injectStateEvent.highWatermark());
            }
            if (injectStateEvent.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(injectStateEvent.logStartOffset());
                state.startOffset_$eq(injectStateEvent.logStartOffset());
            }
            if (injectStateEvent.config() != -1L) {
                state.config_$eq(injectStateEvent.config());
            }
            this.db().addPartition(injectStateEvent.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Updated the durabilityDB due to injected Event ").append(injectStateEvent).append(" with new state ").append(state).toString());
    }

    private void materializeOffsetChangeEvent(OffsetChangeEvent offsetChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(offsetChangeEvent.topicIdPartition().topicPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.highWatermark(), offsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(offsetChangeEvent.topicIdPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.logStartOffset(), offsetChangeEvent.highWatermark(), offsetChangeEvent.nodeId(), offsetChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange);
        if (this.validator().isInISR(topicPartition)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, isr, state, metadata);
        }
        if (hwm < state.highWatermark() && !state.mirrorCacheEpochChain().isEmpty()) {
            this.truncateFromEnd(hwm, state.mirrorCacheEpochChain());
        }
        state.highWatermark_$eq(hwm);
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromEnd(long hwm, HashMap<Object, Object> mirrorCacheEpochChain) {
        if (mirrorCacheEpochChain.size() > 0 && ((Tuple2)mirrorCacheEpochChain.max(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))._2$mcJ$sp() >= hwm) {
            BufferedIterator iterator = ((List)mirrorCacheEpochChain.toList().sortWith((Function2 & Serializable & scala.Serializable)(cur, next) -> BoxesRunTime.boxToBoolean((boolean)BrokerDurabilityEventsMaterialize.$anonfun$truncateFromEnd$1(cur, next)))).iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                void var8_7;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                if (var8_7 >= hwm) {
                    void var7_6;
                    mirrorCacheEpochChain.remove((Object)BoxesRunTime.boxToInteger((int)var7_6));
                    continue;
                }
                continueLoop = false;
            }
            return;
        }
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, int nodeId, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr, nodeId);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent startOffsetChangeEvent, PartitionState state, String metadata, boolean validateHWM) {
        block11: {
            block10: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block9: {
                    if (this.validator().isInSync(startOffsetChangeEvent.isr()) && state.committedStartOffset() < startOffsetChangeEvent.logStartOffset() && this.validator().validateDBLogStartOffset(startOffsetChangeEvent, state, metadata)) {
                        this.validator().validateLocalLogStartOffset(startOffsetChangeEvent.topicIdPartition(), state.mirrorState(), startOffsetChangeEvent.logStartOffset(), metadata);
                        state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(Math.max(startOffsetChangeEvent.logStartOffset(), state.committedStartOffset()));
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(startOffsetChangeEvent.topicIdPartition().topicPartition(), startOffsetChangeEvent.epoch(), startOffsetChangeEvent.highWatermark(), startOffsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
                    }
                    state.startOffset_$eq(startOffsetChangeEvent.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(startOffsetChangeEvent.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block9;
                    if (value != null) {
                        return;
                    }
                    break block10;
                }
                if (!value2.equals(value)) break block11;
            }
            state.retentionMs_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.nodeId(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, state.mirrorState(), metadata);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        if (state.clusterLinkMirrorState().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BrokerDurabilityEventsMaterialize.$anonfun$materializeEpochChangeEvent$1(x$6))) && !state.mirrorCacheEpochChain().contains((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()))) {
            state.mirrorCacheEpochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        }
        this.truncateEpochChain(state);
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    public void materializeDestLogEpochChangeEvent(DestLogEpochChangeEvent destLogEpochChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(destLogEpochChangeEvent.topicIdPartition().topicPartition(), destLogEpochChangeEvent.epoch(), destLogEpochChangeEvent.highWatermark(), destLogEpochChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(destLogEpochChangeEvent.topicIdPartition(), destLogEpochChangeEvent.epoch(), destLogEpochChangeEvent.logStartOffset(), destLogEpochChangeEvent.highWatermark(), destLogEpochChangeEvent.nodeId(), destLogEpochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateDestLogEpochChangeWithLocal(destLogEpochChangeEvent, state, metadata);
        if (!state.mirrorCacheEpochChain().contains((Object)BoxesRunTime.boxToInteger((int)destLogEpochChangeEvent.destLogEpoch()))) {
            state.mirrorCacheEpochChain().put((Object)BoxesRunTime.boxToInteger((int)destLogEpochChangeEvent.destLogEpoch()), (Object)BoxesRunTime.boxToLong((long)destLogEpochChangeEvent.firstOffset()));
        }
        this.truncateEpochChain(state);
    }

    public String materializeDestLogEpochChangeEvent$default$3() {
        return "";
    }

    public void truncateEpochChain(PartitionState state) {
        this.doTruncateEpochChain(state.startOffset(), state.epochChain());
        if (state.mirrorState().isDefined()) {
            this.doTruncateEpochChain(state.startOffset(), state.mirrorCacheEpochChain());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doTruncateEpochChain(long startOffset, HashMap<Object, Object> epochChain) {
        if (epochChain.size() > 2 && ((Tuple2)epochChain.min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))._2$mcJ$sp() < startOffset) {
            BufferedIterator iterator = ((List)epochChain.toList().sortWith((Function2 & Serializable & scala.Serializable)(cur, next) -> BoxesRunTime.boxToBoolean((boolean)BrokerDurabilityEventsMaterialize.$anonfun$doTruncateEpochChain$1(cur, next)))).iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                void var12_10;
                void var8_7;
                void var11_9;
                void var7_6;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                if (!iterator.hasNext()) continue;
                Tuple2 tuple22 = (Tuple2)iterator.head();
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                int nextEpoch = tuple22._1$mcI$sp();
                long nextFirstOffset = tuple22._2$mcJ$sp();
                if (var7_6 < var11_9 && var8_7 <= var12_10) {
                    if (var8_7 < startOffset && var12_10 < startOffset) {
                        epochChain.remove((Object)BoxesRunTime.boxToInteger((int)var7_6));
                        continue;
                    }
                    continueLoop = false;
                    continue;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(117).append("Epoch chain map is not in the sorted order: \ncurrent (Epoch, firstOffset) are (").append((int)var7_6).append(", ").append((long)var8_7).append(")\n").append("next (Epoch, firstOffset) are (").append((int)var11_9).append(", ").append((long)var12_10).append(")").toString());
                }
                continueLoop = false;
            }
            return;
        }
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
        if (retentionChangeEvent.isCompacted()) {
            state.config_$eq(state.config() | (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        }
        if (retentionChangeEvent.isIndependentRetentionMirror()) {
            state.config_$eq(state.config() | (long)ConfigFlag$.MODULE$.OnceIndependentRetentionMirror().id());
            return;
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent deletePartitionEvent) {
        this.db().deletePartition(deletePartitionEvent.topicIdPartition().topicPartition());
    }

    public void materializeClusterLinkTruncationEvent(ClusterLinkTruncationEvent clusterLinkTruncationEvent, PartitionState state2, String metadata) {
        block8: {
            block10: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block9: {
                    boolean bl = false;
                    Some some = null;
                    Option option = Option$.MODULE$.apply((Object)ClusterLinkTruncationEvent$TruncationType$.MODULE$.apply(clusterLinkTruncationEvent.truncationType()));
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        Enumeration.Value value3 = (Enumeration.Value)some.value();
                        Enumeration.Value value4 = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateHWM();
                        if (!(value4 != null ? !value4.equals(value3) : value3 != null)) {
                            long truncateOffsetTo;
                            if (state2.clusterLinkMirrorState().exists((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)state.isTruncationBelowHighWatermarkAllowed())) && (truncateOffsetTo = clusterLinkTruncationEvent.truncateOffsetTo()) < state2.highWatermark()) {
                                state2.highWatermark_$eq(truncateOffsetTo);
                            }
                            this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), clusterLinkTruncationEvent.isr()), state2, metadata, this.materializeStartOffset$default$4());
                            return;
                        }
                    }
                    if (!bl) break block8;
                    value2 = (Enumeration.Value)some.value();
                    value = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateLSO();
                    if (value != null) break block9;
                    if (value2 != null) {
                        return;
                    }
                    break block10;
                }
                if (!value.equals(value2)) break block8;
            }
            state2.committedStartOffset_$eq(package$.MODULE$.max(state2.committedStartOffset(), clusterLinkTruncationEvent.truncateOffsetTo()));
            state2.lapseWatchStartTime_$eq(0L);
            this.materializeHighWatermarkChanges(clusterLinkTruncationEvent.topicIdPartition().topicPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.isr(), state2, metadata, this.materializeHighWatermarkChanges$default$7());
            this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state2, metadata, this.materializeStartOffset$default$4());
            return;
        }
    }

    public String materializeClusterLinkTruncationEvent$default$3() {
        return "";
    }

    public void materializeMirrorStateChangeEvent(MirrorStateChangeEvent mirrorStateChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(mirrorStateChangeEvent.topicIdPartition().topicPartition(), mirrorStateChangeEvent.epoch(), mirrorStateChangeEvent.highWatermark(), mirrorStateChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(mirrorStateChangeEvent.topicIdPartition(), mirrorStateChangeEvent.epoch(), mirrorStateChangeEvent.logStartOffset(), mirrorStateChangeEvent.highWatermark(), mirrorStateChangeEvent.nodeId(), mirrorStateChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        state.mirrorState_$eq(mirrorStateChangeEvent.mirrorState());
    }

    public String materializeMirrorStateChangeEvent$default$3() {
        return "";
    }

    private void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        v0 = state.topicId();
        var4_3 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var5_4 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var6_5 = state.topicId();
        if (v2 == null ? var6_5 != null : v2.equals(var6_5) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = event instanceof EpochChangeEvent ? (var7_7 = (EpochChangeEvent)event).epoch() == 0 && var7_7.firstOffset() == 0L && var7_7.highWatermark() <= 0L : (reset = false);
        }
        if (reset) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
            this.reporter.resetTopicPartition(event.topicIdPartition().topicPartition());
            return;
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            return true;
        }
        return false;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() > next._1$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$materializeEpochChangeEvent$1(DurabilityAuditMirrorState x$6) {
        return !x$6.isReadOnly();
    }

    public static final /* synthetic */ boolean $anonfun$doTruncateEpochChain$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() < next._1$mcI$sp();
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$2, PartitionState state$3) {
        return new StringBuilder(44).append("Durability partition reset for ").append(event$2).append(" old topicID ").append(state$3.topicId()).toString();
    }

    public BrokerDurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time, Option<Set<Enumeration.Value>> ignoredEventTypesTobeLogged) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        this.ignoredEventTypesTobeLogged = ignoredEventTypesTobeLogged;
        super(db, reporter, time);
        this.validator = new BrokerValidator(replicaManager, reporter, time);
    }
}

