/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LocalLogSegmentReadAdapter;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.ValidateLogResult$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0015b\u0001\u0002\u0015*\u00019B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003D\u0011!\u0011\u0006A!A!\u0002\u0013i\u0004\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u0011\u00151\b\u0001\"\u0001x\u0011\u001d\t)\u0001\u0001C)\u0003\u000fA\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0002\u0002CA\u001e\u0001\u0001\u0006K!a\t\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005\u0005\u0002\"CA \u0001\u0001\u0007I\u0011BA!\u0011!\t)\u0005\u0001Q!\n\u0005\r\u0002\"CA$\u0001\t\u0007I\u0011BA%\u0011!\t\t\u0006\u0001Q\u0001\n\u0005-\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\t\u0003g\u0002A\u0011A\u0015\u0002v!A\u0011Q\u0010\u0001\u0005\u0002%\ny\bC\u0004\u0002<\u0002!\t!!0\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fB\u0001B!\u0015\u0001\t\u0003I#1\u000b\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u00119\t\u0001C\u0001\u0005\u0013CqAa\"\u0001\t\u0013\u0011I\nC\u0004\u0003*\u0002!IAa+\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"9!Q\u001e\u0001\u0005\n\t=\bbBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007'\u0001A\u0011AB\u000b\u0005\u001d\u0019E.Z1oKJT!AK\u0016\u0002\u00071|wMC\u0001-\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011a'O\u0007\u0002o)\u0011\u0001hK\u0001\u0006kRLGn]\u0005\u0003u]\u0012q\u0001T8hO&tw-\u0001\u0002jIV\tQ\b\u0005\u00021}%\u0011q(\r\u0002\u0004\u0013:$\u0018aA5eA\u0005IqN\u001a4tKRl\u0015\r]\u000b\u0002\u0007B\u0011AiT\u0007\u0002\u000b*\u0011!F\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005%S\u0015aB:u_J\fw-\u001a\u0006\u0003Y-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001+\u0012\u0002\n\u001f\u001a47/\u001a;NCB\f!b\u001c4gg\u0016$X*\u00199!\u00031IwNQ;gM\u0016\u00148+\u001b>f\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0017a\u00053va\n+hMZ3s\u0019>\fGMR1di>\u0014\bC\u0001\u0019W\u0013\t9\u0016G\u0001\u0004E_V\u0014G.Z\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"A\u0017/\u000e\u0003mS!\u0001\u000f$\n\u0005u[&!\u0003+ie>$H\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005\u0001$W\"A1\u000b\u0005a\u0012'BA2K\u0003\u0019\u0019w.\\7p]&\u0011Q-\u0019\u0002\u0005)&lW-A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001\u0007\u001b6o\u0013\tI\u0017GA\u0005Gk:\u001cG/[8ocA\u00111\u000e\\\u0007\u0002E&\u0011QN\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\u0001t.\u0003\u0002qc\t!QK\\5u\u00039\u0019G.Z1oKJlU\r\u001e:jGN\u0004\"a\u001d;\u000e\u0003%J!!^\u0015\u0003#1{wm\u00117fC:,'/T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\rqfT8\u0010`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003g\u0002AQa\u000f\u0007A\u0002uBQ!\u0011\u0007A\u0002\rCQA\u0015\u0007A\u0002uBQa\u0015\u0007A\u0002uBQ\u0001\u0016\u0007A\u0002UCQ\u0001\u0017\u0007A\u0002eCQA\u0018\u0007A\u0002}CQA\u001a\u0007A\u0002\u001dDQ!\u001d\u0007A\u0002I\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\tI\u0001\u0005\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003+\u00012!a\u00042\u001b\t\t\tBC\u0002\u0002\u00145\na\u0001\u0010:p_Rt\u0014bAA\fc\u00051\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u00062\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0002oS>T!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t9C\u0001\u0006CsR,')\u001e4gKJ\faB]3bI\n+hMZ3s?\u0012*\u0017\u000fF\u0002o\u0003oA\u0011\"!\u000f\u0010\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\u0006sK\u0006$')\u001e4gKJ\u0004\u0013aC<sSR,')\u001e4gKJ\fqb\u001e:ji\u0016\u0014UO\u001a4fe~#S-\u001d\u000b\u0004]\u0006\r\u0003\"CA\u001d%\u0005\u0005\t\u0019AA\u0012\u000319(/\u001b;f\u0005V4g-\u001a:!\u0003m!WmY8naJ,7o]5p]\n+hMZ3s'V\u0004\b\u000f\\5feV\u0011\u00111\n\t\u0004A\u00065\u0013bAA(C\nq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001\b3fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003/\nI\u0007E\u00041\u00033\ni&a\u0019\n\u0007\u0005m\u0013G\u0001\u0004UkBdWM\r\t\u0004a\u0005}\u0013bAA1c\t!Aj\u001c8h!\r\u0019\u0018QM\u0005\u0004\u0003OJ#\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA6-\u0001\u0007\u0011QN\u0001\nG2,\u0017M\\1cY\u0016\u00042a]A8\u0013\r\t\t(\u000b\u0002\f\u00072,\u0017M\u001c)be\u0006l7/A\u0004e_\u000ecW-\u00198\u0015\r\u0005]\u0013qOA=\u0011\u001d\tYg\u0006a\u0001\u0003[Bq!a\u001f\u0018\u0001\u0004\ti&A\u0006dkJ\u0014XM\u001c;US6,\u0017!D2mK\u0006t7+Z4nK:$8\u000fF\to\u0003\u0003\u000bI)a(\u0002$\u0006\u0015\u0016\u0011VAZ\u0003oCaA\u000b\rA\u0002\u0005\r\u0005cA:\u0002\u0006&\u0019\u0011qQ\u0015\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0003\u0017C\u0002\u0019AAG\u0003!\u0019XmZ7f]R\u001c\bCBAH\u0003+\u000bI*\u0004\u0002\u0002\u0012*\u0019\u00111S\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u0006E%aA*fcB\u0019A)a'\n\u0007\u0005uUI\u0001\u0006M_\u001e\u001cVmZ7f]RDa!!)\u0019\u0001\u0004\u0019\u0015aA7ba\"9\u00111\u0010\rA\u0002\u0005u\u0003bBAT1\u0001\u0007\u00111M\u0001\u0006gR\fGo\u001d\u0005\b\u0003WC\u0002\u0019AAW\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r\u0019\u0018qV\u0005\u0004\u0003cK#AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBA[1\u0001\u0007\u0011QL\u0001\u0016Y\u0016<\u0017mY=EK2,G/\u001a%pe&TxN\\'t\u0011\u001d\tI\f\u0007a\u0001\u0003;\nq$\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;PM\u000ecW-\u00198j]\u001e\u0014v.\u001e8e\u0003%\u0019G.Z1o\u0013:$x\u000eF\u000eo\u0003\u007f\u000b\u0019-!4\u0002R\u0006M\u0017Q\\Aq\u0003K\f9/a>\u0002z\u0006m\u0018Q \u0005\u0007\u0003\u0003L\u0002\u0019\u00016\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QY\rA\u0002\u0005\u001d\u0017AB:pkJ\u001cW\rE\u0002t\u0003\u0013L1!a3*\u0005UaunZ*fO6,g\u000e\u001e*fC\u0012\fE-\u00199uKJDq!a4\u001a\u0001\u0004\tI*\u0001\u0003eKN$\bBBAQ3\u0001\u00071\tC\u0004\u0002Vf\u0001\r!a6\u0002AI,G/Y5o\u0019\u0016<\u0017mY=EK2,G/Z:B]\u0012$\u0006P\\'be.,'o\u001d\t\u0004a\u0005e\u0017bAAnc\t9!i\\8mK\u0006t\u0007bBAp3\u0001\u0007\u0011QL\u0001\u0012I\u0016dW\r^3SKR,g\u000e^5p]6\u001b\bBBAr3\u0001\u0007Q(A\tnCbdunZ'fgN\fw-Z*ju\u0016Dq!a+\u001a\u0001\u0004\ti\u000bC\u0004\u0002jf\u0001\r!a;\u000291\f7\u000f\u001e*fG>\u0014Hm](g\u0003\u000e$\u0018N^3Qe>$WoY3sgBA\u0011qRAw\u0003;\n\t0\u0003\u0003\u0002p\u0006E%aA'baB\u0019A)a=\n\u0007\u0005UXI\u0001\u0006MCN$(+Z2pe\u0012Dq!!/\u001a\u0001\u0004\ti\u0006C\u0004\u0002(f\u0001\r!a\u0019\t\u000f\u0005m\u0014\u00041\u0001\u0002^!9\u0011q`\rA\u0002\u0005]\u0017\u0001\u0007<bY&$\u0017\r^3T_V\u00148-\u001a+j[\u0016\u001cH/Y7qg\u0006\trM]8x\u0005V4g-\u001a:t\u001fJ4\u0015-\u001b7\u0015\u00139\u0014)Aa\u0002\u0003\f\t5\u0001bBAc5\u0001\u0007\u0011q\u0019\u0005\u0007\u0005\u0013Q\u0002\u0019A\u001f\u0002\u0011A|7/\u001b;j_:Da!a9\u001b\u0001\u0004i\u0004b\u0002B\b5\u0001\u0007!\u0011C\u0001\u000e[\u0016lwN]=SK\u000e|'\u000fZ:\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006c\u0003\u0019\u0011XmY8sI&!!1\u0004B\u000b\u00055iU-\\8ssJ+7m\u001c:eg\u0006\u00112\u000f[8vY\u0012$\u0015n]2be\u0012\u0014\u0015\r^2i)\u0019\t9N!\t\u0003,!9!1E\u000eA\u0002\t\u0015\u0012!\u00022bi\u000eD\u0007\u0003\u0002B\n\u0005OIAA!\u000b\u0003\u0016\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\tYk\u0007a\u0001\u0003[\u000b!c\u001d5pk2$'+\u001a;bS:\u0014VmY8sIR\u0001\u0012q\u001bB\u0019\u0005g\u00119D!\u000f\u0003B\t\r#Q\t\u0005\u0007\u0003Cc\u0002\u0019A\"\t\u000f\tUB\u00041\u0001\u0002X\u0006i\"/\u001a;bS:$U\r\\3uKN4uN\u001d'fO\u0006\u001c\u0017PU3d_J$7\u000fC\u0004\u0003$q\u0001\rA!\n\t\u000f\t]A\u00041\u0001\u0003<A!!1\u0003B\u001f\u0013\u0011\u0011yD!\u0006\u0003\rI+7m\u001c:e\u0011\u001d\t9\u000b\ba\u0001\u0003GBq!a\u001f\u001d\u0001\u0004\ti\u0006C\u0004\u0002`r\u0001\r!!\u0018\u0002\u0017\u001d\u0014xn\u001e\"vM\u001a,'o\u001d\u000b\u0004]\n-\u0003BBAr;\u0001\u0007Q(\u0001\bsKN$xN]3Ck\u001a4WM]:\u0015\u00039\f1c\u001a:pkB\u001cVmZ7f]R\u001c()_*ju\u0016$\"B!\u0016\u0003h\t=$1\u000fB<!\u0019\u00119F!\u0019\u0002\u000e:!!\u0011\fB/\u001d\u0011\tyAa\u0017\n\u0003IJ1Aa\u00182\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0019\u0003f\t!A*[:u\u0015\r\u0011y&\r\u0005\b\u0003\u0017{\u0002\u0019\u0001B5!\u0019\tyIa\u001b\u0002\u001a&!!QNAI\u0005!IE/\u001a:bE2,\u0007B\u0002B9?\u0001\u0007Q(A\u0004nCb\u001c\u0016N_3\t\r\tUt\u00041\u0001>\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0011\u001d\u0011Ih\ba\u0001\u0003;\naCZ5sgR,fn\u00197fC:\f'\r\\3PM\u001a\u001cX\r^\u0001\u001aY\u0006\u001cHo\u00144gg\u0016$hi\u001c:GSJ\u001cHoU3h[\u0016tG\u000f\u0006\u0004\u0002^\t}$Q\u0011\u0005\b\u0005\u0003\u0003\u0003\u0019\u0001BB\u0003\u0011\u0019XmZ:\u0011\r\t]#\u0011MAM\u0011\u001d\u0011I\b\ta\u0001\u0003;\naBY;jY\u0012|eMZ:fi6\u000b\u0007\u000f\u0006\u0007\u0002X\n-%Q\u0012BI\u0005+\u00139\n\u0003\u0004+C\u0001\u0007\u00111\u0011\u0005\b\u0005\u001f\u000b\u0003\u0019AA/\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011\u0019*\ta\u0001\u0003;\n1!\u001a8e\u0011\u0019\t\t+\ta\u0001\u0007\"9\u0011qU\u0011A\u0002\u0005\rDCDAl\u00057\u0013iJ!)\u0003$\n\u0015&q\u0015\u0005\u0007U\t\u0002\r!a!\t\u000f\u0005-%\u00051\u0001\u0003 B1\u0011q\u0012B6\u0003\u000fDqAa$#\u0001\u0004\ti\u0006C\u0004\u0003\u0014\n\u0002\r!!\u0018\t\r\u0005\u0005&\u00051\u0001D\u0011\u001d\t9K\ta\u0001\u0003G\n\u0001DY;jY\u0012|eMZ:fi6\u000b\u0007OR8s'\u0016<W.\u001a8u)I\t9N!,\u00030\nE&1\u0017B\\\u0005w\u0013iLa0\t\r\u0005\u00057\u00051\u0001k\u0011\u001d\t)m\ta\u0001\u0003\u000fDa!!)$\u0001\u0004\u0019\u0005b\u0002B[G\u0001\u0007\u0011QL\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003:\u000e\u0002\r!!\u0018\u0002!U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$\bBBArG\u0001\u0007Q\bC\u0004\u0002,\u000e\u0002\r!!,\t\u000f\u0005\u001d6\u00051\u0001\u0002d\u0005Ya/\u00197jI\u0006$X\rT8h)1\u0011)Ma7\u0003^\n}'\u0011\u001dBv!\u0011\u00119M!6\u000f\t\t%'\u0011\u001b\b\u0005\u0005\u0017\u0014yM\u0004\u0003\u0002\u0010\t5\u0017\"\u0001\u0017\n\u0005)Z\u0013b\u0001BjS\u0005\tb+\u00197jI\u0006$X\rT8h%\u0016\u001cX\u000f\u001c;\n\t\t]'\u0011\u001c\u0002\u0012-\u0006d\u0017\u000eZ1uK2{wMU3tk2$(b\u0001BjS!1!\u0006\na\u0001\u0003\u0007CqAa$%\u0001\u0004\ti\u0006C\u0004\u0003\u0014\u0012\u0002\r!!\u0018\t\u000f\t\rH\u00051\u0001\u0003f\u0006i!-Y:f\u001f\u001a47/\u001a;NCB\u00042\u0001\u0012Bt\u0013\r\u0011I/\u0012\u0002\u0012\u000bb$XM\u001c3fI>3gm]3u\u001b\u0006\u0004\bbBATI\u0001\u0007\u00111M\u0001\u0013m\u0006d\u0017\u000eZ1uK2{wmU3h[\u0016tG\u000f\u0006\n\u0002^\tE(1\u001fB{\u0005s\u0014iPa@\u0004\u0002\r\r\u0001BBAaK\u0001\u0007!\u000eC\u0004\u0002F\u0016\u0002\r!a2\t\u000f\t]X\u00051\u0001\u0003f\u00069!-Y:f\u001b\u0006\u0004\bb\u0002B~K\u0001\u0007!Q]\u0001\bI&4g-T1q\u0011\u001d\u0011),\na\u0001\u0003;Ba!a9&\u0001\u0004i\u0004bBAVK\u0001\u0007\u0011Q\u0016\u0005\b\u0003O+\u0003\u0019AA2\u0003-awnZ*fO6,g\u000e^:\u0015\u0011\t}5\u0011BB\u0006\u0007\u001fAaA\u000b\u0014A\u0002\u0005\r\u0005bBB\u0007M\u0001\u0007\u0011QL\u0001\u0005MJ|W\u000eC\u0004\u0004\u0012\u0019\u0002\r!!\u0018\u0002\u0005Q|\u0017AG2pY2,7\r^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003CB\f\u0007?\u0019\tca\t\u0011\r\t]#\u0011MB\r!\r!51D\u0005\u0004\u0007;)%AC!c_J$X\r\u001a+y]\"1!f\na\u0001\u0003\u0007CqAa$(\u0001\u0004\ti\u0006C\u0004\u0003\u0014\u001e\u0002\r!!\u0018")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final LogCleanerMetrics cleanerMetrics;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        if (cleanable.firstDirtyOffset() >= cleanable.firstUncleanableOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Skip cleaning for log ").append(cleanable.log().name()).append(" because dirty range is not cleanable. ").append("firstDirtyOffset=").append(cleanable.firstDirtyOffset()).append(", firstUncleanableOffset=").append(cleanable.firstUncleanableOffset()).toString());
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)cleanable.firstDirtyOffset()), (Object)new CleanerStats(this.time, this.cleanerMetrics));
        }
        Tuple2<Object, CleanerStats> tuple2 = this.doClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    public Tuple2<Object, CleanerStats> doClean(CleanParams cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset())).asScala()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanable.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(this.time, this.cleanerMetrics);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.localLogSegments(0L, cleanable.firstUncleanableOffset())).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize((Iterable<LogSegment>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.localLogSegments(cleanable.startOffset(), endOffset)).asScala()), log.config().segmentSize, log.config().maxIndexSize, cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs, upperBoundOffset);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, long upperBoundOffsetOfCleaningRound) {
        LogSegment cleaned = MergedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    LocalLogSegmentReadAdapter segmentAdapter = new LocalLogSegmentReadAdapter(log, currentSegment);
                    this.cleanInto(log.topicPartition(), segmentAdapter, cleaned, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, upperBoundOffsetOfCleaningRound, stats, currentTime, log.config().confluentLogConfig().logCleanerTimestampValidationEnable);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.setLastModified(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegmentReadAdapter source, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, long upperBoundOffsetOfCleaningRound, CleanerStats stats, long currentTime, boolean validateSourceTimestamps) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, upperBoundOffsetOfCleaningRound, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final long upperBoundOffsetOfCleaningRound$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    if (batch.deleteHorizonMs().isPresent()) {
                        this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                    } else {
                        this.discardBatchRecords_$eq(canDiscardBatch && this.deleteRetentionMs == 0L);
                    }
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1 & Serializable & scala.Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch, lastRecord))) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (batch.nextOffset() == this.upperBoundOffsetOfCleaningRound$1 ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY));
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime, this.deleteRetentionMs);
            }

            public void onBatchRetained(RecordBatch batch) {
                this.transactionMetadata$2.onBatchRetained(batch);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                if (lastRecord.lastDataOffset.isPresent()) {
                    return batch$1.lastOffset() == lastRecord.lastDataOffset.getAsLong();
                }
                return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch && batch$1.maxTimestamp() >= lastRecord.lastTimestampMs;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.upperBoundOffsetOfCleaningRound$1 = upperBoundOffsetOfCleaningRound$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch org.apache.kafka.storage.internals.log.LastRecord )}, serializedLambda);
            }
        };
        int position = source.startPosition();
        while (position < source.endPosition()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            source.readBytes(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier(), validateSourceTimestamps);
            stats.readMessages(result.messagesRead(), result.bytesRead(), result.keyBytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), retained);
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)outputBuffer.limit()));
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(source, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(LogSegmentReadAdapter source, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(13).append(source).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            int bytesLeft = source.endPosition() - position;
            if (Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime, long deleteRetentionMs) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, deleteRetentionMs, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    private void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    private void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            return;
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public boolean buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        Iterable<LogSegmentReadAdapter> dirty = this.logSegments(log, start, end);
        return this.buildOffsetMap(log, dirty, start, end, map, stats);
    }

    private boolean buildOffsetMap(AbstractLog log, Iterable<LogSegmentReadAdapter> segments, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = segments.toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        IntRef mappedSegmentCount = IntRef.create((int)0);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$3(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$23))).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, mappedSegmentCount, dirty, full, map, start, transactionMetadata, stats, x$24);
            return BoxedUnit.UNIT;
        });
        return full.elem;
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, OffsetMap map, long startOffset, long upperBoundOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = source.startPosition();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < source.endPosition() && map.latestOffset() < upperBoundOffset - 1L) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
                int startPosition = position;
                java.util.Iterator batchIter = records.batches().iterator();
                while (batchIter.hasNext() && map.latestOffset() < upperBoundOffset - 1L) {
                    MutableRecordBatch batch = (MutableRecordBatch)batchIter.next();
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        stats.indexMessagesRead(1);
                    } else if (transactionMetadata.onBatchRead((RecordBatch)batch)) {
                        stats.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                    } else {
                        try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                                Cleaner.$anonfun$buildOffsetMapForSegment$1(startOffset, map, maxDesiredMapSize, object, stats, record);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    if (batch.lastOffset() < startOffset) continue;
                    map.updateLatestOffset(batch.lastOffset());
                }
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(upperBoundOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public Enumeration.Value validateLog(AbstractLog log, long start, long end, ExtendedOffsetMap baseOffsetMap, CleanerStats stats) {
        this.offsetMap().clear();
        ExtendedOffsetMap diffOffsetMap = new ExtendedOffsetMap(this.offsetMap());
        Iterable<LogSegmentReadAdapter> segments = this.logSegments(log, start, end);
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        LongRef totalValidatedCount = LongRef.create((long)0L);
        LongRef validatedCount = LongRef.create((long)0L);
        segments.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$validateLog$1(validatedCount, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$validateLog$2(this, validatedCount, log, baseOffsetMap, diffOffsetMap, start, transactionMetadata, stats, totalValidatedCount, segment);
            return BoxedUnit.UNIT;
        });
        if (validatedCount.elem < 0L) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append(log.topicPartition()).append(": log validation terminated prematurely because diff offset map is full.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Aborted();
        }
        if (totalValidatedCount.elem != (long)(baseOffsetMap.size() - baseOffsetMap.tombstoneCount()) || diffOffsetMap.size() != diffOffsetMap.tombstoneCount()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(215).append(log.topicPartition()).append(": log validation failed. Log data in offset range [").append(start).append(", ").append(end).append(") is inconsistent with baseOffsetMap.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", baseOffsetMap.tombstoneCount=").append(baseOffsetMap.tombstoneCount()).append(". ").append("diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Failed();
        }
        return ValidateLogResult$.MODULE$.Passed();
    }

    private long validateLogSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, ExtendedOffsetMap baseMap, ExtendedOffsetMap diffMap, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int diffMapMaxSize = (int)((double)diffMap.slots() * this.dupBufferLoadFactor);
            IntRef validatedRecordCount = IntRef.create((int)0);
            int position = source.startPosition();
            while (position < source.endPosition()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
                int startPosition = position;
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$validateLogSegment$1(this, transactionMetadata, stats, startOffset, baseMap, diffMap, diffMapMaxSize, object, validatedRecordCount, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            this.restoreBuffers();
            return validatedRecordCount.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.localLogSegments(from, to)).asScala()).map((Function1 & Serializable & scala.Serializable)x$25 -> new LocalLogSegmentReadAdapter(log, (LogSegment)x$25), Iterable$.MODULE$.canBuildFrom())).dropWhile((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$logSegments$2(from, x)));
    }

    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        return log.collectAbortedTransactions(start, end, false);
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, long deleteRetentionMs$2, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            if (deleteRetentionMs$2 != 0L) {
                return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
            }
            return false;
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$23) {
        if (x$23 != null) {
            return !full$1.elem;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, IntRef mappedSegmentCount$1, Buffer dirty$1, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Tuple2 x$24) {
        if (x$24 != null) {
            LogSegmentReadAdapter segment = (LogSegmentReadAdapter)x$24._1();
            long nextSegmentStartOffset = x$24._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            if (segment.endOffset() < log$4.logStartOffset() && segment.baseOffset() < log$4.logStartOffset()) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("End offset of segment: ").append(segment).append(" is smaller than log start offset ").append(log$4.logStartOffset()).append(". Abort current cleaning operation and will be retried").toString());
                throw new LogCleaningAbortedException();
            }
            ++mappedSegmentCount$1.elem;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Building offset map for segment ").append(mappedSegmentCount$1.elem).append("/").append(dirty$1.size()).append(": ").append(segment).toString());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, log$4.config().maxMessageSize(), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mappedSegmentCount$1.elem - 1)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset(), !record.hasValue());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ boolean $anonfun$validateLog$1(LongRef validatedCount$1, LogSegmentReadAdapter segment) {
        return validatedCount$1.elem >= 0L;
    }

    public static final /* synthetic */ void $anonfun$validateLog$2(Cleaner $this, LongRef validatedCount$1, AbstractLog log$5, ExtendedOffsetMap baseOffsetMap$1, ExtendedOffsetMap diffOffsetMap$1, long start$2, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$6, LongRef totalValidatedCount$1, LogSegmentReadAdapter segment) {
        validatedCount$1.elem = $this.validateLogSegment(log$5.topicPartition(), segment, baseOffsetMap$1, diffOffsetMap$1, start$2, 0, transactionMetadata$4, stats$6);
        if (validatedCount$1.elem > 0L) {
            totalValidatedCount$1.elem += validatedCount$1.elem;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$validateLogSegment$2(long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, CleanerStats stats$7, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            long off = baseMap$1.get(record.key());
            if (off == -1L) {
                if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                diffMap$1.put(record.key(), record.offset(), !record.hasValue());
            } else if (record.offset() >= off) {
                if (record.offset() == off) {
                    if (record.hasValue()) {
                        ++validatedRecordCount$1.elem;
                    }
                } else {
                    if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                    diffMap$1.put(record.key(), record.offset(), !record.hasValue());
                }
            }
        }
        stats$7.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$validateLogSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$5, CleanerStats stats$7, long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$5.onControlBatchRead((RecordBatch)batch);
            stats$7.indexMessagesRead(1);
            return;
        }
        if (transactionMetadata$5.onBatchRead((RecordBatch)batch)) {
            stats$7.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
            return;
        }
        try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                Cleaner.$anonfun$validateLogSegment$2(startOffset$2, baseMap$1, diffMap$1, diffMapMaxSize$1, nonLocalReturnKey3$1, validatedRecordCount$1, stats$7, record);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, LocalLogSegmentReadAdapter x) {
        return x.endOffset() < from$1;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone, LogCleanerMetrics cleanerMetrics) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.cleanerMetrics = cleanerMetrics;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

