/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.Arrays;
import kafka.restore.RestoreConfig;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.RestoreMetricsUtil;
import kafka.restore.RestoreTierPartitionState;
import kafka.restore.rest.RestoreRestServer;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restore {
    private static final Logger LOGGER = LoggerFactory.getLogger(Restore.class);
    private static final String PARTITION_FILE_CONFIG = "partition-file";
    private static final String PARTITION_FILE_DOC = "Name of the file contains the list of partitions to be restored";
    private static final String KAFKA_INTERNAL_REST_SERVER_PORT_CONFIG = "internal-rest-port";
    private static final String KAFKA_INTERNAL_REST_SERVER_PORT_DOC = "Port of kafka internal rest server";
    private static final String KAFKA_BOOTSTRAP_SERVER_PORT_CONFIG = "kafka-bootstrap-port";
    private static final String KAFKA_BOOTSTRAP_SERVER_PORT_DOC = "Port of kafka bootstrap server";
    private static final String CLUSTER_ID_CONFIG = "clusterid";
    private static final String CLUSTER_ID_DOC = "ID of the cluster";

    public static void main(String[] args) throws Exception {
        String bootstrapServerPort;
        LOGGER.info("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = Restore.createComparatorParser();
        Namespace res = cliParser.parseArgs(args);
        String partitionFile = res.getString(PARTITION_FILE_CONFIG);
        RestoreConfig.setProperty(PARTITION_FILE_CONFIG, partitionFile);
        String internalRestPort = res.getString(KAFKA_INTERNAL_REST_SERVER_PORT_CONFIG);
        if (internalRestPort != null) {
            RestoreConfig.setKafkaInternalRestPort(Integer.parseInt(internalRestPort));
        }
        if ((bootstrapServerPort = res.getString(KAFKA_BOOTSTRAP_SERVER_PORT_CONFIG)) != null) {
            RestoreConfig.setKafkaBootstrapPort(Integer.parseInt(bootstrapServerPort));
        }
        Time time = Time.SYSTEM;
        String clusterId = res.getString(CLUSTER_ID_CONFIG);
        Metrics metrics = RestoreMetricsUtil.initializeMetrics(RestoreConfig.kafkaConfig(), time, clusterId);
        RestoreMetricsManager restoreMetricsManager = new RestoreMetricsManager(metrics, clusterId);
        RestoreRestServer restServer = new RestoreRestServer(restoreMetricsManager, time);
        restServer.start();
        LOGGER.info("Restore Web Server started, waiting for commands.");
    }

    private static ArgumentParser createComparatorParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)RestoreTierPartitionState.class.getName()).defaultHelp(true).description("Restore the partitions from input partition list file");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(PARTITION_FILE_CONFIG)}).dest(PARTITION_FILE_CONFIG).type(String.class).required(true).help(PARTITION_FILE_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(KAFKA_INTERNAL_REST_SERVER_PORT_CONFIG)}).dest(KAFKA_INTERNAL_REST_SERVER_PORT_CONFIG).type(String.class).required(false).help(KAFKA_INTERNAL_REST_SERVER_PORT_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(KAFKA_BOOTSTRAP_SERVER_PORT_CONFIG)}).dest(KAFKA_BOOTSTRAP_SERVER_PORT_CONFIG).type(String.class).required(false).help(KAFKA_BOOTSTRAP_SERVER_PORT_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(CLUSTER_ID_CONFIG)}).dest(CLUSTER_ID_CONFIG).type(String.class).required(true).help(CLUSTER_ID_DOC);
        return parser;
    }
}

